/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.oauth2.useragent;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class AuthorizationException
extends Exception {
    static final String ERROR_CODE = "error";
    static final String ERROR_DESCRIPTION = "error_description";
    static final String ERROR_URI = "error_uri";
    private static final String UTF_8 = "UTF-8";
    private final String code;
    private final String description;
    private final URI uri;

    public AuthorizationException(String code) {
        this(code, null, null, null);
    }

    public AuthorizationException(String code, String description, URI uri, Throwable cause) {
        super(code, cause);
        if (code == null) {
            throw new IllegalArgumentException("The 'code' argument cannot be null.");
        }
        this.code = code;
        this.description = description;
        this.uri = uri;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append(": ");
        sb.append("Code: ").append(this.code);
        if (this.uri != null) {
            sb.append(" Uri: ").append(this.uri.toString());
        }
        if (this.description != null) {
            sb.append(" Description: ").append(this.description);
        }
        return sb.toString();
    }

    public static String toString(String code, Throwable throwable, URI uri) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        throwable.printStackTrace(printStream);
        String description = baos.toString();
        return AuthorizationException.toString(code, description, uri);
    }

    public static String toString(String code, String description, URI uri) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(ERROR_CODE).append('=').append(URLEncoder.encode(code, UTF_8));
            if (description != null) {
                sb.append('&');
                sb.append(ERROR_DESCRIPTION).append('=').append(URLEncoder.encode(description, UTF_8));
            }
            if (uri != null) {
                sb.append('&');
                sb.append(ERROR_URI).append('=').append(URLEncoder.encode(uri.toString(), UTF_8));
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }
}

