/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.CoreAuthenticationUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.metadata.BasicCredentialMetaData;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.ticket.AbstractTicketException;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.AbstractCasWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class DefaultCasDelegatingWebflowEventResolver
extends AbstractCasWebflowEventResolver
implements CasDelegatingWebflowEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasDelegatingWebflowEventResolver.class);
    private final List<CasWebflowEventResolver> orderedResolvers = new ArrayList<CasWebflowEventResolver>(0);
    private final CasWebflowEventResolver selectiveResolver;

    public DefaultCasDelegatingWebflowEventResolver(CasWebflowEventResolutionConfigurationContext configurationContext, CasWebflowEventResolver selectiveResolver) {
        super(configurationContext);
        this.selectiveResolver = selectiveResolver;
    }

    @Override
    public Set<Event> resolveInternal(RequestContext context) {
        Credential credential = this.getCredentialFromContext(context);
        Service service = this.locateServiceForRequest(context);
        LOGGER.trace("Resolved service [{}]", (Object)service);
        try {
            if (credential != null) {
                AuthenticationResultBuilder builder = this.getConfigurationContext().getAuthenticationSystemSupport().handleInitialAuthenticationTransaction(service, new Credential[]{credential});
                String agent = WebUtils.getHttpServletRequestUserAgentFromRequestContext((RequestContext)context);
                GeoLocationRequest geoLocation = WebUtils.getHttpServletRequestGeoLocationFromRequestContext((RequestContext)context);
                BasicCredentialMetaData metadata = new BasicCredentialMetaData(credential, CollectionUtils.wrap((String)"UserAgent", (Object)agent, (String)"GeoLocation", (Object)geoLocation));
                builder.collect((CredentialMetaData)metadata);
                builder.getInitialAuthentication().ifPresent(authn -> {
                    WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)builder, (RequestContext)context);
                    WebUtils.putAuthentication((Authentication)authn, (RequestContext)context);
                });
            }
            RegisteredService registeredService = this.determineRegisteredServiceForEvent(context, service);
            LOGGER.trace("Attempting to resolve candidate authentication events for service [{}]", (Object)service);
            Collection<Event> resolvedEvents = this.resolveCandidateAuthenticationEvents(context, service, registeredService);
            if (!resolvedEvents.isEmpty()) {
                LOGGER.trace("Authentication events resolved for [{}] are [{}]. Selecting final event...", (Object)service, resolvedEvents);
                WebUtils.putResolvedEventsAsAttribute((RequestContext)context, resolvedEvents);
                Event finalResolvedEvent = this.selectiveResolver.resolveSingle(context);
                LOGGER.debug("The final authentication event resolved for [{}] is [{}]", (Object)service, (Object)finalResolvedEvent);
                if (finalResolvedEvent != null) {
                    return CollectionUtils.wrapSet((Object)finalResolvedEvent);
                }
            } else {
                LOGGER.trace("No candidate authentication events were resolved for service [{}]", (Object)service);
            }
            AuthenticationResultBuilder builder = WebUtils.getAuthenticationResultBuilder((RequestContext)context);
            if (builder == null) {
                String msg = "Unable to locate authentication object in the webflow context";
                throw new IllegalArgumentException((Throwable)new AuthenticationException("Unable to locate authentication object in the webflow context"));
            }
            return CollectionUtils.wrapSet((Object)this.grantTicketGrantingTicketToAuthenticationResult(context, builder, service));
        }
        catch (Exception exception) {
            Event event = this.returnAuthenticationExceptionEventIfNeeded(exception, credential, service);
            if (event == null) {
                FunctionUtils.doIf((boolean)LOGGER.isDebugEnabled(), e -> LOGGER.debug(exception.getMessage(), (Throwable)exception), e -> LoggingUtils.warn((Logger)LOGGER, (String)exception.getMessage(), (Throwable)exception)).accept(exception);
                event = this.newEvent("error", exception);
            }
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)context);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            LOGGER.debug("Authentication request failed with [{}], resulting in event [{}]", (Object)response.getStatus(), (Object)event);
            return CollectionUtils.wrapSet((Object)event);
        }
    }

    @Override
    public void addDelegate(CasWebflowEventResolver r) {
        if (r != null && BeanSupplier.isNotProxy((Object)r)) {
            this.orderedResolvers.add(r);
        }
    }

    @Override
    public void addDelegate(CasWebflowEventResolver r, int index) {
        if (r != null && BeanSupplier.isNotProxy((Object)r)) {
            this.orderedResolvers.add(index, r);
        }
    }

    protected Collection<Event> resolveCandidateAuthenticationEvents(RequestContext context, Service service, RegisteredService registeredService) {
        return this.orderedResolvers.stream().filter(BeanSupplier::isNotProxy).map(resolver -> {
            LOGGER.debug("Resolving candidate authentication event for service [{}] using [{}]", (Object)service, (Object)resolver.getName());
            return resolver.resolveSingle(context);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(Event::getId)).collect(Collectors.toList());
    }

    private RegisteredService determineRegisteredServiceForEvent(RequestContext context, Service service) {
        if (service == null) {
            return null;
        }
        LOGGER.trace("Locating authentication event in the request context...");
        Authentication authn = WebUtils.getAuthentication((RequestContext)context);
        if (authn == null) {
            String msg = "Unable to locate authentication object in the webflow context";
            throw new IllegalArgumentException((Throwable)new AuthenticationException("Unable to locate authentication object in the webflow context"));
        }
        LOGGER.trace("Locating service [{}] in service registry to determine authentication policy", (Object)service);
        RegisteredService registeredService = this.getConfigurationContext().getServicesManager().findServiceBy(service);
        LOGGER.trace("Enforcing access strategy policies for registered service [{}] and principal [{}]", (Object)registeredService, (Object)authn.getPrincipal());
        URI unauthorizedRedirectUrl = registeredService.getAccessStrategy().getUnauthorizedRedirectUrl();
        if (unauthorizedRedirectUrl != null) {
            WebUtils.putUnauthorizedRedirectUrlIntoFlowScope((RequestContext)context, (URI)unauthorizedRedirectUrl);
        }
        RegisteredServiceAttributeReleasePolicyContext attributeReleaseContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(authn.getPrincipal()).build();
        Map releasingAttributes = registeredService.getAttributeReleasePolicy().getAttributes(attributeReleaseContext);
        releasingAttributes.putAll(authn.getAttributes());
        Map accessStrategyAttributes = CoreAuthenticationUtils.mergeAttributes((Map)authn.getPrincipal().getAttributes(), (Map)releasingAttributes);
        Principal accessStrategyPrincipal = this.getConfigurationContext().getPrincipalFactory().createPrincipal(authn.getPrincipal().getId(), accessStrategyAttributes);
        AuditableContext audit = AuditableContext.builder().service(service).principal(accessStrategyPrincipal).registeredService(registeredService).build();
        AuditableExecutionResult result = this.getConfigurationContext().getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        result.throwExceptionIfNeeded();
        return registeredService;
    }

    protected Event returnAuthenticationExceptionEventIfNeeded(Exception exception, Credential credential, Service service) {
        Optional<Exception> result = exception instanceof AuthenticationException || exception instanceof AbstractTicketException ? Optional.of(exception) : (exception.getCause() instanceof AuthenticationException || exception.getCause() instanceof AbstractTicketException ? Optional.of(exception.getCause()) : Optional.empty());
        return result.map(Exception.class::cast).map(ex -> {
            FunctionUtils.doIf((boolean)LOGGER.isDebugEnabled(), e -> LOGGER.debug(ex.getMessage(), (Throwable)ex), e -> LOGGER.warn(ex.getMessage())).accept(exception);
            LocalAttributeMap attributes = new LocalAttributeMap("error", ex);
            attributes.put(Credential.class.getName(), (Object)credential);
            attributes.put(WebApplicationService.class.getName(), (Object)service);
            return this.newEvent("authenticationFailure", (AttributeMap)attributes);
        }).orElse(null);
    }

    protected Service locateServiceForRequest(RequestContext context) {
        WebApplicationService serviceFromRequest = WebUtils.getService(this.getConfigurationContext().getArgumentExtractors(), (RequestContext)context);
        WebApplicationService serviceFromFlow = WebUtils.getService((RequestContext)context);
        WebApplicationService finalService = (WebApplicationService)ObjectUtils.defaultIfNull((Object)serviceFromRequest, (Object)serviceFromFlow);
        return this.getConfigurationContext().getAuthenticationRequestServiceSelectionStrategies().resolveService((Service)finalService);
    }
}

