/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.beans.spring.parser;

import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.beans.spring.parser.AbstractBeanDefinitionParser;
import org.ldaptive.filter.Filter;
import org.ldaptive.filter.FilterParseException;
import org.ldaptive.filter.FilterParser;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SearchOperationBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String idAttrValue = element.getAttribute("id");
        return StringUtils.hasText((String)idAttrValue) ? idAttrValue : "search-operation";
    }

    protected Class<?> getBeanClass(Element element) {
        return SearchOperation.class;
    }

    protected void doParse(Element element, ParserContext context, BeanDefinitionBuilder builder) {
        builder.addPropertyValue("request", (Object)this.parseSearchRequest(null, element).getBeanDefinition());
        this.setObjectIfPresent(element, "exceptionHandler", builder);
        this.setObjectIfPresent(element, "throwCondition", builder);
    }

    protected BeanDefinitionBuilder parseSearchRequest(BeanDefinitionBuilder builder, Element element) {
        BeanDefinitionBuilder searchRequest = builder;
        if (searchRequest == null) {
            searchRequest = BeanDefinitionBuilder.genericBeanDefinition(SearchRequest.class);
        }
        searchRequest.addPropertyValue("baseDn", (Object)element.getAttribute("baseDn"));
        searchRequest.addPropertyValue("searchScope", (Object)element.getAttribute("searchScope"));
        searchRequest.addPropertyValue("derefAliases", (Object)element.getAttribute("derefAliases"));
        this.setIfPresent(element, "sizeLimit", searchRequest);
        if (element.hasAttribute("timeLimit")) {
            BeanDefinitionBuilder timeLimit = BeanDefinitionBuilder.rootBeanDefinition(AbstractBeanDefinitionParser.class, (String)"parseDuration");
            timeLimit.addConstructorArgValue((Object)element.getAttribute("timeLimit"));
            searchRequest.addPropertyValue("timeLimit", (Object)timeLimit.getBeanDefinition());
        }
        this.setIfPresent(element, "typesOnly", searchRequest);
        if (element.hasAttribute("filter")) {
            BeanDefinitionBuilder filter = BeanDefinitionBuilder.rootBeanDefinition(SearchOperationBeanDefinitionParser.class, (String)"parseFilter");
            filter.addConstructorArgValue((Object)element.getAttribute("filter"));
            searchRequest.addPropertyValue("filter", (Object)filter.getBeanDefinition());
        }
        this.setIfPresent(element, "returnAttributes", searchRequest);
        this.setIfPresent(element, "binaryAttributes", searchRequest);
        return searchRequest;
    }

    protected static Filter parseFilter(String value) {
        try {
            return FilterParser.parse((String)value);
        }
        catch (FilterParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

