/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.io.IOException;
import java.util.Base64;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class PagedSearchStrategy
extends LdapSearchStrategy {
    private static final Log LOG = Log.getLog(PagedSearchStrategy.class);
    protected final int pageSize;
    protected final int pagedResultsOffset;
    protected final String pagedResultsCookie;
    protected final SearchResultsHandler searchResultHandler;
    protected final org.identityconnectors.framework.common.objects.SortKey[] sortKeys;

    public PagedSearchStrategy(int pageSize, String pagedResultsCookie, Integer pagedResultsOffset, SearchResultsHandler searchResultHandler, org.identityconnectors.framework.common.objects.SortKey[] sortKeys) {
        this.pageSize = pageSize;
        this.pagedResultsOffset = pagedResultsOffset == null ? 0 : pagedResultsOffset;
        this.pagedResultsCookie = pagedResultsCookie;
        this.searchResultHandler = searchResultHandler;
        this.sortKeys = sortKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSearch(LdapContext initCtx, List<String> baseDNs, String query, SearchControls searchControls, LdapSearchResultsHandler handler) throws IOException, NamingException {
        LOG.ok("Searching in {0} with filter {1} and {2}", new Object[]{baseDNs, query, PagedSearchStrategy.searchControlsToString(searchControls)});
        byte[] cookie = null;
        int context = 0;
        if (StringUtil.isNotBlank((String)this.pagedResultsCookie)) {
            String[] split = this.pagedResultsCookie.split(":", 2);
            if (split.length == 2) {
                try {
                    cookie = Base64.getDecoder().decode(split[0]);
                }
                catch (RuntimeException e) {
                    throw new ConnectorException("PagedResultsCookie is not properly encoded", (Throwable)e);
                }
                context = Integer.valueOf(split[1]);
            } else {
                throw new ConnectorException("PagedResultsCookie is not properly formatted");
            }
        }
        LdapContext ctx = initCtx.newInstance(null);
        int remainingResults = -1;
        boolean allResultsReturned = true;
        try {
            boolean needMore;
            boolean proceed = true;
            int records = 0;
            do {
                SortControl sortControl = null;
                if (this.sortKeys != null && this.sortKeys.length > 0) {
                    SortKey[] skis = new SortKey[this.sortKeys.length];
                    for (int i = 0; i < this.sortKeys.length; ++i) {
                        skis[i] = new SortKey(this.sortKeys[i].getField(), this.sortKeys[i].isAscendingOrder(), null);
                    }
                    sortControl = new SortControl(skis, false);
                }
                if (sortControl == null) {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize - records, cookie, true)});
                } else {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.pageSize - records, cookie, true), sortControl});
                }
                NamingEnumeration<javax.naming.directory.SearchResult> results = ctx.search(baseDNs.get(context), query, searchControls);
                while (proceed && results.hasMore()) {
                    javax.naming.directory.SearchResult result = results.next();
                    if (++records <= this.pagedResultsOffset) continue;
                    proceed = handler.handle(baseDNs.get(context), result);
                }
                if (records < this.pageSize && context + 1 < baseDNs.size()) {
                    needMore = true;
                    ++context;
                    cookie = null;
                } else {
                    needMore = false;
                    PagedResultsResponseControl pagedControl = this.getPagedControl(ctx.getResponseControls());
                    if (pagedControl != null) {
                        cookie = pagedControl.getCookie();
                        if (pagedControl.getResultSize() > 0) {
                            remainingResults = pagedControl.getResultSize();
                        }
                    }
                }
                results.close();
            } while (needMore);
        }
        catch (OperationNotSupportedException e) {
            LOG.ok("OperationNotSupportedException caught: {0}. Check the Cookie validity", new Object[]{e.getRemainingName()});
            throw new ConnectorException("Operation Not Supported. Bad cookie");
        }
        catch (PartialResultException e) {
            LOG.ok("PartialResultException caught: {0}", new Object[]{e.getRemainingName()});
            allResultsReturned = false;
        }
        finally {
            ctx.close();
        }
        String returnedCookie = null;
        if (cookie != null) {
            returnedCookie = Base64.getEncoder().encodeToString(cookie).concat(":" + context);
        }
        if (this.searchResultHandler != null) {
            this.searchResultHandler.handleResult(new SearchResult(returnedCookie, remainingResults, allResultsReturned));
        }
    }

    protected PagedResultsResponseControl getPagedControl(Control[] controls) {
        if (controls != null) {
            for (Control control : controls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                return (PagedResultsResponseControl)control;
            }
        }
        return null;
    }
}

