/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObjectIdentification;
import org.identityconnectors.framework.common.objects.ObjectClass;

public abstract class BaseConnectorObject {
    private final ObjectClass objectClass;
    protected final Map<String, Attribute> attributeMap;

    BaseConnectorObject(ObjectClass objectClass, Set<? extends Attribute> attributes) {
        if (ObjectClass.ALL.equals(objectClass)) {
            throw new IllegalArgumentException("Connector object class can not be type of __ALL__");
        }
        if (CollectionUtil.isEmpty(attributes)) {
            throw new IllegalArgumentException("The set can not be null or empty.");
        }
        this.objectClass = objectClass;
        this.attributeMap = AttributeUtil.toMap(attributes);
    }

    public Set<Attribute> getAttributes() {
        return CollectionUtil.newReadOnlySet(this.attributeMap.values());
    }

    public Attribute getAttributeByName(String name) {
        return this.attributeMap.get(name);
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public abstract ConnectorObjectIdentification getIdentification();

    public boolean equals(Object obj) {
        if (obj instanceof BaseConnectorObject) {
            BaseConnectorObject other = (BaseConnectorObject)obj;
            if (!this.objectClass.equals(other.getObjectClass())) {
                return false;
            }
            return CollectionUtil.equals(this.getAttributes(), other.getAttributes());
        }
        return false;
    }

    public int hashCode() {
        return this.getAttributes().hashCode();
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ObjectClass", this.getObjectClass());
        map.put("Attributes", this.getAttributes());
        return this.getClass().getSimpleName() + ": " + String.valueOf(map);
    }
}

