/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.tenant;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.flowable.common.engine.impl.db.DbSqlSession;
import org.flowable.common.engine.impl.tenant.BaseChangeTenantIdCmd;
import org.flowable.common.engine.impl.tenant.ChangeTenantIdBuilderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimulateChangeTenantIdCmd
extends BaseChangeTenantIdCmd {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SimulateChangeTenantIdCmd.class);
    protected final Set<String> entityTypes;

    public SimulateChangeTenantIdCmd(ChangeTenantIdBuilderImpl builder, String engineScopeType, Set<String> entityTypes) {
        super(builder, engineScopeType);
        this.entityTypes = entityTypes;
    }

    @Override
    protected Map<String, Long> executeOperation(DbSqlSession dbSqlSession, Map<String, Object> parameters) {
        if (LOGGER.isDebugEnabled()) {
            String definitionTenantId = this.builder.getDefinitionTenantId();
            Object option = definitionTenantId != null ? " but only for instances from the '" + definitionTenantId + "' tenant definitions" : "";
            LOGGER.debug("Simulating instance migration from '{}' to '{}'{}.", new Object[]{parameters.get("sourceTenantId"), parameters.get("targetTenantId"), option});
        }
        HashMap<String, Long> results = new HashMap<String, Long>();
        for (String entityType : this.entityTypes) {
            results.put(entityType, (long)((Long)dbSqlSession.selectOne("countChangeTenantId" + entityType, parameters)));
        }
        return results;
    }
}

