/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import org.apereo.cas.ticket.expiration.AbstractCasExpirationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class OAuth20RefreshTokenExpirationPolicy
extends AbstractCasExpirationPolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RefreshTokenExpirationPolicy.class);
    private static final long serialVersionUID = -7144233906843566234L;
    private long timeToKillInSeconds;

    @JsonCreator
    public OAuth20RefreshTokenExpirationPolicy(@JsonProperty(value="timeToLive") long timeToKillInSeconds) {
        this.timeToKillInSeconds = timeToKillInSeconds;
    }

    public boolean isExpired(TicketGrantingTicketAwareTicket ticketState) {
        boolean expired = this.isRefreshTokenExpired((Ticket)ticketState);
        return expired || super.isExpired(ticketState);
    }

    public Long getTimeToLive() {
        return this.timeToKillInSeconds;
    }

    @JsonIgnore
    protected boolean isRefreshTokenExpired(Ticket ticketState) {
        ZonedDateTime now;
        if (ticketState == null) {
            return true;
        }
        ZonedDateTime expiringTime = this.toMaximumExpirationTime(ticketState);
        boolean result = expiringTime.isBefore(now = ZonedDateTime.now(ZoneOffset.UTC));
        if (result) {
            LOGGER.trace("Ticket [{}] is expired because its expiration time [{}] is before [{}]", new Object[]{ticketState.getId(), expiringTime, now});
        }
        return result;
    }

    @JsonIgnore
    public ZonedDateTime toMaximumExpirationTime(Ticket ticketState) {
        ZonedDateTime creationTime = ticketState.getCreationTime();
        return creationTime.plusSeconds(this.timeToKillInSeconds);
    }

    @Generated
    public OAuth20RefreshTokenExpirationPolicy() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth20RefreshTokenExpirationPolicy)) {
            return false;
        }
        OAuth20RefreshTokenExpirationPolicy other = (OAuth20RefreshTokenExpirationPolicy)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.timeToKillInSeconds == other.timeToKillInSeconds;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OAuth20RefreshTokenExpirationPolicy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $timeToKillInSeconds = this.timeToKillInSeconds;
        result = result * 59 + (int)($timeToKillInSeconds >>> 32 ^ $timeToKillInSeconds);
        return result;
    }

    @Generated
    public String toString() {
        return "OAuth20RefreshTokenExpirationPolicy(super=" + super.toString() + ", timeToKillInSeconds=" + this.timeToKillInSeconds + ")";
    }
}

