/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.monitor;

import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class MemoryMonitorHealthIndicator
extends AbstractHealthIndicator {
    private static final int PERCENTAGE_VALUE = 100;
    private final double freeMemoryWarnThreshold;

    protected void doHealthCheck(Health.Builder builder) {
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        long availableMemory = maxMemory - usedMemory;
        double availableMemoryPercentage = (double)availableMemory * 100.0 / (double)maxMemory;
        String freeMemoryPercentage = String.format("%.2f%%", availableMemoryPercentage);
        builder.withDetail("availableMemory", (Object)FileUtils.byteCountToDisplaySize((long)availableMemory)).withDetail("maxMemory", (Object)FileUtils.byteCountToDisplaySize((long)maxMemory)).withDetail("usedMemory", (Object)FileUtils.byteCountToDisplaySize((long)usedMemory)).withDetail("totalMemory", (Object)FileUtils.byteCountToDisplaySize((long)totalMemory)).withDetail("freeMemory", (Object)FileUtils.byteCountToDisplaySize((long)freeMemory)).withDetail("freeMemoryPercentage", (Object)freeMemoryPercentage).status(availableMemoryPercentage < this.freeMemoryWarnThreshold ? Status.DOWN : Status.UP);
    }

    @Generated
    public MemoryMonitorHealthIndicator(double freeMemoryWarnThreshold) {
        this.freeMemoryWarnThreshold = freeMemoryWarnThreshold;
    }
}

