/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.messaging.handler.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;

public abstract class AbstractMessageChannelSecurity
extends AbstractMessageHandler {
    @Nonnull
    private Function<MessageContext, BaseContext> parentContextLookupStrategy = new Function<MessageContext, BaseContext>(){

        @Override
        @Nullable
        public BaseContext apply(@Nullable MessageContext input) {
            return input;
        }
    };
    @Nullable
    private BaseContext parentContext;

    public void setParentContextLookupStrategy(@Nonnull Function<MessageContext, BaseContext> strategy) {
        this.checkSetterPreconditions();
        this.parentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Parent context lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.parentContext = this.parentContextLookupStrategy.apply(messageContext);
        return this.parentContext != null;
    }

    @Nullable
    protected BaseContext getParentContext() {
        return this.parentContext;
    }

    @Nonnull
    protected BaseContext ensureParentContext() {
        if (this.parentContext != null) {
            return this.parentContext;
        }
        throw new IllegalStateException("Parent context was null");
    }
}

