/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.zookeeper;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.DomainOps;
import org.apache.syncope.common.keymaster.client.api.KeymasterProperties;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.zookeeper.ZookeeperConfParamOps;
import org.apache.syncope.common.keymaster.client.zookeeper.ZookeeperDomainOps;
import org.apache.syncope.common.keymaster.client.zookeeper.ZookeeperServiceDiscoveryOps;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.client.ZKClientConfig;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.server.auth.DigestLoginModule;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;

@EnableConfigurationProperties(value={KeymasterProperties.class})
@Configuration(proxyBeanMethods=false)
public class ZookeeperKeymasterClientContext {
    private static final Pattern IPV4 = Pattern.compile("^((\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})\\.(\\d{1,3})|[a-z\\.]+):[0-9]+$");

    @Conditional(value={ZookeeperCondition.class})
    @ConditionalOnMissingBean
    @Bean
    public ZKClientConfig zkClientConfig() {
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        zkClientConfig.setProperty("zookeeper.fips-mode", "false");
        return zkClientConfig;
    }

    @Conditional(value={ZookeeperCondition.class})
    @Bean
    public CuratorFramework curatorFramework(ZKClientConfig zkClientConfig, final KeymasterProperties props) throws InterruptedException {
        if (StringUtils.isNotBlank((CharSequence)props.getUsername()) && StringUtils.isNotBlank((CharSequence)props.getPassword())) {
            javax.security.auth.login.Configuration.setConfiguration(new javax.security.auth.login.Configuration(this){
                private final AppConfigurationEntry[] entries;
                {
                    this.entries = new AppConfigurationEntry[]{new AppConfigurationEntry(DigestLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Map.of("username", props.getUsername(), "password", props.getPassword()))};
                }

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    return this.entries;
                }
            });
        }
        CuratorFrameworkFactory.Builder clientBuilder = CuratorFrameworkFactory.builder().connectString(props.getAddress()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(props.getBaseSleepTimeMs(), props.getMaxRetries()));
        if (StringUtils.isNotBlank((CharSequence)props.getUsername())) {
            clientBuilder.authorization("digest", props.getUsername().getBytes()).aclProvider(new ACLProvider(this){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        CuratorFramework client = clientBuilder.zkClientConfig(zkClientConfig).build();
        client.start();
        client.blockUntilConnected(3, TimeUnit.SECONDS);
        return client;
    }

    @Conditional(value={ZookeeperCondition.class})
    @Bean
    public ConfParamOps selfConfParamOps(CuratorFramework client) {
        return new ZookeeperConfParamOps(client);
    }

    @Conditional(value={ZookeeperCondition.class})
    @Bean
    public ServiceOps serviceOps() {
        return new ZookeeperServiceDiscoveryOps();
    }

    @Conditional(value={ZookeeperCondition.class})
    @Bean
    public DomainOps domainOps() {
        return new ZookeeperDomainOps();
    }

    static class ZookeeperCondition
    extends SpringBootCondition {
        ZookeeperCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String keymasterAddress = context.getEnvironment().getProperty("keymaster.address");
            return new ConditionOutcome(keymasterAddress != null && IPV4.matcher(keymasterAddress).matches(), "Keymaster address not set for Zookeeper: " + keymasterAddress);
        }
    }
}

