/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow.account;

import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.gauth.CoreGoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.springframework.webflow.execution.RequestContext;

public class GoogleMultifactorAuthenticationAccountProfilePrepareAction
extends ConsumerExecutionAction {
    public GoogleMultifactorAuthenticationAccountProfilePrepareAction(OneTimeTokenCredentialRepository repository, MultifactorAuthenticationProvider googleAuthenticatorMultifactorAuthenticationProvider, CasConfigurationProperties casProperties) {
        super(requestContext -> {
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            CoreGoogleAuthenticatorMultifactorProperties core = casProperties.getAuthn().getMfa().getGauth().getCore();
            boolean enabled = (core.isMultipleDeviceRegistrationEnabled() || repository.count(principal.getId()) == 0L) && MultifactorAuthenticationWebflowUtils.isMultifactorDeviceRegistrationEnabled((RequestContext)requestContext);
            requestContext.getFlowScope().put("gauthAccountProfileRegistrationEnabled", (Object)enabled);
            MultifactorAuthenticationWebflowUtils.putMultifactorAuthenticationProvider((RequestContext)requestContext, (MultifactorAuthenticationProvider)googleAuthenticatorMultifactorAuthenticationProvider);
        });
    }
}

