/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.Uuid;

public final class ReplicaKey {
    private final int id;
    private final Optional<Uuid> directoryId;

    private ReplicaKey(int id, Optional<Uuid> directoryId) {
        this.id = id;
        this.directoryId = directoryId;
    }

    public int id() {
        return this.id;
    }

    public Optional<Uuid> directoryId() {
        return this.directoryId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaKey that = (ReplicaKey)o;
        if (this.id != that.id) {
            return false;
        }
        return Objects.equals(this.directoryId, that.directoryId);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.directoryId);
    }

    public String toString() {
        return String.format("ReplicaKey(id=%d, directoryId=%s)", this.id, this.directoryId);
    }

    public static ReplicaKey of(int id, Optional<Uuid> directoryId) {
        return new ReplicaKey(id, directoryId);
    }
}

