/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet.result;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.result.RequestResultMatchers;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001J\u001a\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0010\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0014\u001a\u00020\t\"\u0004\b\u0000\u0010\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u001f\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0017\"\u00020\u0012\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/springframework/test/web/servlet/result/RequestResultMatchersDsl;", "", "actions", "Lorg/springframework/test/web/servlet/ResultActions;", "(Lorg/springframework/test/web/servlet/ResultActions;)V", "matchers", "Lorg/springframework/test/web/servlet/result/RequestResultMatchers;", "kotlin.jvm.PlatformType", "asyncNotStarted", "", "asyncResult", "expectedResult", "T", "matcher", "Lorg/hamcrest/Matcher;", "asyncStarted", "attribute", "name", "", "expectedValue", "sessionAttribute", "sessionAttributeDoesNotExist", "names", "", "([Ljava/lang/String;)V", "spring-test"})
public final class RequestResultMatchersDsl {
    @NotNull
    private final ResultActions actions;
    private final RequestResultMatchers matchers;

    public RequestResultMatchersDsl(@NotNull ResultActions actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.actions = actions;
        this.matchers = MockMvcResultMatchers.request();
    }

    public final void asyncStarted() {
        this.actions.andExpect(this.matchers.asyncStarted());
    }

    public final void asyncNotStarted() {
        this.actions.andExpect(this.matchers.asyncNotStarted());
    }

    public final <T> void asyncResult(@NotNull Matcher<T> matcher) {
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.asyncResult(matcher));
    }

    public final void asyncResult(@Nullable Object expectedResult) {
        this.actions.andExpect(this.matchers.asyncResult(expectedResult));
    }

    public final <T> void attribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.attribute(name, matcher));
    }

    public final void attribute(@NotNull String name, @Nullable Object expectedValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.attribute(name, expectedValue));
    }

    public final <T> void sessionAttribute(@NotNull String name, @NotNull Matcher<T> matcher) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
        this.actions.andExpect(this.matchers.sessionAttribute(name, matcher));
    }

    public final void sessionAttribute(@NotNull String name, @Nullable Object expectedValue) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.actions.andExpect(this.matchers.sessionAttribute(name, expectedValue));
    }

    public final void sessionAttributeDoesNotExist(String ... names) {
        Intrinsics.checkNotNullParameter((Object)names, (String)"names");
        this.actions.andExpect(this.matchers.sessionAttributeDoesNotExist(Arrays.copyOf(names, names.length)));
    }
}

