/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.audit.listener.AuditApplicationEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class FilterAndDelegateAuditTrailManager
implements AuditTrailManager,
ApplicationEventPublisherAware {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterAndDelegateAuditTrailManager.class);
    private final Collection<AuditTrailManager> auditTrailManagers;
    private final List<String> supportedActionsPerformed;
    private final List<String> excludedActionsPerformed;
    private ApplicationEventPublisher applicationEventPublisher;

    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditTrailManagers.forEach(mgr -> mgr.setAuditFormat(auditFormat));
    }

    public void record(AuditActionContext ctx) {
        boolean matched = this.supportedActionsPerformed.stream().anyMatch(action -> {
            String actionPerformed = ctx.getActionPerformed();
            return "*".equals(action) || Pattern.compile(action).matcher(actionPerformed).find();
        });
        if (matched) {
            matched = this.excludedActionsPerformed.stream().noneMatch(action -> {
                String actionPerformed = ctx.getActionPerformed();
                return "*".equals(action) || Pattern.compile(action).matcher(actionPerformed).find();
            });
        }
        if (matched) {
            LOGGER.trace("Recording audit action context [{}]", (Object)ctx);
            this.auditTrailManagers.forEach(mgr -> mgr.record(ctx));
            if (this.applicationEventPublisher != null) {
                AuditApplicationEvent auditEvent = new AuditApplicationEvent(ctx.getPrincipal(), ctx.getActionPerformed(), new String[]{ctx.getApplicationCode(), ctx.getClientInfo().getClientIpAddress(), ctx.getClientInfo().getServerIpAddress(), ctx.getResourceOperatedUpon(), ctx.getWhenActionWasPerformed().toString(), ctx.getClientInfo().getGeoLocation(), ctx.getClientInfo().getUserAgent(), ctx.getClientInfo().getLocale().getLanguage()});
                this.applicationEventPublisher.publishEvent((ApplicationEvent)auditEvent);
            }
        } else {
            LOGGER.trace("Skipping to record audit action context [{}] as it's not authorized as an audit action among [{}]", (Object)ctx, this.supportedActionsPerformed);
        }
    }

    public List<? extends AuditActionContext> getAuditRecords(Map<AuditTrailManager.WhereClauseFields, Object> params) {
        return this.auditTrailManagers.stream().map(mgr -> mgr.getAuditRecords(params)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public void removeAll() {
        this.auditTrailManagers.forEach(AuditTrailManager::removeAll);
    }

    @Generated
    public FilterAndDelegateAuditTrailManager(Collection<AuditTrailManager> auditTrailManagers, List<String> supportedActionsPerformed, List<String> excludedActionsPerformed) {
        this.auditTrailManagers = auditTrailManagers;
        this.supportedActionsPerformed = supportedActionsPerformed;
        this.excludedActionsPerformed = excludedActionsPerformed;
    }

    @Generated
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

