/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.JobType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.persistence.api.dao.JobStatusDAO;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.java.job.SyncopeTaskScheduler;
import org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob;
import org.apache.syncope.core.provisioning.java.job.TaskJob;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;

abstract class AbstractJobLogic<T extends EntityTO>
extends AbstractTransactionalLogic<T> {
    protected final JobManager jobManager;
    protected final SyncopeTaskScheduler scheduler;
    protected final JobStatusDAO jobStatusDAO;

    protected AbstractJobLogic(JobManager jobManager, SyncopeTaskScheduler scheduler, JobStatusDAO jobStatusDAO) {
        this.jobManager = jobManager;
        this.scheduler = scheduler;
        this.jobStatusDAO = jobStatusDAO;
    }

    protected abstract JobReference getReference(String var1);

    protected Optional<JobTO> getJobTO(String jobName, boolean includeCustom) {
        Optional<Class> jobClass;
        JobTO jobTO = null;
        JobReference reference = this.getReference(jobName);
        if (reference != null) {
            jobTO = new JobTO();
            jobTO.setType(reference.type());
            jobTO.setRefKey(reference.key());
            jobTO.setRefDesc(reference.desc());
        } else if (includeCustom && (jobClass = this.scheduler.getJobClass(AuthContextUtils.getDomain(), jobName).filter(jc -> !TaskJob.class.isAssignableFrom((Class<?>)jc) && !ReportJob.class.isAssignableFrom((Class<?>)jc) && !SystemLoadReporterJob.class.isAssignableFrom((Class<?>)jc) && !NotificationJob.class.isAssignableFrom((Class<?>)jc))).isPresent()) {
            jobTO = new JobTO();
            jobTO.setType(JobType.CUSTOM);
            jobTO.setRefKey(jobName);
            jobTO.setRefDesc(jobClass.get().getName());
        }
        if (jobTO != null) {
            Optional nextTrigger = this.scheduler.getNextTrigger(AuthContextUtils.getDomain(), jobName);
            if (nextTrigger.isPresent()) {
                jobTO.setScheduled(true);
                jobTO.setStart((OffsetDateTime)nextTrigger.get());
            } else {
                jobTO.setScheduled(false);
            }
            jobTO.setRunning(this.jobManager.isRunning(jobName));
            jobTO.setStatus(this.jobStatusDAO.get(jobName));
        }
        return Optional.ofNullable(jobTO);
    }

    protected List<JobTO> doListJobs(boolean includeCustom) {
        ArrayList<JobTO> jobTOs = new ArrayList<JobTO>();
        for (String jobName : this.scheduler.getJobNames(AuthContextUtils.getDomain())) {
            this.getJobTO(jobName, includeCustom).ifPresent(jobTOs::add);
        }
        return jobTOs;
    }

    protected void doActionJob(String jobName, JobAction action) {
        switch (action) {
            case START: {
                this.scheduler.start(AuthContextUtils.getDomain(), jobName);
                break;
            }
            case STOP: {
                this.scheduler.stop(AuthContextUtils.getDomain(), jobName);
                break;
            }
            case DELETE: {
                this.scheduler.delete(AuthContextUtils.getDomain(), jobName);
                break;
            }
        }
    }

    protected record JobReference(JobType type, String key, String desc) {
    }
}

