/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.decorator.CachingDecorator;
import org.apache.avalon.excalibur.logger.decorator.LogToSelfDecorator;
import org.apache.avalon.excalibur.logger.decorator.PrefixDecorator;
import org.apache.avalon.excalibur.logger.log4j.Log4JConfAdapter;
import org.apache.avalon.excalibur.logger.logkit.LogKitAdapter;
import org.apache.avalon.excalibur.logger.logkit.LogKitConfHelper;
import org.apache.avalon.excalibur.logger.logkit.LogKitLoggerHelper;
import org.apache.avalon.excalibur.logger.util.LoggerManagerTee;
import org.apache.log.Hierarchy;

public class Facade {
    public static LoggerManager createLogKitConfigurable(String prefix, String switchTo) {
        Hierarchy hierarchy = new Hierarchy();
        LogKitAdapter bare = new LogKitAdapter(hierarchy);
        LoggerManager decorated = Facade.applyDecorators(bare, prefix, switchTo);
        LoggerManagerTee tee = new LoggerManagerTee(decorated);
        tee.addTee(new LogKitLoggerHelper(hierarchy));
        tee.addTee((Object)new LogKitConfHelper(hierarchy));
        tee.makeReadOnly();
        return tee;
    }

    public static LoggerManager createLog4JConfigurable(String prefix, String switchTo) {
        Log4JConfAdapter bare = new Log4JConfAdapter();
        LoggerManager decorated = Facade.applyDecorators(bare, prefix, switchTo);
        return decorated;
    }

    private static LoggerManager applyDecorators(LoggerManager target, String prefix, String switchTo) {
        if (switchTo != null) {
            target = new LogToSelfDecorator(target, switchTo);
        }
        if (prefix != null && prefix.length() > 0) {
            target = new PrefixDecorator(target, prefix);
        }
        target = new CachingDecorator(target);
        return target;
    }
}

