/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.avaloncomponent;

import java.io.File;
import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.configuration.Configuration;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;
import org.apache.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.avaloncomponent.AvalonComponentService;

public class ACSYaafiComponentService
extends TurbineBaseService
implements AvalonComponentService,
Initializable,
Disposable {
    public static final String SERVICE_NAME = "YaafiComponentService";
    public static final String CONTAINER_CONFIGURATION_KEY = "containerConfiguration";
    public static final String CONTAINER_CONFIGURATION_VALUE = "/WEB-INF/conf/containerConfiguration.xml";
    public static final String COMPONENT_PARAMETERS_KEY = "parameters";
    public static final String COMPONENT_PARAMETERS_VALUE = "/WEB-INF/conf/parameters.properties";
    private ServiceContainer container;
    private Logger logger = Logger.getLogger((Class)ACSYaafiComponentService.class);

    public void init() throws InitializationException {
        try {
            this.logger.info((Object)"Initializing ACSYaafiComponentService ...");
            this.initialize();
            this.setInit(true);
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception caught initializing service: ", (Throwable)e);
            throw new InitializationException("Initializing ACSYaafiComponentService failed", e);
        }
    }

    public void shutdown() {
        this.logger.info((Object)"Disposing ACSYaafiComponentService ...");
        this.dispose();
        this.setInit(false);
    }

    public void initialize() throws Exception {
        Configuration conf = this.getConfiguration();
        String homePath = Turbine.getRealPath("/");
        if (homePath == null) {
            homePath = Turbine.getApplicationRoot();
        }
        File home = new File(homePath);
        this.logger.info((Object)("Using the following home : " + home.getAbsolutePath()));
        ServiceContainerConfiguration config = this.createServiceContainerConfiguration(conf, home.getAbsolutePath());
        try {
            this.container = ServiceContainerFactory.create((ServiceContainerConfiguration)config);
        }
        catch (Throwable t) {
            throw new Exception("Initializing YAAFI failed", t);
        }
    }

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    public Component lookup(String path) throws ComponentException {
        try {
            return (Component)this.container.lookup(path);
        }
        catch (ServiceException e) {
            throw new ComponentException(e.getKey(), e.getMessage(), (Throwable)e);
        }
    }

    public void release(Component component) {
        this.container.release((Object)component);
    }

    protected ServiceContainerConfiguration createServiceContainerConfiguration(Configuration conf, String appRoot) throws IOException {
        ServiceContainerConfiguration result = new ServiceContainerConfiguration();
        result.setLogger(this.createAvalonLogger("avalon"));
        result.setApplicationRootDir(appRoot);
        if (conf.containsKey(CONTAINER_CONFIGURATION_KEY)) {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY);
            result.loadContainerConfiguration(containerConfiguration);
        } else if (conf.containsKey("componentRoles")) {
            String roleConfigurationFileName = conf.getString("componentRoles", "/WEB-INF/conf/roleConfiguration.xml");
            String componentConfigurationFileName = conf.getString("componentConfiguration", "/WEB-INF/conf/componentConfiguration.xml");
            String parametersFileName = conf.getString(COMPONENT_PARAMETERS_KEY, COMPONENT_PARAMETERS_VALUE);
            result.setComponentRolesLocation(roleConfigurationFileName);
            result.setComponentConfigurationLocation(componentConfigurationFileName);
            result.setParametersLocation(parametersFileName);
        } else {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY, CONTAINER_CONFIGURATION_VALUE);
            result.loadContainerConfiguration(containerConfiguration);
        }
        return result;
    }

    protected org.apache.avalon.framework.logger.Logger createAvalonLogger(String name) {
        return new Log4JLogger(Logger.getLogger((String)name));
    }
}

