/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.Normalize;

public class CalculateDeviceName
extends FieldCalculator {
    private static final Pattern CLEAN_1_PATTERN = Pattern.compile("AppleWebKit", 18);

    private String removeBadSubStrings(String input) {
        input = CLEAN_1_PATTERN.matcher(input).replaceAll("");
        return input;
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField.MutableAgentField deviceName = userAgent.get("DeviceName");
        if (!deviceName.isDefaultValue()) {
            AgentField.MutableAgentField deviceBrand = userAgent.get("DeviceBrand");
            String deviceNameValue = this.removeBadSubStrings(deviceName.getValue());
            String deviceBrandValue = deviceBrand.getValue();
            deviceNameValue = deviceName.getConfidence() >= 0L && deviceBrand.getConfidence() >= 0L && !deviceBrandValue.equals("Unknown") ? Normalize.cleanupDeviceBrandName(deviceBrandValue, deviceNameValue) : Normalize.brand(deviceNameValue);
            userAgent.setForced("DeviceName", deviceNameValue, deviceName.getConfidence());
        }
    }

    @Override
    public String getCalculatedFieldName() {
        return "DeviceName";
    }

    @Override
    public Set<String> getDependencies() {
        return Collections.singleton("DeviceBrand");
    }

    @Override
    public String toString() {
        return "Calculate DeviceName";
    }
}

