/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule;

import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RuleElementCaretaker
implements RuleElementContainer {
    private final RuleElementContainer container;

    public RuleElementCaretaker(RuleElementContainer container) {
        this.container = container;
    }

    public RuleElement getElementAfter(RuleElement element) {
        int indexOf = this.container.getRuleElements().indexOf(element);
        if (indexOf < this.container.getRuleElements().size() - 1) {
            RuleElement ruleElement = this.container.getRuleElements().get(indexOf + 1);
            return ruleElement;
        }
        return null;
    }

    public RuleElement getElementBefore(RuleElement element) {
        int indexOf = this.container.getRuleElements().indexOf(element);
        if (indexOf > 0) {
            RuleElement ruleElement = this.container.getRuleElements().get(indexOf - 1);
            return ruleElement;
        }
        if (indexOf == -1) {
            return this.container.getRuleElements().get(this.container.getRuleElements().size() - 1);
        }
        return null;
    }

    @Override
    public List<RuleElement> getRuleElements() {
        return this.container.getRuleElements();
    }

    @Override
    public RuleElement getAnchoringRuleElement(RutaStream stream) {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        if (ruleElements.size() == 1) {
            return ruleElements.get(0);
        }
        for (RuleElement ruleElement : ruleElements) {
            RuleElement anchoringRuleElement;
            if (ruleElement.isStartAnchor()) {
                return ruleElement;
            }
            if (!(ruleElement instanceof ComposedRuleElement) || !(anchoringRuleElement = ((ComposedRuleElement)ruleElement).getAnchoringRuleElement(stream)).isStartAnchor()) continue;
            return ruleElement;
        }
        if (stream.isDynamicAnchoring()) {
            long min = Long.MAX_VALUE;
            RuleElement minElement = null;
            int i = 1;
            for (RuleElement each : ruleElements) {
                long estimate = each.estimateAnchors(stream);
                if (estimate == 0L) {
                    return each;
                }
                double factor = stream.getIndexPenalty();
                if (factor != 0.0) {
                    estimate = (long)(Math.log(estimate) * ((double)i * factor));
                }
                if (estimate < min) {
                    min = estimate;
                    minElement = each;
                }
                ++i;
            }
            return minElement;
        }
        return ruleElements.get(0);
    }

    @Override
    public RuleElement getFirstElement() {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        return ruleElements.get(0);
    }

    @Override
    public RuleElement getLastElement() {
        List<RuleElement> ruleElements = this.container.getRuleElements();
        return ruleElements.get(ruleElements.size() - 1);
    }

    @Override
    public void applyRuleElements(RuleMatch ruleMatch, RutaStream stream, InferenceCrowd crowd) {
        for (RuleElement eachElement : this.getRuleElements()) {
            eachElement.apply(ruleMatch, stream, crowd);
        }
    }

    @Override
    public RuleElement getNextElement(boolean after, RuleElement ruleElement) {
        if (after) {
            return this.getElementAfter(ruleElement);
        }
        return this.getElementBefore(ruleElement);
    }
}

