/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.AbstractBooleanListExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.AbstractNumberListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class CountCondition
extends TypeSentiveCondition {
    private final INumberExpression min;
    private final INumberExpression max;
    private final String var;
    private ListExpression list;
    private IRutaExpression arg;

    public CountCondition(ITypeExpression type, INumberExpression min, INumberExpression max, String var) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public CountCondition(ListExpression list, IRutaExpression a, INumberExpression min, INumberExpression max, String var) {
        super((ITypeExpression)null);
        this.list = list;
        this.arg = a;
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    @Override
    public EvaluatedCondition eval(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS annotation = context.getAnnotation();
        RuleElement element = context.getElement();
        if (this.arg == null) {
            Type t = this.type.getType(context, stream);
            if (t == null) {
                return new EvaluatedCondition(this, false);
            }
            List<AnnotationFS> annotationsInWindow = stream.getAnnotationsInWindow(annotation, t);
            int count = annotationsInWindow.size();
            if (this.var != null) {
                element.getParent().getEnvironment().setVariableValue(this.var, count);
            }
            boolean value = count >= this.min.getIntegerValue(context, stream) && count <= this.max.getIntegerValue(context, stream);
            return new EvaluatedCondition(this, value);
        }
        int count = 0;
        if (this.arg instanceof IBooleanExpression && this.list instanceof AbstractBooleanListExpression) {
            e = (IBooleanExpression)this.arg;
            AbstractBooleanListExpression le = (AbstractBooleanListExpression)this.list;
            boolean v = e.getBooleanValue(context, stream);
            ArrayList l = new ArrayList(le.getList(context, stream));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof INumberExpression && this.list instanceof AbstractNumberListExpression) {
            e = (INumberExpression)this.arg;
            AbstractNumberListExpression le = (AbstractNumberListExpression)this.list;
            Double v = e.getDoubleValue(context, stream);
            ArrayList l = new ArrayList(le.getList(context, stream));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof IStringExpression && this.list instanceof AbstractStringListExpression) {
            e = (IStringExpression)this.arg;
            AbstractStringListExpression le = (AbstractStringListExpression)this.list;
            String v = e.getStringValue(context, stream);
            ArrayList l = new ArrayList(le.getList(context, stream));
            while (l.remove(v)) {
                ++count;
            }
        } else if (this.arg instanceof ITypeExpression && this.list instanceof AbstractTypeListExpression) {
            e = (ITypeExpression)this.arg;
            AbstractTypeListExpression le = (AbstractTypeListExpression)this.list;
            Type v = e.getType(context, stream);
            ArrayList l = new ArrayList(le.getList(context, stream));
            while (l.remove(v)) {
                ++count;
            }
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, count);
        }
        boolean value = count >= this.min.getIntegerValue(context, stream) && count <= this.max.getIntegerValue(context, stream);
        return new EvaluatedCondition(this, value);
    }

    public INumberExpression getMin() {
        return this.min;
    }

    public INumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }

    public ListExpression getArgList() {
        return this.list;
    }

    public IRutaExpression getArg() {
        return this.arg;
    }
}

