/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.rule.quantifier;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleElementContainer;
import org.apache.uima.ruta.rule.RuleElementMatch;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;

public abstract class AbstractRuleElementQuantifier
implements RuleElementQuantifier {
    protected boolean nextElementMatched(RuleElement nextElement, List<RuleMatch> matches) {
        if (matches == null) {
            return false;
        }
        for (RuleMatch eachRuleMatch : matches) {
            if (eachRuleMatch == null) continue;
            List<List<RuleElementMatch>> matchInfo = eachRuleMatch.getMatchInfo(nextElement);
            for (List<RuleElementMatch> list : matchInfo) {
                if (list == null) continue;
                for (RuleElementMatch ruleElementMatch : list) {
                    if (ruleElementMatch == null || !ruleElementMatch.matched()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected RuleElement getNextRuleElement(boolean after, RuleElement ruleElement) {
        RuleElement nextElement = null;
        RuleElementContainer container = ruleElement.getContainer();
        RuleElement previousElement = ruleElement;
        while (nextElement == null && container instanceof ComposedRuleElement) {
            nextElement = container.getNextElement(after, previousElement);
            previousElement = (ComposedRuleElement)container;
            container = ((ComposedRuleElement)container).getContainer();
        }
        return nextElement;
    }

    protected void updateLabelAssignment(List<RuleElementMatch> matches, MatchContext context, RutaStream stream) {
        RutaEnvironment environment = context.getParent().getEnvironment();
        RuleElement ruleElement = context.getElement();
        String label = ruleElement.getLabel();
        if (matches == null || matches.isEmpty()) {
            environment.removeVariableValue(label, context);
            return;
        }
        if (!StringUtils.isBlank((CharSequence)label)) {
            RuleElementMatch ruleElementMatch = matches.get(matches.size() - 1);
            List<AnnotationFS> textsMatched = ruleElementMatch.getTextsMatched();
            environment.addAnnotationsToVariable(textsMatched, label, context);
        }
    }
}

