/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cpm;

import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.apache.uima.tools.util.gui.FileSelector;
import org.apache.uima.tools.util.gui.ListSelector;

public class ConfigField {
    private String parameterName;
    private String classString;
    private boolean isMultiValued;
    private JComponent fieldComponent;
    private Object originalValue;
    private Object lastSavedValue;

    public ConfigField(String pn, String cs, boolean mv, JComponent c) {
        this.parameterName = pn;
        this.classString = cs;
        this.isMultiValued = mv;
        this.fieldComponent = c;
        this.lastSavedValue = this.originalValue = this.getFieldValue();
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getClassString() {
        return this.classString;
    }

    public JComponent getFieldComponent() {
        return this.fieldComponent;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public Object getFieldValue() {
        if (this.fieldComponent instanceof JTextField) {
            String fieldString = ((JTextField)this.fieldComponent).getText();
            if (this.classString.equals("Integer")) {
                try {
                    return Integer.valueOf(fieldString);
                }
                catch (NumberFormatException e) {
                    return fieldString;
                }
            }
            if (this.classString.equals("Float")) {
                try {
                    return Float.valueOf(fieldString);
                }
                catch (NumberFormatException e) {
                    return fieldString;
                }
            }
            return fieldString;
        }
        if (this.fieldComponent instanceof JCheckBox) {
            return ((JCheckBox)this.fieldComponent).isSelected();
        }
        if (this.fieldComponent instanceof FileSelector) {
            return ((FileSelector)this.fieldComponent).getSelected();
        }
        if (this.fieldComponent instanceof ListSelector) {
            String[] valueStrings = ((ListSelector)this.fieldComponent).getValues();
            if (valueStrings == null) {
                return null;
            }
            try {
                if (this.classString.equals("Integer")) {
                    Integer[] intValues = new Integer[valueStrings.length];
                    for (int i = 0; i < valueStrings.length; ++i) {
                        intValues[i] = Integer.valueOf(valueStrings[i]);
                    }
                    return intValues;
                }
                if (this.classString.equals("Float")) {
                    Float[] floatValues = new Float[valueStrings.length];
                    for (int i = 0; i < valueStrings.length; ++i) {
                        floatValues[i] = Float.valueOf(valueStrings[i]);
                    }
                    return floatValues;
                }
                return valueStrings;
            }
            catch (NumberFormatException e) {
                return valueStrings;
            }
        }
        return null;
    }

    public void setFieldValue(Object fieldValue) {
        if (this.fieldComponent instanceof JTextField) {
            ((JTextField)this.fieldComponent).setText(fieldValue.toString());
        } else if (this.fieldComponent instanceof JCheckBox) {
            boolean onOff = "true".equalsIgnoreCase(fieldValue.toString());
            ((JCheckBox)this.fieldComponent).setSelected(onOff);
        } else if (this.fieldComponent instanceof FileSelector) {
            ((FileSelector)this.fieldComponent).setSelected(fieldValue.toString());
        } else if (this.isMultiValued) {
            Object[] vals = fieldValue instanceof Object[] ? (Object[])fieldValue : (fieldValue == null ? new Object[]{} : new Object[]{fieldValue});
            ((ListSelector)this.fieldComponent).populate(vals);
        }
    }

    public boolean isModified() {
        Object currentValue = this.getFieldValue();
        if (this.originalValue == null) {
            return currentValue != null;
        }
        if (this.originalValue instanceof Object[] && currentValue instanceof Object[]) {
            return !Arrays.equals((Object[])this.originalValue, (Object[])currentValue);
        }
        return !this.originalValue.equals(currentValue);
    }

    public boolean isDirty() {
        Object currentValue = this.getFieldValue();
        if (this.lastSavedValue == null) {
            return currentValue != null;
        }
        if (this.lastSavedValue instanceof Object[] && currentValue instanceof Object[]) {
            return !Arrays.equals((Object[])this.lastSavedValue, (Object[])currentValue);
        }
        return !this.lastSavedValue.equals(currentValue);
    }

    public void clearDirty() {
        this.lastSavedValue = this.getFieldValue();
    }
}

