/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.caseditor.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SerialFormat;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.caseditor.CasEditorPlugin;
import org.apache.uima.caseditor.editor.AbstractDocument;
import org.apache.uima.caseditor.editor.util.StrictTypeConstraint;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.impl.ResourceManager_impl;
import org.apache.uima.resource.metadata.FsIndexDescription;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.resource.metadata.impl.FsIndexDescription_impl;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.preference.IPreferenceStore;

public class DocumentUimaImpl
extends AbstractDocument {
    public static final String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    private CAS mCAS;
    private SerialFormat format = SerialFormat.XMI;
    private final String typeSystemText;

    public DocumentUimaImpl(CAS cas, IFile casFile, String typeSystemText) throws CoreException {
        this.mCAS = cas;
        this.typeSystemText = typeSystemText;
        this.setContent(casFile);
    }

    @Override
    public CAS getCAS() {
        return this.mCAS;
    }

    @Override
    public String getTypeSystemText() {
        return this.typeSystemText;
    }

    private void addFeatureStructureInternal(FeatureStructure featureStructure) {
        this.getCAS().getIndexRepository().addFS(featureStructure);
    }

    @Override
    public void addFeatureStructure(FeatureStructure annotation) {
        this.addFeatureStructureInternal(annotation);
        this.fireAddedFeatureStructure(annotation);
    }

    @Override
    public void addFeatureStructures(Collection<? extends FeatureStructure> annotations) {
        for (FeatureStructure featureStructure : annotations) {
            this.addFeatureStructureInternal(featureStructure);
        }
        if (annotations.size() > 0) {
            this.fireAddedFeatureStructure(annotations);
        }
    }

    private void removeAnnotationInternal(FeatureStructure featureStructure) {
        this.getCAS().getIndexRepository().removeFS(featureStructure);
    }

    @Override
    public void removeFeatureStructure(FeatureStructure annotation) {
        this.removeAnnotationInternal(annotation);
        this.fireRemovedFeatureStructure(annotation);
    }

    @Override
    public void removeFeatureStructures(Collection<? extends FeatureStructure> annotationsToRemove) {
        for (FeatureStructure featureStructure : annotationsToRemove) {
            this.removeAnnotationInternal(featureStructure);
        }
        if (annotationsToRemove.size() > 0) {
            this.fireRemovedFeatureStructure(annotationsToRemove);
        }
    }

    @Override
    public void update(FeatureStructure annotation) {
        this.fireUpdatedFeatureStructure(annotation);
    }

    @Override
    public void updateFeatureStructure(Collection<? extends FeatureStructure> annotations) {
        this.fireUpdatedFeatureStructure(annotations);
    }

    @Override
    public void changed() {
        this.fireChanged();
    }

    @Override
    public Collection<AnnotationFS> getAnnotations(Type type) {
        AnnotationIndex annotationIndex = this.mCAS.getAnnotationIndex(type);
        StrictTypeConstraint typeConstrain = new StrictTypeConstraint(type);
        FSIterator strictTypeIterator = this.mCAS.createFilteredIterator(annotationIndex.iterator(), (FSMatchConstraint)typeConstrain);
        return DocumentUimaImpl.fsIteratorToCollection((FSIterator<AnnotationFS>)strictTypeIterator);
    }

    static Collection<AnnotationFS> fsIteratorToCollection(FSIterator<AnnotationFS> iterator) {
        LinkedList<AnnotationFS> annotations = new LinkedList<AnnotationFS>();
        while (iterator.hasNext()) {
            AnnotationFS annotation = (AnnotationFS)iterator.next();
            annotations.addFirst(annotation);
        }
        return annotations;
    }

    @Override
    public Type getType(String type) {
        return this.getCAS().getTypeSystem().getType(type);
    }

    @Override
    public void switchView(String viewName) {
        String oldViewName = this.mCAS.getViewName();
        this.mCAS = this.mCAS.getView(viewName);
        this.fireViewChanged(oldViewName, viewName);
    }

    private void setContent(IFile casFile) throws CoreException {
        IPreferenceStore store = CasEditorPlugin.getDefault().getPreferenceStore();
        boolean withPartialTypesystem = store.getBoolean("ANNOTATION_EDITOR_PARTIAL_TYPESYSTEM");
        URI uri = casFile.getLocationURI();
        if (casFile.isLinked()) {
            uri = casFile.getRawLocationURI();
        }
        File file = EFS.getStore((URI)uri).toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
        try {
            this.format = CasIOUtils.load((URL)file.toURI().toURL(), null, (CAS)this.mCAS, (boolean)withPartialTypesystem);
        }
        catch (IOException e) {
            this.throwCoreException(e);
        }
    }

    private void throwCoreException(Exception e) throws CoreException {
        String message = e.getMessage() != null ? e.getMessage() : "";
        Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
        throw new CoreException((IStatus)s);
    }

    public void serialize(OutputStream out) throws CoreException {
        try {
            CasIOUtils.save((CAS)this.mCAS, (OutputStream)out, (SerialFormat)this.format);
        }
        catch (IOException e) {
            this.throwCoreException(e);
        }
    }

    public static CAS getVirginCAS(IFile extensionTypeSystemFile) throws CoreException {
        CAS cas;
        TypeSystemDescription typeSystemDesciptor;
        ResourceSpecifierFactory resourceSpecifierFactory = UIMAFramework.getResourceSpecifierFactory();
        if (extensionTypeSystemFile == null || !extensionTypeSystemFile.exists()) {
            return null;
        }
        InputStream inTypeSystem = extensionTypeSystemFile.getContents();
        XMLInputSource xmlTypeSystemSource = new XMLInputSource(inTypeSystem, extensionTypeSystemFile.getLocation().toFile());
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        try {
            typeSystemDesciptor = (TypeSystemDescription)xmlParser.parse(xmlTypeSystemSource);
            IProject project = extensionTypeSystemFile.getProject();
            ClassLoader classLoader = DocumentUimaImpl.getProjectClassLoader(project);
            Object resourceManager = classLoader != null ? new ResourceManager_impl(classLoader) : UIMAFramework.newDefaultResourceManager();
            String dataPath = project.getPersistentProperty(new QualifiedName("", "CDEdataPath"));
            if (dataPath != null) {
                resourceManager.setDataPath(dataPath);
            }
            typeSystemDesciptor.resolveImports(resourceManager);
        }
        catch (MalformedURLException | InvalidXMLException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, e);
            throw new CoreException((IStatus)s);
        }
        TypePriorities typePriorities = resourceSpecifierFactory.createTypePriorities();
        FsIndexDescription_impl indexDesciptor = new FsIndexDescription_impl();
        indexDesciptor.setLabel("TOPIndex");
        indexDesciptor.setTypeName("uima.cas.TOP");
        indexDesciptor.setKind("sorted");
        try {
            cas = CasCreationUtils.createCas((TypeSystemDescription)typeSystemDesciptor, (TypePriorities)typePriorities, (FsIndexDescription[])new FsIndexDescription[]{indexDesciptor});
        }
        catch (ResourceInitializationException e) {
            String message = e.getMessage() != null ? e.getMessage() : "";
            Status s = new Status(4, "org.apache.uima.caseditor", 0, message, (Throwable)e);
            throw new CoreException((IStatus)s);
        }
        return cas;
    }

    public static ClassLoader getProjectClassLoader(IProject project) throws CoreException {
        IProjectNature javaNature = project.getNature(JAVA_NATURE);
        if (javaNature != null) {
            JavaProject javaProject = (JavaProject)JavaCore.create((IProject)project);
            String[] runtimeClassPath = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String cp : runtimeClassPath) {
                try {
                    urls.add(Paths.get(cp, new String[0]).toUri().toURL());
                }
                catch (MalformedURLException e) {
                    CasEditorPlugin.log(e);
                }
            }
            return new URLClassLoader(urls.toArray(new URL[0]));
        }
        return null;
    }
}

