/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.resource.metadata.impl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.UIMA_IllegalArgumentException;
import org.apache.uima.UIMA_UnsupportedOperationException;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.resource.metadata.AllowedValue;
import org.apache.uima.resource.metadata.MetaDataObject;
import org.apache.uima.resource.metadata.impl.MetaDataObjectSerializer_indent;
import org.apache.uima.resource.metadata.impl.MetaDataObjectSerializer_plain;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.util.ConcurrentHashMapWithProducer;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Level;
import org.apache.uima.util.NameClassPair;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLSerializer;
import org.apache.uima.util.XMLizable;
import org.apache.uima.util.impl.Settings_impl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class MetaDataObject_impl
implements MetaDataObject {
    static final long serialVersionUID = 5876728533863334480L;
    private static String PROP_NAME_SOURCE_URL = "sourceUrl";
    private static String PROP_NAME_INFOSET = "infoset";
    private static final Attributes EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final List<MetaDataAttr> EMPTY_ATTRIBUTE_LIST = Collections.emptyList();
    private static final transient ConcurrentHashMapWithProducer<Class<? extends MetaDataObject_impl>, MetaDataAttr[]> class2attrsMap = new ConcurrentHashMapWithProducer();
    private static final transient ConcurrentHashMapWithProducer<Class<? extends MetaDataObject_impl>, MetaDataAttr[]> class2attrsMapUnfiltered = new ConcurrentHashMapWithProducer();
    public static final ThreadLocal<SerialContext> serialContext = new ThreadLocal();
    private transient URL mSourceUrl;
    private transient Node infoset = null;

    public static SerialContext getSerialContext(ContentHandler ch) {
        SerialContext sc = serialContext.get();
        if (null == serialContext.get()) {
            sc = new SerialContext(ch, MetaDataObject_impl.getSerializerFromContentHandler(ch));
            serialContext.set(sc);
        }
        return sc;
    }

    public void setInfoset(Node infoset) {
        this.infoset = infoset;
    }

    public Node getInfoset() {
        return this.infoset;
    }

    public List<MetaDataAttr> getAdditionalAttributes() {
        return EMPTY_ATTRIBUTE_LIST;
    }

    MetaDataAttr[] getUnfilteredAttributes() {
        Class<?> clazz = this.getClass();
        MetaDataAttr[] attrs = (MetaDataAttr[])class2attrsMapUnfiltered.get(clazz);
        if (null == attrs) {
            this.getAttributesFromBeans(clazz);
        }
        return (MetaDataAttr[])class2attrsMapUnfiltered.get(clazz);
    }

    MetaDataAttr[] getAttributes() {
        Class<?> clazz = this.getClass();
        MetaDataAttr[] attrs = (MetaDataAttr[])class2attrsMap.get(clazz);
        if (null == attrs) {
            this.getAttributesFromBeans(clazz);
        }
        return (MetaDataAttr[])class2attrsMap.get(clazz);
    }

    private void getAttributesFromBeans(Class<? extends MetaDataObject_impl> clazz) {
        PropertyDescriptor[] pds;
        try {
            pds = Introspector.getBeanInfo(clazz, 3).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            throw new UIMARuntimeException(e);
        }
        ArrayList<MetaDataAttr> resultList = new ArrayList<MetaDataAttr>(pds.length);
        ArrayList<MetaDataAttr> resultListUnfiltered = new ArrayList<MetaDataAttr>(pds.length);
        for (PropertyDescriptor pd : pds) {
            String propName = pd.getName();
            Class propClass = pd.getPropertyType();
            if (null != propClass && propClass.isPrimitive()) {
                propClass = MetaDataObject_impl.getWrapperClass(propClass);
            }
            MetaDataAttr mda = new MetaDataAttr(propName, pd.getReadMethod(), pd.getWriteMethod(), propClass);
            resultListUnfiltered.add(mda);
            if (pd.getReadMethod() == null || pd.getWriteMethod() == null || pd.getName().equals(PROP_NAME_SOURCE_URL) || pd.getName().equals(PROP_NAME_INFOSET)) continue;
            resultList.add(mda);
        }
        resultList.addAll(this.getAdditionalAttributes());
        resultListUnfiltered.addAll(this.getAdditionalAttributes());
        MetaDataAttr[] attrs = resultList.toArray(new MetaDataAttr[resultList.size()]);
        MetaDataAttr[] otherAttrs = class2attrsMap.putIfAbsent(clazz, attrs);
        attrs = resultListUnfiltered.toArray(new MetaDataAttr[resultListUnfiltered.size()]);
        otherAttrs = class2attrsMapUnfiltered.putIfAbsent(clazz, attrs);
        attrs = otherAttrs != null ? otherAttrs : attrs;
    }

    @Override
    @Deprecated
    public List<NameClassPair> listAttributes() {
        try {
            PropertyDescriptor[] props = this.getPropertyDescriptors();
            ArrayList<NameClassPair> resultList = new ArrayList<NameClassPair>(props.length);
            for (int i = 0; i < props.length; ++i) {
                if (props[i].getReadMethod() == null || props[i].getWriteMethod() == null || props[i].getName().equals(PROP_NAME_SOURCE_URL) || props[i].getName().equals(PROP_NAME_INFOSET)) continue;
                String propName = props[i].getName();
                Class propClass = props[i].getPropertyType();
                if (propClass.isPrimitive()) {
                    propClass = MetaDataObject_impl.getWrapperClass(propClass);
                }
                resultList.add(new NameClassPair(propName, propClass.getName()));
            }
            return resultList;
        }
        catch (IntrospectionException e) {
            throw new UIMARuntimeException(e);
        }
    }

    private Object getAttributeValue(MetaDataAttr attr) {
        Method reader = attr.reader;
        if (reader != null) {
            try {
                return reader.invoke((Object)this, new Object[0]);
            }
            catch (Exception e) {
                throw new UIMARuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public Object getAttributeValue(String aName) {
        try {
            MetaDataAttr[] attrs;
            for (MetaDataAttr attr : attrs = this.getUnfilteredAttributes()) {
                Method reader;
                if (!attr.name.equals(aName) || (reader = attr.reader) == null) continue;
                return reader.invoke((Object)this, new Object[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new UIMARuntimeException(e);
        }
    }

    public Class getAttributeClass(String aName) {
        MetaDataAttr[] attrList;
        for (MetaDataAttr attr : attrList = this.getAttributes()) {
            if (!attr.name.equals(aName)) continue;
            return attr.clazz;
        }
        return null;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    private void setAttributeValue(MetaDataAttr attr, Object aValue) {
        Method writer = attr.writer;
        if (writer != null) {
            try {
                writer.invoke((Object)this, aValue);
            }
            catch (IllegalArgumentException e) {
                throw new UIMA_IllegalArgumentException("metadata_attribute_type_mismatch", new Object[]{aValue, attr.name}, e);
            }
            catch (Exception e) {
                throw new UIMARuntimeException(e);
            }
        }
    }

    @Override
    public void setAttributeValue(String aName, Object aValue) {
        try {
            MetaDataAttr[] attrs;
            for (MetaDataAttr attr : attrs = this.getUnfilteredAttributes()) {
                if (!attr.name.equals(aName)) continue;
                Method writer = attr.writer;
                if (writer != null) {
                    try {
                        writer.invoke((Object)this, aValue);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new UIMA_IllegalArgumentException("metadata_attribute_type_mismatch", new Object[]{aValue, aName}, e);
                    }
                }
                throw new UIMA_UnsupportedOperationException("not_modifiable", new Object[]{aName, this.getClass().getName()});
            }
        }
        catch (UIMA_IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UIMARuntimeException(e);
        }
    }

    public URL getRelativePathBase() {
        if (this.mSourceUrl != null) {
            return this.mSourceUrl;
        }
        try {
            return new File(System.getProperty("user.dir")).toURL();
        }
        catch (MalformedURLException e) {
            try {
                return new URL("file:/");
            }
            catch (MalformedURLException e1) {
                return null;
            }
        }
    }

    @Override
    public URL getSourceUrl() {
        return this.mSourceUrl;
    }

    @Override
    public String getSourceUrlString() {
        return this.mSourceUrl != null ? this.mSourceUrl.toString() : "<unknown>";
    }

    public void setSourceUrlIfNull(URL aUrl) {
        if (this.mSourceUrl == null) {
            this.setSourceUrl(aUrl);
        }
    }

    @Override
    public void setSourceUrl(URL aUrl) {
        MetaDataAttr[] attrs;
        this.mSourceUrl = aUrl;
        for (MetaDataAttr attr : attrs = this.getAttributes()) {
            Object val = this.getAttributeValue(attr);
            if (val instanceof MetaDataObject_impl) {
                ((MetaDataObject_impl)val).setSourceUrl(aUrl);
                continue;
            }
            if (val != null && val.getClass().isArray()) {
                Object[] arrayVal = (Object[])val;
                for (Object item : arrayVal) {
                    if (!(item instanceof MetaDataObject_impl)) continue;
                    ((MetaDataObject_impl)item).setSourceUrl(aUrl);
                }
                continue;
            }
            if (!(val instanceof Map)) continue;
            Collection values = ((Map)val).values();
            for (Object value : values) {
                if (!(value instanceof MetaDataObject_impl)) continue;
                ((MetaDataObject_impl)value).setSourceUrl(aUrl);
            }
        }
    }

    @Override
    public Object clone() {
        MetaDataAttr[] attrs;
        MetaDataObject_impl clone = null;
        try {
            clone = (MetaDataObject_impl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new UIMARuntimeException(e);
        }
        for (MetaDataAttr attr : attrs = this.getAttributes()) {
            Object val = this.getAttributeValue(attr);
            if (val instanceof MetaDataObject) {
                Object clonedVal = ((MetaDataObject)val).clone();
                clone.setAttributeValue(attr, clonedVal);
                continue;
            }
            if (val == null || !val.getClass().isArray()) continue;
            Class<?> componentType = val.getClass().getComponentType();
            int length = Array.getLength(val);
            Object arrayClone = Array.newInstance(componentType, length);
            for (int j = 0; j < length; ++j) {
                Object component = Array.get(val, j);
                if (component instanceof MetaDataObject) {
                    component = ((MetaDataObject)component).clone();
                }
                Array.set(arrayClone, j, component);
            }
            clone.setAttributeValue(attr, arrayClone);
        }
        return clone;
    }

    public String toString() {
        MetaDataAttr[] attrList;
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName()).append(": \n");
        for (MetaDataAttr attr : attrList = this.getAttributes()) {
            buf.append(attr.name + " = ");
            Object val = this.getAttributeValue(attr);
            if (val == null) {
                buf.append("NULL");
            } else if (val instanceof Object[]) {
                Object[] array = (Object[])val;
                buf.append("Array{");
                for (int j = 0; j < array.length; ++j) {
                    buf.append(j).append(": ").append(array[j].toString()).append('\n');
                }
                buf.append("}\n");
            } else {
                buf.append(val.toString());
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object aObj) {
        MetaDataAttr[] thoseAttrs;
        if (!(aObj instanceof MetaDataObject_impl)) {
            return false;
        }
        MetaDataObject_impl mdo = (MetaDataObject_impl)aObj;
        MetaDataAttr[] theseAttrs = this.getAttributes();
        if (theseAttrs.length != (thoseAttrs = mdo.getAttributes()).length) {
            return false;
        }
        List<MetaDataAttr> thoseAttrsAsList = Arrays.asList(thoseAttrs);
        for (MetaDataAttr attr : theseAttrs) {
            Object val2;
            if (!thoseAttrsAsList.contains(attr)) {
                return false;
            }
            Object val1 = this.getAttributeValue(attr);
            if (this.valuesEqual(val1, val2 = mdo.getAttributeValue(attr))) continue;
            return false;
        }
        return true;
    }

    private boolean valuesEqual(Object val1, Object val2) {
        if (val1 == null) {
            return val2 == null;
        }
        if (val1.getClass().isArray()) {
            if (val2.getClass() != val1.getClass()) {
                return false;
            }
            if (val1 instanceof String[]) {
                return Arrays.equals((String[])val1, (String[])val2);
            }
            if (val1 instanceof Object[]) {
                return Arrays.deepEquals((Object[])val1, (Object[])val2);
            }
            if (val1 instanceof int[]) {
                return Arrays.equals((int[])val1, (int[])val2);
            }
            if (val1 instanceof float[]) {
                return Arrays.equals((float[])val1, (float[])val2);
            }
            if (val1 instanceof double[]) {
                return Arrays.equals((double[])val1, (double[])val2);
            }
            if (val1 instanceof boolean[]) {
                return Arrays.equals((boolean[])val1, (boolean[])val2);
            }
            if (val1 instanceof byte[]) {
                return Arrays.equals((byte[])val1, (byte[])val2);
            }
            if (val1 instanceof short[]) {
                return Arrays.equals((short[])val1, (short[])val2);
            }
            if (val1 instanceof long[]) {
                return Arrays.equals((long[])val1, (long[])val2);
            }
            return Arrays.equals((char[])val1, (char[])val2);
        }
        if (val1 instanceof Map) {
            if (!(val2 instanceof Map) || ((Map)val1).size() != ((Map)val2).size() || val1.getClass() != val2.getClass()) {
                return false;
            }
            Set entrySet1 = ((Map)val1).entrySet();
            for (Map.Entry entry : entrySet1) {
                Object subval2;
                Object subval1 = ((Map)val1).get(entry.getKey());
                if (this.valuesEqual(subval1, subval2 = ((Map)val2).get(entry.getKey()))) continue;
                return false;
            }
            return true;
        }
        return val1.equals(val2);
    }

    public int hashCode() {
        MetaDataAttr[] attrs;
        int hashCode = 0;
        for (MetaDataAttr attr : attrs = this.getAttributes()) {
            Object val = this.getAttributeValue(attr);
            if (val == null) continue;
            if (val instanceof Object[]) {
                hashCode += Arrays.hashCode((Object[])val);
                continue;
            }
            if (val instanceof Map) {
                Set entrySet = ((Map)val).entrySet();
                for (Map.Entry entry : entrySet) {
                    hashCode += entry.getKey().hashCode();
                    Object subval = entry.getValue();
                    if (subval instanceof Object[]) {
                        hashCode += Arrays.hashCode((Object[])subval);
                        continue;
                    }
                    hashCode += subval.hashCode();
                }
                continue;
            }
            hashCode += val.hashCode();
        }
        return hashCode;
    }

    @Override
    public void toXML(Writer aWriter) throws SAXException, IOException {
        this.toXML(new XMLSerializer(aWriter));
    }

    @Override
    public void toXML(OutputStream aOutputStream) throws SAXException, IOException {
        this.toXML(new XMLSerializer(aOutputStream));
    }

    private void toXML(XMLSerializer sax2xml) throws SAXException, IOException {
        ContentHandler contentHandler = sax2xml.getContentHandler();
        contentHandler.startDocument();
        this.toXML(contentHandler, true);
        contentHandler.endDocument();
    }

    @Override
    public void toXML(ContentHandler aContentHandler) throws SAXException {
        this.toXML(aContentHandler, false);
    }

    @Override
    public void toXML(ContentHandler aContentHandler, boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        if (null == serialContext.get()) {
            MetaDataObject_impl.getSerialContext(aContentHandler);
            try {
                this.toXMLcommon(aWriteDefaultNamespaceAttribute);
            }
            finally {
                serialContext.remove();
            }
        } else {
            this.toXMLcommon(aWriteDefaultNamespaceAttribute);
        }
    }

    private static Serializer getSerializerFromContentHandler(ContentHandler aContentHandler) {
        return aContentHandler instanceof XMLSerializer.CharacterValidatingContentHandler ? new MetaDataObjectSerializer_indent((XMLSerializer.CharacterValidatingContentHandler)aContentHandler) : new MetaDataObjectSerializer_plain(aContentHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toXMLcommon(boolean aWriteDefaultNamespaceAttribute) throws SAXException {
        XmlizationInfo inf = this.getXmlizationInfo();
        Serializer serializer = MetaDataObject_impl.serialContext.get().serializer;
        AttributesImpl attrs = this.getXMLAttributes();
        if (aWriteDefaultNamespaceAttribute && inf.namespace != null) {
            ((MetaDataObjectSerializer_plain)serializer).startPrefixMapping("", inf.namespace);
        }
        serializer.outputStartElement(this.infoset, inf.namespace, inf.elementTagName, inf.elementTagName, attrs);
        serializer.saveAndAddNodeStore(this.infoset);
        try {
            boolean insertNl = serializer.indentChildElements(inf, this);
            for (PropertyXmlInfo propInf : inf.propertyInfo) {
                if (insertNl) {
                    serializer.insertNl();
                }
                this.writePropertyAsElement(propInf, inf.namespace);
            }
        }
        finally {
            serializer.deleteNodeStore();
        }
        serializer.outputEndElement(this.infoset, inf.namespace, inf.elementTagName, inf.elementTagName);
    }

    protected AttributesImpl getXMLAttributes() {
        return new AttributesImpl();
    }

    protected abstract XmlizationInfo getXmlizationInfo();

    protected PropertyXmlInfo getPropertyXmlInfo(String aXmlElementName) {
        PropertyXmlInfo[] inf = this.getXmlizationInfo().propertyInfo;
        for (int i = 0; i < inf.length; ++i) {
            if (!aXmlElementName.equals(inf[i].xmlElementName)) continue;
            return inf[i];
        }
        return null;
    }

    public boolean valueIsNullOrEmptyArray(Object val) {
        return val == null || val.getClass().isArray() && ((Object[])val).length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePropertyAsElement(PropertyXmlInfo aPropInfo, String aNamespace) throws SAXException {
        SerialContext sc = serialContext.get();
        Serializer serializer = sc.serializer;
        Object val = this.getAttributeValue(aPropInfo.propertyName);
        if (serializer.shouldBeSkipped(aPropInfo, val, this)) {
            return;
        }
        String elementName = aPropInfo.xmlElementName;
        Node elementNode = null;
        if (null != elementName) {
            elementNode = this.getMatchingNode(sc, aPropInfo.xmlElementName);
            if (serializer.startElementProperty()) {
                serializer.outputStartElement(elementNode, aNamespace, aPropInfo.xmlElementName, aPropInfo.xmlElementName, EMPTY_ATTRIBUTES);
            }
            serializer.addNodeStore();
        }
        Class propClass = this.getAttributeClass(aPropInfo.propertyName);
        try {
            if (val != null) {
                if (aPropInfo.xmlElementName != null) {
                    serializer.writeDelayedStart(aPropInfo.xmlElementName);
                }
                if (val.getClass().isArray()) {
                    this.writeArrayPropertyAsElement(aPropInfo.propertyName, propClass, val, aPropInfo.arrayElementTagName, aNamespace);
                } else if (val instanceof XMLizable) {
                    ((XMLizable)val).toXML(sc.ch);
                } else if (propClass == Object.class) {
                    this.writePrimitiveValue(val);
                } else {
                    serializer.writeSimpleValue(val);
                }
            }
        }
        finally {
            if (null != elementName) {
                serializer.deleteNodeStore();
                if (serializer.startElementProperty()) {
                    serializer.outputEndElement(elementNode, aNamespace, aPropInfo.xmlElementName, aPropInfo.xmlElementName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeArrayPropertyAsElement(String aPropName, Class aPropClass, Object aValue, String aArrayElementTagName, String aNamespace) throws SAXException {
        SerialContext sc = serialContext.get();
        Serializer serializer = sc.serializer;
        Node arraySubElement = null;
        if (serializer.shouldEncloseInArrayElement(aPropClass)) {
            arraySubElement = this.getMatchingNode(sc, "array");
            serializer.outputStartElement(arraySubElement, aNamespace, "array", "array", EMPTY_ATTRIBUTES);
            serializer.addNodeStore();
        }
        try {
            serializer.maybeStartArraySymbol();
            if (serializer.isArrayHasIndentableElements(aValue)) {
                serializer.insertNl();
            }
            for (Object curElem : (Object[])aValue) {
                Node matchingArrayElement = this.getMatchingNode(sc, aArrayElementTagName);
                serializer.outputStartElementForArrayElement(matchingArrayElement, aNamespace, aArrayElementTagName, aArrayElementTagName, EMPTY_ATTRIBUTES);
                if (curElem instanceof AllowedValue) {
                    ((XMLizable)curElem).toXML(sc.ch);
                } else if (curElem instanceof XMLizable) {
                    serializer.insertNl();
                    ((XMLizable)curElem).toXML(sc.ch);
                } else if (aArrayElementTagName == null) {
                    this.writePrimitiveValue(curElem);
                } else {
                    serializer.writeSimpleValue(curElem);
                }
                serializer.outputEndElementForArrayElement(matchingArrayElement, aNamespace, aArrayElementTagName, aArrayElementTagName);
            }
            serializer.maybeEndArraySymbol();
        }
        finally {
            if (serializer.shouldEncloseInArrayElement(aPropClass)) {
                serializer.deleteNodeStore();
                serializer.outputEndElement(arraySubElement, aNamespace, "array", "array");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMapPropertyToXml(String aPropName, String aXmlElementName, String aKeyXmlAttribute, String aValueTagName, boolean aOmitIfNull, String aNamespace) throws SAXException {
        SerialContext sc = serialContext.get();
        Serializer serializer = sc.serializer;
        Map theMap = (Map)this.getAttributeValue(aPropName);
        Node matchingNode = this.getMatchingNode(sc, aXmlElementName);
        if (theMap == null || theMap.isEmpty()) {
            if (!aOmitIfNull && aXmlElementName != null) {
                serializer.outputStartElement(matchingNode, aNamespace, aXmlElementName, aXmlElementName, EMPTY_ATTRIBUTES);
                serializer.outputEndElement(matchingNode, aNamespace, aXmlElementName, aXmlElementName);
            }
        } else {
            serializer.outputStartElement(matchingNode, aNamespace, aXmlElementName, aXmlElementName, EMPTY_ATTRIBUTES);
            serializer.addNodeStore();
            try {
                for (Map.Entry curEntry : theMap.entrySet()) {
                    String key = (String)curEntry.getKey();
                    AttributesImpl attrs = new AttributesImpl();
                    attrs.addAttribute("", aKeyXmlAttribute, aKeyXmlAttribute, "", key);
                    Node innerMatchingNode = this.getMatchingNode(sc, aValueTagName);
                    serializer.outputStartElement(innerMatchingNode, aNamespace, aValueTagName, aValueTagName, attrs);
                    Object val = curEntry.getValue();
                    if (val.getClass().isArray()) {
                        Object[] arr = (Object[])val;
                        for (int j = 0; j < arr.length; ++j) {
                            XMLizable elem = (XMLizable)arr[j];
                            elem.toXML(sc.ch);
                        }
                    } else {
                        serializer.addNodeStore();
                        try {
                            ((XMLizable)val).toXML(sc.ch);
                        }
                        finally {
                            serializer.deleteNodeStore();
                        }
                    }
                    serializer.outputEndElement(innerMatchingNode, aNamespace, aValueTagName, aValueTagName);
                }
            }
            finally {
                serializer.deleteNodeStore();
                serializer.outputEndElement(matchingNode, aNamespace, aXmlElementName, aXmlElementName);
            }
        }
    }

    @Override
    public final void buildFromXMLElement(Element aElement, XMLParser aParser) throws InvalidXMLException {
        this.buildFromXMLElement(aElement, aParser, new XMLParser.ParsingOptions(true));
    }

    @Override
    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        if (!aElement.getTagName().equals(this.getXmlizationInfo().elementTagName)) {
            throw new InvalidXMLException("invalid_element_type", new Object[]{this.getXmlizationInfo().elementTagName, aElement.getTagName()});
        }
        if (aOptions.preserveComments) {
            this.infoset = aElement;
        }
        ArrayList<String> foundProperties = new ArrayList<String>();
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element curElem = (Element)curNode;
            String elemName = curElem.getTagName();
            PropertyXmlInfo propXmlInfo = this.getPropertyXmlInfo(elemName);
            if (propXmlInfo != null) {
                this.readPropertyValueFromXMLElement(propXmlInfo, curElem, aParser, aOptions);
                foundProperties.add(elemName);
                continue;
            }
            if (this.getXmlizationInfo().propertyInfo.length == 1) {
                this.readPropertyValueFromXMLElement(this.getXmlizationInfo().propertyInfo[0], aElement, aParser, aOptions);
                continue;
            }
            this.readUnknownPropertyValueFromXMLElement(curElem, aParser, aOptions, foundProperties);
        }
    }

    protected void readPropertyValueFromXMLElement(PropertyXmlInfo aPropXmlInfo, Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        String propName = aPropXmlInfo.propertyName;
        Class propClass = this.getAttributeClass(propName);
        if (propClass.isArray()) {
            this.readArrayPropertyValueFromXMLElement(aPropXmlInfo, propClass, aElement, aParser, aOptions);
        } else if (propClass == String.class) {
            String text = XMLUtils.getText(aElement, aOptions.expandEnvVarRefs);
            this.setAttributeValue(propName, (Object)text);
        } else {
            Element objElem = XMLUtils.getFirstChildElement(aElement);
            if (objElem != null) {
                if (objElem.getTagName().equals("array")) {
                    this.readArrayPropertyValueFromXMLElement(aPropXmlInfo, Object.class, objElem, aParser, aOptions);
                } else {
                    this.setAttributeValue(propName, aParser.buildObjectOrPrimitive(objElem, aOptions));
                }
            } else {
                String text = XMLUtils.getText(aElement, aOptions.expandEnvVarRefs);
                if (!text.equals("")) {
                    try {
                        Constructor constructor = propClass.getConstructor(String.class);
                        Object val = constructor.newInstance(text);
                        this.setAttributeValue(propName, val);
                    }
                    catch (Exception e) {
                        throw new InvalidXMLException("unknown_element", new Object[]{aElement.getTagName()}, e);
                    }
                }
            }
        }
    }

    protected void readArrayPropertyValueFromXMLElement(PropertyXmlInfo aPropXmlInfo, Class aPropClass, Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        Constructor<?> primitiveElementStringConstructor = null;
        NodeList elems = aElement.getChildNodes();
        int numChildren = elems.getLength();
        ArrayList<Object> valueList = new ArrayList<Object>();
        for (int i = 0; i < numChildren; ++i) {
            Node curNode = elems.item(i);
            if (!(curNode instanceof Element)) continue;
            Element element = (Element)curNode;
            if (aPropXmlInfo.arrayElementTagName != null) {
                if (element.getTagName().equals(aPropXmlInfo.arrayElementTagName)) {
                    String elemText = XMLUtils.getText(element, aOptions.expandEnvVarRefs);
                    try {
                        if (primitiveElementStringConstructor == null) {
                            primitiveElementStringConstructor = aPropClass.getComponentType().getConstructor(String.class);
                        }
                        valueList.add(primitiveElementStringConstructor.newInstance(elemText));
                        continue;
                    }
                    catch (Exception e) {
                        throw new InvalidXMLException(e);
                    }
                }
                throw new InvalidXMLException("invalid_element_type", new Object[]{aPropXmlInfo.arrayElementTagName, element.getTagName()});
            }
            valueList.add(aParser.buildObjectOrPrimitive(element, aOptions));
        }
        Class componentType = Object.class;
        if (aPropClass != Object.class) {
            componentType = aPropClass.getComponentType();
            for (Object e : valueList) {
                if (componentType.isAssignableFrom(e.getClass())) continue;
                throw new InvalidXMLException("invalid_class", new Object[]{componentType, e.getClass()});
            }
        } else {
            for (Object e : valueList) {
                if (componentType == Object.class) {
                    componentType = e.getClass();
                    continue;
                }
                if (componentType == e.getClass()) continue;
                componentType = Object.class;
                break;
            }
        }
        Object array = Array.newInstance(componentType, valueList.size());
        valueList.toArray((Object[])array);
        this.setAttributeValue(aPropXmlInfo.propertyName, array);
    }

    protected void readUnknownPropertyValueFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions, List<String> aKnownPropertyNames) throws InvalidXMLException {
        boolean success;
        block8: {
            success = false;
            try {
                Object valueObj = aParser.buildObjectOrPrimitive(aElement, aOptions);
                if (valueObj == null) break block8;
                PropertyXmlInfo[] props = this.getXmlizationInfo().propertyInfo;
                for (int i = 0; i < props.length; ++i) {
                    String propName = props[i].propertyName;
                    Class propClass = this.getAttributeClass(propName);
                    if (propClass.isAssignableFrom(valueObj.getClass())) {
                        if (aKnownPropertyNames.contains(propName)) continue;
                        this.setAttributeValue(propName, valueObj);
                        success = true;
                    } else {
                        if (!propClass.isArray() || !propClass.getComponentType().isAssignableFrom(valueObj.getClass())) continue;
                        Object curVal = this.getAttributeValue(propName);
                        int curLen = curVal == null ? 0 : Array.getLength(curVal);
                        Object newVal = Array.newInstance(propClass.getComponentType(), curLen + 1);
                        if (curLen > 0) {
                            System.arraycopy(curVal, 0, newVal, 0, curLen);
                        }
                        Array.set(newVal, curLen, valueObj);
                        this.setAttributeValue(propName, newVal);
                        success = true;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (e instanceof InvalidXMLException) {
                    throw (InvalidXMLException)e;
                }
                throw new InvalidXMLException(e);
            }
        }
        if (!success) {
            throw new InvalidXMLException("unknown_element", new Object[]{aElement.getTagName()});
        }
    }

    protected void readMapPropertyFromXml(String aPropName, Element aElement, String aKeyXmlAttribute, String aValueTagName, XMLParser aParser, XMLParser.ParsingOptions aOptions, boolean aValueIsArray) throws InvalidXMLException {
        Map theMap = (Map)this.getAttributeValue(aPropName);
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element curElem = (Element)curNode;
            if (!curElem.getTagName().equals(aValueTagName)) {
                throw new InvalidXMLException("invalid_element_type", new Object[]{aValueTagName, curElem.getTagName()});
            }
            String key = curElem.getAttribute(aKeyXmlAttribute);
            if (key.equals("")) {
                throw new InvalidXMLException("required_attribute_missing", new Object[]{"key", aValueTagName});
            }
            Object val = null;
            if (!aValueIsArray) {
                Element valElem = XMLUtils.getFirstChildElement(curElem);
                if (valElem == null) {
                    throw new InvalidXMLException("element_not_found", new Object[]{"(any)", aValueTagName});
                }
                val = aParser.buildObject(valElem, aOptions);
            } else {
                ArrayList<XMLizable> vals = new ArrayList<XMLizable>();
                NodeList arrayNodes = curElem.getChildNodes();
                for (int j = 0; j < arrayNodes.getLength(); ++j) {
                    Node curArrayNode = arrayNodes.item(j);
                    if (!(curArrayNode instanceof Element)) continue;
                    Element valElem = (Element)curArrayNode;
                    vals.add(aParser.buildObject(valElem));
                }
                if (!vals.isEmpty()) {
                    val = Array.newInstance(((XMLizable)vals.get(0)).getClass(), vals.size());
                    vals.toArray((Object[])val);
                }
            }
            theMap.put(key, val);
        }
    }

    protected static Class getWrapperClass(Class aPrimitiveType) {
        if (Integer.TYPE.equals(aPrimitiveType)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(aPrimitiveType)) {
            return Short.class;
        }
        if (Long.TYPE.equals(aPrimitiveType)) {
            return Long.class;
        }
        if (Byte.TYPE.equals(aPrimitiveType)) {
            return Byte.class;
        }
        if (Character.TYPE.equals(aPrimitiveType)) {
            return Character.class;
        }
        if (Float.TYPE.equals(aPrimitiveType)) {
            return Float.class;
        }
        if (Double.TYPE.equals(aPrimitiveType)) {
            return Double.class;
        }
        if (Boolean.TYPE.equals(aPrimitiveType)) {
            return Boolean.class;
        }
        return aPrimitiveType;
    }

    @Deprecated
    protected PropertyDescriptor[] getPropertyDescriptors() throws IntrospectionException {
        return Introspector.getBeanInfo(this.getClass(), 3).getPropertyDescriptors();
    }

    private void writePrimitiveValue(Object aObj) throws SAXException {
        SerialContext sc = serialContext.get();
        Serializer serializer = sc.serializer;
        String className = aObj.getClass().getName();
        int lastDotIndex = className.lastIndexOf(".");
        if (lastDotIndex > -1) {
            className = className.substring(lastDotIndex + 1).toLowerCase();
        }
        Node node = this.getMatchingNode(sc, className);
        serializer.writeSimpleValueWithTag(className, aObj, node);
    }

    protected Node getMatchingNode(SerialContext serialContext, String name) {
        return this.infoset == null ? null : serialContext.serializer.findMatchingSubElement(name);
    }

    protected String resolveSettings(String text) {
        Settings_impl settings;
        UimaContext uimaContext = UimaContextHolder.getContext();
        if (uimaContext != null && (settings = (Settings_impl)uimaContext.getExternalOverrides()) != null) {
            try {
                return settings.resolve(text);
            }
            catch (Exception e) {
                UIMAFramework.getLogger(this.getClass()).log(Level.WARNING, e.toString());
            }
        }
        return null;
    }

    public static class SerialContext {
        public final ContentHandler ch;
        public final Serializer serializer;

        public SerialContext(ContentHandler ch, Serializer serializer) {
            this.ch = ch;
            this.serializer = serializer;
        }
    }

    public static interface Serializer {
        public void outputStartElement(Node var1, String var2, String var3, String var4, Attributes var5) throws SAXException;

        public void outputEndElement(Node var1, String var2, String var3, String var4) throws SAXException;

        public void outputStartElementForArrayElement(Node var1, String var2, String var3, String var4, Attributes var5) throws SAXException;

        public void outputEndElementForArrayElement(Node var1, String var2, String var3, String var4) throws SAXException;

        public void insertNl();

        public boolean shouldBeSkipped(PropertyXmlInfo var1, Object var2, MetaDataObject_impl var3);

        public boolean startElementProperty();

        public void deleteNodeStore();

        public boolean indentChildElements(XmlizationInfo var1, MetaDataObject_impl var2);

        public void saveAndAddNodeStore(Node var1);

        public void addNodeStore();

        public void writeDelayedStart(String var1) throws SAXException;

        public void writeSimpleValue(Object var1) throws SAXException;

        public void writeSimpleValueWithTag(String var1, Object var2, Node var3) throws SAXException;

        public boolean shouldEncloseInArrayElement(Class var1);

        public boolean isArrayHasIndentableElements(Object var1);

        public void maybeStartArraySymbol() throws SAXException;

        public void maybeEndArraySymbol() throws SAXException;

        public Node findMatchingSubElement(String var1);
    }

    public static class MetaDataAttr {
        final String name;
        final Method reader;
        final Method writer;
        final Class clazz;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MetaDataAttr other = (MetaDataAttr)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public MetaDataAttr(String name, Method reader, Method writer, Class clazz) {
            this.name = name;
            this.reader = reader;
            this.writer = writer;
            this.clazz = clazz;
        }
    }
}

