/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JsonSchemaHelper {
    private static final Pattern PATTERN = Pattern.compile("\"(.+?)\"|\\[(.+)\\]|(true|false)|(-?\\d+\\.?\\d*)");
    private static final String QUOT = "&quot;";

    private JsonSchemaHelper() {
    }

    public static String getType(Class<?> type) {
        if (type.isEnum()) {
            return "enum";
        }
        if (type.isArray()) {
            return "array";
        }
        if (type.isAssignableFrom(URI.class) || type.isAssignableFrom(URL.class)) {
            return "string";
        }
        String primitive = JsonSchemaHelper.getPrimitiveType(type.getCanonicalName());
        if (primitive != null) {
            return primitive;
        }
        return "object";
    }

    public static String getPrimitiveType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return "string";
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return "array";
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return "array";
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name) || "char".equals(name)) {
            return "string";
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return "string";
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name) || "boolean".equals(name)) {
            return "boolean";
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name) || "int".equals(name)) {
            return "integer";
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name) || "long".equals(name)) {
            return "integer";
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name) || "short".equals(name)) {
            return "integer";
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name) || "byte".equals(name)) {
            return "integer";
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name) || "float".equals(name)) {
            return "number";
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name) || "double".equals(name)) {
            return "number";
        }
        return null;
    }

    public static List<Map<String, String>> parseJsonSchema(String group, String json, boolean parseProperties) {
        String[] lines;
        ArrayList<Map<String, String>> answer = new ArrayList<Map<String, String>>();
        if (json == null) {
            return answer;
        }
        boolean found = false;
        for (String line : lines = json.split("\n")) {
            if (!found) {
                String s = line.trim();
                found = s.startsWith("\"" + group + "\":") && s.endsWith("{");
                continue;
            }
            if (line.equals("  },") || line.equals("  }")) break;
            line = line.replaceAll("\"\\\\\"\"", "\"&quot;\"");
            LinkedHashMap<String, String> row = new LinkedHashMap<String, String>();
            Matcher matcher = PATTERN.matcher(line);
            String key = parseProperties ? "name" : null;
            while (matcher.find()) {
                if (key == null) {
                    key = matcher.group(1);
                    continue;
                }
                String value = matcher.group(1);
                if (value != null) {
                    value = value.trim();
                    value = value.replaceAll(QUOT, "\"");
                    value = JsonSchemaHelper.decodeJson(value);
                }
                if (value == null && (value = matcher.group(2)) != null) {
                    value = value.replaceAll("\"", "");
                    value = value.replaceAll(", ", ",");
                    value = value.trim();
                }
                if (value == null) {
                    value = matcher.group(3);
                }
                if (value == null) {
                    value = matcher.group(4);
                }
                if (value != null) {
                    row.put(key, value);
                }
                key = null;
            }
            if (row.isEmpty()) continue;
            answer.add(row);
        }
        return answer;
    }

    private static String decodeJson(String value) {
        if ("\\\\".equals(value)) {
            value = "\\";
        }
        return value;
    }

    public static boolean isPropertyRequired(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean required = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("required")) {
                required = "true".equals(row.get("required"));
            }
            if (!found) continue;
            return required;
        }
        return false;
    }

    public static String getPropertyDefaultValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String defaultValue = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("defaultValue")) {
                defaultValue = row.get("defaultValue");
            }
            if (!found) continue;
            return defaultValue;
        }
        return null;
    }

    public static boolean isPropertyMultiValue(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            boolean multiValue = false;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("multiValue")) {
                multiValue = "true".equals(row.get("multiValue"));
            }
            if (!found) continue;
            return multiValue;
        }
        return false;
    }

    public static String getPropertyPrefix(List<Map<String, String>> rows, String name) {
        for (Map<String, String> row : rows) {
            String prefix = null;
            boolean found = false;
            if (row.containsKey("name")) {
                found = name.equals(row.get("name"));
            }
            if (row.containsKey("prefix")) {
                prefix = row.get("prefix");
            }
            if (!found) continue;
            return prefix;
        }
        return null;
    }
}

