/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.NotMasterException;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;

public class BatchedRerouteService
implements RerouteService {
    private static final Logger logger = LogManager.getLogger(BatchedRerouteService.class);
    private static final String CLUSTER_UPDATE_TASK_SOURCE = "cluster_reroute";
    private final ClusterService clusterService;
    private final BiFunction<ClusterState, String, ClusterState> reroute;
    private final Object mutex = new Object();
    @Nullable
    private List<ActionListener<Void>> pendingRerouteListeners;
    private Priority pendingTaskPriority = Priority.LANGUID;

    public BatchedRerouteService(ClusterService clusterService, BiFunction<ClusterState, String, ClusterState> reroute) {
        this.clusterService = clusterService;
        this.reroute = reroute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reroute(final String reason, Priority priority, ActionListener<Void> listener) {
        ArrayList currentListeners;
        Object object = this.mutex;
        synchronized (object) {
            if (this.pendingRerouteListeners != null) {
                if (priority.sameOrAfter(this.pendingTaskPriority)) {
                    logger.trace("already has pending reroute at priority [{}], adding [{}] with priority [{}] to batch", (Object)this.pendingTaskPriority, (Object)reason, (Object)priority);
                    this.pendingRerouteListeners.add(listener);
                    return;
                }
                logger.trace("already has pending reroute at priority [{}], promoting batch to [{}] and adding [{}]", (Object)this.pendingTaskPriority, (Object)priority, (Object)reason);
                currentListeners = new ArrayList(1 + this.pendingRerouteListeners.size());
                currentListeners.add(listener);
                currentListeners.addAll(this.pendingRerouteListeners);
                this.pendingRerouteListeners.clear();
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            } else {
                logger.trace("no pending reroute, scheduling reroute [{}] at priority [{}]", (Object)reason, (Object)priority);
                currentListeners = new ArrayList<ActionListener<Void>>(1);
                currentListeners.add(listener);
                this.pendingRerouteListeners = currentListeners;
                this.pendingTaskPriority = priority;
            }
        }
        try {
            this.clusterService.submitStateUpdateTask("cluster_reroute(" + reason + ")", new ClusterStateUpdateTask(priority){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClusterState execute(ClusterState currentState) {
                    boolean currentListenersArePending;
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        assert (currentListeners.isEmpty() == (BatchedRerouteService.this.pendingRerouteListeners != currentListeners)) : "currentListeners=" + currentListeners + ", pendingRerouteListeners=" + BatchedRerouteService.access$100(BatchedRerouteService.this);
                        boolean bl = currentListenersArePending = BatchedRerouteService.this.pendingRerouteListeners == currentListeners;
                        if (currentListenersArePending) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    if (currentListenersArePending) {
                        logger.trace("performing batched reroute [{}]", (Object)reason);
                        return (ClusterState)BatchedRerouteService.this.reroute.apply(currentState, reason);
                    }
                    logger.trace("batched reroute [{}] was promoted", (Object)reason);
                    return currentState;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNoLongerMaster(String source) {
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        if (BatchedRerouteService.this.pendingRerouteListeners == currentListeners) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    ActionListener.onFailure(currentListeners, new NotMasterException("delayed reroute [" + reason + "] cancelled"));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(String source, Exception e) {
                    Object object = BatchedRerouteService.this.mutex;
                    synchronized (object) {
                        if (BatchedRerouteService.this.pendingRerouteListeners == currentListeners) {
                            BatchedRerouteService.this.pendingRerouteListeners = null;
                        }
                    }
                    ClusterState state = BatchedRerouteService.this.clusterService.state();
                    if (logger.isTraceEnabled()) {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state:\n{}", (Object)source, (Object)state), (Throwable)e);
                    } else {
                        logger.error(() -> new ParameterizedMessage("unexpected failure during [{}], current state version [{}]", (Object)source, (Object)state.version()), (Throwable)e);
                    }
                    ActionListener.onFailure(currentListeners, new ElasticsearchException("delayed reroute [" + reason + "] failed", (Throwable)e, new Object[0]));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    ActionListener.onResponse(currentListeners, null);
                }
            });
        }
        catch (Exception e) {
            Object object2 = this.mutex;
            synchronized (object2) {
                assert (currentListeners.isEmpty() == (this.pendingRerouteListeners != currentListeners));
                if (this.pendingRerouteListeners == currentListeners) {
                    this.pendingRerouteListeners = null;
                }
            }
            ClusterState state = this.clusterService.state();
            logger.warn(() -> new ParameterizedMessage("failed to reroute routing table, current state:\n{}", (Object)state), (Throwable)e);
            ActionListener.onFailure(currentListeners, new ElasticsearchException("delayed reroute [" + reason + "] could not be submitted", (Throwable)e, new Object[0]));
        }
    }
}

