/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.loader.DefaultLoaderListener;
import org.javamoney.moneta.internal.loader.LoadableResource;

public class LoadDataLoaderService {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderListener.class.getName());
    private final DefaultLoaderListener listener;

    LoadDataLoaderService(DefaultLoaderListener listener) {
        this.listener = listener;
    }

    public boolean execute(String resourceId, Map<String, LoadableResource> resources) {
        LoadableResource load = resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.load()) {
                    this.listener.trigger(resourceId, load.getDataStream());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to load resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return LoadDataLoaderService.class.getName() + '{' + " listener: " + this.listener + '}';
    }
}

