/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovy.lang.Closure;
import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.ToServer;
import groovyx.net.http.UriBuilder;
import groovyx.net.http.fn.ClosureBiFunction;
import groovyx.net.http.fn.ClosureFunction;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface HttpConfig {
    public void context(String var1, Object var2, Object var3);

    default public void context(Iterable<String> contentTypes, Object id, Object obj) {
        for (String contentType : contentTypes) {
            this.context(contentType, id, obj);
        }
    }

    public Request getRequest();

    public Response getResponse();

    public static interface Response {
        default public void when(Status status, Closure<?> closure) {
            this.when(status, new ClosureBiFunction(closure));
        }

        public void when(Status var1, BiFunction<FromServer, Object, ?> var2);

        default public void when(Integer code, Closure<?> closure) {
            this.when(code, new ClosureBiFunction(closure));
        }

        public void when(Integer var1, BiFunction<FromServer, Object, ?> var2);

        default public void when(String code, Closure<?> closure) {
            this.when(code, new ClosureBiFunction(closure));
        }

        public void when(String var1, BiFunction<FromServer, Object, ?> var2);

        public BiFunction<FromServer, Object, ?> when(Integer var1);

        default public void success(Closure<?> closure) {
            this.success(new ClosureBiFunction(closure));
        }

        public void success(BiFunction<FromServer, Object, ?> var1);

        default public void failure(Closure<?> closure) {
            this.failure(new ClosureBiFunction(closure));
        }

        public void failure(BiFunction<FromServer, Object, ?> var1);

        default public void exception(Closure<?> closure) {
            this.exception(new ClosureFunction(closure));
        }

        public void exception(Function<Throwable, ?> var1);

        public void parser(String var1, BiFunction<ChainedHttpConfig, FromServer, Object> var2);

        public void parser(Iterable<String> var1, BiFunction<ChainedHttpConfig, FromServer, Object> var2);

        public BiFunction<ChainedHttpConfig, FromServer, Object> parser(String var1);
    }

    public static interface Request {
        public Auth getAuth();

        public void setContentType(String var1);

        public void setCharset(String var1);

        public void setCharset(Charset var1);

        public UriBuilder getUri();

        public void setUri(String var1);

        public void setRaw(String var1);

        public void setUri(URI var1);

        public void setUri(URL var1) throws URISyntaxException;

        public Map<String, CharSequence> getHeaders();

        public void setHeaders(Map<String, CharSequence> var1);

        public void setAccept(String[] var1);

        public void setAccept(Iterable<String> var1);

        public void setBody(Object var1);

        default public void cookie(String name, String value) {
            this.cookie(name, value, (Date)null);
        }

        public void cookie(String var1, String var2, Date var3);

        public void cookie(String var1, String var2, LocalDateTime var3);

        public void encoder(String var1, BiConsumer<ChainedHttpConfig, ToServer> var2);

        public void encoder(Iterable<String> var1, BiConsumer<ChainedHttpConfig, ToServer> var2);

        public BiConsumer<ChainedHttpConfig, ToServer> encoder(String var1);
    }

    public static interface Auth {
        public AuthType getAuthType();

        public String getUser();

        public String getPassword();

        default public void basic(String user, String password) {
            this.basic(user, password, false);
        }

        public void basic(String var1, String var2, boolean var3);

        default public void digest(String user, String password) {
            this.digest(user, password, false);
        }

        public void digest(String var1, String var2, boolean var3);
    }

    public static enum AuthType {
        BASIC,
        DIGEST;

    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

