/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.util.Scanner;

public class FileDataSet
extends ListDataSet {
    private File sourceFile;
    private String delimiter = "\\z";
    private List<Object> defaultBodies;

    public FileDataSet(String sourceFileName) throws IOException {
        this(new File(sourceFileName));
    }

    public FileDataSet(File sourceFile) throws IOException {
        this(sourceFile, "\\z");
    }

    public FileDataSet(String sourceFileName, String delimiter) throws IOException {
        this(new File(sourceFileName), delimiter);
    }

    public FileDataSet(File sourceFile, String delimiter) throws IOException {
        this.setSourceFile(sourceFile, delimiter);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(File sourceFile) throws IOException {
        this.sourceFile = sourceFile;
        this.readSourceFile();
    }

    public void setSourceFile(File sourceFile, String delimiter) throws IOException {
        this.sourceFile = sourceFile;
        this.delimiter = delimiter;
        this.readSourceFile();
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    private void readSourceFile() throws IOException {
        LinkedList<Object> bodies = new LinkedList<Object>();
        try (Scanner scanner = new Scanner(this.sourceFile, null, this.delimiter);){
            while (scanner.hasNext()) {
                String nextPayload = scanner.next();
                if (nextPayload == null || nextPayload.length() <= 0) continue;
                bodies.add(nextPayload);
            }
            this.setDefaultBodies(bodies);
        }
    }
}

