/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.guice.GuiceInjectorHolder;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.util.lang.Objects;

class GuiceProxyTargetLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private final Annotation bindingAnnotation;
    private final boolean optional;
    private final String className;
    private final String fieldName;
    private Boolean isSingletonCache = null;

    public GuiceProxyTargetLocator(Field field, Annotation bindingAnnotation, boolean optional) {
        this.bindingAnnotation = bindingAnnotation;
        this.optional = optional;
        this.className = field.getDeclaringClass().getName();
        this.fieldName = field.getName();
    }

    public Object locateProxyTarget() {
        Injector injector = this.getInjector();
        Key<?> key = this.newGuiceKey();
        if (this.optional) {
            try {
                if (injector.getBinding(key) == null) {
                    return null;
                }
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return injector.getInstance(key);
    }

    private Key<?> newGuiceKey() {
        Type type;
        try {
            Class clazz = WicketObjects.resolveClass((String)this.className);
            Field field = clazz.getDeclaredField(this.fieldName);
            type = field.getGenericType();
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Error accessing member: " + this.fieldName + " of class: " + this.className, (Throwable)e);
        }
        if (this.bindingAnnotation == null) {
            return Key.get((TypeLiteral)TypeLiteral.get((Type)type));
        }
        return Key.get((TypeLiteral)TypeLiteral.get((Type)type), (Annotation)this.bindingAnnotation);
    }

    public boolean isSingletonScope() {
        if (this.isSingletonCache == null) {
            try {
                this.isSingletonCache = Scopes.isSingleton((Binding)this.getInjector().getBinding(this.newGuiceKey()));
            }
            catch (ConfigurationException ex) {
                if (this.optional) {
                    this.isSingletonCache = true;
                }
                throw ex;
            }
        }
        return this.isSingletonCache;
    }

    private Injector getInjector() {
        GuiceInjectorHolder holder = (GuiceInjectorHolder)Application.get().getMetaData(GuiceInjectorHolder.INJECTOR_KEY);
        return holder.getInjector();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuiceProxyTargetLocator)) {
            return false;
        }
        GuiceProxyTargetLocator that = (GuiceProxyTargetLocator)o;
        return Objects.equal((Object)this.optional, (Object)that.optional) && Objects.equal((Object)this.bindingAnnotation, (Object)that.bindingAnnotation) && Objects.equal((Object)this.className, (Object)that.className) && Objects.equal((Object)this.fieldName, (Object)that.fieldName);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.bindingAnnotation, this.optional, this.className, this.fieldName});
    }
}

