/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.woden.ant.CmBaseWriter;
import org.apache.woden.ant.NamespaceWriter;
import org.apache.woden.ant.XMLWriter;
import org.apache.woden.wsdl20.extensions.http.HTTPAuthenticationScheme;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPErrorStatusCode;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;

public class CmHttpWriter
extends NamespaceWriter {
    public static final String NS = "http://www.w3.org/2002/ws/desc/wsdl/component-http";
    public static final String PREFIX = "cmhttp";
    private CmBaseWriter cmbase;

    public CmHttpWriter(XMLWriter out) {
        super(out, NS, PREFIX);
        this.cmbase = (CmBaseWriter)out.lookup("http://www.w3.org/2002/ws/desc/wsdl/component-base");
    }

    public void httpBindingExtension(HTTPBindingExtensions http) {
        if (http == null) {
            return;
        }
        this.out.beginElement("cmhttp:httpBindingExtension");
        this.out.write("cmhttp:httpCookies", http.isHttpCookies());
        this.out.write("cmhttp:httpMethodDefault", http.getHttpMethodDefault());
        this.out.write("cmhttp:httpQueryParameterSeparatorDefault", http.getHttpQueryParameterSeparatorDefault());
        this.out.write("cmhttp:httpContentEncodingDefault", http.getHttpContentEncodingDefault());
        this.out.endElement();
    }

    public void httpBindingFaultExtension(HTTPBindingFaultExtensions http) {
        if (http != null) {
            this.out.beginElement("cmhttp:httpBindingFaultExtension");
            this.write("cmhttp:httpErrorStatusCode", http.getHttpErrorStatusCode());
            this.write("cmhttp:httpHeaders", http.getHttpHeaders());
            this.out.write("cmhttp:httpContentEncoding", http.getHttpContentEncoding());
            this.out.endElement();
        }
    }

    public void httpBindingOperationExtension(HTTPBindingOperationExtensions http) {
        if (http == null) {
            return;
        }
        this.out.beginElement("cmhttp:httpBindingOperationExtension");
        this.out.write("cmhttp:httpFaultSerialization", http.getHttpFaultSerialization());
        this.out.write("cmhttp:httpInputSerialization", http.getHttpInputSerialization());
        this.write("cmhttp:httpLocation", http.getHttpLocation());
        this.out.write("cmhttp:httpLocationIgnoreUncited", http.isHttpLocationIgnoreUncited());
        this.out.write("cmhttp:httpMethod", http.getHttpMethod());
        this.out.write("cmhttp:httpOutputSerialization", http.getHttpOutputSerialization());
        this.out.write("cmhttp:httpQueryParameterSeparator", http.getHttpQueryParameterSeparator());
        this.out.write("cmhttp:httpContentEncodingDefault", http.getHttpContentEncodingDefault());
        this.out.endElement();
    }

    public void httpBindingMessageReferenceExtension(HTTPBindingMessageReferenceExtensions http) {
        if (http == null) {
            return;
        }
        this.out.beginElement("cmhttp:httpBindingMessageReferenceExtension");
        this.write("cmhttp:httpHeaders", http.getHttpHeaders());
        this.out.write("cmhttp:httpContentEncoding", http.getHttpContentEncoding());
        this.out.endElement();
    }

    public void httpEndpointExtension(HTTPEndpointExtensions http) {
        if (http == null) {
            return;
        }
        this.out.beginElement("cmhttp:httpEndpointExtension");
        this.out.write("cmhttp:httpAuthenticationRealm", http.getHttpAuthenticationRealm());
        this.write("cmhttp:httpAuthenticationScheme", http.getHttpAuthenticationScheme());
        this.out.endElement();
    }

    private void write(String tag, HTTPErrorStatusCode httpErrorStatusCode) {
        if (httpErrorStatusCode == null) {
            return;
        }
        this.out.beginElement(tag);
        if (httpErrorStatusCode.isCodeUsed()) {
            this.out.write("cmhttp:code", httpErrorStatusCode.toString());
        }
        this.out.endElement();
    }

    public void write(String tag, HTTPHeader[] components) {
        if (components.length == 0) {
            return;
        }
        Arrays.sort(components, new Comparator(){

            public int compare(Object o1, Object o2) {
                String n1 = ((HTTPHeader)o1).getName();
                String n2 = ((HTTPHeader)o2).getName();
                return n1.compareTo(n2);
            }
        });
        this.out.beginElement(tag);
        for (int i = 0; i < components.length; ++i) {
            this.write("cmhttp:httpHeaderComponent", components[i]);
        }
        this.out.endElement();
    }

    private void write(String tag, HTTPHeader component) {
        this.out.beginElement(tag, this.cmbase.idAttribute(component));
        this.out.write("cmhttp:name", component.getName());
        this.cmbase.writeRef("cmhttp:typeDefinition", component.getTypeDefinition());
        this.out.write("cmhttp:required", component.isRequired());
        this.cmbase.parent(component.getParent());
        this.out.endElement();
    }

    public void write(String tag, HTTPAuthenticationScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.out.write(tag, scheme.toString());
    }

    private void write(String tag, HTTPLocation location) {
        if (location == null) {
            return;
        }
        this.out.write(tag, location.getOriginalLocation());
    }
}

