setlistener("/sim/signals/fdm-initialized", func {
    settimer(update_FADEC, 5);
    print("FADEC (Full Authority Digital Engine Control) loaded.");
});

setlistener("/controls/engines/engine[0]/condition-lever-state", func (i) {
	if(i.getValue()==0){ #CUTOFF
		setprop("/controls/engines/engine[0]/cutoff-cmd", 1);
		setprop("/controls/engines/engine[0]/condition", 0);
		setprop("/controls/engines/engine[0]/propeller-pitch", 0);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}else if(i.getValue()==1){ #START&FEATHER
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 0.5);
		setprop("/controls/engines/engine[0]/propeller-pitch", 0);
		setprop("/controls/engines/engine[0]/propeller-feather", 1);
	}else if(i.getValue()==2){ #MIN 850
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 1);
		setprop("/controls/engines/engine[0]/propeller-pitch", 0);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}else if(i.getValue()==3){ #900
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 1);
		setprop("/controls/engines/engine[0]/propeller-pitch", 0.294);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}else if(i.getValue()==4){ #MAX 1020
		setprop("/controls/engines/engine[0]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[0]/condition", 1);
		setprop("/controls/engines/engine[0]/propeller-pitch", 1);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}
	
});

setlistener("/controls/engines/engine[1]/condition-lever-state", func (i) {
	if(i.getValue()==0){ #CUTOFF
		setprop("/controls/engines/engine[1]/cutoff-cmd", 1);
		setprop("/controls/engines/engine[1]/condition", 0);
		setprop("/controls/engines/engine[1]/propeller-pitch", 0);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}else if(i.getValue()==1){ #START&FEATHER
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 0.5);
		setprop("/controls/engines/engine[1]/propeller-pitch", 0);
		setprop("/controls/engines/engine[1]/propeller-feather", 1);
	}else if(i.getValue()==2){ #MIN 850
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 1);
		setprop("/controls/engines/engine[1]/propeller-pitch", 0);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}else if(i.getValue()==3){ #900
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 1);
		setprop("/controls/engines/engine[1]/propeller-pitch", 0.294);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}else if(i.getValue()==4){ #MAX 1020
		setprop("/controls/engines/engine[1]/cutoff-cmd", 0);
		setprop("/controls/engines/engine[1]/condition", 1);
		setprop("/controls/engines/engine[1]/propeller-pitch", 1);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}
	
});

#FADEC loop
var update_FADEC = func{
	if(getprop("/fdm/jsbsim/fcs/fadec/throttle-input[0]")<=0.8 or getprop("/engines/engine[0]/reversed")){
		var state=getprop("/controls/engines/engine[0]/condition-lever-state");
		if(state==1 or state==4){
			if(getprop("/controls/engines/mtop-discrete")==1){
				setprop("/FADEC/thrust-mode[0]", "MTOP");
			}else{
				setprop("/FADEC/thrust-mode[0]", "NTOP");
			}
		}else if(state==2){
			setprop("/FADEC/thrust-mode[0]", "MCR");
		}else if(state==3){
			setprop("/FADEC/thrust-mode[0]", "MCL");
		}else{
			setprop("/FADEC/thrust-mode[0]", "");
		}
	}else{
		setprop("/FADEC/thrust-mode[0]", "EMERG");
		setprop("/controls/engines/engine[0]/propeller-pitch", 1);
		setprop("/controls/engines/engine[0]/propeller-feather", 0);
	}
	
	if(getprop("/fdm/jsbsim/fcs/fadec/throttle-input[1]")<=0.8 or getprop("/engines/engine[1]/reversed")){
		var state2=getprop("/controls/engines/engine[1]/condition-lever-state");
		if(state2==1 or state2==4){
			if(getprop("/controls/engines/mtop-discrete")==1){
				setprop("/FADEC/thrust-mode[1]", "MTOP");
			}else{
				setprop("/FADEC/thrust-mode[1]", "NTOP");
			}
		}else if(state2==2){
			setprop("/FADEC/thrust-mode[1]", "MCR");
		}else if(state2==3){
			setprop("/FADEC/thrust-mode[1]", "MCL");
		}else{
			setprop("/FADEC/thrust-mode[1]", "");
		}
	}else{
		setprop("/FADEC/thrust-mode[1]", "EMERG");
		setprop("/controls/engines/engine[1]/propeller-pitch", 1);
		setprop("/controls/engines/engine[1]/propeller-feather", 0);
	}

    #Automatical ignition setting
    var ignitionL=getprop("/controls/engines/engine[0]/ignition"); # 1=NORM (AUTO) 0=FORCE OFF
    var ignitionR=getprop("/controls/engines/engine[1]/ignition"); # 1=NORM (AUTO) 0=FORCE OFF
    var runningL=getprop("/engines/engine[0]/running");
    var runningR=getprop("/engines/engine[1]/running");
    var starterL=getprop("/controls/engines/engine[0]/starter");
    var starterR=getprop("/controls/engines/engine[1]/starter");
    
    if(ignitionL and !runningL and starterL){
        setprop("/controls/engines/fadec/ignitionL", 1);
    }else{
        setprop("/controls/engines/fadec/ignitionL", 0);
    }
    
    if(ignitionR and !runningR and starterR){
        setprop("/controls/engines/fadec/ignitionR", 1);
    }else{
        setprop("/controls/engines/fadec/ignitionR", 0);
    }

    

    #Engine System
    var cutoffcmdL=getprop("/controls/engines/engine[0]/cutoff-cmd") or 0;
    var cutoffcmdR=getprop("/controls/engines/engine[1]/cutoff-cmd") or 0;
    var n2L=getprop("/engines/engine[0]/n2");
    var n2R=getprop("/engines/engine[1]/n2");
    var runningL=getprop("/engines/engine[0]/running");
    var runningR=getprop("/engines/engine[1]/running");
    var starterL=getprop("/controls/engines/engine[0]/starter");
    var starterR=getprop("/controls/engines/engine[1]/starter");
    var ignitionL=getprop("/controls/engines/fadec/ignitionL");
    var ignitionR=getprop("/controls/engines/fadec/ignitionR");

    if(!cutoffcmdL and runningL or !cutoffcmdL and starterL and n2L>=15 and ignitionL) {
        setprop("/controls/engines/engine[0]/cutoff", 0);
    }else{
        setprop("/controls/engines/engine[0]/cutoff", 1);
    }


    if(!cutoffcmdR and runningR or !cutoffcmdR and starterR and n2R>=15 and ignitionR) {
        setprop("/controls/engines/engine[1]/cutoff", 0);
    }else{
        setprop("/controls/engines/engine[1]/cutoff", 1);
    }
    
    
    #Set some values so that all scripts work well
    setprop("/engines/engine[0]/n2", (getprop("/engines/engine[0]/thruster/rpm")/1020)*100);
    setprop("/engines/engine[1]/n2", (getprop("/engines/engine[1]/thruster/rpm")/1020)*100);
    setprop("/engines/engine[0]/rpm", getprop("/engines/engine[0]/thruster/rpm"));
    setprop("/engines/engine[1]/rpm", getprop("/engines/engine[1]/thruster/rpm"));
    
    settimer(update_FADEC, 0);
}
