var start1 = props.globals.getNode("/controls/engines/start1", 1);
var abort1 = props.globals.getNode("/controls/engines/abort1", 1);
var start2 = props.globals.getNode("/controls/engines/start2", 1);
var abort2 = props.globals.getNode("/controls/engines/abort2", 1);
var spool_time = 25;

# engine 2
var switchback2 = func() {
    setprop("/controls/engines/run2",1);
    setprop("/controls/engines/start2",0);
    setprop("/controls/engines/abort2",0);
}

var set_engine2_state = func() {
    start2 = getprop("/controls/engines/start2");
    abort2 = getprop("/controls/engines/abort2");
    cutoff2 = getprop("/controls/engines/engine[1]/cutoff");
    fuel_cutoff2 = getprop("/controls/fuel-cutoff2");

    if (start2 and cutoff2 and !fuel_cutoff2)
    {
        # turboprops
        setprop("/controls/engines/engine[1]/starter", 1);
        interpolate("/fdm/jsbsim/propulsion/engine[1]/n1", 20, spool_time);
        settimer(func {
            setprop("/controls/engines/engine[1]/cutoff", 0);
         }, spool_time);

        settimer(switchback2, 1);
    }
    if (abort1)
    {
        setprop("/controls/engines/engine[1]/cutoff", 1);
        settimer(switchback2, 1);
    }
}

var set_pitch_fadec2 = maketimer(0.333333333, func {
    ## management of the feathering of the propellers
    ## for the moment, if the engine is stopped, we feather the propeller,
    ## otherwise, we put full throttle
    if (getprop("/engines/engine[1]/fuel-flow_pph") == 0) {
        interpolate("/controls/engines/engine[1]/propeller-pitch-fadec", 0, 1);
    } elsif (getprop("/controls/engines/engine[1]/propeller-feather") == 1) {
        ##for testing
        interpolate("/controls/engines/engine[1]/propeller-pitch-fadec", 0, 1);
    } else {
        var propeller_pitch = 1; #full power
        ##icing
#        propeller_pitch = propeller_pitch - getprop("/sim/icing/propellers");
        interpolate("/controls/engines/engine[1]/propeller-pitch-fadec", propeller_pitch, 1);
    }
});
set_pitch_fadec2.start();

setlistener(start2, set_engine2_state);
setlistener(abort2, set_engine2_state);

# engine 1
var switchback1 = func() {
    setprop("/controls/engines/run1",1);
    setprop("/controls/engines/start1",0);
    setprop("/controls/engines/abort1",0);
    settimer(func {
        setprop("/controls/engines/run2",!getprop("/controls/engines/run2"));
        setprop("/controls/engines/start2",!getprop("/controls/engines/start2"));
        setprop("/controls/engines/abort2",!getprop("/controls/engines/abort2"));
    }, spool_time);
}

var set_engine1_state = func() {
    start1 = getprop("/controls/engines/start1");
    abort1 = getprop("/controls/engines/abort1");
    cutoff1 = getprop("/controls/engines/engine[0]/cutoff");
    fuel_cutoff1 = getprop("/controls/fuel-cutoff1");

    if (start1 and cutoff1 and !fuel_cutoff1)
    {
        # turboprops
        setprop("/controls/engines/engine[0]/starter", 1);
        interpolate("/fdm/jsbsim/propulsion/engine[0]/n1", 20, spool_time);
        settimer(func {
            setprop("/controls/engines/engine[0]/cutoff", 0);
        }, spool_time);

        settimer(switchback1, 1);
    }
    if (abort1)
    {
        setprop("/controls/engines/engine[0]/cutoff", 1);
        settimer(switchback1, 1);
    }
}

var set_pitch_fadec1 = maketimer(0.333333333, func {
    ## management of the feathering of the propellers
    ## for the moment, if the engine is stopped, we feather the propeller,
    ## otherwise, we put full throttle
    if (getprop("/engines/engine[0]/fuel-flow_pph") == 0) {
        interpolate("/controls/engines/engine[0]/propeller-pitch-fadec", 0, 1);
    } elsif (getprop("/controls/engines/engine[0]/propeller-feather") == 1) {
        ##for testing
        interpolate("/controls/engines/engine[0]/propeller-pitch-fadec", 0, 1);
    } else {
        var propeller_pitch = 1; #full power
        ##icing
#        propeller_pitch = propeller_pitch - getprop("/sim/icing/propellers");
        interpolate("/controls/engines/engine[0]/propeller-pitch-fadec", propeller_pitch, 1);
    }
});
set_pitch_fadec1.start();

setlistener(start1, set_engine1_state);
setlistener(abort1, set_engine1_state);
