# Becker Transponder BXP6401 by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var BXP6401_start = nil;
var BXP6401_ai = nil;
var BXP6401_alt = nil;
var BXP6401_display = nil;
var page = "start";

var base = "/instrumentation/transponder[0]/";
var inputs = base~"inputs/";

setprop(base~"sq", 1);

var mode_prop = base~"inputs/knob-mode";
	#Knob mode assignments: 0 = OFF  1 = STBY  2 = TEST (not avail) 3 = GND (not avail)  4=ON 5=ALT
var start_prop = base~"start";
var battery_prop = "/controls/electric/battery-switch";
var active_prop = inputs~"current-change";
var idcode_prop = base~"id-code";

setprop(active_prop, 0);

var instrument_dir = "Aircraft/Antares23E/Models/Instruments/bxp6401/";


var canvas_BXP6401_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		
		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		 var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var svg_keys = me.getKeys();
			foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var battery = getprop(battery_prop) or 0;
		var mode = getprop(mode_prop) or 0;
		var start = getprop(start_prop) or 0;
		if ( start == 1 and battery == 1 and mode != 0 ) {
			BXP6401_start.page.hide();
			if(mode==1 or mode==4){
				BXP6401_ai.page.show();
				BXP6401_alt.page.hide();
			}else if(mode==5){
				BXP6401_alt.page.show();
				BXP6401_ai.page.hide();
			}else{
				setprop(mode_prop, 1); #GND and TEST not available for this transponder, so we reset to STBY
			}
		} else if ( start > 0 and start < 1 and battery == 1 and mode != 0){
			BXP6401_ai.page.hide();
			BXP6401_alt.page.hide();
			BXP6401_start.page.show();
		} else {
			BXP6401_ai.page.hide();
			BXP6401_alt.page.hide();
			BXP6401_start.page.hide();
		}
		
		settimer(func me.update(), 0.02);
	},
};
	
	
var canvas_BXP6401_ai = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_BXP6401_ai , canvas_BXP6401_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ident.flag","r.flag","id1.digit","id2.digit","id3.digit","id4.digit","id1.change","id1.change.digit","id2.change","id2.change.digit","id3.change","id3.change.digit","id4.change","id4.change.digit","status"];
	},
	update: func() {
		#IDENT (ID) FLAG
		var ident_btn = getprop(base~"inputs/ident-btn") or 0;
		if( ident_btn == 1 ){
			me["ident.flag"].show();
		}else{
			me["ident.flag"].hide();
		}
		
		#ID CODE
		var cc = getprop(active_prop) or 0;
		if( cc == 0 ){
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 1 ){
			me["id1.change"].show();
			me["id1.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].hide();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 2 ){
			me["id2.change"].show();
			me["id2.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id1.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].hide();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 3 ){
			me["id3.change"].show();
			me["id3.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].hide();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 4 ){
			me["id4.change"].show();
			me["id4.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].hide();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
		}
		
		
		#Status (STBY/ON)
		var stat = getprop(mode_prop);
		if( stat == 1 ){
			me["status"].setText("SBY");
		}else if( stat == 4 ) {
			me["status"].setText("ON");
		}else{
			me["status"].setText("FAIL");
		}
		
		
		settimer(func me.update(), 0.02);
	}
	
};


var canvas_BXP6401_alt = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_BXP6401_alt , canvas_BXP6401_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["ident.flag","r.flag","id1.digit","id2.digit","id3.digit","id4.digit","id1.change","id1.change.digit","id2.change","id2.change.digit","id3.change","id3.change.digit","id4.change","id4.change.digit","altitude"];
	},
	update: func() {
		
		#IDENT (ID) FLAG
		var ident_btn = getprop(base~"inputs/ident-btn") or 0;
		if( ident_btn == 1 ){
			me["ident.flag"].show();
		}else{
			me["ident.flag"].hide();
		}
		
		#ID CODE
		var cc = getprop(active_prop) or 0;
		if( cc == 0 ){
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 1 ){
			me["id1.change"].show();
			me["id1.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].hide();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 2 ){
			me["id2.change"].show();
			me["id2.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id1.change"].hide();
			me["id3.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].hide();
			me["id3.digit"].show();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 3 ){
			me["id3.change"].show();
			me["id3.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id4.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].hide();
			me["id4.digit"].show();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id4.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
		}else if ( cc == 4 ){
			me["id4.change"].show();
			me["id4.change.digit"].setText(sprintf("%1d", getprop(inputs~"digit[0]")));
			me["id1.change"].hide();
			me["id2.change"].hide();
			me["id3.change"].hide();
			me["id1.digit"].show();
			me["id2.digit"].show();
			me["id3.digit"].show();
			me["id4.digit"].hide();
			me["id1.digit"].setText(sprintf("%1d", getprop(inputs~"digit[3]")));
			me["id2.digit"].setText(sprintf("%1d", getprop(inputs~"digit[2]")));
			me["id3.digit"].setText(sprintf("%1d", getprop(inputs~"digit[1]")));
		}
		
		#Altitude (FL)
		var alt = getprop(base~"altitude") or 0;
		var alt_val = getprop(base~"altitude-valid") or 0;
		if(alt_val == 1){
			me["altitude"].setText(sprintf("%03d", math.round(alt/100)));
		}else{
			me["altitude"].setText("---");
		}
			
		
		
		settimer(func me.update(), 0.02);
	}
	
};


var canvas_BXP6401_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_BXP6401_start , canvas_BXP6401_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};




var identoff = func {
	setprop("/instrumentation/transponder/inputs/ident-btn", 0);
}

setlistener("/instrumentation/transponder/inputs/ident-btn-2", func{
	setprop("/instrumentation/transponder/inputs/ident-btn", 1);
	settimer(identoff, 18);
});


setlistener("sim/signals/fdm-initialized", func {
	BXP6401_display = canvas.new({
		"name": "BXP6401",
		"size": [1024, 512],
		"view": [1024, 512],
		"mipmapping": 1
	});
	BXP6401_display.addPlacement({"node": "BXP6401.display"});
	var groupAi = BXP6401_display.createGroup();
	var groupAlt = BXP6401_display.createGroup();
	var groupStart = BXP6401_display.createGroup();


	BXP6401_ai = canvas_BXP6401_ai.new(groupAi, instrument_dir~"bxp6401-ai.svg");
	BXP6401_alt = canvas_BXP6401_alt.new(groupAlt, instrument_dir~"bxp6401-alt.svg");
	BXP6401_start = canvas_BXP6401_start.new(groupStart, instrument_dir~"bxp6401-start.svg");

	BXP6401_ai.update();
	BXP6401_alt.update();
	canvas_BXP6401_base.update();
});

var showBXP6401 = func {
	var dlg = canvas.Window.new([512, 256], "dialog").set("resize", 1);
	dlg.setCanvas(BXP6401_display);
}

var stop1 = 0;
var stop2 = 0;
var stop3 = 0;

var sqlicpressed = func () {
	var time_passed = getprop(base~"sql-ic-pressed-time") or 0;
	var pressed = getprop(base~"sql-ic-pressed") or 0;
	if(pressed){
		if( time_passed > 2 and stop1 != 1) {
			var intercom = getprop(base~"intercom");
			if(intercom==0){
				setprop("instrumentation/comm[0]/intercom", 1);
			}else{
				setprop("instrumentation/comm[0]/intercom", 0);
			}
			stop1 = 1;
		}
		setprop(base~"sql-ic-pressed-time", time_passed + 0.1);
		settimer(sqlicpressed, 0.1);		
	} else {
		if(time_passed<2){
			var sq = getprop(base~"sq");
			if(sq==0){
				setprop("instrumentation/comm[0]/sq", 1);
			}else{
				setprop("instrumentation/comm[0]/sq", 0);
			}
		}
		setprop(base~"sql-ic-pressed-time", 0);
		stop1 = 0;
		
	}
}

var swap_freqs = func () {
	var active_prop = base~"frequencies/selected-mhz";
	var standby_prop = base~"frequencies/standby-mhz";
	var active = getprop(active_prop) or 0;
	var standby = getprop(standby_prop) or 0;
	
	var i=1;
	var fail=0;
	while(i<6){
		var frq=stored_frequencies[i].frequency;
		if(frq==nil){
			stored_frequencies[i].set_frequency(active);
			break;
		}else if(i==5){
			fail=1;
		}
		i=i+1;
	}
	if(fail==1){
		stored_frequencies[1].set_frequency(active);
	}
	
	setprop(active_prop, standby);
	setprop(standby_prop, active);
}

var swapscanpressed = func () {
	var time_passed = getprop(base~"swap-scan-pressed-time") or 0;
	var pressed = getprop(base~"swap-scan-pressed") or 0;
	if(pressed){
		if( time_passed > 2 and stop2 != 1) {
			var scan = getprop(base~"scan");
			if(scan==0){
				setprop("instrumentation/comm[0]/scan", 1);
			}else{
				setprop("instrumentation/comm[0]/scan", 0);
			}
			stop2 = 1;
		}
		setprop(base~"swap-scan-pressed-time", time_passed + 0.1);
		settimer(swapscanpressed, 0.1);
	} else {
		if(time_passed<2){
			swap_freqs();
		}
		setprop(base~"swap-scan-pressed-time", 0);
		stop2 = 0;
		
	}
}

var modepressed = func () {
	var short_prop = "instrumentation/comm[0]/channel-menu";
	var long_prop = "instrumentation/comm[0]/pilot-menu";
	var time_prop = "instrumentation/comm[0]/mode-pressed-time";
	var time_passed = getprop(time_prop) or 0;
	var pressed = getprop(base~"mode-pressed") or 0;
	if(pressed){
		if( time_passed > 2 and stop3 != 1) {
			var pm = getprop(long_prop);
			if(pm==0){
				setprop(long_prop, 1);
			}else{
				setprop(long_prop, 0);
			}
			stop3 = 1;
		}
		setprop(time_prop, time_passed + 0.1);
		settimer(modepressed, 0.1);
	} else {
		if(time_passed<2){
			var sch = getprop(short_prop);
			if(sch==0){
				setprop(short_prop,1);
			}else{
				setprop(short_prop,0);
			}
		}
		setprop(time_prop, 0);
		stop3 = 0;
		
	}
}

var identoff = func {
	setprop("/instrumentation/transponder/inputs/ident-btn", 0);
}

var ident_btn = func() {
	setprop("/instrumentation/transponder/inputs/ident-btn", 1);
	settimer(identoff, 18);
}

setlistener(mode_prop, func{
	if(getprop(mode_prop) != 0 and getprop(battery_prop) == 1 and getprop(start_prop) == 0){
		interpolate(start_prop, 1, 1 );
	}else if( ( getprop(mode_prop) == 0 or getprop(battery_prop) == 0 ) and getprop(start_prop) != 0){
		setprop(start_prop, 0);
	}
});

setlistener(battery_prop, func{
	if(getprop(mode_prop) != 0 and getprop(battery_prop) == 1 and getprop(start_prop) == 0){
		interpolate(start_prop, 1, 1 );
	}else if( ( getprop(mode_prop) == 0 or getprop(battery_prop) == 0 ) and getprop(start_prop) != 0){
		setprop(start_prop, 0);
	}
});

setlistener(base~"channel-menu", func{
	if(getprop(base~"channel-menu")==0){
		setprop(base~"selected-channel", 0);
	}else if(getprop(base~"channel-menu")==2){
		var i=6;
		var fail=0;
		while(i<16){
			var frq=stored_frequencies[i].frequency;
			if(frq==nil){
				setprop(base~"selected-channel", i);
				break;
			}else if(i==15){
				fail=1;
			}
			i=i+1;
		}
		if(fail==1){
			setprop(base~"selected-channel", 6);
		}
	}
});
	
