/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Label;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Language;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class IfExp
extends Expression {
    Expression test;
    Expression then_clause;
    Expression else_clause;

    public IfExp(Expression expression, Expression expression2, Expression expression3) {
        this.test = expression;
        this.then_clause = expression2;
        this.else_clause = expression3;
    }

    protected final Language getLanguage() {
        return Language.getDefaultLanguage();
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        if (this.getLanguage().isTrue(this.test.eval(callContext))) {
            this.then_clause.apply(callContext);
        } else if (this.else_clause != null) {
            this.else_clause.apply(callContext);
        }
    }

    Expression select(boolean bl) {
        return bl ? this.then_clause : (this.else_clause == null ? QuoteExp.voidExp : this.else_clause);
    }

    public void compile(Compilation compilation, Target target) {
        IfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, compilation, target);
    }

    /*
     * Unable to fully structure code
     */
    public static void compile(Expression var0, Expression var1_1, Expression var2_2, Compilation var3_3, Target var4_4) {
        block12: {
            block11: {
                var5_5 = var3_3.getLanguage();
                var6_6 = var3_3.getCode();
                var8_7 = null;
                if (!(var4_4 instanceof ConditionalTarget) || !(var2_2 instanceof QuoteExp)) break block11;
                var11_8 = true;
                var12_9 = ((QuoteExp)var2_2).getValue();
                var8_7 = var5_5.isTrue(var12_9) ? ((ConditionalTarget)var4_4).ifTrue : ((ConditionalTarget)var4_4).ifFalse;
                break block12;
            }
            if (!(var2_2 instanceof ExitExp) || !(((ExitExp)var2_2).result instanceof QuoteExp)) ** GOTO lbl-1000
            var9_10 = ((ExitExp)var2_2).block;
            if (var9_10.exitTarget instanceof IgnoreTarget && (var8_7 = var9_10.exitableBlock.exitIsGoto()) != null) {
                var11_8 = true;
            } else lbl-1000:
            // 2 sources

            {
                var11_8 = false;
            }
        }
        if (var8_7 == null) {
            var8_7 = new Label(var6_6);
        }
        if (var0 == var1_1 && var4_4 instanceof ConditionalTarget && var1_1 instanceof ReferenceExp) {
            var10_11 = true;
            var7_12 = ((ConditionalTarget)var4_4).ifTrue;
        } else {
            var10_11 = false;
            var7_12 = new Label(var6_6);
        }
        var12_9 = new ConditionalTarget(var7_12, var8_7, var5_5);
        if (var10_11) {
            var12_9.trueBranchComesFirst = false;
        }
        var0.compile(var3_3, (Target)var12_9);
        var6_6.emitIfThen();
        if (!var10_11) {
            var7_12.define(var6_6);
            var13_13 = var3_3.callContextVar;
            var1_1.compileWithPosition(var3_3, var4_4);
            var3_3.callContextVar = var13_13;
        }
        if (!var11_8) {
            var6_6.emitElse();
            var8_7.define(var6_6);
            var13_13 = var3_3.callContextVar;
            if (var2_2 == null) {
                var3_3.compileConstant(Values.empty, var4_4);
            } else {
                var2_2.compileWithPosition(var3_3, var4_4);
            }
            var3_3.callContextVar = var13_13;
        } else {
            var6_6.setUnreachable();
        }
        var6_6.emitFi();
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkIfExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.test = this.test.walk(expWalker);
        if (expWalker.exitValue == null) {
            this.then_clause = expWalker.walk(this.then_clause);
        }
        if (expWalker.exitValue == null && this.else_clause != null) {
            this.else_clause = expWalker.walk(this.else_clause);
        }
    }

    public Type getType() {
        PrimType primType;
        Type type = this.then_clause.getType();
        Type type2 = primType = this.else_clause == null ? Type.voidType : this.else_clause.getType();
        if (type == primType) {
            return type;
        }
        return Type.pointer_type;
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(If ", false, ")");
        outPort.setIndentation(-2, false);
        this.test.print(outPort);
        outPort.writeSpaceLinear();
        this.then_clause.print(outPort);
        if (this.else_clause != null) {
            outPort.writeSpaceLinear();
            this.else_clause.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }
}

