/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.ModuleExp;
import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.kawa.functions.Convert;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.OccurrenceType;
import gnu.kawa.reflect.SingletonType;
import gnu.kawa.xml.DescendantOrSelfAxis;
import gnu.kawa.xml.ElementType;
import gnu.kawa.xml.MakeAttribute;
import gnu.kawa.xml.MakeElement;
import gnu.kawa.xml.MakeWithBaseUri;
import gnu.kawa.xml.NodeType;
import gnu.kawa.xml.ParentAxis;
import gnu.kawa.xml.ProcessingInstructionType;
import gnu.kawa.xml.XDataType;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.PropertySet;
import gnu.mapping.Symbol;
import gnu.mapping.TtyInPort;
import gnu.mapping.WrappedException;
import gnu.math.IntNum;
import gnu.text.FilePath;
import gnu.text.Lexer;
import gnu.text.LineBufferedReader;
import gnu.text.Path;
import gnu.text.SourceError;
import gnu.text.SourceLocator;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.text.URIPath;
import gnu.xml.NamespaceBinding;
import gnu.xml.TextUtils;
import gnu.xml.XName;
import gnu.xquery.lang.XQResolveNames;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.CastableAs;
import gnu.xquery.util.NamedCollator;
import gnu.xquery.util.QNameUtils;
import gnu.xquery.util.RelativeStep;
import gnu.xquery.util.ValuesFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Stack;
import java.util.Vector;
import kawa.standard.require;

public class XQParser
extends Lexer {
    int curToken;
    Object curValue;
    int parseContext;
    boolean seenDeclaration;
    String libraryModuleNamespace;
    int curLine;
    int curColumn;
    XQuery interpreter;
    int seenPosition;
    int seenLast;
    public static boolean warnOldVersion = true;
    public static boolean warnHidePreviousDeclaration = false;
    static final Symbol DOT_VARNAME = Symbol.makeUninterned("$dot$");
    static final Symbol POSITION_VARNAME = Symbol.makeUninterned("$position$");
    static final Symbol LAST_VARNAME = Symbol.makeUninterned("$last$");
    public static final InstanceOf instanceOf = new InstanceOf(XQuery.getInstance(), "instance");
    public static final CastableAs castableAs = CastableAs.castableAs;
    public static final Convert treatAs = Convert.as;
    NamedCollator defaultCollator = null;
    char defaultEmptyOrder = (char)76;
    boolean emptyOrderDeclarationSeen;
    Path baseURI = null;
    boolean baseURIDeclarationSeen;
    boolean boundarySpacePreserve;
    boolean boundarySpaceDeclarationSeen;
    boolean orderingModeUnordered;
    boolean orderingModeSeen;
    boolean copyNamespacesDeclarationSeen;
    int copyNamespacesMode = 3;
    boolean constructionModeStrip;
    boolean constructionModeDeclarationSeen;
    public Namespace[] functionNamespacePath = XQuery.defaultFunctionNamespacePath;
    Declaration[] flworDecls;
    int flworDeclsFirst;
    int flworDeclsCount;
    int parseCount;
    int commentCount;
    String errorIfComment;
    static final int EOF_TOKEN = -1;
    static final int EOL_TOKEN = 10;
    static final char INTEGER_TOKEN = '0';
    static final char DECIMAL_TOKEN = '1';
    static final char DOUBLE_TOKEN = '2';
    static final int STRING_TOKEN = 34;
    static final int SLASHSLASH_TOKEN = 68;
    static final int DOTDOT_TOKEN = 51;
    static final int COLON_EQUAL_TOKEN = 76;
    static final int COLON_COLON_TOKEN = 88;
    static final int NCNAME_TOKEN = 65;
    static final int NCNAME_COLON_TOKEN = 67;
    static final int QNAME_TOKEN = 81;
    static final int ARROW_TOKEN = 82;
    static final int FNAME_TOKEN = 70;
    static final int IMPORT_MODULE_TOKEN = 73;
    static final int IMPORT_SCHEMA_TOKEN = 84;
    static final int MODULE_NAMESPACE_TOKEN = 77;
    static final int DECLARE_NAMESPACE_TOKEN = 78;
    static final int DECLARE_BOUNDARY_SPACE_TOKEN = 83;
    static final int DEFAULT_ELEMENT_TOKEN = 69;
    static final int DEFAULT_FUNCTION_TOKEN = 79;
    static final int DEFAULT_COLLATION_TOKEN = 71;
    static final int DEFAULT_ORDER_TOKEN = 72;
    static final int DECLARE_FUNCTION_TOKEN = 80;
    static final int DECLARE_VARIABLE_TOKEN = 86;
    static final int DECLARE_BASE_URI_TOKEN = 66;
    static final int DECLARE_ORDERING_TOKEN = 85;
    static final int DECLARE_CONSTRUCTION_TOKEN = 75;
    static final int DECLARE_OPTION_TOKEN = 111;
    static final int DECLARE_COPY_NAMESPACES_TOKEN = 76;
    static final int DEFINE_QNAME_TOKEN = 87;
    static final int XQUERY_VERSION_TOKEN = 89;
    static final int OP_AXIS_FIRST = 100;
    static final int COUNT_OP_AXIS = 13;
    static final int AXIS_ANCESTOR = 0;
    static final int AXIS_ANCESTOR_OR_SELF = 1;
    static final int AXIS_ATTRIBUTE = 2;
    static final int AXIS_CHILD = 3;
    static final int AXIS_DESCENDANT = 4;
    static final int AXIS_DESCENDANT_OR_SELF = 5;
    static final int AXIS_FOLLOWING = 6;
    static final int AXIS_FOLLOWING_SIBLING = 7;
    static final int AXIS_NAMESPACE = 8;
    static final int AXIS_PARENT = 9;
    static final int AXIS_PRECEDING = 10;
    static final int AXIS_PRECEDING_SIBLING = 11;
    static final int AXIS_SELF = 12;
    static final int OP_WHERE = 196;
    static final int PRAGMA_START_TOKEN = 197;
    static final int OP_BASE = 400;
    static final int OP_OR = 400;
    static final int OP_AND = 401;
    static final int OP_EQU = 402;
    static final int OP_NEQ = 403;
    static final int OP_LSS = 404;
    static final int OP_GRT = 405;
    static final int OP_LEQ = 406;
    static final int OP_GEQ = 407;
    static final int OP_IS = 408;
    static final int OP_ISNOT = 409;
    static final int OP_GRTGRT = 410;
    static final int OP_LSSLSS = 411;
    static final int OP_RANGE_TO = 412;
    static final int OP_ADD = 413;
    static final int OP_SUB = 414;
    static final int OP_MUL = 415;
    static final int OP_DIV = 416;
    static final int OP_IDIV = 417;
    static final int OP_MOD = 418;
    static final int OP_UNION = 419;
    static final int OP_INTERSECT = 420;
    static final int OP_EXCEPT = 421;
    static final int OP_INSTANCEOF = 422;
    static final int OP_TREAT_AS = 423;
    static final int OP_CASTABLE_AS = 424;
    static final int OP_CAST_AS = 425;
    static final int OP_EQ = 426;
    static final int OP_NE = 427;
    static final int OP_LT = 428;
    static final int OP_LE = 429;
    static final int OP_GT = 430;
    static final int OP_GE = 431;
    static final int OP_NODE = 230;
    static final int OP_TEXT = 231;
    static final int OP_COMMENT = 232;
    static final int OP_PI = 233;
    static final int OP_DOCUMENT = 234;
    static final int OP_ELEMENT = 235;
    static final int OP_ATTRIBUTE = 236;
    static final int OP_ITEM = 237;
    static final int OP_EMPTY_SEQUENCE = 238;
    static final int OP_SCHEMA_ATTRIBUTE = 239;
    static final int OP_SCHEMA_ELEMENT = 240;
    static final int IF_LPAREN_TOKEN = 241;
    static final int TYPESWITCH_LPAREN_TOKEN = 242;
    static final int FOR_DOLLAR_TOKEN = 243;
    static final int LET_DOLLAR_TOKEN = 244;
    static final int SOME_DOLLAR_TOKEN = 245;
    static final int EVERY_DOLLAR_TOKEN = 246;
    static final int CASE_DOLLAR_TOKEN = 247;
    static final int VALIDATE_LBRACE_TOKEN = 248;
    static final int ORDERED_LBRACE_TOKEN = 249;
    static final int UNORDERED_LBRACE_TOKEN = 250;
    static final int ELEMENT_TOKEN = 251;
    static final int ATTRIBUTE_TOKEN = 252;
    static final int TEXT_TOKEN = 253;
    static final int COMMENT_TOKEN = 254;
    static final int PI_TOKEN = 255;
    static final int DOCUMENT_TOKEN = 256;
    private int saveToken;
    private Object saveValue;
    private boolean warnedOldStyleKindTest;
    static PrimProcedure proc_OccurrenceType_getInstance = new PrimProcedure(ClassType.make("gnu.kawa.reflect.OccurrenceType").getDeclaredMethod("getInstance", 3));
    public static QuoteExp makeChildAxisStep = QuoteExp.getInstance(new PrimProcedure("gnu.kawa.xml.ChildAxis", "make", 1));
    public static QuoteExp makeDescendantAxisStep = QuoteExp.getInstance(new PrimProcedure("gnu.kawa.xml.DescendantAxis", "make", 1));
    int enclosedExpressionsSeen;
    public static Expression makeText = XQParser.makeFunctionExp("gnu.kawa.xml.MakeText", "makeText");
    static final Expression makeCDATA = XQParser.makeFunctionExp("gnu.kawa.xml.MakeCDATA", "makeCDATA");
    Compilation comp;
    String defaultElementNamespace = "";
    NamespaceBinding constructorNamespaces = NamespaceBinding.predefinedXML;
    NamespaceBinding prologNamespaces;
    static NamespaceBinding builtinNamespaces;
    public static final QuoteExp getExternalFunction;
    public static final String[] axisNames;

    public void setStaticBaseUri(String string) {
        try {
            this.baseURI = XQParser.fixupStaticBaseUri(URIPath.valueOf(string));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof WrappedException) {
                throwable2 = ((WrappedException)throwable).getCause();
            }
            this.error('e', "invalid URI: " + throwable2.getMessage());
        }
    }

    static Path fixupStaticBaseUri(Path path) {
        if ((path = path.getAbsolute()) instanceof FilePath) {
            path = URIPath.valueOf(path.toURI());
        }
        return path;
    }

    public String getStaticBaseUri() {
        Path path = this.baseURI;
        if (path == null) {
            LineBufferedReader lineBufferedReader;
            Environment environment = Environment.getCurrent();
            Object object2 = environment.get(Symbol.make("", "base-uri"), null, null);
            if (object2 != null && !(object2 instanceof Path)) {
                path = URIPath.valueOf(object2.toString());
            }
            if (path == null && (lineBufferedReader = this.getPort()) != null && (path = lineBufferedReader.getPath()) instanceof FilePath && (!path.exists() || lineBufferedReader instanceof TtyInPort || lineBufferedReader instanceof CharArrayInPort)) {
                path = null;
            }
            if (path == null) {
                path = Path.currentPath();
            }
            this.baseURI = path = XQParser.fixupStaticBaseUri(path);
        }
        return path.toString();
    }

    public String resolveAgainstBaseUri(String string) {
        if (Path.uriSchemeSpecified(string)) {
            return string;
        }
        String string2 = this.getStaticBaseUri();
        Path path = Path.valueOf(string2);
        return path.resolve(string).toString();
    }

    final int skipSpace() throws IOException, SyntaxException {
        return this.skipSpace(true);
    }

    final int skipSpace(boolean bl) throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) == 40) {
                if (!this.checkNext(':')) {
                    return 40;
                }
                this.skipComment();
                continue;
            }
            if (n == 123) {
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    return 123;
                }
                n = this.read();
                if (n != 45) {
                    this.unread(n);
                    this.unread(45);
                    return 123;
                }
                this.skipOldComment();
                continue;
            }
            if (bl ? n < 0 || !Character.isWhitespace((char)n) : n != 32 && n != 9) break;
        }
        return n;
    }

    final void skipToSemicolon() throws IOException {
        int n;
        while ((n = this.read()) >= 0 && n != 59) {
        }
    }

    final void skipOldComment() throws IOException, SyntaxException {
        int n = 0;
        int n2 = this.getLineNumber() + 1;
        int n3 = this.getColumnNumber() - 2;
        this.warnOldVersion("use (: :) instead of old-style comment {-- --}");
        while (true) {
            int n4;
            if ((n4 = this.read()) == 45) {
                ++n;
                continue;
            }
            if (n4 == 125 && n >= 2) {
                return;
            }
            if (n4 < 0) {
                this.curLine = n2;
                this.curColumn = n3;
                this.eofError("non-terminated comment starting here");
                continue;
            }
            n = 0;
        }
    }

    final void skipComment() throws IOException, SyntaxException {
        ++this.commentCount;
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() - 1;
        if (this.errorIfComment != null) {
            this.curLine = n;
            this.curColumn = n2;
            this.error('e', this.errorIfComment);
        }
        int n3 = 0;
        int n4 = 0;
        char c = this.pushNesting(':');
        while (true) {
            int n5;
            if ((n5 = this.read()) == 58) {
                if (n3 == 40) {
                    ++n4;
                    n5 = 0;
                }
            } else if (n5 == 41 && n3 == 58) {
                if (n4 == 0) {
                    this.popNesting(c);
                    return;
                }
                --n4;
            } else if (n5 < 0) {
                this.curLine = n;
                this.curColumn = n2;
                this.eofError("non-terminated comment starting here");
            }
            n3 = n5;
        }
    }

    final int peekNonSpace(String string) throws IOException, SyntaxException {
        int n = this.skipSpace();
        if (n < 0) {
            this.eofError(string);
        }
        this.unread(n);
        return n;
    }

    public void mark() throws IOException {
        super.mark();
        this.saveToken = this.curToken;
        this.saveValue = this.curValue;
    }

    public void reset() throws IOException {
        this.curToken = this.saveToken;
        this.curValue = this.saveValue;
        super.reset();
    }

    private int setToken(int n, int n2) {
        this.curToken = n;
        this.curLine = this.port.getLineNumber() + 1;
        this.curColumn = this.port.getColumnNumber() + 1 - n2;
        return n;
    }

    void checkSeparator(char c) {
        if (XName.isNameStart(c)) {
            this.error('e', "missing separator", "XPST0003");
        }
    }

    int getRawToken() throws IOException, SyntaxException {
        int n;
        while (true) {
            if ((n = this.read()) < 0) {
                return this.setToken(-1, 0);
            }
            if (n == 10 || n == 13) {
                if (this.nesting > 0) continue;
                return this.setToken(10, 0);
            }
            if (n == 40) {
                if (this.checkNext(':')) {
                    this.skipComment();
                    continue;
                }
                if (this.checkNext('#')) {
                    return this.setToken(197, 2);
                }
                return this.setToken(40, 1);
            }
            if (n == 123) {
                if (!this.checkNext('-')) {
                    return this.setToken(123, 1);
                }
                n = this.read();
                if (n != 45) {
                    this.unread();
                    this.unread();
                    return this.setToken(123, 1);
                }
                this.skipOldComment();
                continue;
            }
            if (n != 32 && n != 9) break;
        }
        this.tokenBufferLength = 0;
        this.curLine = this.port.getLineNumber() + 1;
        this.curColumn = this.port.getColumnNumber();
        int n2 = n;
        switch (n2) {
            case 36: 
            case 41: 
            case 44: 
            case 59: 
            case 63: 
            case 64: 
            case 91: 
            case 93: 
            case 125: {
                break;
            }
            case 58: {
                if (this.checkNext('=')) {
                    n2 = 76;
                    break;
                }
                if (!this.checkNext(':')) break;
                n2 = 88;
                break;
            }
            case 124: {
                n2 = 419;
                break;
            }
            case 42: {
                n2 = 415;
                break;
            }
            case 43: {
                n2 = 413;
                break;
            }
            case 45: {
                n2 = 414;
                break;
            }
            case 33: {
                if (!this.checkNext('=')) break;
                n2 = 403;
                break;
            }
            case 47: {
                if (!this.checkNext('/')) break;
                n2 = 68;
                break;
            }
            case 61: {
                if (this.checkNext('>')) {
                    n2 = 82;
                }
                n2 = 402;
                break;
            }
            case 62: {
                n2 = this.checkNext('=') ? 407 : (this.checkNext('>') ? 410 : 405);
                break;
            }
            case 60: {
                n2 = this.checkNext('=') ? 406 : (this.checkNext('<') ? 411 : 404);
                break;
            }
            case 34: 
            case 39: {
                char c = this.pushNesting((char)n);
                while (true) {
                    if ((n = this.read()) < 0) {
                        this.eofError("unexpected end-of-file in string starting here");
                    }
                    if (n == 38) {
                        this.parseEntityOrCharRef();
                        continue;
                    }
                    if (n2 == n && n2 != (n = this.read())) break;
                    this.tokenBufferAppend((char)n);
                }
                this.unread(n);
                this.popNesting(c);
                n2 = 34;
                break;
            }
            default: {
                if (Character.isDigit((char)n2) || n2 == 46 && Character.isDigit((char)this.peek())) {
                    boolean bl = n2 == 46;
                    while (true) {
                        this.tokenBufferAppend(n2);
                        n = this.read();
                        if (n < 0) break;
                        n2 = (char)n;
                        if (n2 == 46) {
                            if (bl) break;
                            bl = true;
                            continue;
                        }
                        if (!Character.isDigit((char)n2)) break;
                    }
                    if (n == 101 || n == 69) {
                        this.tokenBufferAppend((char)n);
                        n = this.read();
                        if (n == 43 || n == 45) {
                            this.tokenBufferAppend((char)n);
                            n = this.read();
                        }
                        int n3 = 0;
                        while (n >= 0) {
                            n2 = (char)n;
                            if (!Character.isDigit((char)n2)) {
                                this.checkSeparator((char)n2);
                                this.unread();
                                break;
                            }
                            this.tokenBufferAppend(n2);
                            n = this.read();
                            ++n3;
                        }
                        if (n3 == 0) {
                            this.error('e', "no digits following exponent", "XPST0003");
                        }
                        n2 = 50;
                        break;
                    }
                    int n4 = n2 = bl ? 49 : 48;
                    if (n < 0) break;
                    this.checkSeparator((char)n);
                    this.unread(n);
                    break;
                }
                if (n2 == 46) {
                    if (!this.checkNext('.')) break;
                    n2 = 51;
                    break;
                }
                if (XName.isNameStart(n2)) {
                    do {
                        this.tokenBufferAppend(n2);
                    } while (XName.isNamePart(n2 = (int)((char)(n = this.read()))));
                    if (n < 0) {
                        n2 = 65;
                        break;
                    }
                    if (n != 58) {
                        n2 = 65;
                    } else {
                        n = this.read();
                        if (n < 0) {
                            this.eofError("unexpected end-of-file after NAME ':'");
                        }
                        if (XName.isNameStart(n2 = (int)((char)n))) {
                            this.tokenBufferAppend(58);
                            do {
                                this.tokenBufferAppend(n2);
                            } while (XName.isNamePart(n2 = (int)((char)(n = this.read()))));
                            n2 = 81;
                        } else if (n2 == 61) {
                            this.unread(n2);
                            n2 = 65;
                        } else {
                            n2 = 67;
                        }
                    }
                    this.unread(n);
                    break;
                }
                if (n2 >= 32 && n2 < 127) {
                    this.syntaxError("invalid character '" + (char)n2 + '\'');
                    break;
                }
                this.syntaxError("invalid character '\\u" + Integer.toHexString(n2) + '\'');
            }
        }
        this.curToken = n2;
        return n2;
    }

    public void getDelimited(String string) throws IOException, SyntaxException {
        this.tokenBufferLength = 0;
        int n = string.length();
        char c = string.charAt(n - 1);
        while (true) {
            int n2;
            int n3;
            int n4;
            if ((n4 = this.read()) < 0) {
                this.eofError("unexpected end-of-file looking for '" + string + '\'');
            }
            if (n4 == c && (n3 = this.tokenBufferLength - (n2 = n - 1)) >= 0) {
                do {
                    if (n2 != 0) continue;
                    this.tokenBufferLength = n3;
                    return;
                } while (this.tokenBuffer[n3 + --n2] == string.charAt(n2));
            }
            this.tokenBufferAppend((char)n4);
        }
    }

    public void appendNamedEntity(String string) {
        string = string.intern();
        int n = 63;
        if (string == "lt") {
            n = 60;
        } else if (string == "gt") {
            n = 62;
        } else if (string == "amp") {
            n = 38;
        } else if (string == "quot") {
            n = 34;
        } else if (string == "apos") {
            n = 39;
        } else {
            this.error("unknown enity reference: '" + string + "'");
        }
        this.tokenBufferAppend(n);
    }

    boolean match(String string, String string2, boolean bl) throws IOException, SyntaxException {
        if (this.match(string)) {
            this.mark();
            this.getRawToken();
            if (this.match(string2)) {
                this.reset();
                this.getRawToken();
                return true;
            }
            this.reset();
            if (bl) {
                this.error('e', "'" + string + "' must be followed by '" + string2 + "'", "XPST0003");
                return true;
            }
        }
        return false;
    }

    int peekOperator() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            if (this.nesting == 0) {
                return 10;
            }
            this.getRawToken();
        }
        if (this.curToken == 65) {
            int n = this.tokenBufferLength;
            switch (n) {
                case 2: {
                    char c = this.tokenBuffer[0];
                    char c2 = this.tokenBuffer[1];
                    if (c == 'o' && c2 == 'r') {
                        this.curToken = 400;
                        break;
                    }
                    if (c == 't' && c2 == 'o') {
                        this.curToken = 412;
                        break;
                    }
                    if (c == 'i' && c2 == 's') {
                        this.curToken = 408;
                        break;
                    }
                    if (c == 'e' && c2 == 'q') {
                        this.curToken = 426;
                        break;
                    }
                    if (c == 'n' && c2 == 'e') {
                        this.curToken = 427;
                        break;
                    }
                    if (c == 'g') {
                        if (c2 == 'e') {
                            this.curToken = 431;
                            break;
                        }
                        if (c2 != 't') break;
                        this.curToken = 430;
                        break;
                    }
                    if (c != 'l') break;
                    if (c2 == 'e') {
                        this.curToken = 429;
                        break;
                    }
                    if (c2 != 't') break;
                    this.curToken = 428;
                    break;
                }
                case 3: {
                    char c = this.tokenBuffer[0];
                    char c3 = this.tokenBuffer[1];
                    char c4 = this.tokenBuffer[2];
                    if (c == 'a') {
                        if (c3 != 'n' || c4 != 'd') break;
                        this.curToken = 401;
                        break;
                    }
                    if (c == 'm') {
                        if (c3 == 'u' && c4 == 'l') {
                            this.curToken = 415;
                        }
                        if (c3 != 'o' || c4 != 'd') break;
                        this.curToken = 418;
                        break;
                    }
                    if (c != 'd' || c3 != 'i' || c4 != 'v') break;
                    this.curToken = 416;
                    break;
                }
                case 4: {
                    if (this.match("idiv")) {
                        this.curToken = 417;
                        break;
                    }
                    if (!this.match("cast", "as", true)) break;
                    this.curToken = 425;
                    break;
                }
                case 5: {
                    if (this.match("where")) {
                        this.curToken = 196;
                        break;
                    }
                    if (this.match("isnot")) {
                        this.curToken = 409;
                        break;
                    }
                    if (this.match("union")) {
                        this.curToken = 419;
                        break;
                    }
                    if (!this.match("treat", "as", true)) break;
                    this.curToken = 423;
                    break;
                }
                case 6: {
                    if (!this.match("except")) break;
                    this.curToken = 421;
                    break;
                }
                case 8: {
                    if (this.match("instance", "of", true)) {
                        this.curToken = 422;
                        break;
                    }
                    if (!this.match("castable", "as", true)) break;
                    this.curToken = 424;
                    break;
                }
                case 9: {
                    if (!this.match("intersect")) break;
                    this.curToken = 420;
                    break;
                }
                case 10: {
                    if (!this.match("instanceof")) break;
                    this.warnOldVersion("use 'instanceof of' (two words) instead of 'instanceof'");
                    this.curToken = 422;
                    break;
                }
            }
        }
        return this.curToken;
    }

    private boolean lookingAt(String string, String string2) throws IOException, SyntaxException {
        int n;
        if (!string.equals(this.curValue)) {
            return false;
        }
        int n2 = 0;
        int n3 = string2.length();
        do {
            n = this.read();
            if (n2 != n3) continue;
            if (n < 0) {
                return true;
            }
            if (!XName.isNamePart((char)n)) {
                this.unread();
                return true;
            }
            ++n2;
            break;
        } while (n >= 0 && n == string2.charAt(n2++));
        this.port.skip(-n2);
        return false;
    }

    int getAxis() {
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
        int n = 13;
        while (--n >= 0 && axisNames[n] != string) {
        }
        if (n < 0 || n == 8) {
            this.error('e', "unknown axis name '" + string + '\'', "XPST0003");
            n = 3;
        }
        return (char)(100 + n);
    }

    int peekOperand() throws IOException, SyntaxException {
        while (this.curToken == 10) {
            this.getRawToken();
        }
        if (this.curToken == 65 || this.curToken == 81) {
            int n = this.skipSpace(this.nesting != 0);
            switch (this.tokenBuffer[0]) {
                case 'a': {
                    if (!this.match("attribute")) break;
                    if (n == 40) {
                        this.curToken = 236;
                        return 236;
                    }
                    if (n != 123 && !XName.isNameStart((char)n)) break;
                    this.unread();
                    this.curToken = 252;
                    return 252;
                }
                case 'c': {
                    if (!this.match("comment")) break;
                    if (n == 40) {
                        this.curToken = 232;
                        return 232;
                    }
                    if (n != 123) break;
                    this.unread();
                    this.curToken = 254;
                    return 254;
                }
                case 'd': {
                    if (n == 123 && this.match("document")) {
                        this.unread();
                        this.curToken = 256;
                        return 256;
                    }
                    if (n != 40 || !this.match("document-node")) break;
                    this.curToken = 234;
                    return 234;
                }
                case 'e': {
                    if (this.match("element")) {
                        if (n == 40) {
                            this.curToken = 235;
                            return 235;
                        }
                        if (n != 123 && !XName.isNameStart((char)n)) break;
                        this.unread();
                        this.curToken = 251;
                        return 251;
                    }
                    if (n == 40 && this.match("empty-sequence")) {
                        this.curToken = 238;
                        return 238;
                    }
                    if (n != 36 || !this.match("every")) break;
                    this.curToken = 246;
                    return 246;
                }
                case 'f': {
                    if (n != 36 || !this.match("for")) break;
                    this.curToken = 243;
                    return 243;
                }
                case 'i': {
                    if (n == 40 && this.match("if")) {
                        this.curToken = 241;
                        return 241;
                    }
                    if (n != 40 || !this.match("item")) break;
                    this.curToken = 237;
                    return 237;
                }
                case 'l': {
                    if (n != 36 || !this.match("let")) break;
                    this.curToken = 244;
                    return 244;
                }
                case 'n': {
                    if (n != 40 || !this.match("node")) break;
                    this.curToken = 230;
                    return 230;
                }
                case 'o': {
                    if (n != 123 || !this.match("ordered")) break;
                    this.curToken = 249;
                    return 249;
                }
                case 'p': {
                    if (!this.match("processing-instruction")) break;
                    if (n == 40) {
                        this.curToken = 233;
                        return 233;
                    }
                    if (n != 123 && !XName.isNameStart((char)n)) break;
                    this.unread();
                    this.curToken = 255;
                    return 255;
                }
                case 's': {
                    if (n == 36 && this.match("some")) {
                        this.curToken = 245;
                        return 245;
                    }
                    if (n == 40 && this.match("schema-attribute")) {
                        this.curToken = 239;
                        return 239;
                    }
                    if (n != 40 || !this.match("schema-element")) break;
                    this.curToken = 240;
                    return 240;
                }
                case 't': {
                    if (this.match("text")) {
                        if (n == 40) {
                            this.curToken = 231;
                            return 231;
                        }
                        if (n == 123) {
                            this.unread();
                            this.curToken = 253;
                            return 253;
                        }
                    }
                    if (n != 40 || !this.match("typeswitch")) break;
                    this.curToken = 242;
                    return 242;
                }
                case 'u': {
                    if (n != 123 || !this.match("unordered")) break;
                    this.curToken = 250;
                    return 250;
                }
                case 'v': {
                    if (n != 123 || !this.match("validate")) break;
                    this.curToken = 248;
                    return 248;
                }
            }
            if (n == 40 && this.peek() != 58) {
                this.curToken = 70;
                return 70;
            }
            if (n == 58 && this.peek() == 58) {
                this.curToken = this.getAxis();
                return this.curToken;
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            this.curValue = string;
            switch (n) {
                case 98: {
                    if (this.lookingAt("declare", "ase-uri")) {
                        this.curToken = 66;
                        return 66;
                    }
                    if (!this.lookingAt("declare", "oundary-space")) break;
                    this.curToken = 83;
                    return 83;
                }
                case 99: {
                    if (this.lookingAt("declare", "onstruction")) {
                        this.curToken = 75;
                        return 75;
                    }
                    if (!this.lookingAt("declare", "opy-namespaces")) break;
                    this.curToken = 76;
                    return 76;
                }
                case 100: {
                    if (this.lookingAt("declare", "efault")) {
                        this.getRawToken();
                        if (this.match("function")) {
                            this.curToken = 79;
                            return 79;
                        }
                        if (this.match("element")) {
                            this.curToken = 69;
                            return 69;
                        }
                        if (this.match("collation")) {
                            this.curToken = 71;
                            return 71;
                        }
                        if (this.match("order")) {
                            this.curToken = 72;
                            return 72;
                        }
                        this.error("unrecognized/unimplemented 'declare default'");
                        this.skipToSemicolon();
                        return this.peekOperand();
                    }
                }
                case 101: {
                    if (!this.lookingAt("default", "lement")) break;
                    this.warnOldVersion("replace 'default element' by 'declare default element namespace'");
                    this.curToken = 69;
                    return 69;
                }
                case 102: {
                    if (this.lookingAt("declare", "unction")) {
                        this.curToken = 80;
                        return 80;
                    }
                    if (this.lookingAt("define", "unction")) {
                        this.warnOldVersion("replace 'define function' by 'declare function'");
                        this.curToken = 80;
                        return 80;
                    }
                    if (!this.lookingAt("default", "unction")) break;
                    this.warnOldVersion("replace 'default function' by 'declare default function namespace'");
                    this.curToken = 79;
                    return 79;
                }
                case 109: {
                    if (!this.lookingAt("import", "odule")) break;
                    this.curToken = 73;
                    return 73;
                }
                case 110: {
                    if (this.lookingAt("declare", "amespace")) {
                        this.curToken = 78;
                        return 78;
                    }
                    if (this.lookingAt("default", "amespace")) {
                        this.warnOldVersion("replace 'default namespace' by 'declare default element namespace'");
                        this.curToken = 69;
                        return 69;
                    }
                    if (!this.lookingAt("module", "amespace")) break;
                    this.curToken = 77;
                    return 77;
                }
                case 111: {
                    if (this.lookingAt("declare", "rdering")) {
                        this.curToken = 85;
                        return 85;
                    }
                    if (!this.lookingAt("declare", "ption")) break;
                    this.curToken = 111;
                    return 111;
                }
                case 115: {
                    if (!this.lookingAt("import", "chema")) break;
                    this.curToken = 84;
                    return 84;
                }
                case 118: {
                    if (this.lookingAt("declare", "ariable")) {
                        this.curToken = 86;
                        return 86;
                    }
                    if (this.lookingAt("define", "ariable")) {
                        this.warnOldVersion("replace 'define variable' by 'declare variable'");
                        this.curToken = 86;
                        return 86;
                    }
                    if (!this.lookingAt("xquery", "ersion")) break;
                    this.curToken = 89;
                    return 89;
                }
                case 120: {
                    if (!this.lookingAt("declare", "mlspace")) break;
                    this.warnOldVersion("replace 'define xmlspace' by 'declare boundary-space'");
                    this.curToken = 83;
                    return 83;
                }
            }
            if (n >= 0) {
                this.unread();
                if (XName.isNameStart((char)n) && this.curValue.equals("define")) {
                    this.getRawToken();
                    this.curToken = 87;
                }
            }
            return this.curToken;
        }
        if (this.curToken == 67) {
            int n = this.read();
            if (n == 58) {
                this.curToken = this.getAxis();
            } else {
                this.unread(n);
            }
        }
        return this.curToken;
    }

    void checkAllowedNamespaceDeclaration(String string, String string2, boolean bl) {
        boolean bl2 = "xml".equals(string);
        if ("http://www.w3.org/XML/1998/namespace".equals(string2)) {
            if (!bl2 || !bl) {
                this.error('e', "namespace uri cannot be the same as the prefined xml namespace", "XQST0070");
            }
        } else if (bl2 || "xmlns".equals(string)) {
            this.error('e', "namespace prefix cannot be 'xml' or 'xmlns'", "XQST0070");
        }
    }

    void pushNamespace(String string, String string2) {
        if (string2.length() == 0) {
            string2 = null;
        }
        this.prologNamespaces = new NamespaceBinding(string, string2, this.prologNamespaces);
    }

    public XQParser(InPort inPort, SourceMessages sourceMessages, XQuery xQuery) {
        super(inPort, sourceMessages);
        NamespaceBinding namespaceBinding;
        this.interpreter = xQuery;
        this.nesting = 1;
        this.prologNamespaces = namespaceBinding = builtinNamespaces;
    }

    public void setInteractive(boolean bl) {
        if (this.interactive != bl) {
            this.nesting = bl ? --this.nesting : ++this.nesting;
        }
        this.interactive = bl;
    }

    private static final int priority(int n) {
        switch (n) {
            case 400: {
                return 1;
            }
            case 401: {
                return 2;
            }
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 426: 
            case 427: 
            case 428: 
            case 429: 
            case 430: 
            case 431: {
                return 3;
            }
            case 412: {
                return 4;
            }
            case 413: 
            case 414: {
                return 5;
            }
            case 415: 
            case 416: 
            case 417: 
            case 418: {
                return 6;
            }
            case 419: {
                return 7;
            }
            case 420: 
            case 421: {
                return 8;
            }
            case 422: {
                return 9;
            }
            case 423: {
                return 10;
            }
            case 424: {
                return 11;
            }
            case 425: {
                return 12;
            }
        }
        return 0;
    }

    static Expression makeBinary(Expression expression, Expression expression2, Expression expression3) {
        Expression[] expressionArray = new Expression[]{expression2, expression3};
        return new ApplyExp(expression, expressionArray);
    }

    static Expression makeExprSequence(Expression expression, Expression expression2) {
        return XQParser.makeBinary(XQParser.makeFunctionExp("gnu.kawa.functions.AppendValues", "appendValues"), expression, expression2);
    }

    Expression makeBinary(int n, Expression expression, Expression expression2) throws IOException, SyntaxException {
        Expression expression3;
        switch (n) {
            case 413: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "add", "+");
                break;
            }
            case 414: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "sub", "-");
                break;
            }
            case 415: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "mul", "*");
                break;
            }
            case 416: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "div", "div");
                break;
            }
            case 417: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "idiv", "idiv");
                break;
            }
            case 418: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", "mod", "mod");
                break;
            }
            case 426: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valEq", "eq");
                break;
            }
            case 427: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valNe", "ne");
                break;
            }
            case 428: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valLt", "lt");
                break;
            }
            case 429: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valLe", "le");
                break;
            }
            case 430: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valGt", "gt");
                break;
            }
            case 431: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "valGe", "ge");
                break;
            }
            case 402: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "=");
                break;
            }
            case 403: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "!=");
                break;
            }
            case 404: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<");
                break;
            }
            case 406: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", "<=");
                break;
            }
            case 405: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">");
                break;
            }
            case 407: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.Compare", ">=");
                break;
            }
            case 408: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Eq", "is");
                break;
            }
            case 409: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ne", "isnot");
                break;
            }
            case 410: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Gr", ">>");
                break;
            }
            case 411: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.NodeCompare", "$Ls", "<<");
                break;
            }
            case 412: {
                expression3 = XQParser.makeFunctionExp("gnu.xquery.util.IntegerRange", "integerRange");
                break;
            }
            case 419: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.UnionNodes", "unionNodes");
                break;
            }
            case 420: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "intersectNodes");
                break;
            }
            case 421: {
                expression3 = XQParser.makeFunctionExp("gnu.kawa.xml.IntersectNodes", "exceptNodes");
                break;
            }
            default: {
                return this.syntaxError("unimplemented binary op: " + n);
            }
        }
        return XQParser.makeBinary(expression3, expression, expression2);
    }

    private void parseSimpleKindType() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken == 41) {
            this.getRawToken();
        } else {
            this.error("expected ')'");
        }
    }

    public Expression parseNamedNodeType(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        Expression expression2 = null;
        this.getRawToken();
        if (this.curToken == 41) {
            expression = QuoteExp.getInstance(ElementType.MATCH_ANY_QNAME);
            this.getRawToken();
        } else {
            if (this.curToken == 81 || this.curToken == 65) {
                expression = this.parseNameTest(bl);
            } else {
                if (this.curToken != 415) {
                    this.syntaxError("expected QName or *");
                }
                expression = QuoteExp.getInstance(ElementType.MATCH_ANY_QNAME);
            }
            this.getRawToken();
            if (this.curToken == 44) {
                this.getRawToken();
                if (this.curToken == 81 || this.curToken == 65) {
                    expression2 = this.parseDataType();
                } else {
                    this.syntaxError("expected QName");
                }
            }
            if (this.curToken == 41) {
                this.getRawToken();
            } else {
                this.error("expected ')' after element");
            }
        }
        return XQParser.makeNamedNodeType(bl, expression, expression2);
    }

    static Expression makeNamedNodeType(boolean bl, Expression expression, Expression expression2) {
        Expression[] expressionArray = new Expression[2];
        ClassType classType = ClassType.make(bl ? "gnu.kawa.xml.AttributeType" : "gnu.kawa.xml.ElementType");
        ApplyExp applyExp = new ApplyExp(classType.getDeclaredMethod("make", 1), new Expression[]{expression});
        applyExp.setFlag(2);
        if (expression2 == null) {
            return applyExp;
        }
        return new BeginExp(expression2, applyExp);
    }

    private void warnOldStyleKindTest() {
        if (this.warnedOldStyleKindTest) {
            return;
        }
        this.error('w', "old-style KindTest - first one here");
        this.warnedOldStyleKindTest = true;
    }

    public Expression parseOptionalTypeDeclaration() throws IOException, SyntaxException {
        if (!this.match("as")) {
            return null;
        }
        this.getRawToken();
        return this.parseDataType();
    }

    public Expression parseDataType() throws IOException, SyntaxException {
        int n;
        int n2;
        Expression expression = this.parseItemType();
        if (expression == null) {
            if (this.curToken != 238) {
                return this.syntaxError("bad syntax - expected DataType");
            }
            this.parseSimpleKindType();
            if (this.curToken == 63 || this.curToken == 413 || this.curToken == 415) {
                this.getRawToken();
                return this.syntaxError("occurrence-indicator meaningless after empty-sequence()");
            }
            expression = QuoteExp.getInstance(OccurrenceType.emptySequenceType);
            n2 = 0;
            n = 0;
        } else if (this.curToken == 63) {
            n2 = 0;
            n = 1;
        } else if (this.curToken == 413) {
            n2 = 1;
            n = -1;
        } else if (this.curToken == 415) {
            n2 = 0;
            n = -1;
        } else {
            n2 = 1;
            n = 1;
        }
        if (this.parseContext == 67 && n != 1) {
            return this.syntaxError("type to 'cast as' or 'castable as' must be a 'SingleType'");
        }
        if (n2 != n) {
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, QuoteExp.getInstance(IntNum.make(n2)), QuoteExp.getInstance(IntNum.make(n))};
            ApplyExp applyExp = new ApplyExp(proc_OccurrenceType_getInstance, expressionArray);
            applyExp.setFlag(2);
            return applyExp;
        }
        return expression;
    }

    public Expression parseMaybeKindTest() throws IOException, SyntaxException {
        NodeType nodeType;
        switch (this.curToken) {
            case 235: 
            case 236: {
                return this.parseNamedNodeType(this.curToken == 236);
            }
            case 231: {
                this.parseSimpleKindType();
                nodeType = NodeType.textNodeTest;
                break;
            }
            case 232: {
                this.parseSimpleKindType();
                nodeType = NodeType.commentNodeTest;
                break;
            }
            case 234: {
                this.parseSimpleKindType();
                nodeType = NodeType.documentNodeTest;
                break;
            }
            case 230: {
                this.parseSimpleKindType();
                nodeType = NodeType.anyNodeTest;
                break;
            }
            case 233: {
                this.getRawToken();
                String string = null;
                if (this.curToken == 65 || this.curToken == 34) {
                    string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                }
                if (this.curToken == 41) {
                    this.getRawToken();
                } else {
                    this.error("expected ')'");
                }
                nodeType = ProcessingInstructionType.getInstance(string);
                break;
            }
            default: {
                return null;
            }
        }
        return QuoteExp.getInstance(nodeType);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression parseItemType() throws IOException, SyntaxException {
        void var2_4;
        this.peekOperand();
        Expression expression = this.parseMaybeKindTest();
        if (expression != null) {
            if (this.parseContext != 67) return expression;
            XDataType xDataType = XDataType.anyAtomicType;
            return QuoteExp.getInstance(var2_4);
        } else if (this.curToken == 237) {
            this.parseSimpleKindType();
            SingletonType singletonType = SingletonType.getInstance();
            return QuoteExp.getInstance(var2_4);
        } else {
            if (this.curToken != 65 && this.curToken != 81) return null;
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            ReferenceExp referenceExp = new ReferenceExp((Object)string);
            referenceExp.setFlag(16);
            this.maybeSetLine(referenceExp, this.curLine, this.curColumn);
            this.getRawToken();
            return referenceExp;
        }
    }

    Object parseURILiteral() throws IOException, SyntaxException {
        this.getRawToken();
        if (this.curToken != 34) {
            return this.declError("expected a URILiteral");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        string = TextUtils.replaceWhitespace(string, true);
        return string;
    }

    Expression parseExpr() throws IOException, SyntaxException {
        return this.parseExprSingle();
    }

    final Expression parseExprSingle() throws IOException, SyntaxException {
        int n = this.curLine;
        int n2 = this.curColumn;
        this.peekOperand();
        switch (this.curToken) {
            case 241: {
                return this.parseIfExpr();
            }
            case 242: {
                return this.parseTypeSwitch();
            }
            case 243: {
                return this.parseFLWRExpression(true);
            }
            case 244: {
                return this.parseFLWRExpression(false);
            }
            case 245: {
                return this.parseQuantifiedExpr(false);
            }
            case 246: {
                return this.parseQuantifiedExpr(true);
            }
        }
        return this.parseBinaryExpr(XQParser.priority(400));
    }

    Expression parseBinaryExpr(int n) throws IOException, SyntaxException {
        Expression expression = this.parseUnaryExpr();
        int n2;
        while ((n2 = this.peekOperator()) != 10 && (n2 != 404 || this.peek() != 47)) {
            Expression[] expressionArray;
            int n3 = XQParser.priority(n2);
            if (n3 < n) {
                return expression;
            }
            char c = this.pushNesting('%');
            this.getRawToken();
            this.popNesting(c);
            if (n2 >= 422 && n2 <= 425) {
                Expression expression2;
                if (n2 == 425 || n2 == 424) {
                    this.parseContext = 67;
                }
                expressionArray = this.parseDataType();
                this.parseContext = 0;
                Expression[] expressionArray2 = new Expression[2];
                switch (n2) {
                    case 422: {
                        expressionArray2[0] = expression;
                        expressionArray2[1] = expressionArray;
                        expression2 = XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf");
                        break;
                    }
                    case 424: {
                        expressionArray2[0] = expression;
                        expressionArray2[1] = expressionArray;
                        expression2 = new ReferenceExp(XQResolveNames.castableAsDecl);
                        break;
                    }
                    case 423: {
                        expressionArray2[0] = expressionArray;
                        expressionArray2[1] = expression;
                        expression2 = XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "treatAs");
                        break;
                    }
                    default: {
                        expressionArray2[0] = expressionArray;
                        expressionArray2[1] = expression;
                        expression2 = new ReferenceExp(XQResolveNames.castAsDecl);
                    }
                }
                expression = new ApplyExp(expression2, expressionArray2);
                continue;
            }
            if (n2 == 422) {
                expressionArray = new Expression[]{expression, this.parseDataType()};
                expression = new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.lang.XQParser", "instanceOf"), expressionArray);
                continue;
            }
            expressionArray = this.parseBinaryExpr(n3 + 1);
            if (n2 == 401) {
                expression = new IfExp(XQParser.booleanValue(expression), XQParser.booleanValue((Expression)expressionArray), XQuery.falseExp);
                continue;
            }
            if (n2 == 400) {
                expression = new IfExp(XQParser.booleanValue(expression), XQuery.trueExp, XQParser.booleanValue((Expression)expressionArray));
                continue;
            }
            expression = this.makeBinary(n2, expression, (Expression)expressionArray);
        }
        return expression;
    }

    Expression parseUnaryExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 414 || this.curToken == 413) {
            int n = this.curToken;
            this.getRawToken();
            expression = this.parseUnaryExpr();
            Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.ArithOp", n == 413 ? "plus" : "minus", n == 413 ? "+" : "-");
            expression = new ApplyExp(expression2, new Expression[]{expression});
        } else {
            expression = this.parseUnionExpr();
        }
        return expression;
    }

    Expression parseUnionExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parseIntersectExceptExpr();
        while ((n = this.peekOperator()) == 419) {
            this.getRawToken();
            Expression expression2 = this.parseIntersectExceptExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parseIntersectExceptExpr() throws IOException, SyntaxException {
        int n;
        Expression expression = this.parsePathExpr();
        while ((n = this.peekOperator()) == 420 || n == 421) {
            this.getRawToken();
            Expression expression2 = this.parsePathExpr();
            expression = this.makeBinary(n, expression, expression2);
        }
        return expression;
    }

    Expression parsePathExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 47 || this.curToken == 68) {
            Declaration declaration = this.comp.lexical.lookup((Object)DOT_VARNAME, false);
            Expression expression2 = declaration == null ? this.syntaxError("context item is undefined", "XPDY0002") : new ReferenceExp(DOT_VARNAME, declaration);
            expression = new ApplyExp(ClassType.make("gnu.xquery.util.NodeUtils").getDeclaredMethod("rootDocument", 1), new Expression[]{expression2});
            int n = this.skipSpace(this.nesting != 0);
            this.unread(n);
            if (n < 0 || n == 41 || n == 125) {
                this.getRawToken();
                return expression;
            }
        } else {
            expression = this.parseStepExpr();
        }
        return this.parseRelativePathExpr(expression);
    }

    Expression parseNameTest(boolean bl) throws IOException, SyntaxException {
        int n;
        String string = null;
        String string2 = null;
        if (this.curToken == 81) {
            n = this.tokenBufferLength;
            while (this.tokenBuffer[--n] != ':') {
            }
            string2 = new String(this.tokenBuffer, 0, n);
            string = new String(this.tokenBuffer, ++n, this.tokenBufferLength - n);
        } else {
            if (this.curToken == 415) {
                int n2 = this.read();
                string = "";
                if (n2 != 58) {
                    this.unread(n2);
                } else {
                    n2 = this.read();
                    if (n2 < 0) {
                        this.eofError("unexpected end-of-file after '*:'");
                    }
                    if (XName.isNameStart((char)n2)) {
                        this.unread();
                        this.getRawToken();
                        if (this.curToken != 65) {
                            this.syntaxError("invalid name test");
                        } else {
                            string = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                        }
                    } else if (n2 != 42) {
                        this.syntaxError("missing local-name after '*:'");
                    }
                }
                return QuoteExp.getInstance(new Symbol(null, string));
            }
            if (this.curToken == 65) {
                string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (bl) {
                    return new QuoteExp(Namespace.EmptyNamespace.getSymbol(string.intern()));
                }
                string2 = null;
            } else if (this.curToken == 67) {
                string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                n = this.read();
                if (n != 42) {
                    this.syntaxError("invalid characters after 'NCName:'");
                }
                string = "";
            }
        }
        if (string2 != null) {
            string2 = string2.intern();
        }
        Expression[] expressionArray = new Expression[]{new ApplyExp(new ReferenceExp(XQResolveNames.resolvePrefixDecl), new Expression[]{QuoteExp.getInstance(string2)}), new QuoteExp((Object)(string == null ? "" : string)), new QuoteExp((Object)string2)};
        ApplyExp applyExp = new ApplyExp(Compilation.typeSymbol.getDeclaredMethod("make", 3), expressionArray);
        applyExp.setFlag(2);
        return applyExp;
    }

    Expression parseNodeTest(int n) throws IOException, SyntaxException {
        Object object2;
        QuoteExp quoteExp;
        int n2 = this.peekOperand();
        Expression[] expressionArray = new Expression[1];
        Expression expression = this.parseMaybeKindTest();
        if (expression != null) {
            expressionArray[0] = expression;
        } else if (this.curToken == 65 || this.curToken == 81 || this.curToken == 67 || this.curToken == 415) {
            expressionArray[0] = XQParser.makeNamedNodeType(n == 2, this.parseNameTest(n == 2), null);
        } else {
            if (n >= 0) {
                return this.syntaxError("unsupported axis '" + axisNames[n] + "::'");
            }
            return null;
        }
        Declaration declaration = this.comp.lexical.lookup((Object)DOT_VARNAME, false);
        Expression expression2 = declaration == null ? this.syntaxError("node test when context item is undefined", "XPDY0002") : new ReferenceExp(DOT_VARNAME, declaration);
        if (expression == null) {
            this.getRawToken();
        }
        if (n == 3 || n == -1) {
            quoteExp = makeChildAxisStep;
        } else if (n == 4) {
            quoteExp = makeDescendantAxisStep;
        } else {
            switch (n) {
                case 5: {
                    object2 = "DescendantOrSelf";
                    break;
                }
                case 12: {
                    object2 = "Self";
                    break;
                }
                case 9: {
                    object2 = "Parent";
                    break;
                }
                case 0: {
                    object2 = "Ancestor";
                    break;
                }
                case 1: {
                    object2 = "AncestorOrSelf";
                    break;
                }
                case 6: {
                    object2 = "Following";
                    break;
                }
                case 7: {
                    object2 = "FollowingSibling";
                    break;
                }
                case 10: {
                    object2 = "Preceding";
                    break;
                }
                case 11: {
                    object2 = "PrecedingSibling";
                    break;
                }
                case 2: {
                    object2 = "Attribute";
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            quoteExp = QuoteExp.getInstance(new PrimProcedure("gnu.kawa.xml." + (String)object2 + "Axis", "make", 1));
        }
        object2 = new ApplyExp(quoteExp, expressionArray);
        ((Expression)object2).setFlag(2);
        return new ApplyExp((Expression)object2, new Expression[]{expression2});
    }

    Expression parseRelativePathExpr(Expression expression) throws IOException, SyntaxException {
        Expression expression2 = null;
        while (this.curToken == 47 || this.curToken == 68) {
            Procedure procedure;
            Expression[] expressionArray;
            Expression[] expressionArray2;
            boolean bl = this.curToken == 68;
            LambdaExp lambdaExp = new LambdaExp(3);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            declaration.setFlag(262144);
            declaration.setType(NodeType.anyNodeTest);
            declaration.noteValue(null);
            lambdaExp.addDeclaration(POSITION_VARNAME, LangPrimType.intType);
            lambdaExp.addDeclaration(LAST_VARNAME, LangPrimType.intType);
            this.comp.push(lambdaExp);
            if (bl) {
                this.curToken = 47;
                expressionArray2 = new ReferenceExp(DOT_VARNAME, declaration);
                expressionArray = new Expression[]{expressionArray2};
                procedure = DescendantOrSelfAxis.anyNode;
                lambdaExp.body = new ApplyExp(procedure, expressionArray);
                expression2 = expression;
            } else {
                this.getRawToken();
                expressionArray2 = this.parseStepExpr();
                if (expression2 != null && expressionArray2 instanceof ApplyExp && (expressionArray = ((ApplyExp)expressionArray2).getFunction()) instanceof ApplyExp && ((ApplyExp)(procedure = (ApplyExp)expressionArray)).getFunction() == makeChildAxisStep) {
                    ((ApplyExp)procedure).setFunction(makeDescendantAxisStep);
                    expression = expression2;
                }
                lambdaExp.body = expressionArray2;
                expression2 = null;
            }
            this.comp.pop(lambdaExp);
            expressionArray2 = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(RelativeStep.relativeStep, expressionArray2);
        }
        return expression;
    }

    Expression parseStepExpr() throws IOException, SyntaxException {
        Expression expression;
        if (this.curToken == 46 || this.curToken == 51) {
            int n = this.curToken == 46 ? 12 : 9;
            this.getRawToken();
            Declaration declaration = this.comp.lexical.lookup((Object)DOT_VARNAME, false);
            Expression expression2 = declaration == null ? this.syntaxError("context item is undefined", "XPDY0002") : new ReferenceExp(DOT_VARNAME, declaration);
            if (n == 9) {
                Expression[] expressionArray = new Expression[]{expression2};
                expression2 = new ApplyExp(ParentAxis.make(NodeType.anyNodeTest), expressionArray);
            }
            return this.parseStepQualifiers(expression2, n == 12 ? -1 : n);
        }
        int n = this.peekOperand() - 100;
        if (n >= 0 && n < 13) {
            this.getRawToken();
            expression = this.parseNodeTest(n);
        } else if (this.curToken == 64) {
            this.getRawToken();
            n = 2;
            expression = this.parseNodeTest(n);
        } else if (this.curToken == 236) {
            n = 2;
            expression = this.parseNodeTest(n);
        } else {
            expression = this.parseNodeTest(-1);
            if (expression != null) {
                n = 3;
            } else {
                n = -1;
                expression = this.parsePrimaryExpr();
            }
        }
        return this.parseStepQualifiers(expression, n);
    }

    Expression parseStepQualifiers(Expression expression, int n) throws IOException, SyntaxException {
        while (this.curToken == 91) {
            ValuesFilter valuesFilter;
            int n2;
            int n3 = this.getLineNumber() + 1;
            int n4 = this.getColumnNumber() + 1;
            int n5 = this.seenPosition;
            int n6 = this.seenLast;
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(3);
            this.maybeSetLine(lambdaExp, n3, n4);
            Declaration declaration = lambdaExp.addDeclaration(DOT_VARNAME);
            if (n >= 0) {
                declaration.setType(NodeType.anyNodeTest);
            } else {
                declaration.setType(SingletonType.getInstance());
            }
            lambdaExp.addDeclaration(POSITION_VARNAME, Type.intType);
            lambdaExp.addDeclaration(LAST_VARNAME, Type.intType);
            this.comp.push(lambdaExp);
            declaration.noteValue(null);
            Expression expression2 = this.parseExprSequence(93, false);
            if (this.curToken == -1) {
                this.eofError("missing ']' - unexpected end-of-file");
            }
            if (n < 0) {
                n2 = 80;
                valuesFilter = ValuesFilter.exprFilter;
            } else if (n == 0 || n == 1 || n == 9 || n == 10 || n == 11) {
                n2 = 82;
                valuesFilter = ValuesFilter.reverseFilter;
            } else {
                n2 = 70;
                valuesFilter = ValuesFilter.forwardFilter;
            }
            this.maybeSetLine(expression2, n3, n4);
            this.comp.pop(lambdaExp);
            lambdaExp.body = expression2;
            this.getRawToken();
            Expression[] expressionArray = new Expression[]{expression, lambdaExp};
            expression = new ApplyExp(valuesFilter, expressionArray);
        }
        return expression;
    }

    Expression parsePrimaryExpr() throws IOException, SyntaxException {
        Expression expression = this.parseMaybePrimaryExpr();
        if (expression == null) {
            expression = this.syntaxError("missing expression");
            if (this.curToken != -1) {
                this.getRawToken();
            }
            return expression;
        }
        return expression;
    }

    void parseEntityOrCharRef() throws IOException, SyntaxException {
        int n = this.read();
        if (n == 35) {
            int n2;
            char c;
            int n3;
            int n4;
            n = this.read();
            if (n == 120) {
                n4 = 16;
                n = this.read();
            } else {
                n4 = 10;
            }
            for (n2 = 0; n >= 0 && (n3 = Character.digit(c = (char)n, n4)) >= 0 && n2 < 0x8000000; n2 += n3) {
                n2 *= n4;
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid character reference");
            } else if (n2 > 0 && n2 <= 55295 || n2 >= 57344 && n2 <= 65533 || n2 >= 65536 && n2 <= 0x10FFFF) {
                this.tokenBufferAppend(n2);
            } else {
                this.error('e', "invalid character value " + n2, "XQST0090");
            }
        } else {
            char c;
            int n5 = this.tokenBufferLength;
            while (n >= 0 && XName.isNamePart(c = (char)n)) {
                this.tokenBufferAppend(c);
                n = this.read();
            }
            if (n != 59) {
                this.unread();
                this.error("invalid entity reference");
                return;
            }
            String string = new String(this.tokenBuffer, n5, this.tokenBufferLength - n5);
            this.tokenBufferLength = n5;
            this.appendNamedEntity(string);
        }
    }

    void parseContent(char c, Vector vector) throws IOException, SyntaxException {
        boolean bl;
        this.tokenBufferLength = 0;
        int n = vector.size();
        int n2 = n - 1;
        boolean bl2 = bl = !this.boundarySpacePreserve && c == '<';
        while (true) {
            int n3;
            block20: {
                int n4;
                Object object2;
                block23: {
                    block22: {
                        block21: {
                            if ((n3 = this.read()) == c) {
                                if (c == '<') {
                                    ApplyExp applyExp;
                                    n3 = this.read();
                                    ApplyExp applyExp2 = null;
                                    if (this.tokenBufferLength > 0) {
                                        object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                                        Expression[] expressionArray = new Expression[]{new QuoteExp(object2)};
                                        applyExp2 = new ApplyExp(makeText, expressionArray);
                                    }
                                    this.tokenBufferLength = 0;
                                    if (n3 == 47) {
                                        if (applyExp2 == null || bl2) break;
                                        vector.addElement(applyExp2);
                                        break;
                                    }
                                    object2 = this.parseXMLConstructor(n3, true);
                                    boolean bl3 = false;
                                    boolean bl4 = false;
                                    if (object2 instanceof ApplyExp && (applyExp = (ApplyExp)object2).getFunction() == makeCDATA) {
                                        bl3 = true;
                                        String string = (String)applyExp.getArg(0).valueIfConstant();
                                        boolean bl5 = bl4 = string != null && string.length() == 0;
                                    }
                                    if (applyExp2 != null && (!bl2 || bl3)) {
                                        vector.addElement(applyExp2);
                                    }
                                    bl2 = bl3 ? false : bl;
                                    if (!bl4) {
                                        vector.addElement(object2);
                                    }
                                    this.tokenBufferLength = 0;
                                    continue;
                                }
                                if (this.checkNext(c)) {
                                    this.tokenBufferAppend(c);
                                    continue;
                                }
                            }
                            if (n3 != c && n3 >= 0 && n3 != 123) break block20;
                            int n5 = n4 = n3 == 123 ? this.read() : -1;
                            if (n4 == 123) {
                                this.tokenBufferAppend(123);
                                bl2 = false;
                                continue;
                            }
                            if (this.tokenBufferLength <= 0 || bl2) break block21;
                            object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                            break block22;
                        }
                        if (n3 != 123 || n2 != vector.size()) break block23;
                        object2 = "";
                    }
                    Expression[] expressionArray = new Expression[]{new QuoteExp(object2)};
                    vector.addElement(new ApplyExp(makeText, expressionArray));
                }
                this.tokenBufferLength = 0;
                if (n3 == c) break;
                if (n3 < 0) {
                    this.eofError("unexpected end-of-file");
                    continue;
                }
                this.unread(n4);
                ++this.enclosedExpressionsSeen;
                object2 = this.parseEnclosedExpr();
                vector.addElement(object2);
                this.tokenBufferLength = 0;
                n2 = vector.size();
                bl2 = bl;
                continue;
            }
            if (n3 == 125) {
                n3 = this.read();
                if (n3 == 125) {
                    this.tokenBufferAppend(125);
                    bl2 = false;
                    continue;
                }
                this.error("unexpected '}' in element content");
                this.unread(n3);
                continue;
            }
            if (n3 == 38) {
                this.parseEntityOrCharRef();
                bl2 = false;
                continue;
            }
            if (c != '<' && (n3 == 9 || n3 == 10 || n3 == 13)) {
                n3 = 32;
            }
            if (n3 == 60) {
                this.error('e', "'<' must be quoted in a direct attribute value");
            }
            if (bl2) {
                bl2 = Character.isWhitespace((char)n3);
            }
            this.tokenBufferAppend((char)n3);
        }
    }

    Expression parseEnclosedExpr() throws IOException, SyntaxException {
        String string = this.errorIfComment;
        this.errorIfComment = null;
        char c = this.pushNesting('{');
        this.peekNonSpace("unexpected end-of-file after '{'");
        int n = this.getLineNumber() + 1;
        int n2 = this.getColumnNumber() + 1;
        this.getRawToken();
        Expression expression = this.parseExpr();
        while (this.curToken != 125) {
            if (this.curToken == -1 || this.curToken == 41 || this.curToken == 93) {
                expression = this.syntaxError("missing '}'");
                break;
            }
            if (this.curToken != 44) {
                expression = this.syntaxError("missing '}' or ','");
            } else {
                this.getRawToken();
            }
            expression = XQParser.makeExprSequence(expression, this.parseExpr());
        }
        this.maybeSetLine(expression, n, n2);
        this.popNesting(c);
        this.errorIfComment = string;
        return expression;
    }

    public static Expression booleanValue(Expression expression) {
        Expression[] expressionArray = new Expression[]{expression};
        Expression expression2 = XQParser.makeFunctionExp("gnu.xquery.util.BooleanValue", "booleanValue");
        return new ApplyExp(expression2, expressionArray);
    }

    Expression parseXMLConstructor(int n, boolean bl) throws IOException, SyntaxException {
        Expression expression;
        if (n == 33) {
            n = this.read();
            if (n == 45 && this.peek() == 45) {
                this.skip();
                this.getDelimited("-->");
                boolean bl2 = false;
                int n2 = this.tokenBufferLength;
                boolean bl3 = true;
                while (--n2 >= 0) {
                    boolean bl4;
                    boolean bl5 = bl4 = this.tokenBuffer[n2] == '-';
                    if (bl3 && bl4) {
                        bl2 = true;
                        break;
                    }
                    bl3 = bl4;
                }
                if (bl2) {
                    expression = this.syntaxError("consecutive or final hyphen in XML comment");
                } else {
                    Expression[] expressionArray = new Expression[]{new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength))};
                    expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.CommentConstructor", "commentConstructor"), expressionArray);
                }
            } else if (n == 91 && this.read() == 67 && this.read() == 68 && this.read() == 65 && this.read() == 84 && this.read() == 65 && this.read() == 91) {
                if (!bl) {
                    this.error('e', "CDATA section must be in element content");
                }
                this.getDelimited("]]>");
                Expression[] expressionArray = new Expression[]{new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength))};
                expression = new ApplyExp(makeCDATA, expressionArray);
            } else {
                expression = this.syntaxError("'<!' must be followed by '--' or '[CDATA['");
            }
        } else if (n == 63) {
            int n3;
            n = this.peek();
            if (n < 0 || !XName.isNameStart((char)n) || this.getRawToken() != 65) {
                this.syntaxError("missing target after '<?'");
            }
            String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n4 = 0;
            while ((n3 = this.read()) >= 0) {
                if (!Character.isWhitespace((char)n3)) {
                    this.unread();
                    break;
                }
                ++n4;
            }
            this.getDelimited("?>");
            if (n4 == 0 && this.tokenBufferLength > 0) {
                this.syntaxError("target must be followed by space or '?>'");
            }
            String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            Expression[] expressionArray = new Expression[]{new QuoteExp((Object)string), new QuoteExp((Object)string2)};
            expression = new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.xml.MakeProcInst", "makeProcInst"), expressionArray);
        } else if (n < 0 || !XName.isNameStart((char)n)) {
            expression = this.syntaxError("expected QName after '<'");
        } else {
            this.unread(n);
            this.getRawToken();
            char c = this.pushNesting('<');
            expression = this.parseElementConstructor();
            if (!bl) {
                expression = this.wrapWithBaseUri(expression);
            }
            this.popNesting(c);
        }
        return expression;
    }

    static ApplyExp castQName(Expression expression, boolean bl) {
        Declaration declaration = bl ? XQResolveNames.xsQNameDecl : XQResolveNames.xsQNameIgnoreDefaultDecl;
        return new ApplyExp(new ReferenceExp(declaration), new Expression[]{expression});
    }

    Expression parseElementConstructor() throws IOException, SyntaxException {
        Object[] objectArray;
        Object object2;
        int n;
        boolean bl;
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(XQParser.castQName(new QuoteExp((Object)string), true));
        this.errorIfComment = "comment not allowed in element start tag";
        NamespaceBinding namespaceBinding = null;
        while (true) {
            Object object3;
            bl = false;
            n = this.read();
            while (n >= 0 && Character.isWhitespace((char)n)) {
                n = this.read();
                bl = true;
            }
            if (n < 0 || n == 62 || n == 47) break;
            if (!bl) {
                this.syntaxError("missing space before attribute");
            }
            this.unread(n);
            this.getRawToken();
            int n2 = vector.size();
            if (this.curToken != 65 && this.curToken != 81) break;
            object2 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
            int n3 = this.getLineNumber() + 1;
            int n4 = this.getColumnNumber() + 1 - this.tokenBufferLength;
            String string2 = null;
            if (this.curToken == 65) {
                if (((String)object2).equals("xmlns")) {
                    string2 = "";
                }
            } else if (((String)object2).startsWith("xmlns:")) {
                string2 = ((String)object2).substring(6).intern();
            }
            QuoteExp quoteExp = string2 != null ? null : MakeAttribute.makeAttributeExp;
            vector.addElement(XQParser.castQName(new QuoteExp(object2), false));
            n = this.skipSpace();
            if (n != 61) {
                this.errorIfComment = null;
                return this.syntaxError("missing '=' after attribute");
            }
            n = this.skipSpace();
            int n5 = this.enclosedExpressionsSeen;
            if (n == 123) {
                this.warnOldVersion("enclosed attribute value expression should be quoted");
                vector.addElement(this.parseEnclosedExpr());
            } else {
                this.parseContent((char)n, vector);
            }
            int n6 = vector.size() - n2;
            if (string2 != null) {
                Object object4;
                object3 = "";
                if (n6 == 1) {
                    object3 = "";
                } else if (this.enclosedExpressionsSeen > n5) {
                    this.syntaxError("enclosed expression not allowed in namespace declaration");
                } else {
                    ApplyExp applyExp;
                    object4 = vector.elementAt(n2 + 1);
                    if (object4 instanceof ApplyExp && (applyExp = (ApplyExp)object4).getFunction() == makeText) {
                        object4 = applyExp.getArg(0);
                    }
                    object3 = ((QuoteExp)object4).getValue().toString().intern();
                }
                vector.setSize(n2);
                this.checkAllowedNamespaceDeclaration(string2, (String)object3, true);
                if (string2 == "") {
                    string2 = null;
                }
                for (object4 = namespaceBinding; object4 != null; object4 = ((NamespaceBinding)object4).getNext()) {
                    if (((NamespaceBinding)object4).getPrefix() != string2) continue;
                    this.error('e', string2 == null ? "duplicate default namespace declaration" : "duplicate namespace prefix '" + string2 + '\'', "XQST0071");
                    break;
                }
                namespaceBinding = new NamespaceBinding(string2, (String)(object3 == "" ? null : object3), namespaceBinding);
                continue;
            }
            objectArray = new Expression[n6];
            int n7 = n6;
            while (--n7 >= 0) {
                objectArray[n7] = (Expression)vector.elementAt(n2 + n7);
            }
            vector.setSize(n2);
            object3 = new ApplyExp(quoteExp, (Expression[])objectArray);
            this.maybeSetLine((Expression)object3, n3, n4);
            vector.addElement(object3);
        }
        this.errorIfComment = null;
        bl = false;
        if (n == 47) {
            n = this.read();
            if (n == 62) {
                bl = true;
            } else {
                this.unread(n);
            }
        }
        if (!bl) {
            if (n != 62) {
                return this.syntaxError("missing '>' after start element");
            }
            this.parseContent('<', vector);
            n = this.peek();
            if (n >= 0) {
                if (!XName.isNameStart((char)n)) {
                    return this.syntaxError("invalid tag syntax after '</'");
                }
                this.getRawToken();
                String string3 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                if (!string3.equals(string)) {
                    return this.syntaxError("'<" + string + ">' closed by '</" + string3 + ">'");
                }
                this.errorIfComment = "comment not allowed in element end tag";
                n = this.skipSpace();
                this.errorIfComment = null;
            }
            if (n != 62) {
                return this.syntaxError("missing '>' after end element");
            }
        }
        objectArray = new Expression[vector.size()];
        vector.copyInto(objectArray);
        MakeElement makeElement = new MakeElement();
        makeElement.copyNamespacesMode = this.copyNamespacesMode;
        makeElement.setNamespaceNodes(namespaceBinding);
        object2 = new ApplyExp(new QuoteExp(makeElement), (Expression[])objectArray);
        return object2;
    }

    Expression wrapWithBaseUri(Expression expression) {
        if (this.getStaticBaseUri() == null) {
            return expression;
        }
        return new ApplyExp(MakeWithBaseUri.makeWithBaseUri, new Expression[]{new ApplyExp(new ReferenceExp(XQResolveNames.staticBaseUriDecl), Expression.noExpressions), expression}).setLine(expression);
    }

    Expression parseParenExpr() throws IOException, SyntaxException {
        this.getRawToken();
        char c = this.pushNesting('(');
        Expression expression = this.parseExprSequence(41, true);
        this.popNesting(c);
        if (this.curToken == -1) {
            this.eofError("missing ')' - unexpected end-of-file");
        }
        return expression;
    }

    Expression parseExprSequence(int n, boolean bl) throws IOException, SyntaxException {
        if (this.curToken == n || this.curToken == -1) {
            if (!bl) {
                this.syntaxError("missing expression");
            }
            return QuoteExp.voidExp;
        }
        Expression expression = null;
        while (true) {
            Expression expression2 = this.parseExprSingle();
            Expression expression3 = expression = expression == null ? expression2 : XQParser.makeExprSequence(expression, expression2);
            if (this.curToken == n || this.curToken == -1) break;
            if (this.nesting == 0 && this.curToken == 10) {
                return expression;
            }
            if (this.curToken != 44) {
                return this.syntaxError(n == 41 ? "expected ')'" : "confused by syntax error");
            }
            this.getRawToken();
        }
        return expression;
    }

    Expression parseTypeSwitch() throws IOException, SyntaxException {
        Expression expression;
        Object object2;
        Declaration declaration;
        char c = this.pushNesting('t');
        Expression expression2 = this.parseParenExpr();
        this.getRawToken();
        Object var3_3 = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(expression2);
        while (this.match("case")) {
            this.pushNesting('c');
            this.getRawToken();
            if (this.curToken == 36) {
                declaration = this.parseVariableDeclaration();
                if (declaration == null) {
                    return this.syntaxError("missing Variable after '$'");
                }
                this.getRawToken();
                if (this.match("as")) {
                    this.getRawToken();
                } else {
                    this.error('e', "missing 'as'");
                }
            } else {
                declaration = new Declaration("(arg)");
            }
            declaration.setTypeExp(this.parseDataType());
            this.popNesting('t');
            object2 = new LambdaExp(1);
            ((ScopeExp)object2).addDeclaration(declaration);
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'case'");
            }
            this.comp.push((ScopeExp)object2);
            this.pushNesting('r');
            ((LambdaExp)object2).body = expression = this.parseExpr();
            this.popNesting('t');
            this.comp.pop((ScopeExp)object2);
            vector.addElement(object2);
        }
        if (this.match("default")) {
            object2 = new LambdaExp(1);
            this.getRawToken();
            if (this.curToken == 36) {
                declaration = this.parseVariableDeclaration();
                if (declaration == null) {
                    return this.syntaxError("missing Variable after '$'");
                }
                this.getRawToken();
            } else {
                declaration = new Declaration("(arg)");
            }
            ((ScopeExp)object2).addDeclaration(declaration);
            if (this.match("return")) {
                this.getRawToken();
            } else {
                this.error("missing 'return' after 'default'");
            }
            this.comp.push((ScopeExp)object2);
            ((LambdaExp)object2).body = expression = this.parseExpr();
            this.comp.pop((ScopeExp)object2);
            vector.addElement(object2);
        } else {
            this.error(this.comp.isPedantic() ? (char)'e' : 'w', "no 'default' clause in 'typeswitch'", "XPST0003");
        }
        this.popNesting(c);
        object2 = new Expression[vector.size()];
        vector.copyInto((Object[])object2);
        return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.reflect.TypeSwitch", "typeSwitch"), (Expression[])object2);
    }

    Expression parseMaybePrimaryExpr() throws IOException, SyntaxException {
        Expression expression;
        int n = this.curLine;
        int n2 = this.curColumn;
        int n3 = this.peekOperand();
        switch (n3) {
            case 40: {
                expression = this.parseParenExpr();
                break;
            }
            case 197: {
                Stack<Expression> stack = new Stack<Expression>();
                do {
                    int n4;
                    this.getRawToken();
                    Expression expression2 = this.curToken != 81 && this.curToken != 65 ? this.syntaxError("missing pragma name") : QuoteExp.getInstance(new String(this.tokenBuffer, 0, this.tokenBufferLength));
                    stack.push(expression2);
                    StringBuffer stringBuffer = new StringBuffer();
                    int n5 = -1;
                    do {
                        n4 = this.read();
                        ++n5;
                    } while (n4 >= 0 && Character.isWhitespace((char)n4));
                    while (n4 != 35 || this.peek() != 41) {
                        if (n4 < 0) {
                            this.eofError("pragma ended by end-of-file");
                        }
                        if (n5 == 0) {
                            this.error("missing space between pragma and extension content");
                        }
                        n5 = 1;
                        stringBuffer.append((char)n4);
                        n4 = this.read();
                    }
                    this.read();
                    stack.push(QuoteExp.getInstance(stringBuffer.toString()));
                    this.getRawToken();
                } while (this.curToken == 197);
                if (this.curToken == 123) {
                    this.getRawToken();
                    if (this.curToken != 125) {
                        char c = this.pushNesting('{');
                        stack.push(this.parseExprSequence(125, false));
                        this.popNesting(c);
                        if (this.curToken == -1) {
                            this.eofError("missing '}' - unexpected end-of-file");
                        }
                    }
                    Object[] objectArray = new Expression[stack.size()];
                    stack.copyInto(objectArray);
                    expression = new ApplyExp(new ReferenceExp(XQResolveNames.handleExtensionDecl), (Expression[])objectArray);
                    break;
                }
                expression = this.syntaxError("missing '{' after pragma");
                break;
            }
            case 123: {
                expression = this.syntaxError("saw unexpected '{' - assume you meant '('");
                this.parseEnclosedExpr();
                break;
            }
            case 404: {
                int n6 = this.read();
                if (n6 == 47) {
                    this.getRawToken();
                    String string = this.curToken == 65 || this.curToken == 81 || this.curToken == 67 ? "saw end tag '</" + new String(this.tokenBuffer, 0, this.tokenBufferLength) + ">' not in an element constructor" : "saw end tag '</' not in an element constructor";
                    this.curLine = n;
                    this.curColumn = n2;
                    Expression expression3 = this.syntaxError(string);
                    while (this.curToken != 405 && this.curToken != -1 && this.curToken != 10) {
                        this.getRawToken();
                    }
                    return expression3;
                }
                expression = this.parseXMLConstructor(n6, false);
                this.maybeSetLine(expression, n, n2);
                break;
            }
            case 34: {
                expression = new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength).intern());
                break;
            }
            case 48: {
                expression = new QuoteExp(IntNum.valueOf(this.tokenBuffer, 0, this.tokenBufferLength, 10, false));
                break;
            }
            case 49: 
            case 50: {
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                try {
                    Number number = n3 == 49 ? new BigDecimal(string) : new Double(string);
                    expression = new QuoteExp(number);
                }
                catch (Throwable throwable) {
                    expression = this.syntaxError("invalid decimal literal: '" + string + "'");
                }
                break;
            }
            case 36: {
                Object object2 = this.parseVariable();
                if (object2 == null) {
                    return this.syntaxError("missing Variable");
                }
                expression = new ReferenceExp(object2);
                this.maybeSetLine(expression, this.curLine, this.curColumn);
                break;
            }
            case 70: {
                Expression expression4;
                String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                char c = this.pushNesting('(');
                this.getRawToken();
                Vector<Expression> vector = new Vector<Expression>(10);
                if (this.curToken != 41) {
                    while (true) {
                        expression4 = this.parseExpr();
                        vector.addElement(expression4);
                        if (this.curToken == 41) break;
                        if (this.curToken != 44) {
                            return this.syntaxError("missing ')' after function call");
                        }
                        this.getRawToken();
                    }
                }
                Object[] objectArray = new Expression[vector.size()];
                vector.copyInto(objectArray);
                expression4 = new ReferenceExp(string, null);
                ((ReferenceExp)expression4).setProcedureName(true);
                expression = new ApplyExp(expression4, (Expression[])objectArray);
                this.maybeSetLine(expression, n, n2);
                this.popNesting(c);
                break;
            }
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: {
                Expression expression5;
                Expression expression6;
                this.getRawToken();
                Vector<Expression> vector = new Vector<Expression>();
                if (n3 == 251 || n3 == 252) {
                    if (this.curToken == 65 || this.curToken == 81) {
                        expression6 = this.parseNameTest(n3 != 251);
                    } else if (this.curToken == 123) {
                        expression6 = this.parseEnclosedExpr();
                    } else {
                        return this.syntaxError("missing element/attribute name");
                    }
                    vector.addElement(XQParser.castQName(expression6, n3 == 251));
                    if (n3 == 251) {
                        MakeElement makeElement = new MakeElement();
                        makeElement.copyNamespacesMode = this.copyNamespacesMode;
                        expression5 = new QuoteExp(makeElement);
                    } else {
                        expression5 = MakeAttribute.makeAttributeExp;
                    }
                    this.getRawToken();
                } else if (n3 == 256) {
                    expression5 = XQParser.makeFunctionExp("gnu.kawa.xml.DocumentConstructor", "documentConstructor");
                } else if (n3 == 254) {
                    expression5 = XQParser.makeFunctionExp("gnu.kawa.xml.CommentConstructor", "commentConstructor");
                } else if (n3 == 255) {
                    if (this.curToken == 65) {
                        expression6 = new QuoteExp((Object)new String(this.tokenBuffer, 0, this.tokenBufferLength).intern());
                    } else if (this.curToken == 123) {
                        expression6 = this.parseEnclosedExpr();
                    } else {
                        expression6 = this.syntaxError("expected NCName or '{' after 'processing-instruction'");
                        if (this.curToken != 81) {
                            return expression6;
                        }
                    }
                    vector.addElement(expression6);
                    expression5 = XQParser.makeFunctionExp("gnu.kawa.xml.MakeProcInst", "makeProcInst");
                    this.getRawToken();
                } else {
                    expression5 = XQParser.makeFunctionExp("gnu.kawa.xml.MakeText", "makeText");
                }
                char c = this.pushNesting('{');
                this.peekNonSpace("unexpected end-of-file after '{'");
                if (this.curToken != 123) {
                    return this.syntaxError("missing '{'");
                }
                this.getRawToken();
                if (n3 == 253 || n3 == 254 || n3 == 255) {
                    vector.addElement(this.parseExprSequence(125, n3 == 255));
                } else if (this.curToken != 125) {
                    vector.addElement(this.parseExpr());
                    while (this.curToken == 44) {
                        this.getRawToken();
                        vector.addElement(this.parseExpr());
                    }
                }
                this.popNesting(c);
                if (this.curToken != 125) {
                    return this.syntaxError("missing '}'");
                }
                Object[] objectArray = new Expression[vector.size()];
                vector.copyInto(objectArray);
                expression = new ApplyExp(expression5, (Expression[])objectArray);
                this.maybeSetLine(expression, n, n2);
                if (n3 != 256 && n3 != 251) break;
                expression = this.wrapWithBaseUri(expression);
                break;
            }
            case 249: 
            case 250: {
                this.getRawToken();
                expression = this.parseExprSequence(125, false);
                break;
            }
            default: {
                return null;
            }
        }
        this.getRawToken();
        return expression;
    }

    public Expression parseIfExpr() throws IOException, SyntaxException {
        char c = this.pushNesting('i');
        this.getRawToken();
        char c2 = this.pushNesting('(');
        Expression expression = this.parseExprSequence(41, false);
        this.popNesting(c2);
        if (this.curToken == -1) {
            this.eofError("missing ')' - unexpected end-of-file");
        }
        this.getRawToken();
        if (!this.match("then")) {
            this.syntaxError("missing 'then'");
        } else {
            this.getRawToken();
        }
        Expression expression2 = this.parseExpr();
        if (!this.match("else")) {
            this.syntaxError("missing 'else'");
        } else {
            this.getRawToken();
        }
        this.popNesting(c);
        Expression expression3 = this.parseExpr();
        return new IfExp(XQParser.booleanValue(expression), expression2, expression3);
    }

    public boolean match(String string) {
        if (this.curToken != 65) {
            return false;
        }
        int n = string.length();
        if (this.tokenBufferLength != n) {
            return false;
        }
        int n2 = n;
        while (--n2 >= 0) {
            char c;
            char c2 = string.charAt(n2);
            if (c2 == (c = this.tokenBuffer[n2])) continue;
            return false;
        }
        return true;
    }

    public Object parseVariable() throws IOException, SyntaxException {
        if (this.curToken == 36) {
            this.getRawToken();
        } else {
            this.syntaxError("missing '$' before variable name");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        if (this.curToken == 81) {
            return string;
        }
        if (this.curToken == 65) {
            return Namespace.EmptyNamespace.getSymbol(string.intern());
        }
        return null;
    }

    public Declaration parseVariableDeclaration() throws IOException, SyntaxException {
        Object object2 = this.parseVariable();
        if (object2 == null) {
            return null;
        }
        Declaration declaration = new Declaration(object2);
        this.maybeSetLine(declaration, this.getLineNumber() + 1, this.getColumnNumber() + 1 - this.tokenBufferLength);
        return declaration;
    }

    public Expression parseFLWRExpression(boolean bl) throws IOException, SyntaxException {
        int n = this.flworDeclsFirst;
        this.flworDeclsFirst = this.flworDeclsCount;
        Expression expression = this.parseFLWRInner(bl);
        if (this.match("order")) {
            Expression[] expressionArray;
            int n2;
            this.getRawToken();
            if (this.match("by")) {
                this.getRawToken();
            } else {
                this.error("missing 'by' following 'order'");
            }
            Stack<Object> stack = new Stack<Object>();
            while (true) {
                boolean bl2 = false;
                n2 = this.defaultEmptyOrder;
                expressionArray = new LambdaExp(this.flworDeclsCount - this.flworDeclsFirst);
                for (int i = this.flworDeclsFirst; i < this.flworDeclsCount; ++i) {
                    expressionArray.addDeclaration(this.flworDecls[i].getSymbol());
                }
                this.comp.push((ScopeExp)expressionArray);
                expressionArray.body = this.parseExprSingle();
                this.comp.pop((ScopeExp)expressionArray);
                stack.push(expressionArray);
                if (this.match("ascending")) {
                    this.getRawToken();
                } else if (this.match("descending")) {
                    this.getRawToken();
                    bl2 = true;
                }
                if (this.match("empty")) {
                    this.getRawToken();
                    if (this.match("greatest")) {
                        this.getRawToken();
                        n2 = 71;
                    } else if (this.match("least")) {
                        this.getRawToken();
                        n2 = 76;
                    } else {
                        this.error("'empty' sequence order must be 'greatest' or 'least'");
                    }
                }
                stack.push(new QuoteExp((Object)((bl2 ? "D" : "A") + (char)n2)));
                NamedCollator namedCollator = this.defaultCollator;
                if (this.match("collation")) {
                    Object object2 = this.parseURILiteral();
                    if (object2 instanceof String) {
                        try {
                            String string = this.resolveAgainstBaseUri((String)object2);
                            namedCollator = NamedCollator.make(string);
                        }
                        catch (Exception exception) {
                            this.error('e', "unknown collation '" + object2 + "'", "XQST0076");
                        }
                    }
                    this.getRawToken();
                }
                stack.push(new QuoteExp(namedCollator));
                if (this.curToken != 44) break;
                this.getRawToken();
            }
            if (!this.match("return")) {
                return this.syntaxError("expected 'return' clause");
            }
            this.getRawToken();
            LambdaExp lambdaExp = new LambdaExp(this.flworDeclsCount - this.flworDeclsFirst);
            for (n2 = this.flworDeclsFirst; n2 < this.flworDeclsCount; ++n2) {
                lambdaExp.addDeclaration(this.flworDecls[n2].getSymbol());
            }
            this.comp.push(lambdaExp);
            lambdaExp.body = this.parseExprSingle();
            this.comp.pop(lambdaExp);
            n2 = stack.size();
            expressionArray = new Expression[2 + n2];
            expressionArray[0] = expression;
            expressionArray[1] = lambdaExp;
            for (int i = 0; i < n2; ++i) {
                expressionArray[2 + i] = (Expression)stack.elementAt(i);
            }
            return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.OrderedMap", "orderedMap"), expressionArray);
        }
        this.flworDeclsCount = this.flworDeclsFirst;
        this.flworDeclsFirst = n;
        return expression;
    }

    public Expression parseFLWRInner(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        ScopeExp scopeExp;
        Expression expression2;
        Object object2;
        char c = this.pushNesting(bl ? (char)'f' : 'l');
        this.curToken = 36;
        Declaration declaration = this.parseVariableDeclaration();
        if (declaration == null) {
            return this.syntaxError("missing Variable - saw " + this.tokenString());
        }
        if (this.flworDecls == null) {
            this.flworDecls = new Declaration[8];
        } else if (this.flworDeclsCount >= this.flworDecls.length) {
            object2 = new Declaration[2 * this.flworDeclsCount];
            System.arraycopy(this.flworDecls, 0, object2, 0, this.flworDeclsCount);
            this.flworDecls = object2;
        }
        this.flworDecls[this.flworDeclsCount++] = declaration;
        this.getRawToken();
        object2 = this.parseOptionalTypeDeclaration();
        Expression[] expressionArray = new Expression[1];
        Declaration declaration2 = null;
        if (bl) {
            boolean bl2 = this.match("at");
            expression2 = new LambdaExp(bl2 ? 2 : 1);
            if (bl2) {
                this.getRawToken();
                if (this.curToken == 36) {
                    declaration2 = this.parseVariableDeclaration();
                    this.getRawToken();
                }
                if (declaration2 == null) {
                    this.syntaxError("missing Variable after 'at'");
                }
            }
            scopeExp = expression2;
            if (this.match("in")) {
                this.getRawToken();
            } else {
                if (this.curToken == 76) {
                    this.getRawToken();
                }
                this.syntaxError("missing 'in' in 'for' clause");
            }
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            } else {
                if (this.match("in")) {
                    this.getRawToken();
                }
                this.syntaxError("missing ':=' in 'let' clause");
            }
            LetExp letExp = new LetExp(expressionArray);
            scopeExp = letExp;
        }
        expressionArray[0] = this.parseExprSingle();
        if (object2 != null && !bl) {
            expressionArray[0] = Convert.makeCoercion(expressionArray[0], (Expression)object2);
        }
        this.popNesting(c);
        this.comp.push(scopeExp);
        scopeExp.addDeclaration(declaration);
        if (object2 != null) {
            declaration.setTypeExp((Expression)object2);
        }
        if (bl) {
            declaration.noteValue(null);
            declaration.setFlag(262144);
        }
        if (declaration2 != null) {
            scopeExp.addDeclaration(declaration2);
            declaration2.setType(LangPrimType.intType);
            declaration2.noteValue(null);
            declaration2.setFlag(262144);
        }
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression = this.parseFLWRInner(bl);
        } else if (this.match("for")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'for'");
            }
            expression = this.parseFLWRInner(true);
        } else if (this.match("let")) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after 'let'");
            }
            expression = this.parseFLWRInner(false);
        } else {
            char c2 = this.pushNesting('w');
            if (this.curToken == 196) {
                this.getRawToken();
                expression2 = this.parseExprSingle();
            } else {
                expression2 = this.match("where") ? this.parseExprSingle() : null;
            }
            this.popNesting(c2);
            boolean bl3 = this.match("stable");
            if (bl3) {
                this.getRawToken();
            }
            boolean bl4 = this.match("return");
            boolean bl5 = this.match("order");
            if (!(bl4 || bl5 || this.match("let") || this.match("for"))) {
                return this.syntaxError("missing 'return' clause");
            }
            if (!bl5) {
                this.peekNonSpace("unexpected eof-of-file after 'return'");
            }
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl4) {
                this.getRawToken();
            }
            if (bl5) {
                int n3 = this.flworDeclsCount - this.flworDeclsFirst;
                Expression[] expressionArray2 = new Expression[n3];
                for (int i = 0; i < n3; ++i) {
                    expressionArray2[i] = new ReferenceExp(this.flworDecls[this.flworDeclsFirst + i]);
                }
                expression = new ApplyExp(new PrimProcedure("gnu.xquery.util.OrderedMap", "makeTuple$V", 1), expressionArray2);
            } else {
                expression = this.parseExprSingle();
            }
            if (expression2 != null) {
                expression = new IfExp(XQParser.booleanValue(expression2), expression, QuoteExp.voidExp);
            }
            this.maybeSetLine(expression, n, n2);
        }
        this.comp.pop(scopeExp);
        if (bl) {
            expression2 = (LambdaExp)scopeExp;
            expression2.body = expression;
            Expression[] expressionArray3 = new Expression[]{scopeExp, expressionArray[0]};
            return new ApplyExp(XQParser.makeFunctionExp("gnu.kawa.functions.ValuesMap", expression2.min_args == 1 ? "valuesMap" : "valuesMapWithPos"), expressionArray3);
        }
        ((LetExp)scopeExp).setBody(expression);
        return scopeExp;
    }

    public Expression parseQuantifiedExpr(boolean bl) throws IOException, SyntaxException {
        Expression expression;
        char c = this.pushNesting(bl ? (char)'e' : 's');
        this.curToken = 36;
        Declaration declaration = this.parseVariableDeclaration();
        if (declaration == null) {
            return this.syntaxError("missing Variable token:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp(1);
        lambdaExp.addDeclaration(declaration);
        declaration.noteValue(null);
        declaration.setFlag(262144);
        declaration.setTypeExp(this.parseOptionalTypeDeclaration());
        if (this.match("in")) {
            this.getRawToken();
        } else {
            if (this.curToken == 76) {
                this.getRawToken();
            }
            this.syntaxError("missing 'in' in QuantifiedExpr");
        }
        Expression[] expressionArray = new Expression[]{this.parseExprSingle()};
        this.popNesting(c);
        this.comp.push(lambdaExp);
        if (this.curToken == 44) {
            this.getRawToken();
            if (this.curToken != 36) {
                return this.syntaxError("missing $NAME after ','");
            }
            expression = this.parseQuantifiedExpr(bl);
        } else {
            boolean bl2 = this.match("satisfies");
            if (!(bl2 || this.match("every") || this.match("some"))) {
                return this.syntaxError("missing 'satisfies' clause");
            }
            this.peekNonSpace("unexpected eof-of-file after 'satisfies'");
            int n = this.getLineNumber() + 1;
            int n2 = this.getColumnNumber() + 1;
            if (bl2) {
                this.getRawToken();
            }
            expression = this.parseExprSingle();
            this.maybeSetLine(expression, n, n2);
        }
        this.comp.pop(lambdaExp);
        lambdaExp.body = expression;
        Expression[] expressionArray2 = new Expression[]{lambdaExp, expressionArray[0]};
        return new ApplyExp(XQParser.makeFunctionExp("gnu.xquery.util.ValuesEvery", bl ? "every" : "some"), expressionArray2);
    }

    public Expression parseFunctionDefinition(int n, int n2) throws IOException, SyntaxException {
        Expression expression;
        SourceLocator sourceLocator;
        if (this.curToken != 81 && this.curToken != 65) {
            return this.syntaxError("missing function name");
        }
        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
        this.getMessages().setLine(this.port.getName(), this.curLine, this.curColumn);
        Symbol symbol = this.namespaceResolve(string, true);
        String string2 = symbol.getNamespaceURI();
        if (string2 == "http://www.w3.org/XML/1998/namespace" || string2 == "http://www.w3.org/2001/XMLSchema" || string2 == "http://www.w3.org/2001/XMLSchema-instance" || string2 == "http://www.w3.org/2005/xpath-functions") {
            this.error('e', "cannot declare function in standard namespace '" + string2 + '\'', "XQST0045");
        } else if (string2 == "") {
            this.error(this.comp.isPedantic() ? (char)'e' : 'w', "cannot declare function in empty namespace", "XQST0060");
        } else if (this.libraryModuleNamespace != null && string2 != this.libraryModuleNamespace && (!"http://www.w3.org/2005/xquery-local-functions".equals(string2) || this.comp.isPedantic())) {
            this.error('e', "function not in namespace of library module", "XQST0048");
        }
        this.getRawToken();
        if (this.curToken != 40) {
            return this.syntaxError("missing parameter list:" + this.curToken);
        }
        this.getRawToken();
        LambdaExp lambdaExp = new LambdaExp();
        this.maybeSetLine(lambdaExp, n, n2);
        lambdaExp.setName(string);
        Declaration declaration = this.comp.currentScope().addDeclaration(symbol);
        if (this.comp.isStatic()) {
            declaration.setFlag(2048);
        }
        lambdaExp.setFlag(2048);
        declaration.setCanRead(true);
        declaration.setProcedureDecl(true);
        this.maybeSetLine(declaration, n, n2);
        this.comp.push(lambdaExp);
        if (this.curToken != 41) {
            block0: while (true) {
                if ((sourceLocator = this.parseVariableDeclaration()) == null) {
                    this.error("missing parameter name");
                } else {
                    lambdaExp.addDeclaration((Declaration)sourceLocator);
                    this.getRawToken();
                    ++lambdaExp.min_args;
                    ++lambdaExp.max_args;
                    ((Declaration)sourceLocator).setTypeExp(this.parseOptionalTypeDeclaration());
                }
                if (this.curToken == 41) break;
                if (this.curToken != 44) {
                    expression = this.syntaxError("missing ',' in parameter list");
                    do {
                        this.getRawToken();
                        if (this.curToken < 0 || this.curToken == 59 || this.curToken == 59) {
                            return expression;
                        }
                        if (this.curToken == 41) break block0;
                    } while (this.curToken != 44);
                    continue;
                }
                this.getRawToken();
            }
        }
        this.getRawToken();
        sourceLocator = this.parseOptionalTypeDeclaration();
        lambdaExp.body = this.parseEnclosedExpr();
        this.comp.pop(lambdaExp);
        if (sourceLocator != null) {
            Convert.setCoercedReturnValue(lambdaExp, (Expression)sourceLocator, this.interpreter);
        }
        expression = new SetExp(declaration, (Expression)lambdaExp);
        ((SetExp)expression).setDefining(true);
        declaration.noteValue(lambdaExp);
        return expression;
    }

    public Object readObject() throws IOException, SyntaxException {
        return this.parse(null);
    }

    protected Symbol namespaceResolve(String string, boolean bl) {
        Object object2;
        int n = string.indexOf(58);
        String string2 = n >= 0 ? string.substring(0, n).intern() : (bl ? "(functions)" : XQuery.DEFAULT_ELEMENT_PREFIX);
        String string3 = QNameUtils.lookupPrefix(string2, this.constructorNamespaces, this.prologNamespaces);
        if (string3 == null) {
            if (n < 0) {
                string3 = "";
            } else if (!this.comp.isPedantic()) {
                try {
                    object2 = Class.forName(string2);
                    string3 = "class:" + string2;
                }
                catch (Exception exception) {
                    string3 = null;
                }
            }
            if (string3 == null) {
                this.getMessages().error('e', "unknown namespace prefix '" + string2 + "'", "XPST0081");
                string3 = "(unknown namespace)";
            }
        }
        object2 = n < 0 ? string : string.substring(n + 1);
        return Symbol.make(string3, (String)object2, string2);
    }

    void parseSeparator() throws IOException, SyntaxException {
        int n = this.port.getLineNumber() + 1;
        int n2 = this.port.getColumnNumber() + 1;
        int n3 = this.skipSpace(this.nesting != 0);
        if (n3 == 59) {
            return;
        }
        if (warnOldVersion && n3 != 10) {
            this.curLine = n;
            this.curColumn = n2;
            this.error('w', "missing ';' after declaration");
        }
        if (n3 >= 0) {
            this.unread(n3);
        }
    }

    public Expression parse(Compilation compilation) throws IOException, SyntaxException {
        this.comp = compilation;
        int n = this.skipSpace();
        if (n < 0) {
            return null;
        }
        ++this.parseCount;
        this.unread(n);
        int n2 = this.getLineNumber() + 1;
        int n3 = this.getColumnNumber() + 1;
        if (n == 35 && n2 == 1 && n3 == 1) {
            this.read();
            n = this.read();
            if (n != 33 || (n = this.read()) != 47) {
                this.error("'#' is only allowed in initial '#!/PROGRAM'");
            }
            while (n != 13 && n != 10 && n >= 0) {
                n = this.read();
            }
        }
        if (this.getRawToken() == -1) {
            return null;
        }
        this.peekOperand();
        if (this.curToken == 65 && "namespace".equals((String)this.curValue)) {
            if (warnOldVersion) {
                this.error('w', "use 'declare namespace' instead of 'namespace'");
            }
            this.curToken = 78;
        }
        switch (this.curToken) {
            case 87: {
                int n4 = this.getLineNumber() + 1;
                int n5 = this.getColumnNumber() + 1;
                int n6 = this.peekNonSpace("unexpected end-of-file after 'define QName'");
                if (n6 == 40) {
                    this.syntaxError("'missing 'function' after 'define'");
                    this.curToken = 65;
                    return this.parseFunctionDefinition(n4, n5);
                }
                return this.syntaxError("missing keyword after 'define'");
            }
            case 80: {
                int n7 = this.getLineNumber() + 1;
                int n8 = this.getColumnNumber() + 1;
                this.getRawToken();
                this.peekNonSpace("unexpected end-of-file after 'define function'");
                char c = this.pushNesting('d');
                Expression expression = this.parseFunctionDefinition(n7, n8);
                this.popNesting(c);
                this.parseSeparator();
                this.maybeSetLine(expression, n2, n3);
                this.seenDeclaration = true;
                return expression;
            }
            case 86: {
                String string;
                this.getRawToken();
                Declaration declaration = this.parseVariableDeclaration();
                if (declaration == null) {
                    return this.syntaxError("missing Variable");
                }
                Object object2 = declaration.getSymbol();
                if (object2 instanceof String) {
                    this.getMessages().setLine(this.port.getName(), this.curLine, this.curColumn);
                    declaration.setSymbol(this.namespaceResolve((String)object2, false));
                }
                if (this.libraryModuleNamespace != null && (string = ((Symbol)declaration.getSymbol()).getNamespaceURI()) != this.libraryModuleNamespace && (!"http://www.w3.org/2005/xquery-local-functions".equals(string) || compilation.isPedantic())) {
                    this.error('e', "variable not in namespace of library module", "XQST0048");
                }
                compilation.currentScope().addDeclaration(declaration);
                this.getRawToken();
                Expression expression = this.parseOptionalTypeDeclaration();
                declaration.setCanRead(true);
                declaration.setFlag(16384);
                Expression expression2 = null;
                boolean bl = false;
                if (this.curToken == 402 || this.curToken == 76) {
                    if (this.curToken == 402) {
                        this.error("declare variable contains '=' instead of ':='");
                    }
                    this.getRawToken();
                    bl = true;
                }
                if (this.curToken == 123) {
                    this.warnOldVersion("obsolete '{' in variable declaration");
                    expression2 = this.parseEnclosedExpr();
                    this.parseSeparator();
                } else if (this.match("external")) {
                    Expression[] expressionArray = new Expression[]{XQParser.castQName(new QuoteExp(declaration.getSymbol()), false), expression == null ? QuoteExp.nullExp : expression};
                    expression2 = new ApplyExp(getExternalFunction, expressionArray);
                    this.maybeSetLine(expression2, this.curLine, this.curColumn);
                    this.getRawToken();
                } else {
                    expression2 = this.parseExpr();
                    Expression expression3 = null;
                    if (!bl || expression2 == null) {
                        expression3 = this.syntaxError("expected ':= init' or 'external'");
                    }
                    if (expression2 == null) {
                        expression2 = expression3;
                    }
                }
                if (expression != null) {
                    expression2 = Convert.makeCoercion(expression2, expression);
                }
                declaration.noteValue(expression2);
                SetExp setExp = SetExp.makeDefinition(declaration, expression2);
                this.maybeSetLine(setExp, n2, n3);
                this.seenDeclaration = true;
                return setExp;
            }
            case 77: 
            case 78: {
                int n9 = this.curToken;
                if (n9 == 77 && this.libraryModuleNamespace != null) {
                    this.error('e', "duplicate module declaration");
                } else if (this.seenDeclaration && !this.interactive) {
                    this.error('e', "namespace declared after function/variable/option");
                }
                int n10 = this.skipSpace(this.nesting != 0);
                if (n10 >= 0) {
                    this.unread();
                    if (XName.isNameStart((char)n10)) {
                        Externalizable externalizable;
                        this.getRawToken();
                        if (this.curToken != 65) {
                            return this.syntaxError("missing namespace prefix");
                        }
                        String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                        this.getRawToken();
                        if (this.curToken != 402) {
                            return this.syntaxError("missing '=' in namespace declaration");
                        }
                        this.getRawToken();
                        if (this.curToken != 34) {
                            return this.syntaxError("missing uri in namespace declaration");
                        }
                        String string2 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                        string = string.intern();
                        for (externalizable = this.prologNamespaces; externalizable != builtinNamespaces; externalizable = ((NamespaceBinding)externalizable).getNext()) {
                            if (((NamespaceBinding)externalizable).getPrefix() != string) continue;
                            this.error('e', "duplicate declarations for the same namespace prefix '" + string + "'", "XQST0033");
                            break;
                        }
                        this.pushNamespace(string, string2);
                        this.checkAllowedNamespaceDeclaration(string, string2, false);
                        this.parseSeparator();
                        if (n9 == 77) {
                            externalizable = compilation.getModule();
                            String string3 = Compilation.mangleURI(string2) + '.' + XQuery.makeClassName(((Expression)((Object)externalizable)).getFileName());
                            ((PropertySet)((Object)externalizable)).setName(string3);
                            compilation.mainClass = new ClassType(string3);
                            ((LambdaExp)((Object)externalizable)).setType(compilation.mainClass);
                            ModuleManager moduleManager = ModuleManager.getInstance();
                            ModuleInfo moduleInfo = moduleManager.find(compilation);
                            moduleInfo.setNamespaceUri(string2);
                            ((LambdaExp)((Object)externalizable)).setType(compilation.mainClass);
                            if (string2.length() == 0) {
                                return this.syntaxError("zero-length module namespace", "XQST0088");
                            }
                            this.libraryModuleNamespace = string2;
                        }
                        return QuoteExp.voidExp;
                    }
                }
            }
            case 84: {
                this.fatal("'import schema' not implemented", "XQST0009");
            }
            case 73: {
                Expression[] expressionArray;
                int n10;
                this.getRawToken();
                String string = null;
                if (this.match("namespace")) {
                    this.getRawToken();
                    if (this.curToken != 65) {
                        return this.syntaxError("missing namespace prefix");
                    }
                    string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getRawToken();
                    if (this.curToken != 402) {
                        return this.syntaxError("missing '=' in namespace declaration");
                    }
                    this.getRawToken();
                }
                if (this.curToken != 34) {
                    return this.syntaxError("missing uri in namespace declaration");
                }
                if (this.tokenBufferLength == 0) {
                    return this.syntaxError("zero-length target namespace", "XQST0088");
                }
                String string4 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                if (string != null) {
                    this.checkAllowedNamespaceDeclaration(string, string4, false);
                    this.pushNamespace(string.intern(), string4);
                }
                this.getRawToken();
                ModuleManager.getInstance().find(compilation);
                ModuleExp moduleExp = compilation.getModule();
                Vector vector = new Vector();
                String string5 = Compilation.mangleURI(string4);
                compilation.setLine(this.port.getName(), n2, n3);
                if (this.match("at")) {
                    do {
                        this.getRawToken();
                        if (this.curToken != 34) {
                            return this.syntaxError("missing module location");
                        }
                        String string6 = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                        expressionArray = Compilation.mangleURI(string4) + '.' + XQuery.makeClassName(string6);
                        ModuleInfo moduleInfo = require.lookupModuleFromSourcePath(string6, moduleExp);
                        if (moduleInfo == null) {
                            compilation.error('e', "malformed URL: " + string6);
                        }
                        require.importDefinitions((String)expressionArray, moduleInfo, null, vector, moduleExp, compilation);
                    } while ((n10 = this.skipSpace(this.nesting != 0)) == 44);
                    this.unread(n10);
                    this.parseSeparator();
                } else {
                    ModuleInfo moduleInfo;
                    expressionArray = ModuleManager.getInstance();
                    int n11 = 0;
                    try {
                        expressionArray.loadPackageInfo(string5);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (Throwable throwable) {
                        this.error('e', "error loading map for " + string4 + " - " + throwable);
                    }
                    int n12 = 0;
                    while ((moduleInfo = expressionArray.getModule(n12)) != null) {
                        if (string4.equals(moduleInfo.getNamespaceUri())) {
                            ++n11;
                            require.importDefinitions(moduleInfo.className, moduleInfo, null, vector, moduleExp, compilation);
                        }
                        ++n12;
                    }
                    if (n11 == 0) {
                        this.error('e', "no module found for " + string4);
                    }
                    Object var19_32 = null;
                    if (this.curToken != 59) {
                        this.parseSeparator();
                    }
                }
                if (compilation.pendingImports != null && compilation.pendingImports.size() > 0) {
                    this.error('e', "module import forms a cycle", "XQST0073");
                }
                expressionArray = new Expression[vector.size()];
                vector.toArray(expressionArray);
                return BeginExp.canonicalize(expressionArray);
            }
            case 71: {
                Object object3;
                if (this.defaultCollator != null && !this.interactive) {
                    this.error('e', "duplicate default collation declaration", "XQST0038");
                }
                if ((object3 = this.parseURILiteral()) instanceof Expression) {
                    return (Expression)object3;
                }
                String string = (String)object3;
                try {
                    string = this.resolveAgainstBaseUri(string);
                    this.defaultCollator = NamedCollator.make(string);
                }
                catch (Exception exception) {
                    this.defaultCollator = NamedCollator.codepointCollation;
                    this.error('e', "unknown collation '" + string + "'", "XQST0038");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 69: 
            case 79: {
                String string;
                boolean bl = this.curToken == 79;
                String string7 = string = bl ? "(functions)" : XQuery.DEFAULT_ELEMENT_PREFIX;
                if (this.prologNamespaces.resolve(string, builtinNamespaces) != null) {
                    this.error('e', "duplicate default namespace declaration", "XQST0066");
                } else if (this.seenDeclaration && !this.interactive) {
                    this.error('e', "default namespace declared after function/variable/option");
                }
                this.getRawToken();
                if (this.match("namespace")) {
                    this.getRawToken();
                } else {
                    String string8 = "expected 'namespace' keyword";
                    if (this.curToken != 34 && this.curToken != 402) {
                        return this.declError(string8);
                    }
                    this.warnOldVersion(string8);
                }
                if (this.curToken == 402 || this.curToken == 76) {
                    this.warnOldVersion("extra '=' in default namespace declaration");
                    this.getRawToken();
                }
                if (this.curToken != 34) {
                    return this.declError("missing namespace uri");
                }
                String string9 = new String(this.tokenBuffer, 0, this.tokenBufferLength).intern();
                if (bl) {
                    this.functionNamespacePath = new Namespace[1];
                    this.functionNamespacePath[0] = Namespace.getInstance(string9);
                } else {
                    this.defaultElementNamespace = string9;
                }
                this.pushNamespace(string, string9);
                this.checkAllowedNamespaceDeclaration(string, string9, false);
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 83: {
                this.getRawToken();
                if (this.curToken == 402) {
                    this.warnOldVersion("obsolate '=' in boundary-space declaration");
                    this.getRawToken();
                }
                if (this.boundarySpaceDeclarationSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare boundary-space' seen", "XQST0068");
                }
                this.boundarySpaceDeclarationSeen = true;
                if (this.match("preserve")) {
                    this.boundarySpacePreserve = true;
                } else if (this.match("strip")) {
                    this.boundarySpacePreserve = false;
                } else if (this.match("skip")) {
                    this.warnOldVersion("update: declare boundary-space skip -> strip");
                    this.boundarySpacePreserve = false;
                } else {
                    return this.syntaxError("boundary-space declaration must be preserve or strip");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 75: {
                this.getRawToken();
                if (this.constructionModeDeclarationSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare construction' seen", "XQST0067");
                }
                this.constructionModeDeclarationSeen = true;
                if (this.match("strip")) {
                    this.constructionModeStrip = true;
                } else if (this.match("preserve")) {
                    this.constructionModeStrip = false;
                } else {
                    return this.syntaxError("construction declaration must be strip or preserve");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 76: {
                this.getRawToken();
                if (this.copyNamespacesDeclarationSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare copy-namespaces' seen", "XQST0055");
                }
                this.copyNamespacesDeclarationSeen = true;
                if (this.match("preserve")) {
                    this.copyNamespacesMode |= 1;
                } else if (this.match("no-preserve")) {
                    this.copyNamespacesMode &= 0xFFFFFFFE;
                } else {
                    return this.syntaxError("expected 'preserve' or 'no-preserve' after 'declare copy-namespaces'");
                }
                this.getRawToken();
                if (this.curToken != 44) {
                    return this.syntaxError("missing ',' in copy-namespaces declaration");
                }
                this.getRawToken();
                if (this.match("inherit")) {
                    this.copyNamespacesMode |= 2;
                } else if (this.match("no-inherit")) {
                    this.copyNamespacesMode &= 0xFFFFFFFD;
                } else {
                    return this.syntaxError("expected 'inherit' or 'no-inherit' in copy-namespaces declaration");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 72: {
                this.getRawToken();
                boolean bl = this.match("empty");
                if (this.emptyOrderDeclarationSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare default empty order' seen", "XQST0069");
                }
                this.emptyOrderDeclarationSeen = true;
                if (bl) {
                    this.getRawToken();
                } else {
                    this.syntaxError("expected 'empty greatest' or 'empty least'");
                }
                if (this.match("greatest")) {
                    this.defaultEmptyOrder = (char)71;
                } else if (this.match("least")) {
                    this.defaultEmptyOrder = (char)76;
                } else {
                    return this.syntaxError("expected 'empty greatest' or 'empty least'");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 111: {
                this.getRawToken();
                if (this.curToken != 81) {
                    this.syntaxError("expected QName after 'declare option'");
                } else {
                    String string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    this.getMessages().setLine(this.port.getName(), this.curLine, this.curColumn);
                    Symbol symbol = this.namespaceResolve(string, false);
                    this.getRawToken();
                    if (this.curToken != 34) {
                        this.syntaxError("expected string literal after 'declare option " + string + '\'');
                    } else {
                        this.handleOption(symbol, new String(this.tokenBuffer, 0, this.tokenBufferLength));
                    }
                }
                this.parseSeparator();
                this.seenDeclaration = true;
                return QuoteExp.voidExp;
            }
            case 85: {
                if (this.orderingModeSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare ordering' seen", "XQST0065");
                }
                this.orderingModeSeen = true;
                this.getRawToken();
                if (this.match("ordered")) {
                    this.orderingModeUnordered = false;
                } else if (this.match("unordered")) {
                    this.orderingModeUnordered = true;
                } else {
                    return this.syntaxError("ordering declaration must be ordered or unordered");
                }
                this.parseSeparator();
                return QuoteExp.voidExp;
            }
            case 89: {
                String string;
                if (this.parseCount != 1) {
                    this.error('e', "'xquery version' does not start module");
                } else if (this.commentCount > 0) {
                    this.error('w', "comments should not precede 'xquery version'");
                }
                this.getRawToken();
                if (this.curToken == 34) {
                    string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    if (!string.equals("1.0")) {
                        this.error('e', "unrecognized xquery version " + string, "XQST0031");
                    }
                } else {
                    return this.syntaxError("missing version string after 'xquery version'");
                }
                this.getRawToken();
                if (this.match("encoding")) {
                    boolean bl;
                    this.getRawToken();
                    if (this.curToken != 34) {
                        return this.syntaxError("invalid encoding specification");
                    }
                    string = new String(this.tokenBuffer, 0, this.tokenBufferLength);
                    int n13 = this.tokenBufferLength;
                    boolean bl2 = bl = n13 == 0;
                    while (--n13 >= 0 && !bl) {
                        n = this.tokenBuffer[n13];
                        if (n >= 65 && n <= 90 || n >= 97 && n <= 122 || n13 != 0 && (n >= 48 && n <= 57 || n == 46 || n == 95 || n == 45)) continue;
                        bl = true;
                    }
                    if (bl) {
                        this.error('e', "invalid encoding name syntax", "XQST0087");
                    }
                    this.getRawToken();
                }
                if (this.curToken != 59) {
                    this.syntaxError("missing ';'");
                }
                return QuoteExp.voidExp;
            }
            case 66: {
                if (this.baseURIDeclarationSeen && !this.interactive) {
                    this.syntaxError("duplicate 'declare base-uri' seen", "XQST0032");
                }
                this.baseURIDeclarationSeen = true;
                Object object4 = this.parseURILiteral();
                if (object4 instanceof Expression) {
                    return (Expression)object4;
                }
                this.parseSeparator();
                this.setStaticBaseUri((String)object4);
                return QuoteExp.voidExp;
            }
        }
        Expression expression = this.parseExprSequence(-1, true);
        if (this.curToken == 10) {
            this.unread(10);
        }
        this.maybeSetLine(expression, n2, n3);
        if (this.libraryModuleNamespace != null) {
            this.error('e', "query body in a library module", "XPST0003");
        }
        return expression;
    }

    public void handleOption(Symbol symbol, String string) {
    }

    public static Expression makeFunctionExp(String string, String string2) {
        return XQParser.makeFunctionExp(string, Compilation.mangleNameIfNeeded(string2), string2);
    }

    public static Expression makeFunctionExp(String string, String string2, String string3) {
        return new ReferenceExp(string3, Declaration.getDeclarationValueFromStatic(string, string2, string3));
    }

    String tokenString() {
        switch (this.curToken) {
            case 34: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('\"');
                for (int i = 0; i < this.tokenBufferLength; ++i) {
                    char c = this.tokenBuffer[i];
                    if (c == '\"') {
                        stringBuffer.append('\"');
                    }
                    stringBuffer.append(c);
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            case 70: {
                return new String(this.tokenBuffer, 0, this.tokenBufferLength) + " + '('";
            }
            case 65: 
            case 81: {
                return new String(this.tokenBuffer, 0, this.tokenBufferLength);
            }
            case -1: {
                return "<EOF>";
            }
        }
        if (this.curToken >= 100 && this.curToken - 100 < 13) {
            return axisNames[this.curToken - 100] + "::-axis(" + this.curToken + ")";
        }
        if (this.curToken >= 32 && this.curToken < 127) {
            return Integer.toString(this.curToken) + "='" + (char)this.curToken + "'";
        }
        return Integer.toString(this.curToken);
    }

    public void error(char c, String string, String string2) {
        SourceMessages sourceMessages = this.getMessages();
        SourceError sourceError = new SourceError(c, this.port.getName(), this.curLine, this.curColumn, string);
        sourceError.code = string2;
        sourceMessages.error(sourceError);
    }

    public void error(char c, String string) {
        this.error(c, string, null);
    }

    public Expression declError(String string) throws IOException, SyntaxException {
        if (this.interactive) {
            return this.syntaxError(string);
        }
        this.error(string);
        while (this.curToken != 59 && this.curToken != -1) {
            this.getRawToken();
        }
        return new ErrorExp(string);
    }

    public Expression syntaxError(String string, String string2) throws IOException, SyntaxException {
        this.error('e', string, string2);
        if (this.interactive) {
            int n;
            this.curToken = 0;
            this.curValue = null;
            this.nesting = 0;
            ((InPort)this.getPort()).readState = (char)10;
            while ((n = this.read()) >= 0) {
                if (n != 13 && n != 10) continue;
                this.unread(n);
                break;
            }
            throw new SyntaxException(this.getMessages());
        }
        return new ErrorExp(string);
    }

    public Expression syntaxError(String string) throws IOException, SyntaxException {
        return this.syntaxError(string, "XPST0003");
    }

    public void eofError(String string) throws SyntaxException {
        this.fatal(string, "XPST0003");
    }

    public void fatal(String string, String string2) throws SyntaxException {
        SourceMessages sourceMessages = this.getMessages();
        SourceError sourceError = new SourceError('f', this.port.getName(), this.curLine, this.curColumn, string);
        sourceError.code = string2;
        sourceMessages.error(sourceError);
        throw new SyntaxException(sourceMessages);
    }

    void warnOldVersion(String string) {
        if (warnOldVersion || this.comp.isPedantic()) {
            this.error(this.comp.isPedantic() ? (char)'e' : 'w', string);
        }
    }

    public void maybeSetLine(Expression expression, int n, int n2) {
        String string = this.getName();
        if (string != null && expression.getFileName() == null && !(expression instanceof QuoteExp)) {
            expression.setFile(string);
            expression.setLine(n, n2);
        }
    }

    public void maybeSetLine(Declaration declaration, int n, int n2) {
        String string = this.getName();
        if (string != null) {
            declaration.setFile(string);
            declaration.setLine(n, n2);
        }
    }

    static {
        NamespaceBinding namespaceBinding = NamespaceBinding.predefinedXML;
        namespaceBinding = new NamespaceBinding("xml", "http://www.w3.org/XML/1998/namespace", namespaceBinding);
        namespaceBinding = new NamespaceBinding("xs", "http://www.w3.org/2001/XMLSchema", namespaceBinding);
        namespaceBinding = new NamespaceBinding("xsi", "http://www.w3.org/2001/XMLSchema-instance", namespaceBinding);
        namespaceBinding = new NamespaceBinding("fn", "http://www.w3.org/2005/xpath-functions", namespaceBinding);
        namespaceBinding = new NamespaceBinding("html", "http://www.w3.org/1999/xhtml", namespaceBinding);
        namespaceBinding = new NamespaceBinding("kawa", "http://kawa.gnu.org/", namespaceBinding);
        namespaceBinding = new NamespaceBinding("qexo", "http://qexo.gnu.org/", namespaceBinding);
        builtinNamespaces = namespaceBinding = new NamespaceBinding("local", "http://www.w3.org/2005/xquery-local-functions", namespaceBinding);
        getExternalFunction = QuoteExp.getInstance(new PrimProcedure("gnu.xquery.lang.XQuery", "getExternal", 2));
        axisNames = new String[13];
        XQParser.axisNames[0] = "ancestor";
        XQParser.axisNames[1] = "ancestor-or-self";
        XQParser.axisNames[2] = "attribute";
        XQParser.axisNames[3] = "child";
        XQParser.axisNames[4] = "descendant";
        XQParser.axisNames[5] = "descendant-or-self";
        XQParser.axisNames[6] = "following";
        XQParser.axisNames[7] = "following-sibling";
        XQParser.axisNames[8] = "namespace";
        XQParser.axisNames[9] = "parent";
        XQParser.axisNames[10] = "preceding";
        XQParser.axisNames[11] = "preceding-sibling";
        XQParser.axisNames[12] = "self";
    }
}

