/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.Array;
import gnu.lists.GapManager;
import gnu.lists.GeneralArray;
import gnu.lists.IndirectIndexable;
import gnu.lists.IntSequence;
import gnu.lists.Range;
import gnu.lists.StableManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.RandomAccess;

public abstract class SimpleVector<E>
extends IndirectIndexable<E>
implements Array<E>,
Externalizable,
RandomAccess {
    protected GapManager getGapManager() {
        IntSequence ind = this.indexes;
        if (ind instanceof GapManager) {
            return (GapManager)ind;
        }
        if (ind != null) {
            this.checkCanWrite();
            String msg = this.indexes == cantWriteMarker ? "can't adjust size of constant vector" : "can't adjust size of indirect vector";
            throw new UnsupportedOperationException(msg);
        }
        GapManager manager = new GapManager(this);
        this.indexes = manager;
        return manager;
    }

    protected StableManager getStableManager() {
        StableManager manager;
        IntSequence ind = this.indexes;
        if (ind instanceof StableManager) {
            return (StableManager)ind;
        }
        if (ind instanceof GapManager) {
            manager = new StableManager(this, (GapManager)ind);
        } else {
            if (ind != null) {
                this.checkCanWrite();
                String msg = this.indexes == cantWriteMarker ? "can't adjust size of constant vector" : "can't adjust size of indirect vector";
                throw new UnsupportedOperationException(msg);
            }
            manager = new StableManager(this);
        }
        this.indexes = manager;
        return manager;
    }

    protected abstract void setBuffer(Object var1);

    public abstract void setBufferLength(int var1);

    public long getSegment(int index) {
        Range.IntRange range;
        int size;
        int where;
        IntSequence ind = this.indexes;
        int sz = this.size();
        if (ind == null || ind == cantWriteMarker) {
            where = index;
            size = sz - where;
        } else if (ind instanceof Range.IntRange && (range = (Range.IntRange)ind).getStepInt() == 1) {
            int istart = range.getStartInt();
            where = index + istart;
            size = ind.size() - index;
        } else if (ind instanceof GapManager) {
            GapManager gman = (GapManager)ind;
            int gapStart = gman.getGapStart();
            if (index < gapStart) {
                where = index;
                size = gapStart - index;
            } else {
                where = index + gman.getGapEnd() - gapStart;
                size = this.getBufferLength() - where;
            }
        } else {
            where = ind.intAt(index);
            size = index < sz ? 1 : 0;
        }
        return (long)size << 32 | (long)where;
    }

    public int getSegment(int index, int len) {
        IntSequence ind = this.indexes;
        if (ind instanceof GapManager) {
            return ((GapManager)ind).getSegment(this, index, len, false);
        }
        return this.getSegmentReadOnly(index, len);
    }

    public int getSegmentReadOnly(int start, int len) {
        int sz = this.size();
        if (start < 0 || len < 0 || start + len > sz) {
            return -1;
        }
        long result = this.getSegment(start);
        int where = (int)result;
        int size = (int)(result >> 32);
        return size >= len ? where : -1;
    }

    @Override
    protected boolean isAfterPos(int ipos) {
        return (ipos & 1) != 0;
    }

    protected abstract Object getBuffer();

    @Override
    public E get(int index) {
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        return this.getBuffer(index);
    }

    @Override
    public E getRowMajor(int i) {
        return this.get(i);
    }

    protected abstract E getBuffer(int var1);

    @Override
    public E set(int index, E value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        E old = this.getBuffer(index);
        this.setBuffer(index, value);
        return old;
    }

    @Override
    public void setAt(int index, E value) {
        this.checkCanWrite();
        if (this.indexes != null) {
            index = this.indexes.intAt(index);
        }
        this.setBuffer(index, value);
    }

    protected abstract void setBuffer(int var1, E var2);

    @Override
    public void fill(E value) {
        this.checkCanWrite();
        IntSequence ind = this.getIndexesForce();
        int i = this.size();
        while (--i >= 0) {
            this.setBuffer(ind.intAt(i), value);
        }
    }

    public void shift(int srcStart, int dstStart, int count) {
        this.checkCanWrite();
        Object data = this.getBuffer();
        System.arraycopy(data, srcStart, data, dstStart, count);
    }

    @Override
    public boolean add(E o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public void add(int index, E o) {
        this.addSpace(index, 1);
        this.setBuffer(index, o);
    }

    @Override
    protected int addPos(int ipos, E value) {
        int index = this.nextIndex(ipos);
        this.add(index, value);
        int ret = this.createPos(index + 1, true);
        this.releasePos(ipos);
        return ret;
    }

    protected void addSpace(int index, int count) {
        this.getGapManager().insertUnspecified(this, index, count);
    }

    public void delete(int start, int end) {
        GapManager manager = this.getGapManager();
        int count = end - start;
        manager.delete(this, start, count);
        this.clearBuffer(start, count);
    }

    protected abstract void clearBuffer(int var1, int var2);

    public Object toDataArray() {
        int size;
        int count;
        Object buffer = this.getBuffer();
        Class<?> componentType = buffer.getClass().getComponentType();
        int index = 0;
        Object copy = java.lang.reflect.Array.newInstance(componentType, count);
        for (count = this.size(); count > 0; count -= size) {
            long result = this.getSegment(index);
            int where = (int)result;
            size = (int)(result >> 32);
            if (size > count) {
                size = count;
            }
            System.arraycopy(buffer, where, copy, index, size);
            index += size;
        }
        return copy;
    }

    public String getTag() {
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.getBuffer());
        out.writeObject(this.indexes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setBuffer(in.readObject());
        this.indexes = (IntSequence)in.readObject();
    }

    @Override
    public Array transpose(int[] lowBounds, int[] dimensions, int offset0, int[] factors) {
        GeneralArray array = new GeneralArray();
        array.strides = factors;
        array.dimensions = dimensions;
        array.lowBounds = lowBounds;
        array.offset = offset0;
        array.base = this;
        array.simple = false;
        return array;
    }
}

