<?php
	require_once('lib/Global.php');
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html>

	<head>

		<?php
//# Copyright (C) 2012-2013 GNU remotecontrol authors.
//                    #
//                    # This program is free software: you can redistribute it and/or modify
//                    # it under the terms of the GNU Affero General Public License as
//                    # published by the Free Software Foundation, either version 3 of the
//                    # License, or (at your option) any later version.
//                    #
//                    # This program is distributed in the hope that it will be useful,
//                    # but WITHOUT ANY WARRANTY; without even the implied warranty of
//                    # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//                    # GNU Affero General Public License for more details.
//                    #
//                    # You should have received a copy of the GNU Affero General Public License
//                    # along with this program.  If not, see <http://www.gnu.org/licenses/>.
			require 'inc/index_controller.php';
			echo '<title>' . Common::GetAppName();
			echo ' - ' . $GRCHM->Value . '</title>';
		?>

		<meta http-equiv="Content-Type" content="text/html;charset=utf8" />

		<link rel="shortcut icon" href="images/GNURC.ico" type="image/x-icon" />
		<link rel="icon" href="images/GNURC.ico" type="image/ico" />

		<link rel="Stylesheet" type="text/css" href="styles/master.css" />
		<link rel="Stylesheet" type="text/css" href="styles/form.css" />

		<script>
			/*
			@licstart  The following is the entire license notice for the
			JavaScript code in this page.

			Copyright (C) 2012-2013 GNU remotecontrol authors

			The JavaScript code in this page is free software: you can
			redistribute it and/or modify it under the terms of the GNU
			General Public License (GNU GPL) as published by the Free Software
			Foundation, either version 3 of the License, or (at your option)
			any later version.  The code is distributed WITHOUT ANY WARRANTY;
			without even the implied warranty of MERCHANTABILITY or FITNESS
			FOR A PARTICULAR PURPOSE.  See the GNU GPL for more details.

			As additional permission under GNU GPL version 3 section 7, you
			may distribute non-source (e.g., minimized or compacted) forms of
			that code without the copy of the GNU GPL normally required by
			section 4, provided you include this license notice and a URL
			through which recipients can access the Corresponding Source.


			@licend  The above is the entire license notice
			for the JavaScript code in this page.
			 */
		</script>

		<script type="text/javascript" src="scripts/master.js"></script>
		<script type="text/javascript" src="scripts/ajax.js"></script>
		<script type="text/javascript" src="scripts/form.js"></script>
		<script type="text/javascript">
			var ajax = new Ajax();
		</script>

	</head>

	<body>

		<div id="main-container">

			<div>

				<img id="banner_logo" alt="GNU Remote Control" src="images/logo.png" />

				<img id="loadimage" alt="Working..." title="Working..." src="images/ajax-loader.gif" />

			</div>

			<div id="shader">

				<?php

					echo '<span id="header">' . $GRCHM->Value . '</span>';

				?>

				<div id="container" class="maximum-width">

					<div id="inner">

						<span id="message"></span>

						<div id="thermostatscontainer">

							<div  id="languagediv">

								<?php
									$languages = new LanguageCollection(true);
									$languages->displayLanguagesCombo($resourcesPageLevel, $currentUser);
								?>

							</div>

							<div>

								<?php
									$GRCHM_LBL3 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL3');
									echo '<div class="to-right"><span id="welcomeback">' . str_replace('{0}', $currentUser->UserName, $GRCHM_LBL3->Value) . '</span></div>';

									$thermostats = new IPThermostatCollection($currentUser->ID, true, $currentUser->ThermostatSort);
									$_SESSION['Thermostats'] = $thermostats;
									$firstthermid = -1;

									if ($thermostats->count() > 0)
									{
										$firstthermid = $thermostats[0]->ID;
									}

									$GRCHM_LBL4 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL4');

									echo '<div><span id="subscriptioninfo">' . str_replace('{0}', $currentUser->displayMaxTherms(), $GRCHM_LBL4->Value) . '</span></div>';

									$GRCHM_HLK1 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK1');
									echo '<div><span id="transactionlog"><a  href="transactionhistory.php">' . $GRCHM_HLK1->Value . '</a></span></div><br/>';
								?>

							</div>

							<div class="devices">

								<table id="thermostats" class="settings maximum-width">

									<tr class="header">

										<?php
											$GRCHM_TTP1 = $resourcesPageLevel->FindResourceByCode('GRCHM$TTP1');
											echo '<th id="selectallthermscell"><div><input type="checkbox" id="selectalltherms" title="' . $GRCHM_TTP1->Value . '" onclick="toggleSelectAllThermostats(this);" /></div></th>';
										?>

										<th colspan="2">&nbsp;</th>

										<?php $GRCHM_CLM1 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM1'); ?>

										<th>

											<div><?php echo $GRCHM_CLM1->Value; ?></div>
											<div></div>

										</th>

										<?php $GRCHM_CLM2 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM2'); ?>

										<th>

											<div><?php echo $GRCHM_CLM2->Value; ?></div>
											<div></div>

										</th>

										<?php $GRCHM_CLM3 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM3'); ?>

										<th>

											<div><?php echo $GRCHM_CLM3->Value; ?></div>
											<div></div>

										</th>

										<?php $GRCHM_CLM10 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM10'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('Group_Desc', 'Group_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM10->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'Group_Asc')
												{
													echo '<a href="?thermostatSort=Group_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=Group_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'Group_Desc')
												{
													echo '<a href="?thermostatSort=Group_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=Group_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM4 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM4'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('Name_Desc', 'Name_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM4->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'Name_Asc')
												{
													echo '<a href="?thermostatSort=Name_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=Name_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'Name_Desc')
												{
													echo '<a href="?thermostatSort=Name_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=Name_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM5 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM5'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('Description_Desc', 'Description_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM5->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'Description_Asc')
												{
													echo '<a href="?thermostatSort=Description_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=Description_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'Description_Desc')
												{
													echo '<a href="?thermostatSort=Description_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=Description_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM6 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM6'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('Host_Desc', 'Host_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM6->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'Host_Asc')
												{
													echo '<a href="?thermostatSort=Host_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=Host_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'Host_Desc')
												{
													echo '<a href="?thermostatSort=Host_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=Host_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM7 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM7'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('Port_Desc', 'Port_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM7->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'Port_Asc')
												{
													echo '<a href="?thermostatSort=Port_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=Port_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'Port_Desc')
												{
													echo '<a href="?thermostatSort=Port_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=Port_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM9 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM9'); ?>

										<th>

											<?php
												if (isset($thermostatSort) && in_array($thermostatSort, array('TimeZone_Desc', 'TimeZone_Asc')))
												{
													echo '<div class="sorted">';
												}
												else
												{
													echo '<div>';
												}

												echo $GRCHM_CLM9->Value;
												echo '</div>';

												if (isset($thermostatSort) && $thermostatSort == 'TimeZone_Asc')
												{
													echo '<a href="?thermostatSort=TimeZone_Asc" class="sorted">&#9650;<a/>';
												}
												else
												{
													echo '<a href="?thermostatSort=TimeZone_Asc">&#9650;<a/>';
												}

												if (isset($thermostatSort) && $thermostatSort == 'TimeZone_Desc')
												{
													echo '<a href="?thermostatSort=TimeZone_Desc" class="sorted">&#9660;</a>';
												}
												else
												{
													echo '<a href="?thermostatSort=TimeZone_Desc">&#9660;</a>';
												}
											?>

										</th>

										<?php $GRCHM_CLM8 = $resourcesPageLevel->FindResourceByCode('GRCHM$CLM8'); ?>

										<th>

											<div><?php echo $GRCHM_CLM8->Value; ?></div>

										</th>

										<th colspan="2"><div>&nbsp;</div></th>

									</tr>

									<?php
										$counter = 1;

										foreach ($thermostats as $thermostat)
										{
//								if($thermostat->LowTempAlarm == 3 || $thermostat->HighTempAlarm == 3 || $thermostat->HighHumidityAlarm == 3 ||
//									$thermostat->FilterReminder == 2)
//								{
//									$title = '';
//
//									if($thermostat->LowTempAlarm == 3)
//									{
//										$title .= 'Low Temperature Alert!&nbsp;';
//									}
//
//									if($thermostat->HighTempAlarm == 3)
//									{
//										$title .= 'High Temperature Alert!&nbsp;';
//									}
//
//									if($thermostat->HighHumidityAlarm == 3)
//									{
//										$title .= 'High Humidity Alert!&nbsp;';
//									}
//
//									if($thermostat->FilterReminder == 2)
//									{
//										$title .= 'Filter Change Required';
//									}
//
//									if($thermostat->LowTempAlarm == 3 || $thermostat->HighTempAlarm == 3 || $thermostat->HighHumidityAlarm == 3)
//									{
//										echo '<tr id="~'.$thermostat->ID.'~" class="alarm" title="'.$title.'">';
//									}
//									else if(($thermostat->LowTempAlarm == 3 || $thermostat->HighTempAlarm == 3 || $thermostat->HighHumidityAlarm == 3) &&
//										$thermostat->FilterReminder == 2)
//									{
//										echo '<tr id="~'.$thermostat->ID.'~" class="filterreminder" title="'.$title.'">';
//									}
//									else
//									{
//										echo '<tr id="~'.$thermostat->ID.'~" class="filterreminder" title="'.$title.'">';
//									}
//								}
											if ($counter % 2 == 0)
											{
												echo '<tr id="~' . $thermostat->ID . '~" class="alt">';
											}
											else
											{
												echo '<tr id="~' . $thermostat->ID . '~">';
											}

											echo '<td>';
											echo '<input type="checkbox" id="Select_' . $thermostat->ID . '" onclick="toggleSelectThermostat(this);" />';
											echo '</td>';
											echo '<td>';

											$GRCHM_HLK3 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK3');
											echo '<a href="javascript:void(0);" id="Edit_' . $thermostat->ID . '" onclick="editThermostat(' . $thermostat->ID . ');" class="' . $GRCHM_HLK3->StyleClass . '">' . $GRCHM_HLK3->Value . '</a>';

											$GRCHM_HLK4 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK4');
											echo '<a href="javascript:void(0);" id="Update_' . $thermostat->ID . '" onclick="updateThermostat(' . $thermostat->ID . ');" class="' . $GRCHM_HLK4->StyleClass . '">' . $GRCHM_HLK4->Value . '</a>';

											$GRCHM_HLK5 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK5');
											echo '&nbsp;<a href="javascript:void(0);" id="Cancel_' . $thermostat->ID . '" onclick="cancelEditThermostat(' . $thermostat->ID . ');" class="' . $GRCHM_HLK5->StyleClass . '">' . $GRCHM_HLK5->Value . '</a>';

											echo '</td>';
											echo '<td>';
											echo '<span>' . $counter . '.&nbsp;</span>';
											echo '</td>';
											echo '<td><span>' . $thermostat->DeviceName . '</span></td>';
											echo '<td><span>' . $thermostat->SiteName . '</span></td>';
											echo '<td><span>' . $thermostat->ModelNumber . '</span></td>';
											echo '<td><span id="Group_' . $thermostat->ID . '_Span">' . $thermostat->Group->Name . '</span>';

											echo '<select id="Group_' . $thermostat->ID . '_Input" class="view">';

											echo Common::ConstructGroupDDLItems($thermostat->Group->ID);

											echo '</select>';

											echo '</td>';
											echo '<td><span id="Name_' . $thermostat->ID . '_Span" class="view">' . $thermostat->JUTName . '</span><input type="text" id="Name_' . $thermostat->ID . '_Input" value="' . $thermostat->JUTName . '" class="view" /></td>';
											echo '<td><span id="Description_' . $thermostat->ID . '_Span" class="view">' . $thermostat->Description . '</span><input type="text" id="Description_' . $thermostat->ID . '_Input" value="' . $thermostat->Description . '" class="view" /></td>';
											echo '<td><span id="Host_' . $thermostat->ID . '_Span" class="view">' . $thermostat->Host . '</span><input type="text" id="Host_' . $thermostat->ID . '_Input" value="' . $thermostat->Host . '" class="view" onkeyup="RestrictToDomainChars(this);" /></td>';
											echo '<td><span id="Port_' . $thermostat->ID . '_Span" class="view">' . $thermostat->Port . '</span><input type="text" id="Port_' . $thermostat->ID . '_Input" value="' . $thermostat->Port . '" class="view" onkeyup="RestrictToInteger(this);" /></td>';
											echo '<td><span id="TimeZoneOffset_' . $thermostat->ID . '_Span" class="view">' . $thermostat->TimeZoneOffset->Description . '</span>';

											echo '<select id="TimeZoneOffset_' . $thermostat->ID . '_Input" class="view">';

											echo Common::ConstructTZODDLItems($thermostat->TimeZoneOffset->ID);

											echo '</select>';

											echo '</td>';

											$resourcesGRCHM_CLM8 = new ResourceCollection(true, 'GRCHM$CLM8', null, 1, true);

											if ($thermostat->AuthString)
											{
												$GRCHM_CLM8_HLK1 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$HLK1');
												echo '<td><a href="javascript:void(0);" id="ChangeAuthInfo_' . $thermostat->ID . '" onclick="getAuthInfo(' . $thermostat->ID . ', this);" class="' . $GRCHM_CLM8_HLK1->StyleClass . '">' . $GRCHM_CLM8_HLK1->Value . '</a></td>';
											}
											else
											{
												$GRCHM_CLM8_HLK2 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$HLK2');
												echo '<td><a href="javascript:void(0);" id="SetAuthInfo_' . $thermostat->ID . '" onclick="toggleAuthInfo(true, ' . $thermostat->ID . ', this);" class="' . $GRCHM_CLM8_HLK2->StyleClass . '">' . $GRCHM_CLM8_HLK2->Value . '</a></td>';
											}

											$GRCHM_HLK6 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK6');
											$GRCHM_HLK7 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK7');
											echo '<td><a href="javascript:void(0);" id="View_' . $thermostat->ID . '" onclick="populateForm(' . $thermostat->ID . ', true);" class="' . $GRCHM_HLK6->StyleClass . '">' . $GRCHM_HLK6->Value . '</a><span id="CurrView_' . $thermostat->ID . '" class="' . $GRCHM_HLK7->StyleClass . '">' . $GRCHM_HLK7->Value . '</span>';

											$GRCHM_LBL5 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL5');
											$GRCHM_LBL6 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL6');
											$GRCHM_LBL7 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL7');
											echo '<span id="Success_' . $thermostat->ID . '" class="' . $GRCHM_LBL5->StyleClass . '">' . $GRCHM_LBL5->Value . '</span><span id="Failure_' . $thermostat->ID . '" class="' . $GRCHM_LBL6->StyleClass . '">' . $GRCHM_LBL6->Value . '</span><span id="NoTrans_' . $thermostat->ID . '" class="' . $GRCHM_LBL7->StyleClass . '">' . $GRCHM_LBL7->Value . '</span></td>';

											$GRCHM_HLK8 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK8');
											echo '<td><a href="javascript:void(0);" id="Delete_' . $thermostat->ID . '" onclick="deleteThermostat(' . $thermostat->ID . ');" class="' . $GRCHM_HLK8->StyleClass . '">' . $GRCHM_HLK8->Value . '</a></td>';

											echo '</tr>';

											$counter++;
										}

										if ($counter <= $currentUser->MaxTherms)
										{
											echo '<tr id="addrow">';

											$GRCHM_HLK2 = $resourcesPageLevel->FindResourceByCode('GRCHM$HLK2');
											echo '<td colspan="6">';

											$GRCHM_LBL2 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL2');
											echo '<div><span class="' . $GRCHM_LBL2->StyleClass . '">' . $GRCHM_LBL2->Value . '</span></div>';

											echo '</td>';

											echo '<td>';

											echo '<select id="Group_0_Input" class="required">';

											echo Common::ConstructGroupDDLItems();

											echo '</select>';

											echo '</td>';

											echo '<td><input type="text" id="Name_0_Input" class="required" /></td>';
											echo '<td><input type="text" id="Description_0_Input" /></td>';
											echo '<td><input type="text" id="Host_0_Input" class="required" onkeyup="RestrictToDomainChars(this);" /></td>';
											echo '<td><input type="text" id="Port_0_Input" class="portinput required" onkeyup="return RestrictToInteger(this);" /></td>';
											echo '<td>';

											echo '<select id="TimeZoneOffset_0_Input" class="required">';

											echo Common::ConstructTZODDLItems();

											echo '</select>';

											echo '</td>';

											echo '<td id="addlinkcell" colspan="4"><a href="javascript:void(0);" onclick="addThermostat();" class="' . $GRCHM_HLK2->StyleClass . '">' . $GRCHM_HLK2->Value . '</a></td>';
											echo '</tr>';
										}
									?>

								</table>

								<?php
									$GRCHM_BTN2 = $resourcesPageLevel->FindResourceByCode('GRCHM$BTN2');
									echo '<input type="button" value="' . $GRCHM_BTN2->Value . '" class="' . $GRCHM_BTN2->StyleClass . '" onclick="setTime();" />';

									$GRCHM_LBL8 = $resourcesPageLevel->FindResourceByCode('GRCHM$LBL8');
									$currentDateTime = new DateTime();
									echo '&nbsp;&nbsp;<span id="currdatetime">' . str_replace('{0}', $currentDateTime->format(DateTime::RFC822), $GRCHM_LBL8->Value) . '</span>';
								?>

							</div>

							<form id="tstat" name="tstat" action="javascript:submitForm();" method="POST">

								<!-- HVAC Settings -->

								<div id="hvacsettingssection" class="section half-width">

									<div class="sectionheader">

										<?php
											$GRCHM_HDR1 = $resourcesPageLevel->FindResourceByCode('GRCHM$HDR1');
											echo '<span class="' . $GRCHM_HDR1->StyleClass . '">' . $GRCHM_HDR1->Value . '</span>';

											$resourcesGRCHM_HDR1 = new ResourceCollection(true, $GRCHM_HDR1->Code, false, 1, true);
										?>

									</div>

									<div class="sectioninner quarter-height">

										<?php
											$GRCHM_HDR1 = $resourcesPageLevel->FindResourceByCode('GRCHM$HDR1');

											$resourcesGRCHM_HDR1 = new ResourceCollection(true, $GRCHM_HDR1->Code, false, 1, true);

											//build hvac table
											//column 1
											$GRCHM_HDR1_LBL1 = $resourcesGRCHM_HDR1->FindResourceByCode('GRCHM$HDR1$LBL1');
											$headers[] = $GRCHM_HDR1_LBL1->Value;
											$columnValue = '<select id="hvacmode" name="OID4.1.1" class="fieldvalue" onchange="setHVACModeDDLBackground(this);">';
											$resourcesGRCHM_HDR1_LBL1 = new ResourceCollection(true, $GRCHM_HDR1_LBL1->Code, true, 1, true);

											foreach ($resourcesGRCHM_HDR1_LBL1 as $ddi)
											{
												$columnValue .= '<option value="' . $ddi->DropDownItemValue . '" class="' . $ddi->StyleClass . '">' . $ddi->Value . '</option>';
											}

											$columnValue .= '</select>';
											$values[] = $columnValue;

											//column 2
											$GRCHM_HDR1_LBL2 = $resourcesGRCHM_HDR1->FindResourceByCode('GRCHM$HDR1$LBL2');
											$headers[] = $GRCHM_HDR1_LBL2->Value . '</label>';
											$columnValue = '<select id="fanmode" name="OID4.1.3" class="fieldvalue">';
											$resourcesGRCHM_HDR1_LBL2 = new ResourceCollection(true, $GRCHM_HDR1_LBL2->Code, true, 1, true);

											foreach ($resourcesGRCHM_HDR1_LBL2 as $ddi)
											{
												$columnValue .= '<option value="' . $ddi->DropDownItemValue . '" class="' . $ddi->StyleClass . '">' . $ddi->Value . '</option>';
											}

											$columnValue .= '</select>';
											$values[] = $columnValue;

											//column 3
											$GRCHM_HDR1_LBL3 = $resourcesGRCHM_HDR1->FindResourceByCode('GRCHM$HDR1$LBL3');
											$headers[] = $GRCHM_HDR1_LBL3->Value;
											$columnValue = '<select id="setbackstatus" name="OID4.1.9" class="fieldvalue">';
											$resourcesGRCHM_HDR1_LBL3 = new ResourceCollection(true, $GRCHM_HDR1_LBL3->Code, true, 1, true);

											foreach ($resourcesGRCHM_HDR1_LBL3 as $ddi)
											{
												$columnValue .= '<option value="' . $ddi->DropDownItemValue . '" class="' . $ddi->StyleClass . '">' . $ddi->Value . '</option>';
											}

											$columnValue .= '</select>';
											$values[] = $columnValue;

											//column 4
											$GRCHM_HDR1_LBL4 = $resourcesGRCHM_HDR1->FindResourceByCode('GRCHM$HDR1$LBL4');
											$headers[] = $GRCHM_HDR1_LBL4->Value . '</label>';
											$columnValue = '<select id="setbackheat" name="OID4.1.5" class="fieldvalue">';

											for ($i = 99; $i >= 40; $i--)
											{
												$columnValue .= '<option value="' . ($i * 10) . '">' . $i . '</option>';
											}

											$columnValue .= '</select>';
											$values[] = $columnValue;

											//column 5
											$GRCHM_HDR1_LBL5 = $resourcesGRCHM_HDR1->FindResourceByCode('GRCHM$HDR1$LBL5');
											$headers[] = $GRCHM_HDR1_LBL5->Value;
											$columnValue = '<select id="setbackcool" name="OID4.1.6" class="fieldvalue">';

											for ($i = 99; $i >= 40; $i--)
											{
												$columnValue .= '<option value="' . ($i * 10) . '">' . $i . '</option>';
											}

											$columnValue .='</select>';
											$values[] = $columnValue;

											echo '<table class="settings maximum-width">';

											echo '<tr class="header">';

											foreach ($headers as $header)
											{
												echo '<th> ' . $header . '</th>';
											}

											echo '</tr>';
											echo '<tr>';

											foreach ($values as $value)
											{
												echo '<td>' . $value . '</td>';
											}

											echo '</tr></table>';
										?>

									</div>

								</div>

								<!-- Sensor Settings -->

								<div id="sensorsettingssection" class="section half-width" >

									<div class="sectionheader">

										<?php
											$GRCHM_HDR3 = $resourcesPageLevel->FindResourceByCode('GRCHM$HDR3');
											echo '<span class="' . $GRCHM_HDR3->StyleClass . '">' . $GRCHM_HDR3->Value . '</span>';

											$resourcesGRCHM_HDR3 = new ResourceCollection(true, $GRCHM_HDR3->Code, false, 1, true);
										?>

									</div>

									<div class="sectioninner quarter-height">

										<?php
											echo '<table class="settings maximum-width">';

											echo '<tr class="header">';

											echo '<th class="empty">&nbsp;</th>';

											$GRCHM_HDR3_CLM1 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$CLM1');
											$GRCHM_HDR3_CLM2 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$CLM2');
											$GRCHM_HDR3_CLM3 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$CLM3');

											echo '<th>' . $GRCHM_HDR3_CLM1->Value . '</th>';
											echo '<th>' . $GRCHM_HDR3_CLM2->Value . '</th>';
											echo '<th>' . $GRCHM_HDR3_CLM3->Value . '</th>';

											echo '</tr>';

											$GRCHM_HDR3_LBL1 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$LBL1');
											$GRCHM_HDR3_LBL2 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$LBL2');
											$GRCHM_HDR3_LBL3 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$LBL3');
											$GRCHM_HDR3_DDI1 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$DDI1');
											$GRCHM_HDR3_DDI2 = $resourcesGRCHM_HDR3->FindResourceByCode('GRCHM$HDR3$DDI2');

											echo '<tr>';

											echo '<td class="' . $GRCHM_HDR3_LBL1->StyleClass . '">' . $GRCHM_HDR3_LBL1->Value . '</td>';
											echo '<td>';
											echo '<select id="localsensorstate" name="OID4.3.6.1" class="fieldvalue" onchange="setAveraging(\'L\', this.value);">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>';
											echo '<select id="localsensoraverage" name="OID4.3.8.1" class="fieldvalue">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>&nbsp;</td>';

											echo '</tr>';
											echo '<tr>';

											echo '<td class="' . $GRCHM_HDR3_LBL2->StyleClass . '">' . $GRCHM_HDR3_LBL2->Value . '</td>';
											echo '<td>';
											echo '<select id="remotesensor1state" name="OID4.3.6.2" class="fieldvalue" onchange="setAveraging(\'R1\', this.value);">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>';
											echo '<select id="remotesensor1average" name="OID4.3.8.2" class="fieldvalue">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>';

											echo '<select id="remotesensor1correction" name="OID4.3.4.2" class="fieldvalue">';

											for ($i = 50; $i >= -50; $i -= 5)
											{
												echo '<option value="' . $i . '">' . ($i / 10) . '</option>';
											}

											echo '</select>';

											echo '</td>';

											echo '</tr>';
											echo '<tr>';

											echo '<td class="' . $GRCHM_HDR3_LBL3->StyleClass . '">' . $GRCHM_HDR3_LBL3->Value . '</td>';
											echo '<td>';
											echo '<select id="remotesensor2state" name="OID4.3.6.3" class="fieldvalue" onchange="setAveraging(\'R2\', this.value);">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>';
											echo '<select id="remotesensor2average" name="OID4.3.8.3" class="fieldvalue">';
											echo '<option value="' . $GRCHM_HDR3_DDI1->DropDownItemValue . '">' . $GRCHM_HDR3_DDI1->Value . '</option>';
											echo '<option value="' . $GRCHM_HDR3_DDI2->DropDownItemValue . '">' . $GRCHM_HDR3_DDI2->Value . '</option>';
											echo '</select>';
											echo '</td>';
											echo '<td>';

											echo '<select id="remotesensor2correction" name="OID4.3.4.3" class="fieldvalue">';

											for ($i = 50; $i >= -50; $i -= 5)
											{
												echo '<option value="' . $i . '">' . ($i / 10) . '</option>';
											}

											echo '</select>';

											echo '</td>';

											echo '</tr>';

											echo '</table>';
										?>

									</div>

								</div>

								<!--<div class="clearleft"></div>-->

								<!-- Setback Scheduling -->

								<div class="section">

									<div class="sectionheader">

										<?php
											$GRCHM_HDR2 = $resourcesPageLevel->FindResourceByCode('GRCHM$HDR2');
											echo '<span class="' . $GRCHM_HDR2->StyleClass . '">' . $GRCHM_HDR2->Value . '</span>';

											$resourcesGRCHM_HDR2 = new ResourceCollection(true, $GRCHM_HDR2->Code, false, 1, true);
										?>

									</div>

									<div class="sectioninner">

										<div class="subsection">

											<?php
												$GRCHM_HDR2_CPT1 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CPT1');
												echo '<span class="' . $GRCHM_HDR2_CPT1->StyleClass . '">' . $GRCHM_HDR2_CPT1->Value . '</span>';
											?>

											<table id="dayclasstable" class="maximun-width">

												<tr id="dayclassheader1">

													<th class="empty">&nbsp;</th>

													<?php
														$GRCHM_HDR2_CLM1 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM1');
														$GRCHM_HDR2_CLM2 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM2');
														$GRCHM_HDR2_CLM3 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM3');

														echo '<th colspan="4" class="' . $GRCHM_HDR2_CLM1->StyleClass . '">' . $GRCHM_HDR2_CLM1->Value . '</th>';
														echo '<th colspan="4" class="' . $GRCHM_HDR2_CLM2->StyleClass . '">' . $GRCHM_HDR2_CLM2->Value . '</th>';
														echo '<th colspan="4" class="' . $GRCHM_HDR2_CLM3->StyleClass . '">' . $GRCHM_HDR2_CLM3->Value . '</th>';
													?>

												</tr>

												<tr id="dayclassheader2" class="header">

													<?php
														$GRCHM_HDR2_SCL1 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$SCL1');
														$GRCHM_HDR2_SCL2 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$SCL2');
														$GRCHM_HDR2_SCL3 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$SCL3');
														$GRCHM_HDR2_SCL4 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$SCL4');
														$GRCHM_HDR2_SCL5 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$SCL5');

														echo '<th>' . $GRCHM_HDR2_SCL1->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL2->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL3->StyleClass . '">' . $GRCHM_HDR2_SCL3->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL4->StyleClass . '">' . $GRCHM_HDR2_SCL4->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL5->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL2->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL3->StyleClass . '">' . $GRCHM_HDR2_SCL3->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL4->StyleClass . '">' . $GRCHM_HDR2_SCL4->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL5->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL2->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL3->StyleClass . '">' . $GRCHM_HDR2_SCL3->Value . '</th>';
														echo '<th class="' . $GRCHM_HDR2_SCL4->StyleClass . '">' . $GRCHM_HDR2_SCL4->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_SCL5->Value . '</th>';
													?>

												</tr>

												<?php
													$GRCHM_HDR2_LBL1 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$LBL1');
													$GRCHM_HDR2_LBL2 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$LBL2');
													$GRCHM_HDR2_LBL3 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$LBL3');
													$GRCHM_HDR2_LBL4 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$LBL4');

													for ($i = 1; $i <= 4; $i++)
													{
														echo '<tr>';

														switch ($i)
														{
															case 1:

																echo '<td class="' . $GRCHM_HDR2_LBL1->StyleClass . '">' . $GRCHM_HDR2_LBL1->Value . '</td>';

																break;

															case 2:

																echo '<td class="' . $GRCHM_HDR2_LBL2->StyleClass . '">' . $GRCHM_HDR2_LBL2->Value . '</td>';

																break;

															case 3:

																echo '<td class="' . $GRCHM_HDR2_LBL3->StyleClass . '">' . $GRCHM_HDR2_LBL3->Value . '</td>';

																break;

															case 4:

																echo '<td class="' . $GRCHM_HDR2_LBL4->StyleClass . '">' . $GRCHM_HDR2_LBL4->Value . '</td>';

																break;
														}

														for ($j = 1; $j <= 3; $j++)
														{
															echo '<td id="OID4.4.1.3.' . $j . '.' . $i . '">';

															echo '<select id="setbackPeriodHour' . $j . '.' . $i . '">';

															for ($k = 1; $k <= 12; $k++)
															{
																echo '<option value="' . $k . '">' . $k . '</option>';
															}

															echo '</select>&nbsp;';

															echo '<select id="setbackPeriodMinute' . $j . '.' . $i . '">';

															for ($k = 0; $k <= 55; $k += 5)
															{
																if ($k < 10)
																{
																	echo '<option value="0' . $k . '">0' . $k . '</option>';
																}
																else
																{
																	echo '<option value="' . $k . '">' . $k . '</option>';
																}
															}

															echo '</select>&nbsp;';

															echo '<div>';
															echo '<input type="radio" id="setbackPeriodTimeSuffixAM' . $j . '.' . $i . '" name="timesuffix' . $j . '.' . $i . '" value="AM" /><span class="radiobutton">AM</span>&nbsp;&nbsp;';
															echo '<input type="radio" id="setbackPeriodTimeSuffixPM' . $j . '.' . $i . '" name="timesuffix' . $j . '.' . $i . '" value="PM" /><span class="radiobutton">PM</span>';
															echo '</div>';

															echo '</td>';

															echo '<td>';

															echo '<select id="setbackHeat' . $j . '.' . $i . '" name="OID4.4.1.4.' . $j . '.' . $i . '">';

															for ($k = 99; $k >= 40; $k--)
															{
																echo '<option value="' . ($k * 10) . '">' . $k . '</option>';
															}

															echo '</select>';

															echo '</td>';

															echo '<td>';

															echo '<select id="setbackCool' . $j . '.' . $i . '" name="OID4.4.1.5.' . $j . '.' . $i . '">';

															for ($k = 99; $k >= 40; $k--)
															{
																echo '<option value="' . ($k * 10) . '">' . $k . '</option>';
															}

															echo '</select>';

															echo '</td>';

															echo '<td>';

															echo '<select id="setbackFan' . $j . '.' . $i . '" name="OID4.4.1.6.' . $j . '.' . $i . '">';

															$resourcesGRCHM_HDR2_SCL5 = new ResourceCollection(true, $GRCHM_HDR2_SCL5->Code, true, 1, true);

															foreach ($resourcesGRCHM_HDR2_SCL5 as $ddi)
															{
																echo '<option value="' . $ddi->DropDownItemValue . '">' . $ddi->Value . '</option>';
															}

															for ($k = 15; $k <= 45; $k += 15)
															{
																echo '<option value="' . $k . '">' . $k . '</option>';
															}

															echo '</select>';

															echo '</td>';
														}

														echo '</tr>';
													}
												?>

											</table>

										</div>

										<div class="subsection">

											<?php
												$GRCHM_HDR2_CPT2 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CPT2');
												echo '<span class="' . $GRCHM_HDR2_CPT2->StyleClass . '">' . $GRCHM_HDR2_CPT2->Value . '</span>';
											?>

											<table id="defaultclasstable" class="settings maximum-widh">

												<tr class="header">

													<?php
														$GRCHM_HDR2_CLM4 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM4');
														$GRCHM_HDR2_CLM5 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM5');
														$GRCHM_HDR2_CLM6 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM6');
														$GRCHM_HDR2_CLM7 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM7');
														$GRCHM_HDR2_CLM8 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM8');
														$GRCHM_HDR2_CLM9 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM9');
														$GRCHM_HDR2_CLM10 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$CLM10');

														echo '<th>' . $GRCHM_HDR2_CLM4->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM5->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM6->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM7->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM8->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM9->Value . '</th>';
														echo '<th>' . $GRCHM_HDR2_CLM10->Value . '</th>';
													?>

												</tr>

												<tr>

													<?php
														for ($i = 1; $i <= 7; $i++)
														{
															echo '<td>';
															echo '<select name="OID4.4.3.2.' . $i . '" onchange="setDefaultClassDDLBackground(this);">';

															$GRCHM_HDR2_DDI1 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$DDI1');
															$GRCHM_HDR2_DDI2 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$DDI2');
															$GRCHM_HDR2_DDI3 = $resourcesGRCHM_HDR2->FindResourceByCode('GRCHM$HDR2$DDI3');

															echo '<option value="' . $GRCHM_HDR2_DDI1->DropDownItemValue . '" class="' . $GRCHM_HDR2_DDI1->StyleClass . '">' . $GRCHM_HDR2_DDI1->Value . '</option>';
															echo '<option value="' . $GRCHM_HDR2_DDI2->DropDownItemValue . '" class="' . $GRCHM_HDR2_DDI2->StyleClass . '">' . $GRCHM_HDR2_DDI2->Value . '</option>';
															echo '<option value="' . $GRCHM_HDR2_DDI3->DropDownItemValue . '" class="' . $GRCHM_HDR2_DDI3->StyleClass . '">' . $GRCHM_HDR2_DDI3->Value . '</option>';
															echo '</select>';
															echo '</td>';
														}
													?>

												</tr>

											</table>

										</div>

									</div>

								</div>

							</form>

							<div class="section">

								<div class="sectionheader">

									<?php
										$GRCHM_BTN1 = $resourcesPageLevel->FindResourceByCode('GRCHM$BTN1');
										echo '<input type="submit" name="submit" value="' . $GRCHM_BTN1->Value . '" onclick="scrollTo(0, 0); return validateForm();" class="' . $GRCHM_BTN1->StyleClass . '" />';
									?>

								</div>

							</div>

							<div id="authinfo">

								<?php
									$resourcesGRCHM_CLM8 = new ResourceCollection(true, $GRCHM_CLM8->Code, false, 1, true);

									$GRCHM_CLM8_LBL1 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$LBL1');
									$GRCHM_CLM8_LBL2 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$LBL2');
									$GRCHM_CLM8_BTN1 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$BTN1');
									$GRCHM_CLM8_BTN2 = $resourcesGRCHM_CLM8->FindResourceByCode('GRCHM$CLM8$BTN2');
								?>

								<div class="sectioninner">

									<div style="display:block;">

										<label id="UserNameLabel" for="UserName_ThermID_Input" class="<?php echo $GRCHM_CLM8_LBL1->StyleClass; ?>"><?php echo $GRCHM_CLM8_LBL1->Value; ?> </label>

									</div>

									<div style="display:block;">

										<input type="text" id="UserName_ThermID_Input" value="admin" disabled />

									</div>

									<div style="display:block;">

										<label id="PasswordLabel" for="Password_ThermID_Input" class="<?php echo $GRCHM_CLM8_LBL2->StyleClass; ?>"><?php echo $GRCHM_CLM8_LBL2->Value; ?> </label>

									</div>

									<div style="display:block;">

										<input type="password" id="Password_ThermID_Input" />

									</div>

									<div style="margin-top:10px;">

										<div style="float:left;">

											<input type="button" id="AuthInfoSaveButton" value="<?php echo $GRCHM_CLM8_BTN1->Value; ?>" onclick="updateAuthInfo('ThermID');" class="<?php echo $GRCHM_CLM8_BTN1->StyleClass; ?>" />

										</div>

										<div style="float:left;">

											<input type="button" id="AuthInfoCancelButton" value="<?php echo $GRCHM_CLM8_BTN2->Value; ?>" onclick="toggleAuthInfo(false, 'ThermID');" class="<?php echo $GRCHM_CLM8_BTN2->StyleClass; ?>" />

										</div>

									</div>

								</div>

							</div>

						</div>

					</div>

				</div>

			</div>

			<?php
				echo '<script type="text/javascript" defer>window.onload = function(){populateForm(' . $firstthermid . ', false);};</script>';
			?>

			<input type="hidden" id="messageHidden" />
			<input type="hidden" id="tzoDDLItems" />
			<input type="hidden" id="groupDDLItems" />

		</div>

	</body>

</html>
