// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#pragma once

#include <array>
#include <wtf/HashFunctions.h>
#include <wtf/HashTraits.h>

namespace WebCore {

class Settings;

enum CSSPropertyID : uint16_t {
    CSSPropertyInvalid = 0,
    CSSPropertyCustom = 1,
    CSSPropertyColorScheme = 2,
    CSSPropertyMathDepth = 3,
    CSSPropertyRubyPosition = 4,
    CSSPropertyWritingMode = 5,
    CSSPropertyDirection = 6,
    CSSPropertyDisplay = 7,
    CSSPropertyFontFamily = 8,
    CSSPropertyFontFeatureSettings = 9,
    CSSPropertyFontKerning = 10,
    CSSPropertyFontOpticalSizing = 11,
    CSSPropertyFontPalette = 12,
    CSSPropertyFontSize = 13,
    CSSPropertyFontSizeAdjust = 14,
    CSSPropertyFontStyle = 15,
    CSSPropertyFontSynthesisSmallCaps = 16,
    CSSPropertyFontSynthesisStyle = 17,
    CSSPropertyFontSynthesisWeight = 18,
    CSSPropertyFontVariantAlternates = 19,
    CSSPropertyFontVariantCaps = 20,
    CSSPropertyFontVariantEastAsian = 21,
    CSSPropertyFontVariantEmoji = 22,
    CSSPropertyFontVariantLigatures = 23,
    CSSPropertyFontVariantNumeric = 24,
    CSSPropertyFontVariantPosition = 25,
    CSSPropertyFontVariationSettings = 26,
    CSSPropertyFontWeight = 27,
    CSSPropertyFontWidth = 28,
    CSSPropertyTextOrientation = 29,
    CSSPropertyTextRendering = 30,
    CSSPropertyZoom = 31,
    CSSPropertyWebkitFontSmoothing = 32,
    CSSPropertyWebkitLocale = 33,
    CSSPropertyWebkitTextSizeAdjust = 34,
    CSSPropertyWebkitTextZoom = 35,
    CSSPropertyLetterSpacing = 36,
    CSSPropertyTextAutospace = 37,
    CSSPropertyTextSpacingTrim = 38,
    CSSPropertyWordSpacing = 39,
    CSSPropertyBackgroundImage = 40,
    CSSPropertyMaskImage = 41,
    CSSPropertyAccentColor = 42,
    CSSPropertyAdditiveSymbols = 43,
    CSSPropertyAlignContent = 44,
    CSSPropertyAlignItems = 45,
    CSSPropertyAlignSelf = 46,
    CSSPropertyAlignmentBaseline = 47,
    CSSPropertyAnchorName = 48,
    CSSPropertyAnchorScope = 49,
    CSSPropertyAnimationComposition = 50,
    CSSPropertyAnimationDelay = 51,
    CSSPropertyAnimationDirection = 52,
    CSSPropertyAnimationDuration = 53,
    CSSPropertyAnimationFillMode = 54,
    CSSPropertyAnimationIterationCount = 55,
    CSSPropertyAnimationName = 56,
    CSSPropertyAnimationPlayState = 57,
    CSSPropertyAnimationRangeEnd = 58,
    CSSPropertyAnimationRangeStart = 59,
    CSSPropertyAnimationTimeline = 60,
    CSSPropertyAnimationTimingFunction = 61,
    CSSPropertyAppearance = 62,
    CSSPropertyAspectRatio = 63,
    CSSPropertyBackdropFilter = 64,
    CSSPropertyBackfaceVisibility = 65,
    CSSPropertyBackgroundAttachment = 66,
    CSSPropertyBackgroundBlendMode = 67,
    CSSPropertyBackgroundClip = 68,
    CSSPropertyBackgroundColor = 69,
    CSSPropertyBackgroundOrigin = 70,
    CSSPropertyBackgroundPositionX = 71,
    CSSPropertyBackgroundPositionY = 72,
    CSSPropertyBackgroundRepeat = 73,
    CSSPropertyBackgroundSize = 74,
    CSSPropertyBasePalette = 75,
    CSSPropertyBaselineShift = 76,
    CSSPropertyBlockEllipsis = 77,
    CSSPropertyBlockStepAlign = 78,
    CSSPropertyBlockStepInsert = 79,
    CSSPropertyBlockStepRound = 80,
    CSSPropertyBlockStepSize = 81,
    CSSPropertyBorderCollapse = 82,
    CSSPropertyBorderImageOutset = 83,
    CSSPropertyBorderImageRepeat = 84,
    CSSPropertyBorderImageSlice = 85,
    CSSPropertyBorderImageSource = 86,
    CSSPropertyBorderImageWidth = 87,
    CSSPropertyBoxShadow = 88,
    CSSPropertyBoxSizing = 89,
    CSSPropertyBreakAfter = 90,
    CSSPropertyBreakBefore = 91,
    CSSPropertyBreakInside = 92,
    CSSPropertyBufferedRendering = 93,
    CSSPropertyCaptionSide = 94,
    CSSPropertyCaretColor = 95,
    CSSPropertyClear = 96,
    CSSPropertyClip = 97,
    CSSPropertyClipPath = 98,
    CSSPropertyClipRule = 99,
    CSSPropertyColor = 100,
    CSSPropertyColorInterpolation = 101,
    CSSPropertyColorInterpolationFilters = 102,
    CSSPropertyColumnCount = 103,
    CSSPropertyColumnFill = 104,
    CSSPropertyColumnGap = 105,
    CSSPropertyColumnRuleColor = 106,
    CSSPropertyColumnRuleStyle = 107,
    CSSPropertyColumnRuleWidth = 108,
    CSSPropertyColumnSpan = 109,
    CSSPropertyColumnWidth = 110,
    CSSPropertyContain = 111,
    CSSPropertyContainerName = 112,
    CSSPropertyContainerType = 113,
    CSSPropertyContent = 114,
    CSSPropertyContentVisibility = 115,
    CSSPropertyContinue = 116,
    CSSPropertyCounterIncrement = 117,
    CSSPropertyCounterReset = 118,
    CSSPropertyCounterSet = 119,
    CSSPropertyCursor = 120,
    CSSPropertyCx = 121,
    CSSPropertyCy = 122,
    CSSPropertyD = 123,
    CSSPropertyDominantBaseline = 124,
    CSSPropertyDynamicRangeLimit = 125,
    CSSPropertyEmptyCells = 126,
    CSSPropertyFallback = 127,
    CSSPropertyFieldSizing = 128,
    CSSPropertyFill = 129,
    CSSPropertyFillOpacity = 130,
    CSSPropertyFillRule = 131,
    CSSPropertyFilter = 132,
    CSSPropertyFlexBasis = 133,
    CSSPropertyFlexDirection = 134,
    CSSPropertyFlexGrow = 135,
    CSSPropertyFlexShrink = 136,
    CSSPropertyFlexWrap = 137,
    CSSPropertyFloat = 138,
    CSSPropertyFloodColor = 139,
    CSSPropertyFloodOpacity = 140,
    CSSPropertyFontDisplay = 141,
    CSSPropertyGlyphOrientationHorizontal = 142,
    CSSPropertyGlyphOrientationVertical = 143,
    CSSPropertyGridAutoColumns = 144,
    CSSPropertyGridAutoFlow = 145,
    CSSPropertyGridAutoRows = 146,
    CSSPropertyGridColumnEnd = 147,
    CSSPropertyGridColumnStart = 148,
    CSSPropertyGridRowEnd = 149,
    CSSPropertyGridRowStart = 150,
    CSSPropertyGridTemplateAreas = 151,
    CSSPropertyGridTemplateColumns = 152,
    CSSPropertyGridTemplateRows = 153,
    CSSPropertyHangingPunctuation = 154,
    CSSPropertyHyphenateCharacter = 155,
    CSSPropertyHyphens = 156,
    CSSPropertyImageOrientation = 157,
    CSSPropertyImageRendering = 158,
    CSSPropertyInherits = 159,
    CSSPropertyInitialValue = 160,
    CSSPropertyInputSecurity = 161,
    CSSPropertyIsolation = 162,
    CSSPropertyJustifyContent = 163,
    CSSPropertyJustifyItems = 164,
    CSSPropertyJustifySelf = 165,
    CSSPropertyLightingColor = 166,
    CSSPropertyLineBreak = 167,
    CSSPropertyLineFitEdge = 168,
    CSSPropertyLineHeight = 169,
    CSSPropertyListStyleImage = 170,
    CSSPropertyListStylePosition = 171,
    CSSPropertyListStyleType = 172,
    CSSPropertyMarginTrim = 173,
    CSSPropertyMarkerEnd = 174,
    CSSPropertyMarkerMid = 175,
    CSSPropertyMarkerStart = 176,
    CSSPropertyMaskBorderOutset = 177,
    CSSPropertyMaskBorderRepeat = 178,
    CSSPropertyMaskBorderSlice = 179,
    CSSPropertyMaskBorderSource = 180,
    CSSPropertyMaskBorderWidth = 181,
    CSSPropertyMaskClip = 182,
    CSSPropertyMaskComposite = 183,
    CSSPropertyMaskMode = 184,
    CSSPropertyMaskOrigin = 185,
    CSSPropertyMaskRepeat = 186,
    CSSPropertyMaskSize = 187,
    CSSPropertyMaskType = 188,
    CSSPropertyMathShift = 189,
    CSSPropertyMathStyle = 190,
    CSSPropertyMaxLines = 191,
    CSSPropertyMixBlendMode = 192,
    CSSPropertyNavigation = 193,
    CSSPropertyNegative = 194,
    CSSPropertyObjectFit = 195,
    CSSPropertyObjectPosition = 196,
    CSSPropertyOffsetAnchor = 197,
    CSSPropertyOffsetDistance = 198,
    CSSPropertyOffsetPath = 199,
    CSSPropertyOffsetPosition = 200,
    CSSPropertyOffsetRotate = 201,
    CSSPropertyOpacity = 202,
    CSSPropertyOrder = 203,
    CSSPropertyOrphans = 204,
    CSSPropertyOutlineColor = 205,
    CSSPropertyOutlineOffset = 206,
    CSSPropertyOutlineStyle = 207,
    CSSPropertyOutlineWidth = 208,
    CSSPropertyOverflowAnchor = 209,
    CSSPropertyOverflowWrap = 210,
    CSSPropertyOverrideColors = 211,
    CSSPropertyPad = 212,
    CSSPropertyPage = 213,
    CSSPropertyPaintOrder = 214,
    CSSPropertyPerspective = 215,
    CSSPropertyPerspectiveOriginX = 216,
    CSSPropertyPerspectiveOriginY = 217,
    CSSPropertyPointerEvents = 218,
    CSSPropertyPosition = 219,
    CSSPropertyPositionAnchor = 220,
    CSSPropertyPositionArea = 221,
    CSSPropertyPositionTryFallbacks = 222,
    CSSPropertyPositionTryOrder = 223,
    CSSPropertyPositionVisibility = 224,
    CSSPropertyPrefix = 225,
    CSSPropertyPrintColorAdjust = 226,
    CSSPropertyQuotes = 227,
    CSSPropertyR = 228,
    CSSPropertyRange = 229,
    CSSPropertyResize = 230,
    CSSPropertyResult = 231,
    CSSPropertyRotate = 232,
    CSSPropertyRowGap = 233,
    CSSPropertyRubyAlign = 234,
    CSSPropertyRubyOverhang = 235,
    CSSPropertyRx = 236,
    CSSPropertyRy = 237,
    CSSPropertyScale = 238,
    CSSPropertyScrollBehavior = 239,
    CSSPropertyScrollSnapAlign = 240,
    CSSPropertyScrollSnapStop = 241,
    CSSPropertyScrollSnapType = 242,
    CSSPropertyScrollTimelineAxis = 243,
    CSSPropertyScrollTimelineName = 244,
    CSSPropertyScrollbarColor = 245,
    CSSPropertyScrollbarGutter = 246,
    CSSPropertyScrollbarWidth = 247,
    CSSPropertyShapeImageThreshold = 248,
    CSSPropertyShapeMargin = 249,
    CSSPropertyShapeOutside = 250,
    CSSPropertyShapeRendering = 251,
    CSSPropertySize = 252,
    CSSPropertySizeAdjust = 253,
    CSSPropertySpeakAs = 254,
    CSSPropertySrc = 255,
    CSSPropertyStopColor = 256,
    CSSPropertyStopOpacity = 257,
    CSSPropertyStroke = 258,
    CSSPropertyStrokeColor = 259,
    CSSPropertyStrokeDasharray = 260,
    CSSPropertyStrokeDashoffset = 261,
    CSSPropertyStrokeLinecap = 262,
    CSSPropertyStrokeLinejoin = 263,
    CSSPropertyStrokeMiterlimit = 264,
    CSSPropertyStrokeOpacity = 265,
    CSSPropertyStrokeWidth = 266,
    CSSPropertySuffix = 267,
    CSSPropertySymbols = 268,
    CSSPropertySyntax = 269,
    CSSPropertySystem = 270,
    CSSPropertyTabSize = 271,
    CSSPropertyTableLayout = 272,
    CSSPropertyTextAlign = 273,
    CSSPropertyTextAlignLast = 274,
    CSSPropertyTextAnchor = 275,
    CSSPropertyTextBoxEdge = 276,
    CSSPropertyTextBoxTrim = 277,
    CSSPropertyTextCombineUpright = 278,
    CSSPropertyTextDecorationColor = 279,
    CSSPropertyTextDecorationLine = 280,
    CSSPropertyTextDecorationSkipInk = 281,
    CSSPropertyTextDecorationStyle = 282,
    CSSPropertyTextDecorationThickness = 283,
    CSSPropertyTextEmphasisColor = 284,
    CSSPropertyTextEmphasisPosition = 285,
    CSSPropertyTextEmphasisStyle = 286,
    CSSPropertyTextGroupAlign = 287,
    CSSPropertyTextIndent = 288,
    CSSPropertyTextJustify = 289,
    CSSPropertyTextOverflow = 290,
    CSSPropertyTextShadow = 291,
    CSSPropertyTextTransform = 292,
    CSSPropertyTextUnderlineOffset = 293,
    CSSPropertyTextUnderlinePosition = 294,
    CSSPropertyTextWrapMode = 295,
    CSSPropertyTextWrapStyle = 296,
    CSSPropertyTimelineScope = 297,
    CSSPropertyTouchAction = 298,
    CSSPropertyTransform = 299,
    CSSPropertyTransformBox = 300,
    CSSPropertyTransformOriginX = 301,
    CSSPropertyTransformOriginY = 302,
    CSSPropertyTransformOriginZ = 303,
    CSSPropertyTransformStyle = 304,
    CSSPropertyTransitionBehavior = 305,
    CSSPropertyTransitionDelay = 306,
    CSSPropertyTransitionDuration = 307,
    CSSPropertyTransitionProperty = 308,
    CSSPropertyTransitionTimingFunction = 309,
    CSSPropertyTranslate = 310,
    CSSPropertyTypes = 311,
    CSSPropertyUnicodeBidi = 312,
    CSSPropertyUnicodeRange = 313,
    CSSPropertyVectorEffect = 314,
    CSSPropertyVerticalAlign = 315,
    CSSPropertyViewTimelineAxis = 316,
    CSSPropertyViewTimelineInset = 317,
    CSSPropertyViewTimelineName = 318,
    CSSPropertyViewTransitionClass = 319,
    CSSPropertyViewTransitionName = 320,
    CSSPropertyVisibility = 321,
    CSSPropertyWhiteSpaceCollapse = 322,
    CSSPropertyWidows = 323,
    CSSPropertyWillChange = 324,
    CSSPropertyWordBreak = 325,
    CSSPropertyX = 326,
    CSSPropertyY = 327,
    CSSPropertyZIndex = 328,
    CSSPropertyAppleColorFilter = 329,
    CSSPropertyApplePayButtonStyle = 330,
    CSSPropertyApplePayButtonType = 331,
    CSSPropertyAppleVisualEffect = 332,
    CSSPropertyInternalTextAutosizingStatus = 333,
    CSSPropertyWebkitBackdropFilter = 334,
    CSSPropertyWebkitBackgroundClip = 335,
    CSSPropertyWebkitBackgroundOrigin = 336,
    CSSPropertyWebkitBorderHorizontalSpacing = 337,
    CSSPropertyWebkitBorderVerticalSpacing = 338,
    CSSPropertyWebkitBoxAlign = 339,
    CSSPropertyWebkitBoxDecorationBreak = 340,
    CSSPropertyWebkitBoxDirection = 341,
    CSSPropertyWebkitBoxFlex = 342,
    CSSPropertyWebkitBoxFlexGroup = 343,
    CSSPropertyWebkitBoxLines = 344,
    CSSPropertyWebkitBoxOrdinalGroup = 345,
    CSSPropertyWebkitBoxOrient = 346,
    CSSPropertyWebkitBoxPack = 347,
    CSSPropertyWebkitBoxReflect = 348,
    CSSPropertyWebkitBoxShadow = 349,
    CSSPropertyWebkitColumnAxis = 350,
    CSSPropertyWebkitColumnProgression = 351,
    CSSPropertyWebkitCursorVisibility = 352,
    CSSPropertyWebkitFontSizeDelta = 353,
    CSSPropertyWebkitHyphenateLimitAfter = 354,
    CSSPropertyWebkitHyphenateLimitBefore = 355,
    CSSPropertyWebkitHyphenateLimitLines = 356,
    CSSPropertyWebkitInitialLetter = 357,
    CSSPropertyWebkitLineAlign = 358,
    CSSPropertyWebkitLineBoxContain = 359,
    CSSPropertyWebkitLineClamp = 360,
    CSSPropertyWebkitLineGrid = 361,
    CSSPropertyWebkitLineSnap = 362,
    CSSPropertyWebkitMarqueeDirection = 363,
    CSSPropertyWebkitMarqueeIncrement = 364,
    CSSPropertyWebkitMarqueeRepetition = 365,
    CSSPropertyWebkitMarqueeSpeed = 366,
    CSSPropertyWebkitMarqueeStyle = 367,
    CSSPropertyWebkitMaskClip = 368,
    CSSPropertyWebkitMaskComposite = 369,
    CSSPropertyWebkitMaskPositionX = 370,
    CSSPropertyWebkitMaskPositionY = 371,
    CSSPropertyWebkitMaskSourceType = 372,
    CSSPropertyWebkitNbspMode = 373,
    CSSPropertyWebkitRtlOrdering = 374,
    CSSPropertyWebkitRubyPosition = 375,
    CSSPropertyWebkitTapHighlightColor = 376,
    CSSPropertyWebkitTextCombine = 377,
    CSSPropertyWebkitTextDecorationsInEffect = 378,
    CSSPropertyWebkitTextFillColor = 379,
    CSSPropertyWebkitTextSecurity = 380,
    CSSPropertyWebkitTextStrokeColor = 381,
    CSSPropertyWebkitTextStrokeWidth = 382,
    CSSPropertyWebkitUserDrag = 383,
    CSSPropertyWebkitUserModify = 384,
    CSSPropertyWebkitUserSelect = 385,
    CSSPropertyBorderBottomColor = 386,
    CSSPropertyBorderBottomLeftRadius = 387,
    CSSPropertyBorderBottomRightRadius = 388,
    CSSPropertyBorderBottomStyle = 389,
    CSSPropertyBorderBottomWidth = 390,
    CSSPropertyBorderLeftColor = 391,
    CSSPropertyBorderLeftStyle = 392,
    CSSPropertyBorderLeftWidth = 393,
    CSSPropertyBorderRightColor = 394,
    CSSPropertyBorderRightStyle = 395,
    CSSPropertyBorderRightWidth = 396,
    CSSPropertyBorderTopColor = 397,
    CSSPropertyBorderTopLeftRadius = 398,
    CSSPropertyBorderTopRightRadius = 399,
    CSSPropertyBorderTopStyle = 400,
    CSSPropertyBorderTopWidth = 401,
    CSSPropertyBottom = 402,
    CSSPropertyContainIntrinsicHeight = 403,
    CSSPropertyContainIntrinsicWidth = 404,
    CSSPropertyCornerBottomLeftShape = 405,
    CSSPropertyCornerBottomRightShape = 406,
    CSSPropertyCornerTopLeftShape = 407,
    CSSPropertyCornerTopRightShape = 408,
    CSSPropertyHeight = 409,
    CSSPropertyLeft = 410,
    CSSPropertyMarginBottom = 411,
    CSSPropertyMarginLeft = 412,
    CSSPropertyMarginRight = 413,
    CSSPropertyMarginTop = 414,
    CSSPropertyMaxHeight = 415,
    CSSPropertyMaxWidth = 416,
    CSSPropertyMinHeight = 417,
    CSSPropertyMinWidth = 418,
    CSSPropertyOverflowX = 419,
    CSSPropertyOverflowY = 420,
    CSSPropertyOverscrollBehaviorX = 421,
    CSSPropertyOverscrollBehaviorY = 422,
    CSSPropertyPaddingBottom = 423,
    CSSPropertyPaddingLeft = 424,
    CSSPropertyPaddingRight = 425,
    CSSPropertyPaddingTop = 426,
    CSSPropertyRight = 427,
    CSSPropertyScrollMarginBottom = 428,
    CSSPropertyScrollMarginLeft = 429,
    CSSPropertyScrollMarginRight = 430,
    CSSPropertyScrollMarginTop = 431,
    CSSPropertyScrollPaddingBottom = 432,
    CSSPropertyScrollPaddingLeft = 433,
    CSSPropertyScrollPaddingRight = 434,
    CSSPropertyScrollPaddingTop = 435,
    CSSPropertyTop = 436,
    CSSPropertyWidth = 437,
    CSSPropertyBlockSize = 438,
    CSSPropertyBorderBlockEndColor = 439,
    CSSPropertyBorderBlockEndStyle = 440,
    CSSPropertyBorderBlockEndWidth = 441,
    CSSPropertyBorderBlockStartColor = 442,
    CSSPropertyBorderBlockStartStyle = 443,
    CSSPropertyBorderBlockStartWidth = 444,
    CSSPropertyBorderEndEndRadius = 445,
    CSSPropertyBorderEndStartRadius = 446,
    CSSPropertyBorderInlineEndColor = 447,
    CSSPropertyBorderInlineEndStyle = 448,
    CSSPropertyBorderInlineEndWidth = 449,
    CSSPropertyBorderInlineStartColor = 450,
    CSSPropertyBorderInlineStartStyle = 451,
    CSSPropertyBorderInlineStartWidth = 452,
    CSSPropertyBorderStartEndRadius = 453,
    CSSPropertyBorderStartStartRadius = 454,
    CSSPropertyContainIntrinsicBlockSize = 455,
    CSSPropertyContainIntrinsicInlineSize = 456,
    CSSPropertyCornerEndEndShape = 457,
    CSSPropertyCornerEndStartShape = 458,
    CSSPropertyCornerStartEndShape = 459,
    CSSPropertyCornerStartStartShape = 460,
    CSSPropertyInlineSize = 461,
    CSSPropertyInsetBlockEnd = 462,
    CSSPropertyInsetBlockStart = 463,
    CSSPropertyInsetInlineEnd = 464,
    CSSPropertyInsetInlineStart = 465,
    CSSPropertyMarginBlockEnd = 466,
    CSSPropertyMarginBlockStart = 467,
    CSSPropertyMarginInlineEnd = 468,
    CSSPropertyMarginInlineStart = 469,
    CSSPropertyMaxBlockSize = 470,
    CSSPropertyMaxInlineSize = 471,
    CSSPropertyMinBlockSize = 472,
    CSSPropertyMinInlineSize = 473,
    CSSPropertyOverflowBlock = 474,
    CSSPropertyOverflowInline = 475,
    CSSPropertyOverscrollBehaviorBlock = 476,
    CSSPropertyOverscrollBehaviorInline = 477,
    CSSPropertyPaddingBlockEnd = 478,
    CSSPropertyPaddingBlockStart = 479,
    CSSPropertyPaddingInlineEnd = 480,
    CSSPropertyPaddingInlineStart = 481,
    CSSPropertyScrollMarginBlockEnd = 482,
    CSSPropertyScrollMarginBlockStart = 483,
    CSSPropertyScrollMarginInlineEnd = 484,
    CSSPropertyScrollMarginInlineStart = 485,
    CSSPropertyScrollPaddingBlockEnd = 486,
    CSSPropertyScrollPaddingBlockStart = 487,
    CSSPropertyScrollPaddingInlineEnd = 488,
    CSSPropertyScrollPaddingInlineStart = 489,
    CSSPropertyAll = 490,
    CSSPropertyAnimation = 491,
    CSSPropertyAnimationRange = 492,
    CSSPropertyBackground = 493,
    CSSPropertyBackgroundPosition = 494,
    CSSPropertyBlockStep = 495,
    CSSPropertyBorder = 496,
    CSSPropertyBorderBlock = 497,
    CSSPropertyBorderBlockColor = 498,
    CSSPropertyBorderBlockEnd = 499,
    CSSPropertyBorderBlockStart = 500,
    CSSPropertyBorderBlockStyle = 501,
    CSSPropertyBorderBlockWidth = 502,
    CSSPropertyBorderBottom = 503,
    CSSPropertyBorderColor = 504,
    CSSPropertyBorderImage = 505,
    CSSPropertyBorderInline = 506,
    CSSPropertyBorderInlineColor = 507,
    CSSPropertyBorderInlineEnd = 508,
    CSSPropertyBorderInlineStart = 509,
    CSSPropertyBorderInlineStyle = 510,
    CSSPropertyBorderInlineWidth = 511,
    CSSPropertyBorderLeft = 512,
    CSSPropertyBorderRadius = 513,
    CSSPropertyBorderRight = 514,
    CSSPropertyBorderSpacing = 515,
    CSSPropertyBorderStyle = 516,
    CSSPropertyBorderTop = 517,
    CSSPropertyBorderWidth = 518,
    CSSPropertyColumnRule = 519,
    CSSPropertyColumns = 520,
    CSSPropertyContainIntrinsicSize = 521,
    CSSPropertyContainer = 522,
    CSSPropertyCornerShape = 523,
    CSSPropertyFlex = 524,
    CSSPropertyFlexFlow = 525,
    CSSPropertyFont = 526,
    CSSPropertyFontSynthesis = 527,
    CSSPropertyFontVariant = 528,
    CSSPropertyGap = 529,
    CSSPropertyGrid = 530,
    CSSPropertyGridArea = 531,
    CSSPropertyGridColumn = 532,
    CSSPropertyGridRow = 533,
    CSSPropertyGridTemplate = 534,
    CSSPropertyInset = 535,
    CSSPropertyInsetBlock = 536,
    CSSPropertyInsetInline = 537,
    CSSPropertyLineClamp = 538,
    CSSPropertyListStyle = 539,
    CSSPropertyMargin = 540,
    CSSPropertyMarginBlock = 541,
    CSSPropertyMarginInline = 542,
    CSSPropertyMarker = 543,
    CSSPropertyMask = 544,
    CSSPropertyMaskBorder = 545,
    CSSPropertyMaskPosition = 546,
    CSSPropertyOffset = 547,
    CSSPropertyOutline = 548,
    CSSPropertyOverflow = 549,
    CSSPropertyOverscrollBehavior = 550,
    CSSPropertyPadding = 551,
    CSSPropertyPaddingBlock = 552,
    CSSPropertyPaddingInline = 553,
    CSSPropertyPageBreakAfter = 554,
    CSSPropertyPageBreakBefore = 555,
    CSSPropertyPageBreakInside = 556,
    CSSPropertyPerspectiveOrigin = 557,
    CSSPropertyPlaceContent = 558,
    CSSPropertyPlaceItems = 559,
    CSSPropertyPlaceSelf = 560,
    CSSPropertyPositionTry = 561,
    CSSPropertyScrollMargin = 562,
    CSSPropertyScrollMarginBlock = 563,
    CSSPropertyScrollMarginInline = 564,
    CSSPropertyScrollPadding = 565,
    CSSPropertyScrollPaddingBlock = 566,
    CSSPropertyScrollPaddingInline = 567,
    CSSPropertyScrollTimeline = 568,
    CSSPropertyTextBox = 569,
    CSSPropertyTextDecoration = 570,
    CSSPropertyTextDecorationSkip = 571,
    CSSPropertyTextEmphasis = 572,
    CSSPropertyTextWrap = 573,
    CSSPropertyTransformOrigin = 574,
    CSSPropertyTransition = 575,
    CSSPropertyViewTimeline = 576,
    CSSPropertyWhiteSpace = 577,
    CSSPropertyWebkitBackgroundSize = 578,
    CSSPropertyWebkitBorderImage = 579,
    CSSPropertyWebkitBorderRadius = 580,
    CSSPropertyWebkitColumnBreakAfter = 581,
    CSSPropertyWebkitColumnBreakBefore = 582,
    CSSPropertyWebkitColumnBreakInside = 583,
    CSSPropertyWebkitMask = 584,
    CSSPropertyWebkitMaskBoxImage = 585,
    CSSPropertyWebkitMaskPosition = 586,
    CSSPropertyWebkitPerspective = 587,
    CSSPropertyWebkitTextOrientation = 588,
    CSSPropertyWebkitTextStroke = 589,
};

// Enum value of the first "real" CSS property, which excludes
// CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t firstCSSProperty = 2;
// Total number of enum values in the CSSPropertyID enum. If making an array
// that can be indexed into using the enum value, use this as the size.
constexpr uint16_t cssPropertyIDEnumValueCount = 590;
// Number of "real" CSS properties. This differs from cssPropertyIDEnumValueCount,
// as this doesn't consider CSSPropertyInvalid and CSSPropertyCustom.
constexpr uint16_t numCSSProperties = 588;
constexpr unsigned maxCSSPropertyNameLength = 34;
constexpr auto firstTopPriorityProperty = CSSPropertyID::CSSPropertyColorScheme;
constexpr auto lastTopPriorityProperty = CSSPropertyID::CSSPropertyWritingMode;
constexpr auto firstHighPriorityProperty = CSSPropertyID::CSSPropertyDirection;
constexpr auto lastHighPriorityProperty = CSSPropertyID::CSSPropertyWordSpacing;
constexpr auto firstMediumPriorityProperty = CSSPropertyID::CSSPropertyBackgroundImage;
constexpr auto lastMediumPriorityProperty = CSSPropertyID::CSSPropertyMaskImage;
constexpr auto firstLowPriorityProperty = CSSPropertyID::CSSPropertyAccentColor;
constexpr auto lastLowPriorityProperty = CSSPropertyID::CSSPropertyWebkitUserSelect;
constexpr auto firstLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyBorderBottomColor;
constexpr auto lastLogicalGroupPhysicalProperty = CSSPropertyID::CSSPropertyWidth;
constexpr auto firstLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyBlockSize;
constexpr auto lastLogicalGroupLogicalProperty = CSSPropertyID::CSSPropertyScrollPaddingInlineStart;
constexpr auto firstLogicalGroupProperty = firstLogicalGroupPhysicalProperty;
constexpr auto lastLogicalGroupProperty = lastLogicalGroupLogicalProperty;
constexpr auto firstShorthandProperty = CSSPropertyID::CSSPropertyAll;
constexpr auto lastShorthandProperty = CSSPropertyID::CSSPropertyWebkitTextStroke;
constexpr uint16_t numCSSPropertyLonghands = firstShorthandProperty - firstCSSProperty;

extern const std::array<CSSPropertyID, 454> computedPropertyIDs;

template<CSSPropertyID C> struct PropertyNameConstant {
    static constexpr auto value = C;
    constexpr bool operator==(const PropertyNameConstant&) const = default;
    constexpr bool operator==(CSSPropertyID other) const { return value == other; }
};

struct CSSPropertySettings {
    WTF_DEPRECATED_MAKE_STRUCT_FAST_ALLOCATED(CSSPropertySettings);

    bool accentColorEnabled : 1 { false };
    bool colorFilterEnabled : 1 { false };
    bool crossDocumentViewTransitionsEnabled : 1 { false };
    bool cssAnchorPositioningEnabled : 1 { false };
    bool cssCornerShapeEnabled : 1 { false };
    bool cssDPropertyEnabled : 1 { false };
    bool cssFieldSizingEnabled : 1 { false };
    bool cssFontVariantEmojiEnabled : 1 { false };
    bool cssFunctionAtRuleEnabled : 1 { false };
    bool cssInputSecurityEnabled : 1 { false };
    bool cssLineClampEnabled : 1 { false };
    bool cssLineFitEdgeEnabled : 1 { false };
    bool cssMathDepthEnabled : 1 { false };
    bool cssRhythmicSizingEnabled : 1 { false };
    bool cssRubyAlignEnabled : 1 { false };
    bool cssRubyOverhangEnabled : 1 { false };
    bool cssScrollAnchoringEnabled : 1 { false };
    bool cssScrollbarColorEnabled : 1 { false };
    bool cssScrollbarGutterEnabled : 1 { false };
    bool cssScrollbarWidthEnabled : 1 { false };
    bool cssTextAutospaceEnabled : 1 { false };
    bool cssTextBoxTrimEnabled : 1 { false };
    bool cssTextGroupAlignEnabled : 1 { false };
    bool cssTextJustifyEnabled : 1 { false };
    bool cssTextSpacingTrimEnabled : 1 { false };
    bool cssUnprefixedBackdropFilterEnabled : 1 { false };
    bool overscrollBehaviorEnabled : 1 { false };
    bool scrollDrivenAnimationsEnabled : 1 { false };
    bool supportHDRDisplayEnabled : 1 { false };
    bool textAutosizingEnabled : 1 { false };
    bool useSystemAppearance : 1 { false };
    bool viewTransitionClassesEnabled : 1 { false };
    bool viewTransitionsEnabled : 1 { false };

    CSSPropertySettings() = default;
    explicit CSSPropertySettings(const Settings&);
};

bool operator==(const CSSPropertySettings&, const CSSPropertySettings&);
void add(Hasher&, const CSSPropertySettings&);

constexpr bool isLonghand(CSSPropertyID);
bool isInternal(CSSPropertyID);
bool isExposed(CSSPropertyID, const Settings*);
bool isExposed(CSSPropertyID, const Settings&);
bool isExposed(CSSPropertyID, const CSSPropertySettings*);
bool isExposed(CSSPropertyID, const CSSPropertySettings&);

CSSPropertyID findCSSProperty(const char* characters, unsigned length);
ASCIILiteral nameLiteral(CSSPropertyID);
const AtomString& nameString(CSSPropertyID);
String nameForIDL(CSSPropertyID);

CSSPropertyID cascadeAliasProperty(CSSPropertyID);

template<CSSPropertyID first, CSSPropertyID last> struct CSSPropertiesRange {
    struct Iterator {
        uint16_t index { static_cast<uint16_t>(first) };
        constexpr CSSPropertyID operator*() const { return static_cast<CSSPropertyID>(index); }
        constexpr Iterator& operator++() { ++index; return *this; }
        constexpr bool operator==(std::nullptr_t) const { return index > static_cast<uint16_t>(last); }
    };
    static constexpr Iterator begin() { return { }; }
    static constexpr std::nullptr_t end() { return nullptr; }
    static constexpr uint16_t size() { return last - first + 1; }
};
using AllCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastShorthandProperty>;
using AllLonghandCSSPropertiesRange = CSSPropertiesRange<static_cast<CSSPropertyID>(firstCSSProperty), lastLogicalGroupProperty>;
constexpr AllCSSPropertiesRange allCSSProperties() { return { }; }
constexpr AllLonghandCSSPropertiesRange allLonghandCSSProperties() { return { }; }

constexpr bool isLonghand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= firstCSSProperty
        && static_cast<uint16_t>(property) < static_cast<uint16_t>(firstShorthandProperty);
}
constexpr bool isShorthand(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstShorthandProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastShorthandProperty);
}

constexpr bool isLogicalPropertyGroupProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

constexpr bool isLogicalPropertyGroupPhysicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupPhysicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupPhysicalProperty);
}

constexpr bool isLogicalPropertyGroupLogicalProperty(CSSPropertyID property)
{
    return static_cast<uint16_t>(property) >= static_cast<uint16_t>(firstLogicalGroupLogicalProperty)
        && static_cast<uint16_t>(property) <= static_cast<uint16_t>(lastLogicalGroupLogicalProperty);
}

WTF::TextStream& operator<<(WTF::TextStream&, CSSPropertyID);

} // namespace WebCore

namespace WTF {

template<> struct DefaultHash<WebCore::CSSPropertyID> : IntHash<unsigned> { };

template<> struct HashTraits<WebCore::CSSPropertyID> : GenericHashTraits<WebCore::CSSPropertyID> {
    static const bool emptyValueIsZero = true;
    static void constructDeletedValue(WebCore::CSSPropertyID& slot) { slot = static_cast<WebCore::CSSPropertyID>(std::numeric_limits<uint16_t>::max()); }
    static bool isDeletedValue(WebCore::CSSPropertyID value) { return static_cast<uint16_t>(value) == std::numeric_limits<uint16_t>::max(); }
};

} // namespace WTF

namespace std {

template<> struct iterator_traits<WebCore::AllCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };
template<> struct iterator_traits<WebCore::AllLonghandCSSPropertiesRange::Iterator> { using value_type = WebCore::CSSPropertyID; };

} // namespace std

