/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Statistics
implements Serializable {
    public static final int STATISTICS_ACCURACY_NONE = 0;
    public static final int STATISTICS_ACCURACY_BEST_EFFORT = 1;
    public static final int STATISTICS_ACCURACY_GUARANTEED = 2;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$Statistics == null ? (class$net$sf$ehcache$Statistics = Statistics.class$("net.sf.ehcache.Statistics")) : class$net$sf$ehcache$Statistics).getName());
    private static final long serialVersionUID = 3606940454221918725L;
    private transient Ehcache cache;
    private final int statisticsAccuracy;
    private final long cacheHits;
    private final long onDiskHits;
    private final long inMemoryHits;
    private final long misses;
    private final long size;
    private float averageGetTime;
    private long evictionCount;
    static /* synthetic */ Class class$net$sf$ehcache$Statistics;

    public Statistics(Ehcache cache, int statisticsAccuracy, long cacheHits, long onDiskHits, long inMemoryHits, long misses, long size, float averageGetTime, long evictionCount) {
        this.statisticsAccuracy = statisticsAccuracy;
        this.cacheHits = cacheHits;
        this.onDiskHits = onDiskHits;
        this.inMemoryHits = inMemoryHits;
        this.misses = misses;
        this.cache = cache;
        this.size = size;
        this.averageGetTime = averageGetTime;
        this.evictionCount = evictionCount;
    }

    public void clearStatistics() {
        block3: {
            if (this.cache == null) {
                throw new IllegalStateException("This statistics object no longer references a Cache.");
            }
            try {
                this.cache.clearStatistics();
            }
            catch (IllegalStateException e) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.info((Object)("Ignoring call because " + e.getMessage()));
            }
        }
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getInMemoryHits() {
        return this.inMemoryHits;
    }

    public long getOnDiskHits() {
        return this.onDiskHits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    public long getObjectCount() {
        return this.size;
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public String getStatisticsAccuracyDescription() {
        if (this.statisticsAccuracy == 0) {
            return "None";
        }
        if (this.statisticsAccuracy == 1) {
            return "Best Effort";
        }
        return "Guaranteed";
    }

    public String getAssociatedCacheName() {
        if (this.cache != null) {
            return this.cache.getName();
        }
        return null;
    }

    public Ehcache getAssociatedCache() {
        if (this.cache != null) {
            return this.cache;
        }
        return null;
    }

    public final String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[ ").append(" name = ").append(this.getAssociatedCacheName()).append(" cacheHits = ").append(this.cacheHits).append(" onDiskHits = ").append(this.onDiskHits).append(" inMemoryHits = ").append(this.inMemoryHits).append(" misses = ").append(this.misses).append(" size = ").append(this.size).append(" averageGetTime = ").append(this.averageGetTime).append(" evictionCount = ").append(this.evictionCount).append(" ]");
        return dump.toString();
    }

    public float getAverageGetTime() {
        return this.averageGetTime;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

