/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.jcache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.jcache.JCacheEntry;
import net.sf.ehcache.jcache.JCacheListenerAdaptor;
import net.sf.ehcache.jcache.JCacheStatistics;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.jsr107cache.Cache;
import net.sf.jsr107cache.CacheEntry;
import net.sf.jsr107cache.CacheException;
import net.sf.jsr107cache.CacheListener;
import net.sf.jsr107cache.CacheStatistics;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JCache
implements Cache {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$jcache$JCache == null ? (class$net$sf$ehcache$jcache$JCache = JCache.class$("net.sf.ehcache.jcache.JCache")) : class$net$sf$ehcache$jcache$JCache).getName());
    private Ehcache cache;
    static /* synthetic */ Class class$net$sf$ehcache$jcache$JCache;

    public JCache(Ehcache cache) {
        this.cache = cache;
    }

    public JCache(Ehcache cache, net.sf.jsr107cache.CacheLoader cacheLoader) {
        this.cache = cache;
        if (cacheLoader != null) {
            cache.setCacheLoader((CacheLoader)cacheLoader);
        }
    }

    public JCache(Ehcache cache, CacheLoader cacheLoader) {
        this.cache = cache;
        if (cacheLoader != null) {
            cache.setCacheLoader(cacheLoader);
        }
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        this.cache.setCacheLoader(cacheLoader);
    }

    public void addListener(CacheListener cacheListener) {
        JCacheListenerAdaptor cacheListenerAdaptor = new JCacheListenerAdaptor(cacheListener);
        this.cache.getCacheEventNotificationService().registerListener(cacheListenerAdaptor);
    }

    public void evict() {
        this.cache.evictExpiredElements();
    }

    public Map getAll(Collection keys) throws CacheException {
        return this.getAll(keys, null);
    }

    public Map getAll(Collection keys, Object loaderArgument) throws CacheException {
        return this.cache.getAllWithLoader(keys, loaderArgument);
    }

    public CacheLoader getCacheLoader() {
        return this.cache.getCacheLoader();
    }

    public CacheEntry getCacheEntry(Object key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return new JCacheEntry(element);
        }
        return null;
    }

    public CacheStatistics getCacheStatistics() throws IllegalStateException {
        return new JCacheStatistics(this.cache.getStatistics());
    }

    public void load(Object key) throws CacheException {
        this.cache.load(key);
    }

    public void loadAll(Collection keys) throws CacheException {
        this.loadAll(keys, null);
    }

    public void loadAll(Collection keys, Object argument) throws CacheException {
        this.cache.loadAll(keys, argument);
    }

    public Object peek(Object key) {
        Element element = this.cache.get(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void removeListener(CacheListener cacheListener) {
        JCacheListenerAdaptor cacheListenerAdaptor = new JCacheListenerAdaptor(cacheListener);
        this.cache.getCacheEventNotificationService().unregisterListener(cacheListenerAdaptor);
    }

    public int size() {
        return this.cache.getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.cache.isKeyInCache(key);
    }

    public boolean containsValue(Object value) {
        long start = System.currentTimeMillis();
        boolean inCache = this.cache.isValueInCache(value);
        long end = System.currentTimeMillis();
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("Performance Warning: containsValue is not recommended. This call took " + (end - start) + " ms"));
        }
        return inCache;
    }

    public Object get(Object key) throws RuntimeException {
        return this.get(key, null);
    }

    public Object get(Object key, Object loaderArgument) throws RuntimeException {
        return this.get(key, null, loaderArgument);
    }

    public Object get(Object key, CacheLoader loader) throws RuntimeException {
        return this.get(key, loader, null);
    }

    public Object get(Object key, CacheLoader loader, Object loaderArgument) throws RuntimeException {
        Element element = this.cache.getWithLoader(key, loader, loaderArgument);
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    public Object put(Object key, Object value) {
        return this.put(key, value, 0);
    }

    public Object put(Object key, Object value, int timeToLiveSeconds) {
        Element element = null;
        if (this.cache.isKeyInCache(key)) {
            element = this.cache.getQuiet(key);
        }
        Element newElement = new Element(key, value);
        if (timeToLiveSeconds != 0) {
            newElement.setTimeToLive(timeToLiveSeconds);
        }
        this.cache.put(newElement);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public Object remove(Object key) {
        Element element = this.cache.get(key);
        this.cache.remove(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void putAll(Map sourceMap) {
        if (sourceMap == null) {
            return;
        }
        Iterator iterator = sourceMap.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            this.cache.put(new Element(key, sourceMap.get(key)));
        }
    }

    public void clear() {
        this.cache.removeAll();
    }

    public Set keySet() {
        List list = this.cache.getKeys();
        HashSet set = new HashSet();
        set.addAll(list);
        return set;
    }

    public Collection values() {
        List list = this.cache.getKeysNoDuplicateCheck();
        HashSet<Object> set = new HashSet<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Element element = this.cache.get(key);
            if (element == null) continue;
            set.add(element.getObjectValue());
        }
        return set;
    }

    public Set entrySet() {
        List list = this.cache.getKeysNoDuplicateCheck();
        HashSet<JCacheEntry> set = new HashSet<JCacheEntry>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Object key = list.get(i);
            Element element = this.cache.get(key);
            if (element == null) continue;
            set.add(new JCacheEntry(element));
        }
        return set;
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.cache.setStatisticsAccuracy(statisticsAccuracy);
    }

    public Ehcache getBackingCache() {
        return this.cache;
    }

    public String toString() {
        return ((Object)this.cache).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

