/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.xml.MarkupBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.runtime.MethodClosure;

public class ServletBinding
extends Binding {
    private boolean initialized;

    public ServletBinding(HttpServletRequest request, HttpServletResponse response, ServletContext context) {
        super.setVariable("request", (Object)request);
        super.setVariable("response", (Object)response);
        super.setVariable("context", (Object)context);
        super.setVariable("application", (Object)context);
        super.setVariable("session", (Object)request.getSession(false));
        Map params = this.collectParams(request);
        super.setVariable("params", (Object)params);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String headerName = (String)names.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        super.setVariable("headers", headers);
    }

    private Map collectParams(HttpServletRequest request) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (super.getVariables().containsKey(name)) continue;
            String[] values = request.getParameterValues(name);
            if (values.length == 1) {
                params.put(name, values[0]);
                continue;
            }
            params.put(name, values);
        }
        return params;
    }

    public void setVariable(String name, Object value) {
        this.lazyInit();
        ServletBinding.validateArgs(name, "Can't bind variable to");
        ServletBinding.excludeReservedName(name, "out");
        ServletBinding.excludeReservedName(name, "sout");
        ServletBinding.excludeReservedName(name, "html");
        ServletBinding.excludeReservedName(name, "json");
        ServletBinding.excludeReservedName(name, "forward");
        ServletBinding.excludeReservedName(name, "include");
        ServletBinding.excludeReservedName(name, "redirect");
        super.setVariable(name, value);
    }

    public Map getVariables() {
        this.lazyInit();
        return super.getVariables();
    }

    public Object getVariable(String name) {
        this.lazyInit();
        ServletBinding.validateArgs(name, "No variable with");
        return super.getVariable(name);
    }

    private void lazyInit() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        ServletOutput output = new ServletOutput(response);
        super.setVariable("out", (Object)output.getWriter());
        super.setVariable("sout", (Object)output.getOutputStream());
        MarkupBuilder builder = new MarkupBuilder(output.getWriter());
        builder.setExpandEmptyElements(true);
        super.setVariable("html", (Object)builder);
        try {
            Class<?> jsonBuilderClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass("groovy.json.StreamingJsonBuilder");
            Constructor writerConstructor = this.getWriterConstructor(jsonBuilderClass);
            super.setVariable("json", writerConstructor.newInstance(output.getWriter()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        MethodClosure c = new MethodClosure((Object)this, "forward");
        super.setVariable("forward", (Object)c);
        c = new MethodClosure((Object)this, "include");
        super.setVariable("include", (Object)c);
        c = new MethodClosure((Object)this, "redirect");
        super.setVariable("redirect", (Object)c);
    }

    private Constructor getWriterConstructor(Class jsonBuilderClass) throws NoSuchMethodException {
        return jsonBuilderClass.getConstructor(Writer.class);
    }

    private static void validateArgs(String name, String message) {
        if (name == null) {
            throw new IllegalArgumentException(message + " null key.");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException(message + " blank key name. [length=0]");
        }
    }

    private static void excludeReservedName(String name, String reservedName) {
        if (reservedName.equals(name)) {
            throw new IllegalArgumentException("Can't bind variable to key named '" + name + "'.");
        }
    }

    public void forward(String path) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)super.getVariable("request");
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        RequestDispatcher dispatcher = request.getRequestDispatcher(path);
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    public void include(String path) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)super.getVariable("request");
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        RequestDispatcher dispatcher = request.getRequestDispatcher(path);
        dispatcher.include((ServletRequest)request, (ServletResponse)response);
    }

    public void redirect(String location) throws IOException {
        HttpServletResponse response = (HttpServletResponse)super.getVariable("response");
        response.sendRedirect(location);
    }

    private static class ServletOutput {
        private final HttpServletResponse response;
        private ServletOutputStream outputStream;
        private PrintWriter writer;

        public ServletOutput(HttpServletResponse response) {
            this.response = response;
        }

        private ServletOutputStream getResponseStream() throws IOException {
            if (this.writer != null) {
                throw new IllegalStateException("The variable 'out' or 'html' have been used already. Use either out/html or sout, not both.");
            }
            if (this.outputStream == null) {
                this.outputStream = this.response.getOutputStream();
            }
            return this.outputStream;
        }

        public ServletOutputStream getOutputStream() {
            return new ServletOutputStream(){

                public boolean isReady() {
                    try {
                        return this.getResponseStream().isReady();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void setWriteListener(WriteListener writeListener) {
                    try {
                        this.getResponseStream().setWriteListener(writeListener);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void write(int b) throws IOException {
                    this.getResponseStream().write(b);
                }

                public void close() throws IOException {
                    this.getResponseStream().close();
                }

                public void flush() throws IOException {
                    this.getResponseStream().flush();
                }

                public void write(byte[] b) throws IOException {
                    this.getResponseStream().write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    this.getResponseStream().write(b, off, len);
                }
            };
        }

        private PrintWriter getResponseWriter() {
            if (this.outputStream != null) {
                throw new IllegalStateException("The variable 'sout' have been used already. Use either out/html or sout, not both.");
            }
            if (this.writer == null) {
                try {
                    this.writer = this.response.getWriter();
                }
                catch (IOException ioe) {
                    this.writer = new PrintWriter(new ByteArrayOutputStream());
                    throw new IllegalStateException("unable to get response writer", ioe);
                }
            }
            return this.writer;
        }

        public PrintWriter getWriter() {
            return new PrintWriter(new InvalidOutputStream()){

                @Override
                public boolean checkError() {
                    return this.getResponseWriter().checkError();
                }

                @Override
                public void close() {
                    this.getResponseWriter().close();
                }

                @Override
                public void flush() {
                    this.getResponseWriter().flush();
                }

                @Override
                public void write(char[] buf) {
                    this.getResponseWriter().write(buf);
                }

                @Override
                public void write(char[] buf, int off, int len) {
                    this.getResponseWriter().write(buf, off, len);
                }

                @Override
                public void write(int c) {
                    this.getResponseWriter().write(c);
                }

                @Override
                public void write(String s, int off, int len) {
                    this.getResponseWriter().write(s, off, len);
                }

                @Override
                public void println() {
                    this.getResponseWriter().println();
                }

                @Override
                public PrintWriter format(String format, Object ... args) {
                    this.getResponseWriter().format(format, args);
                    return this;
                }

                @Override
                public PrintWriter format(Locale l, String format, Object ... args) {
                    this.getResponseWriter().format(l, format, args);
                    return this;
                }
            };
        }
    }

    private static class InvalidOutputStream
    extends OutputStream {
        private InvalidOutputStream() {
        }

        @Override
        public void write(int b) {
            throw new GroovyBugError("Any write calls to this stream are invalid!");
        }
    }
}

