# ----------------------------------------------------------------------------------------------------------------------
#  Copyright (c) 2024-2025 Dimitri Kroon.
#  This file is part of plugin.video.viwx.
#  SPDX-License-Identifier: GPL-2.0-or-later
#  See LICENSE.txt
# ----------------------------------------------------------------------------------------------------------------------
import logging
import random

from codequick.support import logger_id


telemetry_data = [
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGMTdjbkxPVUFRQUFndjJ5MnhxaUxYUUVud0orYlh6SFVoN25JcjUwOFlhM0N5ZkZic29WTU9BQTNWQkN1T3hpdW1oUEtXZG9uMWFvZGNZUHdhcTNDTjRGcHJZZ1R6RmFGVUtnbFhiZlpHcmpBd0JMZm00SlBoL0xpeUFKdkhUeFNNVTdVejZQZGwvWlNjdFhrU0Q2MVhZTVBFNk8vUnJjZEdQYTZvc1V4aGUxTDgvM3RMeTlwR0hyYzgvUFV0QlVNL0VZTHN0Q3lrbnZ3cEJEcVNIdVZCclVGdHlXWGo1NFBiVll4QzlaVzZlSjlVa2E5MVdyU1I5ZUc5N24zQkYyRjBKK2J5L3RZK3VEeFB5NnVHV3JPSStqSDJCTGFLVDNONXM0QjROT1owb2VicmtaY21wMWQ5N2JXQmU2N1dYTlllamJ6Rld0L3NmMEFYM05Camh5dFEwZnJnOGVZWVV0SG8veXAyd1lzQjZVY0U5R04yWHdBa3prMDV6bjZhcnMxWXZYR3NiNkw4dVRGRUUyUFhxVWg3bVdMVWlDZ0RnR3FjUVV4NjdPcTJQbkF1VUJ+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGMnNKbmJPVUFRQUFTQisyMnhxb3ZLc2FwS2QwTTc2TldYQzgzTE41b0lFaXl2RUZ6WUdzSWxtck9IR2lkNSs2R1d3U1dhaXlUMUNXcXNRUzZ5QUFiclo3a3FpMCtaQkVSVHoxNzlRSzZ4SG5NMm1oYlZlS0psNkRmNGQya2pLcm9yOHhsTlAyclJSeVg1NWlBVmg5Nkh4cmhPeTRaaGY0REFLMG1uY1AranNBMVdkMi9VekRSc2c1bFpjdDJjOXVLRlZKNHhGa2lLKzlMZ2dlYWIwZGxZUmhTYUhxd0dtWlBJUk4vaFc0VlNTS2kraGNJZlU4QmNHU1V0dWFCS2JlM2p3cFpWWDJZVFAwNDE0S1g3WTRJUWpxckVoblFsbzlDTy8rSlZZVnVtTG5laG1DMkxBdWFxdUNtRFJqRnoxU0JONTJpcVZNbGFTSW9Ed3ZjcjRlZWsrZDBYYkQ2ejZJdk9SSWJHa0Y1RE1XVUtNSjkwKzZvSUh2L3pOTXFoWk1RNTZUaXJDcFFEekdBdExHK1FTVDFZSVJRYkFYb1Q5UVFxWC90czArVEJDdkZwOTJxb2hJNVpibzVRPT1+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGMjhabmJPVUFRQUFKQUMzMnhwMHBoV1kxb1N4R29mVW1xaFJrSHZ0dXNUMmtGbjRGd3BFSmdvTmx4bVNpNms2Q2R0a0EyekhQVE5aWnk5NGdUZm5kZ0FpYTUwVXk1aDBZQWxTUjZSejVhdVJSbEFrRXl2YnpuUVdXSFY3czdmN2R5MTc1dmJXVzY5T01FMkJNUnExZXFRa25pWW1sREVnTjVuaDJueEFtN1ZmM0kxR2dkTC9FMWVuaERZK0R4bUZ5ZGFkNi9DYWs0SG0xOVVCN2NqN095UzNIR3VXbWdCME05Z1pKNnl1SW84QWFBNGZuNzlaaXNXSm9kUkExTUx5SXYrclBFMTI4TTNIR3Q0anlyMDkzWWhLL0o5VEhNdEhaM2c0UGlaSkdPV1kvKzdkZWJ2VEtLL3dBTXpkK0JhQlBPZ3MwRnllN0swciswVTE5Zy9FR1YzSlBHd21KcEd0OFpEYUZVa3BHTHgxK2g2Slo0c0o4VE1uNWpsSzVqV3l4VjhtSHA2L1R3UXZYSU9mT2VCWlZadkZieGUvZnJzd3kxOVBwNzBQZFdvZEVoTlA5bEJmbkdmWGdSeU1JTzdyc01BeFdBeEQ4QT09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=MzsxOzI7MDszNDg2MDA3Ozk5bVk5LzFqR0w5ckFicU5OMDdNcUJtcWdQSm1kYmtVbzhpcjZ3ZnhoMVU9OzQ0LDIsMCwwLDE0LDUxOzZ3WF9ZInJoNiIzIiJVIjYtNiJ8ImprRGhUVHUgUyQ/ZjdFK3BbaiAmRjVuWV9YQDI4RkxhR0ZbZD1QWUg3NlY+dFUkOUhvcGRAPCt2JUhQLlFQKSJEIi5RbSJvIlp+QCgiKyIgM2siZCIiUiJOKnMiSCImIilUMCJ8LE4icS1TKD1jZTE7Z2p6fHhgQH1FIilSZSI7IiIhImgyYCJ6R3BvW3ksRi98L219YlJJIFRaZiNIdHF3YzhrWyFZaXRMeCBzOkMkNXk4a34/QFB1YmReMl0+aGVIPG9Wd0lUWDxveHpGZjljNmA5SFVZV0BQIjR0KyZmfTo9YVcvdW1oU0dWIjsifEs8Imh3Ij5dMiIrQGsiUiIpdXBHQiFXYntjUVliPGdHcWI1KTtqIDQhaX0/cEdKeyVyeFhZNncyUTIuPUwuUDlpXTR8QyU0UUY7S3hTITJsenJ6aV49JERlV01nL2k4KFlUOXlWMkJvVk5zOSRlX1NqanJybEE0TSYjeTZLLGxSRjUhbVI2RiVyXzRfUD05P0Q5VEtTPixNLyErU3RXOCZ+d2plOSBFaXVoRWxlWGVpenE9LDsmekshKzZVJG1WUEFBMT18ZjlVaW1FeHVdfHc2RWhid3NjRnkhfmYuI2BoZmFgXj86bk5KazlxJnIrL1FfITZKST9+Vmh7TyYgdiFuMH0ydXFBezBPJmJfa3gwXXQ5T3JvdFI8TF44dHFzJG8mMjU5LG9Han5mTVNedDdVIUVXKHw2eV96L3lRal1oezc+Rj9BJXo8Ui4jLS5de1pqVF8sRk89IUFdVDZJSVRiLSRDR1I4Lktxb1FwbDtfRm5GWSk5XUhAUylraHVxPEJte0Q8WkUzVnp6dC04Zy9sTCFOMTZYRERlOT99LzVbdUVgKCxAOzVbMTJ7OlczZFF+ZCZhKDg9NnJHSTJPYSlAbzlVcigpIFR9KypTZ0h2az4uaD5eLS0lZzhLP1RoRV03UTJGZ19qSHctIVF0Zi8gZEskbDhraHBWMjg6ZXpMdVF3U289PD50ZGx1QGxfPC1vdEs3XjI0VD59LHxPb1F6XithLVFiek08TGAtbU86NXB3VEogVGpyZkxkfEVhRnRVNXVAcXsoelt2KnNJQCEtfHVsTyZmK004ezRFezomYGMofER6MkZBfElgRH54ZWtjZlhQL3ozYUg4XXlJdGtISHZrNHcxSz08VyxdUFM2VUVNOUcjeDhaU010NGpMMSRtYEkrbyxIPj5kP3xnbWB5dSklLnJoNWBYXiBOKmhjSEsxKmVQdTc7Qm0xM3gmNztDXlVgXU95UFFYIEwzciBbbFpVTC9dIy0zcD48Jjg2W10gJkB8KlguRE98SUN7KXgkIXtbW3xZXm1KLCkgREFqZjlEaFpVM2RwJWMyMSEoKS4lPioqUCU+UzFtbmQqPWB7QE1mc3pdR0prOiB7byF6MiE5NituQmdvYkdNZHswWHZFYSQoLm5ScyVsS1NFaGV6OkE6MCFbLUopISAuTWU9YTZLeSw8LXs3Uzd1NipDUGtqNzJBdHEoXUwzTlIrOSY5fkV7eDUhJDpdTT1MVGsjVll3cyZ1cTlVWUBmdkVnTnpQJU9hOSZ2O21jXmp1QUF6KEdTa2JWM1tTV3oqXy10SSlfMj1lZ2U4a2RTISVNej1jdTlPSUV4T0hKbCR0QChbVn1kJFBJRStXYFJ1KVZ8XXVBTX1zKU4rSDpwfm9BRHhjOX1EeG8gWT9BRmcla31kemBvSEpRLGFwKUd3WD42d25IQ2I7O1I6ISwzYXRJe2AuYC9WYmhJREhfNGZRNjR3b01Ce09hcWQ5V2kuYEZlSCFdN2JqJl9OaylZNCVwfmZmXk9yT21+eG10OGAlfU49aFQkanErIGguPiheY0tQS0I4OWddZjokfTJMLldVJnRMSH5Vbix6bjlgQyV1ICtxOn4hW1BfPi4jQ15FdWVIPy0gUz9QKHN1NmZMNko6TkFYU1E8MlMmMCZKelo4KG9lVVgxbDlbaWIvXVA8U0Fkaip+JXFgQ25mbTdhXSw1dilkdlZDeUFIQntBUThKT2FtMzJDNjxmTkpaL1ZJJDd7Nno0eV0mbml8WTIlLkFBeSBJP2dXYjN6LC9eNyh3K3wlKjB3I1EsOE4lbHJ3IzpbfD9IaWRrVDlGbCJqIjZMSCIvIiMmUDVNbVsiPCJARXwiQkVqPVBvIiJmYzAibHkzInUmdV9FTC1sIi89TW4iMUV4Ol1lc2lWYTJqIj9LaFciVW1hYGBEbiVxP1Z5Zn1ITUBLKFgiUksiKyhaImduI1kiV0taPzhJW1J1KzZXOnxSJjh5JCIpfUEiOyJNeURIdzBGJDolejdtOnU4Unhnaz4rWz9PNi1RWDEpaXN9dyJXIiFDVCI9cToibyw3YClJImY+UlZYT2JtfS9pbE0+aiZFWGhAXjRDd29eM3VFKSBIT0ZaLyBsX1NyTHZ1IloiNmw8Ik4oImU3UiJUImAifmlUInRIYSJQKXBeZzF1InhKelZ7SVBQPSMiMyE0ImRKSiJCNVs3U0tKJSIvYDEiYyIrfShSZns7TzVFK1laJUV3IGc0OmswdHpodCBfeks8Vit7RXkkTTZ8QCJRMHkiamRVIm0iIjg9XSJNXkEiKCJ+X3x5Zn03eHc4WHpMI3E1bV9BM3tvNFUkRjgrREByZ0RPe3U3a3Mva11dZiZbIk1YYSJWQHkiSEE4SC5nSD4pI2dkPnpHaCJTe1JSImgidHgicTFrIiFQYiJYb1V4QToxe1k1TCJmJXhnbiImTUUiU3t7JToiIExLMmU8UCIyLDYkMFthKWlzIFU3PSg6PWFyQUJoTGIpansxbDMrcjFGU1VgbiR5bWh+XSpZY24oQ1hSPFheTlZSay90Sj9WXiR5bSNhRiwuPV01JngqOiJtL1IiUiJeRyVNIil2YyJ4YSkicVFVe2QrUiV4KUFDZTZ1Mj11byk6aS0xMzV0bCYyTGAiOyJtUnwiVTw9THUiUnticiImIiJ1Ijc1ayJKYms5NSJYSVAiLSJ3bSlGRVE+ZEVWM0AiQzVnIkowR0BwL1hlMW8jKT5mLS0lLl4gInpFOyJvcTVxZXAiLSIsPmIiQlFzInxhWjllWmB+Imc1cyJqInw0YFhrImUiQmNtIjIiIlMiX2JtIkMiOW4vaiIvIj5ybyJ+fXVXKyItOCJgbkB3QiJxZnwiW2JrQWpTIXlNIm5VeiIvIiJSIk1wPiJpImhEYiM6N3xfIC5rLSEiXSJ6ZFkiKiI8MWkoLFggZSJnSHAiWVohInZQLSIlJWEiKipsTCZbInpnSmdySygiX0ogbCpffHokWiIhXVREIlhCUkI3ZU9eQldHbTB5TUB7bUo0aD9HOEpKW3ZnV3Jda2BzWSI5IUIiTE1fIiwiIiQiSStlIjMiIjZAMSJGcSIlbHJ7ciI/WTIvInMyKFdSNCBxWyJuOGFefiIseFpnX2JxKCJwayJUdHYjSnphQkMmMiokakV1SURRK09HOn0rcDBJMEA7Om5AUlImUUYkJCAjbH0iUiIwNVEiKnhyKy9fY3ktLyIkRDlGIlgibF5mVm5jZVVHe2Rze149PkBXZCw7Zm87NT91XmUgYDc2fiIqIiAvJSIjZlsgWiIxOCQia3pQYXsvMV5WYCJVNXx9ImIifS0lKGhIaXx7XXBzMVZ6RX4iXSJaMjMiMndXbVZbdS0iPTJNIkdeZWNBIlYhIlBZM0ZzY1g/L0RfOGFnZCU4SF9yIiNYTSJsTzRdZiJQdFUiKyJ9Vz4+eiJHOzwiZmYieiIiTyIgQ3wiN05tPGFJbF51IlBvIkNiNnJgck8iIlFxNyJKOj4iamxwIEVyIiROIjVrLD1SRCI6PD1TImoiIm0iOVVdIlIiIiFXcSJtcDMiLiJvPE5OLDIxclFRIkp+TH0ieXV2IiEhOSJRImxkIiNuRyI3OEw5IkwiIig9JCVDeH5KPyMiPiJVNV8iJHpVImVKeFZpclgyR0UiMWM9In5YeXs2diJGWHNGLHVQV09PJjBaMlRrUTxYZUdeUSNvPDJVMkZaODhFaFIxI2l7a2NUVCkjLUo6KEZdQ2djOCteS3NgIDF+fjpUSSZ+fiV7eHJ2WkFlJiZtN1Y6aFtEO2dsRHxDW05OdDoseXJrKHYoKTp0ZyZIWE1tPXxQTDo+eHVQOl0gcyZIdHJZX2B+cy0lOikmTnJyc09zYTE1ISxwdlU5bjQ3PndCRzA9QFplICE/ISleKzYzcjQxcHBbbGpeRjlwTVdYLFthVnZ8RkFldS14flo3SU0jVU03SURJOU8xM1hBTVdNcnlsNj5xczxRd2h3TzhDW0F0a1tjWXt9K3R4SDU6XkYkMDFUYDRGcyRIQWE7IDRSNnwkbjAlQj9WUUogeS5IOH4sOWtuSGQ6Tn4jOW5vK0sjcXNzMTtbXXdyKmNbaTB8eyA1Wihhb0poOUdhRkVZNHRkbXMtOGdoNyVGJiE7ZV9YanlEe1R9XyBOXXxsd0FfUUtbaiM4XnVGRVE8OmZAOC9AZTNvQ3NWKWVvOzArYDYhczZFbCNQazpEW1JQJV1aX3I4a0A0YE9zZHROOUlzRk9QYnJRbUtPLjlZUmA6X3txSVlLIGU8Q3JLekJERipkdXA0RnRIfT9yMUtVbDJ0djBPKmxLRHV5UjRgNTlLMXMqekVaTGhSdUZ4M0ZJNXEqPnA7KWRfRUoxajx8KTsmZnslXXtVJHIyL0p3KS58ZygscUE7JSBpZUY6el92L3BgaSxSfWM6LGNLZUhNdGBGb35rNThxI319dmtCeT5VUEJjbz93YEMydVcscH5ELH05Z04oM3YuJS50fGc+bikrbEFNQGtdOy5vZT52M2BTV3pKK2xpbyB5LHkpalN8S05BcTB6R0koL3JkQyVNbHRtP3VgRkxTW1t5JC5sZyNmYmoyUk4hLGpxTl0sJlJ4JnpZMyxtIDA/Vm5gd2NgPGt4dUd9YVlKPk40T317PnUhLm5CSS1MSm58QlReXlQsZ3t0YiwhcnBpJGluYmY1eHUmaktDT1hkNjxsITY3OXxednljMS0gPChGQUY/PG5Jan5iTkdJbiZGbytNZ2V0W0NOblM5OCY/PF5KcVtySSBHZlAwPFB2Klt7QFolOkMseS9aRX0gLD5FaXApcShqW3U2LXYqO195YSNZfktOWFZFcit6X3B3MUFidTYtQzN5O2FZU2h5U2JOfFZwT2wkemwrT00wVVh1LVJyOjI9NzFkLiElL1N9XzBsUGlNaCp8IVd4I2d+L1ltSFN+Oj5FRWw4R0lnIFYzc0c0Zz9ZLnQxZDQlLkpVMEYlOmN0RDg8cDlUXiM8e1Q8c2NHNUZ3dSRdO0c4YmlLb0hsQGJ5eyxlUVlZe1MzemlEQXBhLmReblY8QDllLCIhInBPZiJuIlQiMVJ1IihTVyJlQy5pPURlRTVDOnMrbkB4ejYiZmQtIioiImhGNyJoTV0iUyRjU25QayI2YjBlSDRoR3FHImZWOyJwQioiLSJARip2VjAqcDElRVk3RFB2a0hga0hRRUBMXnZaNXkrWl1lTFd+ITloWSIhR3IiPF5rImBUViIsfHoiMHdVMTpBSXlwW1IuIn5sbTciayIzam5WTi1sKV1dWCFXNyIoMS8iN0JGIkdvM0IqIndkPSJSRykqZSJgfjAiNGJYeD80eSpDSjU8fSJ8NEoiTCIiJCJPTE8iUCIiUiJ0QSJndHc6TmlwKCooUi5EUWhPPCJzaSwiTiJPLyNKWCJZak8icytIIkgiVyJ6dmsiYzIuIlQiIkgiNChYIiBWYCI0NWQi',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGNThsbmJPVUFRQUFLdEszMnhySFlBMk1KZmt5K1FCQkVJTDdPRUMxbTM0K0R1UlluYU1BTnlRQ2FUYU1tMFNQNDFzdHZUTmZnbWdkZ0R2aDFnZUwwZC9QUmhpV2RXK0dJK2xiR0FPZGVPN2Y0VkdZaFd5eWVDOGpSTTJUR0R1NVZqN25NUDF1N3pJdndScGJIWTdzdEFpSkE1M1ltdVJtcUxvblVncThJRzYxbi9sZDdyYXg0b0lkeUczUXp4TUJudFlRaTU5eTRmb2xERUpScE54c1U0Vi9PT1htSHdjcFluWXNHallOQ2kzTEFnaDB5UDZ3WDVzdHVXcHMyTExuUExsY2xabHk0KzZXSWVkR2d3ZGh2YnlFcDNIWCtqVndYb21na0tMZytQbUpoZUlML3NoL1VOVkZ3RlpmYVZYMmk1MlI5YkJRQW5uSnBrSXRzbFo1Q2JzaEc4MnFDNEg3cFRzdnFyOGo5dTIxQVV1czZLQjczbTl1U2JUTis0L0o4OTN4MmpSNGF6K2dOVkNTRVliSWkxa2pRR3duUnVyYmVvN3RzaU9iMFBRY29mbVg2aFZNcGlGOFE1VjYxTjRiYW0waWRONTV4cXFQci9zKy9xSUFSWCtTdWc0PX4zNDg2MDA3fjM2ODcyMzg=&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGeDQybmJPVUFRQUFmZU80Mnhya01ta3ovbjk4OEo1TTM3a1BUczVCZW9Hbld2UjdkczhYNEErNFQ5cDkzUFpabUQ0SWV2WllwUVo3ejl5N1B5L0R0WnIrMURXNVZHdkRBdGlXSjl0YkRxWjcrUTNsbFFxMGpHK2x0SVVzTXRHOUxEVStCVmorbmpUQW8wQ0FwWjVYazRacE14VFZwNDhUNXhGMld1MDRWeUhzV1diWTZ4c1JxMHNTVk9MQmdsZnlBTGY1SlJXYm8wbEhWNWg4d011NmdrM0p3NEliOGxoNDYzeUtRSDd0a0dXUTBuK0lBdkRPc1dNNnZNdWxtWFljdnBZVkJVcWpDY3JHU280bHNZYnpLNk9OL2toaFh1Z0VORGliRGpqVXJXOXdNWWV0M2VidUp3enpEVzFDMjdGL3FhbDIvMTFrK1dhcENiTFZVUU1EY0phdVJSbTgxcW56M3paZklJTVRZcWhHTjBESTlOZzJxZWFhSVlOeEU3bTNKbXgwZS9FWnY4QVo0MlhwZVlYUVRSQklEUTZzY29TMGJtM2VGWTNod0Y0VWxjcU1TR3BYZXQ1elBDamJJQ1c4UEtIUG9qT0s0VXc1ZmFXaHZ1VEZIaXpnMVBlU1BGQVFXZVhPRnd3K21PRU9Jbk0xaWc9PX4zNDg2MDA3fjM2ODcyMzg=&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGeGVlbmJPVUFRQUF6VERBMnhyM2VFYW13YUV5MkU1SW5jNjZuNkRHOVNyaUpEQXVuUmJUbEswZHlyb1gwLzlPVThFTVk5UzFhSi9yN1pRT1NZaG1NcWFDY3cwR0tGWXAxZndqaVpGYzg3Z1FEaVdUSzc4NC9qM0wvYXJSKzRaQ21yN21tTTdRbEJTS2c2c3QySStWVm1KUWhNUmU2Ni9lRW1tdkZjc0NqUzFEbU1EZmxUMUdUYWgzdmQrZnEwcnZyMUJhZE40WVdUQVJHdlM1djZnUitjcWZuSHU2WCtUZDNHMFptREZyYUxyQmdrVjNFKzU0QW1HMkZRa2xrWXZ0N1UvcTdVZXpSNEhzMklZd3Rhb3liVzFNNEJyanorWHF6NElnNTNZSEJ5WFdISnBaaldaN0JzZmFUVkc5SnFXZC9ibTZZOGNJVzZGeFQ3aUVwdTNSU1BZakVUcmpaWmVjcmtjVHEyOUxVNVNXbkc4UjB5bmJTY1ZZUThER2wyK1JiZUJrZlBka2dMMTZuejlHTU1JY0JnVnJSVjBDbzZ0UG5ZTFZ0c25mMXNjV1cxVU01UU5hSnRlem41dUZNbkZQMlZ0Zk5kSVUrT3I0MHF1TVRRSHg2aFVlbjFIMjlWQjJxTW9QbnBJTFlQWjVLdVV4M3dBTUk1RFpwMk1TMEkwcnhCQT1+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGMGZ6bmJPVUFRQUFwdjNGMnhvcDBDVkxXUlJBeVZETlhtOU82ZGx0SVFEaVhPVTNJUEdWZEQxMkZwZk9Sa1FJamZaRERzVS9mTHFlZEI4aER1aE1BQmxFRTE5ck5kdTJmYXFvbWFUNUpWV3pINUhtVmptcFNYZlpEQzVJYXBRQ3Evd1FIM2hrdjM3ekpOZWF6Rnk0OUZ5a05TZWFGMjFxamZ1NGczSGdvbDdXVHkwZXlZMnlOMjZhdDVjd0taZUR4QlRqQ0NvbzNZcEN0ZGJ4STI2VmNUMlk4OFJhUHd2bitORU9hbldVaDBNZ1pPS1lBMy9qSGhIK0hZbUlrOUZHa0Jzak00b09ydk80MmdtOWloTmFXTlhFeTA1WFRraUJXT3Q1YU1GdkJVTnpXWFI4RGV6L1ptZS96Zm4xTmdvTnlFNHJMQlB4TGY0OFRpQTA5U3NYV3ZHY3ZtZnE2SHVxcnAySVRvYmVjQ1ZCWjZkNW5aSkJob2NaVFdFVGpndjhOTXRsT3I2QWRvN2VRM2VuMnZrbVFSYnNqbGZQd3hXWlhvbG94bWI4MjloWk5TejM4MXh3SmIraGNSSmNwQUZ2WmNhM0VaYjRFanZDVzE1Y3ZoVjFmNXJUMzI2N2xvb0pVaXdxcnN5cEExSmtFWjZJWGhNSHlpNzJDU01TVHljNkl6bFJwWXVLQkdpN0hlY3VqRVFXfjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGNXo0bmJPVUFRQUFCWHZHMnhvK0V5K3A5QjNKWVM0dUE4RFIyTVF1cnZWS1JVQ0R6ZmVJb3hYcitKajZ3REpjM0xJcmEwNnlGZURzelZtVS9UL0tWdVBMcWlLaUdEV25oc2pjRG1uM0xEdUI3ZURuK3hMNlNldXl2T0hPL3VxalVOaHhjRjNwMUxHUkZQaGdwQmd5QkRuaE5hbE1PVVE5UjlOK0pUaVhqaHczV2kwT1RReDRBL2Y4Mm0vMzJSVktrbWM1d0tvRkY5S2xGd2x2anFFUEtta1BWZnlzclhtRmxUbnlteVhaWnNITVY5eWEzZnJ6alZNNUdUZnNiR1pxVk9kWGtnWnoxNEgvaDRXVTU2SUR4ZzMrUThXMlh1TUVoc1labzRiMFA2TUE5UEJJSmMrZDE2NDU3OTRGcDNneGNDZWp4K2NSc1JwM2M1UlBPSFZhVVlsMis3VnFEMTl5bGo4dG53MWRFYTVWeTFBOEVLQlNOeWVrNS9hbkFmL2VUMFRQaUxJSGxBQTF0V0pZZVoxaVRGZHdZbU54R290bS9tZXRFVkxXRXI1b29FYlhpSFBmRUNBNnoyMUlPUjYrS1FuTSt4azB6clZMTFNTWSt6WXdTMGFGK1Z6NE1mNXVwOEdhdDJOT2gzQW82M0RIQVVSTWZ1QXVJRnFpWVVCTXJHbkJRazRyT1ViTVR5dlBocGd0aGQ4UFQxN3k2RkFqZWc0PX4zNDg2MDA3fjM2ODcyMzg=&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGNjRNbnJPVUFRQUFQdi9IMnhvSG1JT0pSdVU4ZTlJeGFLblNrUHM4UGhEK0tpc0VvMGlqc0QzbDhUUlZzWFhuR2xBUHNqaWxtMFdRNlFnSnVyWFNhWXdJTkdEZVlXdC9NSmxvbmV1TXUyU3E5SXFFWTJqdmpVcjhyMUZTakFWdW9Ndy90T3loTG5IL0REdWh3VS9aUlVDQ0xieHM0KzlGendCL3BwZFIwMkdCb0l4TGdIRGk5Q3VacTJ5dXAwQ1FwZ0hMbW9leFYwbEpjU3lLcmltN0NsM010WGxIN29YMFlHbjJLL3BQRlQ3VVc2NWNpUCtLMFVPMmF5Y2RnQ0xGRlJZMWwrUXJVbXh2K0ljTnVrb2tjcW0zWVZyeDF6eUt2cmVKT05yaWNHWmMraGdPZ3dPckJPMFdLYWNBQVZwNEFJMFFnUVRiZHdXbUhhWEk0cVpkdDNaT04rYy9iMEdsbWRDSU56K2ZQVGlZRkMvSi9uc2ZGTG5HakhVZU9LRkNITlBDd1Ayc25jdlR2dDlocVYvcTVodGwyRkJUTXFHTlF1QzZsWjFVdFJKTjFBR3JWaldaY1pINCt6OCtRK00vWjhJczVWOTRZZG9JYXFZMXFGUlAzUDA5ajVFeVNwVkdGWWEyT21DZVFYbEhVVHlVWm16UkhZaVZXMEhJMHZhb3VneDNzU1lUdVg5V01scHROMVJCMXZNTGhIbENoUlpjfjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGK0U3bnJPVUFRQUFNcFBMMnhxT2x4YmEvcnhnQkRjSzA0bGU4UTZ2Wm1xNHVScUxHSVVMaGVTbk02SFVqTTlRUWprU285a3ZHeUZ0ajQ5Rm05TUtramJXdzl5WVRuWkJTUGdGNkhVVEFoWEJrd2VxMnFwSmhJdlhkV2EySVFjT2cyYWZRb0MxOVB6a08rTlhheFp6cUdLVVJIT29vRFkyNmtqUnVlcnAvSnVkQTc5R3dQLzZQWmJtdFZEODgvOXpxTlpERE4wdVR0YkQyTDVlVW1JK21ka1l1WmdNZFBBek9vSVZhWTB5SENHN3lIMHNIdE9xUThTKzFVS242aXJ2Y2RoTDlGd3ZsSjdBZ0k1STZoSWhCeTdma0FJdzRLZ3ZHZWpGMHdpbDVqME52cm9MU1lVb2d3N0RPMUQxVDV5UkFNandET2Y0WHArSXRwa0JQd1hxOUEzUTVEU1RBQU1tU2JSLzZ3dzR1bTJBNnN3TzhRb2kwcXUvMTRQdmxtcDF3SFNxMEQ3NStnTkdJaDV5SWtRaGRKbEx1ZzNKUEJZM3VzdmFFUk9ZcDlFWUpBV09renJCd3ZUOGQ2Z1liVEtPNUZ0eW9FR2JiYVpYUXpENHBCRnBFVTBqSXpVUUhmdDAvMGk3cVpKWWtkSVlCTkJZM2IwekovdzVSMitqek5xdzFjNEgxRlFDTyt3VGZCTmVGVXFZM0xtdS9LSTh2QTcrU1BVPX4zNDg2MDA3fjM2ODcyMzg=&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGNjVVbnJPVUFRQUFaWDNOMnhwSElUWDhxamVwZDhWZXZwaGdWSk9MVGdmTnVqdFhwUDFqTFhrbURyWVdiUHdxKytSdzFRYUlZWTk4VHlMYkxFS2VldERXbGFuL01iNnlWcmNHODVQV0tYV3Z3MTF1YUdmaXFPdnJ4RDV4NDhmV1Zaek1FcERYTEtoWklkY3JnSTZ4L0tJQi92UmhPV1RXSUZEMjNiejc3ak5lUTA5d0FHdEtVbGpkRGI2TWpaVVpYL1BrOGxvWXlnVlEwd1dzc2UxejBvK0RJT21FZW9hMUREWnJUUUJVNUMxbUhmaHU3dmF3RGFOTHZPd004WC9DUklQY05HYkJGYmp5bFZWVGpwU0NMODBYZ09veVdYU1FpcnFqZkJ5dzJZUmJuL0tMTjlVQzAzSkVuUWpVaVoySkd4L2w2ejRUbHVBdTV0UU01VlBQejFZWkRPa2F5ZEtpS3JUNUp0RXRvUWFTTkFFcnQ5ekV6M0dsT2pXSVp5OVM2M3Z3Q2VFQUQvdzBTanlkYlB5SE1uUHQvSVhhRVVGeUo0aTdyRFpQVjYwbDU3dXRoc0x6NFJ0WE1DRzM1L3htVXJHbTJibjBjSVM2UFQvRXlROThXNHd0YXRwTWxHaGs2MStWU0pHaEd4b3VKQ3VxRmNNT3RMK2g3QUg4c2ozOXR3VWw5N0tFMWNMUkF0SFdtKytCMkwwTE1GdVFHSkJxfjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGMWRZbnJPVUFRQUFjTVROMnhxc2YvbStMUmUvQ1RIVUJKRXFoUUx6R1grcnlIWURrc2xVb1MxY1o5QjNWSm1WVlo1ODkrcG1QK2I4ZFZpTVBITnRMRCt3Vy94cmpYZUZES1VrcS9MMzBBWFdJYlJKclR1M0xrSGNIOGY3Z0Vrdm5iQ3YyM3RlaWFVSjRtKy9LRGNoY1JVa0NYWm1ubXZxQ1NZNkIyaWpxVi9wMlh1cXo3c1g4OHZRZDNCcjlqcUx4OFE4RWovWFZycU5tNHZlOVl1OTF2cHRBZXF4Y2RIMDc5RVBUczFkUllTUkFJTnJDaTl2Y0VDNjdHNVcrRHBwMFI1MnlvaWhydUk1Wml2WDhyMUk1SVBvaFg5QUJHUkIxYUVkaE5EQkR4K3dkYVo1QndUeS9HVGJhQWtkcnZzNTk4ZXNqUEovb0o5OFI5bUJVZEJzNjdFaTBML2xWK0kwOG92eHJWWlRiNnZ6L1lhd2lBeGpUREllQkg3d2hxanFFUUhBNnpQam03c0liOWlseSs3NzFrYytweE1pWUFUK2ZkTzlxQzE0d1ZyZ0s4V20yMUJMaGVEY3FxWFd0WnhBSklKREhCbGhLaTRjSWRTeUthWTB4WFlBR3BXK0ZqUUNucUpHNTlHZjVibjB0elBlUzBrY3RMNTJCMlk4eTJKYUFZYzI3Zk5JQmlkZC9FUHZBc0ZyL1B4UngxaHNsT009fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=MzsxOzI7MDszNDg2MDA3Ozk5bVk5LzFqR0w5ckFicU5OMDdNcUJtcWdQSm1kYmtVbzhpcjZ3ZnhoMVU9OzU2LDEsMCwxLDIwLDIwOzJyWF9ZInJoNiIzIiJVIjYtNiJ8ImprRGhUVHUgUyQ/ZjdFK3BbaiAmRjVuWV9YQDI4RkxhR0ZbZD1QWUg3NlY+dFUkOUhvcGRAPCt2JUhQLlFQKSJEIi5RbSJvIlp+QCgiKyIgM2siZCIiUiJOKnMiSCImIilUMCJ8LE4icS1TKD1jZTE7Z2p6fHhgQH1FIilSZSI7IiIhImgyYCJ6R3BvW3ksRi98L219YlJJIFRaZiNIdHF3YzhrWyFZaXRMeCBzOkMkNXk4bXhHOUtzXmVkM1lCaGVIPG9Wd0lUWDxveHpGZjljNmA5SFVZV0BQIjR0KyZmfTo9YVcvdW1oU0dWIjsifEs8Imh3Ij5dMiIrQGsiUiIpdXBHQSRXYHtjUVliPGdHcWI1KTtqIDQga309cEdKeyVyeFhZNncyUTItPUsvT0BpXTR8QyU0UUY7S3hTITRseXF9bl49JERlV01nL2k4KFlUN3lVMkJtVk5zOSRlX1NqanJybEE2TSUheDFLLGxSRjUhbVI2RiVyXzNfTzw9QEQ5VEtTPixNLyErU3RXOCZ9d2pgOSBFaXVoRWxlWGVpenE8LDkvIE0hKzZVJG1WUEFBMT18ZjtVZ3VHd3VdfHc2RWhid3NjRnkhfmQuIGhqaGFgXj86bk5KazlxJnIrL1Jffj1LSz9+Vmh7TyYgdiFuMH0ydXJBeTdNLWJfa3gwXXQ5T3JvdFI8TFs4cnhyKW8mMjU5LG9Han5mTVNedDhVfkpgK3w2eV96L3lRal1oezc+RkBBI309Ui4jLS5de1pqVF8sRk89IT9dUjpBS1RiLSRDR1I4Lktxb1FwbDxfRHBEYyk5XUhAUylraHVxPEJte0Q8WEY4V3p6dC04Zy9sTCFOMTZYRERlN0AkLzVbdUVgKCxAOzVbMTJ7OlczY0gkayZhKDg9NnJHSTJPYSlAbzpVcCgtJFR9KypTZ0h2az4uaD5eLSwlZThPQlRoRV03UTJGZ19qSHctIVF0ZC4ja0skbDhraHBWMjg6ZXpMdVF3UXI3Qz54ZWx1QGxfPC1vdEs3XjI0UkF3MnxTcFF6XithLVFiek08TF8ta1A6M3B7WEogVGpyZkxkfEVhRnRVMnk7dXsjdlt2KntJQCEtfHVsTylmKE0zeDRFezomYGMofER6MkZBfEhgQSByZWtjZlhQL3ozYUg4XXlJdGtIRXZoNHc1Tz08VyxdUFM2VUVNOUcjdTdeVU10MWpMMXptYEkrbyxIPj5kPHtoamB5dSklLnJoNWBYXiBOKmhjRUoyJmVQdTc7Qm0xM3gmNztDXlRgWU18SlFYIEwzciBbbFpVTC9dIy8zbTs8ITg2W10gJkB8KlguRE98SUF7JXZ8entbW3xZXm1KLCkgREFqZjpEZVZSMGRwJWMyMSEoKS4lPioqUCU+UC1xbWQqPWB7QE1mc3pdR0prOiB7bHx+MSE5NituQmdvYkdNZHswWHZFXn5+KG5ScyVsS1NFaGV6OkE6MCNbKkUseSAuTWU9YTZLeSw8LXs3UzZ1MyRHR2tqNzJBdHEoXUwzTlIrOSY5ez95ezUhJDpdTT1MVGsjVll3cyZ1bUFaUkBmdkVnTnpQJU9hOSZ2O21jWXJ6OkF6KEdTa2JWM1tTV3oqXy10RTFeMD1lZ2U4a2RTISVNej1jdTlPRkQgSEhKbCR0QChbVn1kJFBJRStXXVF7K1Z8XXVBTX1zKU4rSDpwfm5BQXZrP31EeG8gWT9BRmcla31kemJvRUhQMmFwKUd3WD42d25IQ2I7O1A6fSozZXRJe2AuYC9WYmhJREhfNGdRMzAhdE1Ce09hcWQ5V2kuYEZlSCFdNF5se19OaylZNCVwfmZmXk9yT21+dWl2L2AlfU49aFQkanErIGguPiheYEZTSkI4OWddZjokfTJMLldVJnVMRXhebyx6bjlgQyV1ICtxOn4hW09fOygtQl5FdWVIPy0gUz9QKHN1NmZMM0Q8TUFYU1E8MlMmMCZKelo4KG9lU1EvcDlgamIvXVA8U0Fkaip+JXFgQWdkcDdlXiw1dilkdlZDeSJDIk8kfiJNImJxLTI/NjwiRSI9VygiMzZ7ZE43IiJ3aFoiPGZtIklBak8lTTJJIm1Ka28iPy59LyQxKDZ8ZkdzIiltSEgiLj5aZURJd2RrI2gtazlqS0lEUSkiNCgiRDU/IkBjdiAieUllOEFWQE9vQFthaERENTVJViJrX18iTCI+Vj5BQ258JUhwOkhVO2JSfCg7N0NNbnE4U3M2e2NOVWhedSI4Im1IZiJfKSYiYEp2cV93Ii5EK0MtTEo1VlhqZTI/bFguOSNmY1pdeCtjVEpsY1NVeWBIfVddW31ge2skInAifWkxImgxIjY8cCItIi0iZy0kImU+PSJRZ1AzcUJyIjQ3L08/Z14xcC4iQF1+Ilk3cCJ0KmYpXVB8aCJNdSAiISIwe143Kk9xXlpnaUp8fDdDaD8tR2E+fWNhYTN5IG1eW0R9cFE6JXBAayI2JGIibzVCInoiIkpKSSI+JV8iTSJ3O1V8PzVvajRwLTYkcSEmajF+LDNtV2hzRz1Edk4/Q1FxJll2O2QjJjF6ZDQ8IlpBViJsWXoibjdNUVs/anhlPDElKm96XSJxZCZUIl0idWUia0o7IlB6ayJmQ0JAJX1GR3sgVSJgIUxTRiI9R1IiRCt4RGwiU3pYUHdyQSIrck9kWExec2Z1V0ZxRkE4Xy1nQjMsJW9fPi9SJH59Qi5DIzs8czZqbm5bUXh3ISBOYVFoQTE7cTM7IVQwPDgrXyU9VWNqW35DUjtBeDxLPyJCLHwiLyImOXBnIlZrcSJ9Zl8iRmBvJjBIRzRxTnddRWwqYEpVU1J9WUpvZS4oWTA7OVAiTSJqcEAiZzpnKTUiLzQ3NiJ9IiJrInlraCI8IXgqOiJufFEiUiIvflcmZzp8fWx9LD0iUC5AIiZBUDU1QU1uICtJL3QyPlY7cUNHIm9jdSJbcnskckwieyJJRyoiK194Ikh6OHd6eHlnIkQlbCJKIn45THgicCIvYXwiNyIiNyJtOCwiQSJqWlV9IjwiKS1XIlhnJDk+Ing6Ii8lLl4gIiVENyJvcTouN298KWwiJE5XIiYiIm4iOmZNIm4iRn1aOn5bNHU5VldbNiJqImV0UiJiIlloLygpYzk8Il0vVyJkSUMiM3BiIlhBdSJQaShFaj4iOkRmc29ZNyJ0Q2ZLOiNjSSppIlNZe1cidm0+WjBfOllgOVp1entlfjNrMSNhYjZQYF17VWQkMGkrMVUgIiZzOiIyaWMiMiIiOyI4dF4iKiIiTFdqInY3IjNBXT5rIipNT2YiJTQwdThJdWhTIismNHM7ImFxLSl1IEpoInlhIlQ0ZD9XKm9iJjwsdnZjZFt2WWBSIVRxQ0t9WjRYSSQ1al40djBNU0d3PSEiZCJPR2MiMWVjK0tXOmV7IjwgdG4ieCIxU3gkfVF8cFFhX25yOys4IXtGdHYhRHNdQj8mKnp7X0VwIkAiWTItIlJLY3IkInRzNCJBT1khTkQkcXluIl1IKlsiZCJDeXZoJCpbWjEzQTw7bkxpIyJ7IkVBQiJxaVZTflJzbCJ1biwicisvYmEieXYibGkgTX1tLzoqKywlSkl3ZnBzaUgiS1tkIn5KT3R1Ik4uUCJ7ImN2NTVdIn5+dyI0PCIhIiJzIjVVLSI+Ymh4WktSI2QiQiwiJUA5SEE7WiIiZWNBIlkkTSJkPV5+LDwicDAibVloU30gIjlbaXYifSIiSyJDTzMiTSIibkJTIj9JbiJiIik/ZXU/ejwsTzMiUXl0cCJvNl0iYzlwIn0iOjoiKi9rIiVLX0ciUyIiUiYmamdncSxZZCJ6InhkdSI8PGkib1h3MWghUmE6RCJYSCsiQDNXWTxDIl5HJGE7W25oSysyfllkS3A8YjtTc34kXkFOUnlLLm9uTDBzVTFWZ3VYREVGbjlwQHw+fTttbHpfQlpqNXVTREIgbltCe1Nial5FT1MuUTlmRnBZeUxbc1dLYHdGKXFdW01FLCZhM1BmWj5iWENjUyV2PDBRNzxYODxMbE4yKWtubmlPYC9yLkpBLEpVQW5hKytjT29jdi0wKTpVPyUkfXd3IHJyXTdpJitzNlkybFA9MHRsPG89WFdJfDk1IHdleHQoLjZ4VyRPXU1vPXtgRjM0fW1ROlRzfClRbm5WZGR2by0jLip7RXxtdExoXTYqeCUgIkkiOXJsIiEiQiImQEMiVll6IipaMD47cz8ub21mb2dJdzEieSM3ImoiImFyKyI4UHYiJlcvdzJTZCJDQEE/PUYvJVk+IkQ+XyJadCkifCJ0O34lbUUxbXVXSEFGMVtWYlh+L3BzZWJCPkRodSReTmQkJkBpYHEwcSJnaXQiK3c1IlFRYiJ8eVQiP2Bpc1FuMyR7fW5XIjJnVU4iMCJSX3t2LVpVbS8leig2XSJFaTgiaTFDIkxefG5LIk9rdiJwNndBdiJxOEEicnREUjhPXilPamtsXiIzQkcibiIiVyJvKSoiQyIiLyJ9OCJySHZXMWJyOzgwZzAodyo8VyItPHwiaiIlZE5wbCIjay0iRSNbInwiPiJhQkEiRVctIk8iIjkiNS9qIiE9MCJ+VEsi',
    # ------
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGejVlbnJPVUFRQUFoVVhPMnhvQWtHZkpZMjEzVDl5YXdkUVNZS1BvTWs2ZDJqNjNPWW5QSnhyZ3k3dHBNYTBzTm94eHpYTXB0S0xvSzhubzNRbW9ya3lVOE1uMFhvZk9VTXF5dXAvR2dKd24zSjV0Mkt3d3Rqd2RkUk9uWHErZ3NKZHJhaHJUd1l2cjk0UHlsVENnN3h2NTNJWmNoNE1SOVlBMnpXczJlWFBUMlVKRDNMNzhZd250SHVPSitxS2JDYUI0ZE8yTHArcm1tTmlYQjgyQ1BwLzJKckwvdStTMUd5d0dac1Rmd0NCR0hkd1UzNEZOQTVZYm1XMVBHMnFDSGJTSVYrN2NxbFlpbGxmUHpNdWpnazhTdW40YldHdXpjSVNseW1EM2tYQVNObDZPSncyUi9tR011bkE5VjYza3NDdDdXeFEzZmV3enl6U2FtSk1IRVRSTGxBSGxHK0tmNTkrK0Eyei8yOUJuc0tGS2IzMXdjdHNRemYrSGlzRk9XUURWZzczR0NiNmFuTHBad3dmYWNBbDAwaUZkN1craS9iUlNkdlRwcWZLUXlzRjJnZG9wTjlwS0xWcHM1bGZYV0plV2dxMHBvanBTYitKZ29ZY3FoY1h0VHp5NDRZRTA1OFJIY1c1Uk1DMnhtdUJzdlJqQzMrNWNNeGt1d3JRSVBaNU5saW5ES1JIM0cxd0l2Q0U2eU9lUXBoSmZVQT09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGNTVvbnJPVUFRQUF3akRQMnhvM3ZMbXIxOVN0U3ZNTFNnbDJVY0Q4ZXNqa1hHZ0pJZFFIREpzNzJpUlYxL005dUdHVGVweE1DQ2QrV2ZUWWk1eEROd3U1bVhqdjdGYThHK0tjT0Z6ZWRGNGo5dStrc1d4YzZtNUVLd1JlYTJsVHBzMmNwY0ppK2lCYUtTWHNEZUtKcitxaWFFVnA0dzd5SmRhNGUzZ3JYRVUrV2g4U1haZXdqd3lERXMzeFJ0WjIyT0tML0tPQlR6anptVmZRWk5XWUJ0a2dWSTY1RUpnUnlpQVdaaElkVnNzdnZLb1dpTm9VRWpGQ01xZ0hJSXJnVUwzcVMwUS9GMDVWcFBYZitmaDJVVUZTeEx1RUpvVlYrRFJCVjRxQnFNU1F0b1BlNXJDa0JyaWpNaFdjTStCWHRnUk8vMTc2M3BNQUZXUXRhajNrS3lyci9OcjFjRVI2QTBWUG51bDNtVW92YitCSHdROHg4V1pDcm1qNGw0ditEdHVWWEJ6dStMdG9UQ2FIbEZ5OTF1Z3k2ZlFXV005Y2ZHMk5FZHE1emEzSnhOOCtNdldLZVhNS0hvb1NqTUN3TnRjUXhndy8zd0o1ZXlJT2tSejh6OEJiaERHaDVldkxucGIrQnZPMWVQbjNvRDlJYWlXRDZBbHVxcTljMk00Qy9UUHAzaUpUbHFERjZ5b2hjdEs4K0xkbzVIRXN+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGeXh0bnJPVUFRQUFEcDNQMnhxVjVaZWhkT01JclliSGpCcjNueEZ3RW1CbGkrQ05WbitKcHRFT29yd2FyL3NrVmczVTU5R25HSkxTc0wzRmg3V0MxSk42T3poRzRLRkN5dGs5dy9uZzJUV3J3T1E0WEx5QzZqTG5OWWFaTWZ0aFpaL2F4bkl0LzQ4SURuaEVtOHUrYXVxc3dIc2ZpYnRHQlc0RWZ4aGJKYlNPSjhYL0ljSldOMWRwdnVxdHRmb3VSQTVkUjVmODAwVnZCVFVhWVhPbHBCWGpSQW9VbkRCckM0TTVuNkNPTkIzVE5DMGp4N2c5OVBPcmRhSHhGUXJzbXBpaUdQWk9NV3dpME9qVXQrbmxNQTZaYkUvRUcvTFJzalpXcnBmU2tpem42NTBxWkRveWdFY3QvSlF3UmRzTEt4ZU90eGlWQmlWR3FjS3VwNDl1OXJ5ZGJnd1lGUlBNK0lqWnpzTTljM0Y0RGJSQzVwRmNsY3ljVWN0WGxJUUZBdU9VUFZBSmIwaHhVTHF4YlE3MS92eXE3SUQ4U2FJTEZmc0N5QitzUmgrUXJSdGZsWTlpdk1BQ3U0Q0Z3bndhRDVONjhjS3ZFOXVwK3AwUlI5N1JpQ2Zqb1h4UjZEUThCbnRSSWRIL3pJaThncG04UGRhMUlzUUxaN0p6ekN2K3lZYmNGS3lVcmZKeitVTVJOZUNqVXA0ZXo4OWdjdz09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGK2lFbnJPVUFRQUFVODNSMnhxcUxXWVZKekpSR3I4T2w2K0o4R0dyZm9sUi9oODh2WHJRanljNjJCZndjN3dEckhpclRxR0MzUE8rZlpkdlNWa0ZZRnJxSWprZUZuOStDM0Q1WSsvRzU4VFVjZnB0dDA0dU9XbFV2K2tpYXJUdGl0ckhTYkVyMXBTNUliYzg0cWk0RmJvSWpIQTZUVHRZVnlwd3Y3UWJ0SDA3UVFsLzhyelNEbUt5cEZzRkp4NlRuYU1ROXYwK0dCTGJKOXBlVS9HcElvRVY4cUN5bGxuL2dsV2l3OTFnVyt6dFhBTXhqc1owQkFvSUNsRUZPaFdyQXU2N0laZE8xbk55VnNKN0NVUDNneGs5R3dDcFM5N0lMcWRIczZFV29KSjBxUE5UUXBmbFdleWNJTm9JejRUeEpjSHNKb0JnK0FrUUlQMGJoeWZGczFMckRIRFhZNmpaS1FnbUdnTDZpczJkQm1FaVBnWW95OFdKSVU3OTJ2dXo2SU9DRkpENUh0RnZDZ2EvenhyMWNubzFZbm9Fd2hSZnpXZlIzMnVlV05oRHpwakZ2ZGlRSnR6THVuVGVpUVkvQXl5MStxRFBpSWQxTDZ1RUVlRFZ1eS8vS1JIMmw5bjFDalF6SUlsVFlXZmtVRXRvWktiSG91K2oxUVltb0lHQ09COG1QTHpmdC9na0hsQVlpcmxid3U2UFEyZHhkQT09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGOWVJbnJPVUFRQUFNUjNTMnhxOGVJK0tQMG1iMnZuM2Zod1A0WnQwQ2pQaVhUbm9vS05BQWRobzhzdUgvL0NZa2J0N3hMMGdzeXY1U1h5U3N4NG9VSUliMTFZcEgvMEw3UEZDeDEvWFZtTERUZmlLZWZaSEpKVlpPRk9ZL3ZzaC8zWEZJSjZqV1RobEVyYk1CNEFUenJHczZUNlBWWXVsSGR4d2ozYk1sNFNqaUNpNCs0RVlIejU0WDdUd0treEloSjNzWDJiU1RockNZREZraXlHbTBmWkFBQzdOaUxFbWhMYmJMM1dkbTNVZmtGc1p6RG1GQ3dQYWFJUURXNlFCd3ZCeUF5ellHVFltMW9WTExkYVRpK001NThaa1Q4MmtQM1pPVHloSVlZSE1EOTFZVE9EVUI1eUwyMThGb1dZSERuS2pOVmRVOXE1RmtGTVEvK05pMW05a2RaWSszYnRhekhBY1BPQy90b3Y5TzVmYVdUaSt4UXBpNWs2VjlYVTVNY0crTldTNjJDbEMyZDdFK3dCVVF0YUJtV2FxSnoyS1oycGtqNDYyNFE5Zi9lSWp0Y2gvRU9LK1hOSlgxK2hmY01EWERWN25FVDgvTTRrK2VFZ3R5MlhFUmh1MjMyMWpyeEc1RXNZTmp6Z2l6K3ErS3F6bm1XQzdFZTlkSStMdERlWFZheG53RWtSdGEyV3JwaFdjS3NOSTVrZm5+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGM21TbnJPVUFRQUFHWTNTMnhyUng2TFBzVzQyYUtGYTBrN0xmKzJwU2RCOEZieGpOQjNhQ0F0TEp4SVBrUUdJVHhyaE5zbzJIQWpXbjFmM0Y5WWk1T0ZVdjFkTGdKdlQ5ejlwQ0t5UVpoU3o3aG1QbmV5VkRRMU1YRDluMXozaVV5Z1JxajJkVlpqYVFVR1ltTUJHQ0loMHJ6MlNwbDNHL3VPTWFnTGRLUkZhYmU3ZDdVeG9sbzdiSWN2cDEySEgzWmoweDdMcHN1QUZPVWdGcjRWY09BYXNaSzZJVnFvNU9jYkxVQXJnQjU4emRSL1ZUWmoxVFh1UStBRXBzajR6RThYQWNEVVdiTWlVYS9ZTkJ6dyt2NFliUGJXT0xiZTVqVk50ck5xazVJQjgyVFgzeXVCNFJmUjRNRllpQ3lkL1NJZTdIdHhpb2dMeHV6MVIxaTN2YWgwZ0VrN2owZ3h5RjE1OTJDWG1ncUQwNGN5OGZWV1ErS0JuQVZRNzIwa0RCUlpCanJuME1GT0pTbm0rRUR2NG52T0k3b3F3YTJRNmVUTWNWMGN0ZlorV3NlbVB5aHo5NnpoWGxVWWNUeTVROXUvWG54MmhTRUtCTDN6bjJNK2ZUc2VxV3lCREhSZGFvdE5aWVl6MzFjVnlNL2VIcWk4MC9PN3NJbmxVNEdsMUgvZ2lremNCL21SbEpKSytCUEs2S05uais2N3c0UT09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGM09YbnJPVUFRQUEzdkxTMnhvRE9rUkVQMFU5VjNBTlpnVllpNDlSa0I5YU1xWWVYRWlIK1ozRDZ5MDNNcVU3M0dEOGo1OCswZE0yaGFiVEhmVzZmTi83Yk9zTnVxRkdGcThNOE1haUpYeVdHMU9ZcXI1SlBqTFU0bHpla2t3djdmbzdDL09wWHRabUQ5VTFRcWlaVlo5ZGZUSlU3Vi9PbGxWVzdwNzVERVN2ZXRLR1kxSS9IZERjTXdESytFK01Kak5yd1NuUE56MVJIUnRrdGxCSmtTbjhLNG5XeVFlTk5TTjdIRHRoem9FS1hKYzRqVUFJQjlveWRyQlJqRUZxSnlEeFR2V3BGNGUycGJvd1FEQm1jTWkzZXlkVVZ2THVFQ3ptYlVKS3V1dGdleXZtMmYxYlZjbDZONTBVZ0RVTmw1OWNqTDNUQTRsNkhvVExFV3lDMzFHbnpnNnFCTnhHbGV6TjhGQ2FKcGNHODVNR2Z2TithK3ZidVVmVjBrTnZUZ1loOFZIbHY0dThlaHF1WVA0OUxQZmplRThKQ1pQKy9zRms5QlBOdEJjTEhzcGdmdVI3MjhQSm85NEhzc1BDblcxcG5BNWpvcEhGRVMzQ0ovbUhEZWQ2eSswOFZoTlhlRmZrb1g2QnpEOURmd2FXR0pMMUhXSDdOdkZXaFZmeXIyYlZNbEdyTTRHTVdKeUtRTDJEck5Yb1hxczZzUT09fjM0ODYwMDd+MzY4NzIzOA==&&&sensor_data=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',
    'a=&&&e=ODlCMTdFMTE2QjU1MjIyNjQyQjlGNTVDM0IwRjI5NTF+WUFBUVhySXBGL0thbnJPVUFRQUFkVnJUMnhwNEFLaVZXeTJOTkFUZXVTVDRad0syUXFMd2tGQW0wMVlIakNwaHY0SFZiMGdyWU03NER1d0g2Y2tRbnlsZTV6NnpnekdTNHQrNVNON1F2NThjQitLZXpWeHNCQ3NIVEkxenhGaXYyZWxCYUlpMzJ4TGZ0UTRtQjMrNGlVOGJwM2xRYkVLMXMyVG5zRGRIWGM2ZXVGNEpBUWM5RXQydGlnTzNlQlJxMmtKdDBuOXJKNjhKYWc4bDZOeDY3ZXgzeFM0V2NsMENkNWVGS2tPczZzRzlrWEtaRUJ0WFRyWVNudHc1WG03bVU3VE9nS293S3MzdVZ4VFRwMWcxbjVaY1h0bExJaEtBazJnVEhnUWNYd1VmTWtMZWw3Q3I2cFc0NXJ1ZHlhb3hPSDN3VEZodGx2TzBUUnlDVmphOFNOQ21wY1ZqVE5KZktXbzVzYkZRS3U0VVhxQzQ3Zkt3MGt3NUUveWtkS3FkNUFzSjV2S3NBWEtpMEtBUVFJLzdWamlubzZEKzdCMzFOTk9wNFpXaVVHTVBjb0RsNVNDaE1XNURodlQ3a3M2K3A3c0ljSTl3M05uczhsSmQvQ3NxZVIrT2JZY3daZjN4cW51Y3BTMGFmUlcvSjVuSWJwdXd5ekVpR1JuNlZsbEtQV01KUHJqWHZqUXA2YmdlSVEzdjdMS251RnpUTjAxOUR3PT1+MzQ4NjAwN34zNjg3MjM4&&&sensor_data=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',
    # ------
    'a=&&&e=NkQ1NjJCRUFBQkZDN0ZCNzNBMDkwRkNBRkFCMjY4Q0Z+WUFBUVhySXBGMVpZbjdPVUFRQUFNOS9oMnhyU3RXOUdwaU1rZ1R1UTd5RThWbjBFZ0llNjdtenFKYUV0SHNmb1BOZWFwZEFZQVpNQXVaZDlnaEJhSXI1ZDRNSk43a0FVZ2FIZjVpdVBUVEZNQ29GZ0IxU0drMG14dVZ1OVBJRjFFeFh2UnowbmJ0eXJTd0N6eTZqK1J1eUdKRTI3UUxodk5nZVdJYm9KQk0yUis2dVVXditFTDRNeXkvckdPZVBZYUFQQ1ovRlREcHZUSnN2MDFqVUpaZVpNNDJheXQwNXA4QUZ2ZldNYzVlUWhOekdoMXVmbWY5NXVUOXgraXUyOFV1cTJEbEk2aUlBbDg5Nmt4U3FwMVhTMHJVdVVUY25tL3VKWHZQTnljOUl3bVhPRk0vWXhmTTZUMzV4Uy9lUDRaRjNOSTJxc2oyN3J5NU91NGt3WTVqNXZJNDZCN1NTTkhqbml1dTNDTnQwVm9lYjJsb2RaL25NeFE3aW5lMSt1bk5JQm1GUjZySnU4M3Zza2tKLzZmYkYzbXpaZ2JvNkNFZmYxcFFRTGZZcz1+MzQyMjUxM34zNjgzNjQw&&&sensor_data=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',
    'a=&&&e=NkQ1NjJCRUFBQkZDN0ZCNzNBMDkwRkNBRkFCMjY4Q0Z+WUFBUVhySXBGMC9SbjdPVUFRQUFNWGJ0MnhyL3d5U256RFJDU2dTRFFiNzF4a0xUOCtuNHVuU1Avdk11WWJKVm9yTDZYcWNMSjVRa2phNUYvQ1ZZWGdMV2xWUGNCSEFQS3RabWxZWnRSSmRCc3RMY1dQdlZaS0VHTmdhNUFqVWdWYUg4SUVaaFZ0eUFqTXpoWjc4aVh2alYzenU1YjU2cVFpZFovckhlKzVBeXZ3Q0NMeVJPbVhPN0NnbXN0Z3R0cWhrREhTRk14SWpNYytZRWFlWlRLSUkySXo1OGpONlNpRWo4WjV2YlZGdzM3SmhERWZic1ZLRHpvUDBxTkE0bkxpMm91QWQvV0pOSUhEcTg1YWxVai9iMU9PNGRCWlZZR2JKZFZicnhGSmRQMm5Cc2Y3R0I0TWVwQ21nd05WNDdYc2x0NVVpTGx4TGZENThZRFdJc1Jxbm5QK1VjZ0xMSGIyRlFKeHZ5UUNoZGtKQ2k1eVlDZ0pWWHF5VnUwRnBsUFA1NmZVMkFhQ0NpWU5WU2NjYXl4WXE1M0wvRGg2N2VUNHp6eE5OekpzZ0tqSHl5MGxBQXJrMEY4eW1hfjM0MjI1MTN+MzY4MzY0MA==&&&sensor_data=MzsxOzI7MDszNDIyNTEzO0FmSE5UdTZKZSt0S2k1VWIydG5yOFlUMllDamhVRENSV2x1cWtnU3NwamM9OzEwNywxLDAsMSwyNywyOTM7TlcvSXl0IkA/IjlZLyIxaltLIjUieko9KF1XXS9ubC9BVjE9a2ImUE47XStqOzBnaT5Acl1yRTY3YH51XWBba2ckZ35dXXZBbixhbFErIDk2cnlCMyU0NDlWSV9OZFsgIFFRLUQ4ZzNOJVd0YDg+LHp5NCh2QnRvIFdxczU8RV9lY2JkU1cldUhpQ3BnYGogTkZINnZ3Ul1nRHx6Z3w2PChPZnp+c3NlbiFMLSFkcWUtIHpoZzh6JTYpaWdbcylTZShGaF5iQC1DSzJtaldeYnclPH0oUT9Uc1QpRTw0V3k8OyJjYn1VTWUgYEhHQUZaInAiYWlIInYiIV9reUNiNVMiJmhdIk1EUCI2cnFLWyVhIiJ3IkY7ayI8eDcxbjd0Inc3ZnEiWmQjIjFmIkFhWC8rIlFQIlsiSTs4UCItInU5NSJPWG9RTWpsTjo7QFNHZncuTGhTIi0hens8UDw8QF17NHtXKXZlSWhNY0RNdThzdFdYengjayhpe204PWtWJW5UZU9nNzNlYndiISpTWFVCeyxGQzwrW2RsRyJUKXAiRHFAImhrczZme0NKIjBHMCJQayRid0U9ZSJDa1UyKG1nQHlRIzNHIGFqJkdgT2JHdld6RUdfPXs9QH1HPSF5YWVEL108RGNPN0xKIU4kWUB3VHpVUX5eRWRuVyN9X11ITzYyYkteIGtOd3hHIF9AKWpNaklYbGxWfjYhS0NHSSxBfCRnSmN7a2IjRHRKM3VtSDRkOVRxa2gsRytoc15uZXRddkk1ZiV3bDVPNHJhPDh0Z0Z+SF5rZyBWQCEqezgyQ0JJMX1HcGxqLls/dHxfXUkzemglRkpKKUQ4IzYzUFhpcXBmVyVYYmk0Xj4kfG5uW1g4MFchOi9iOTN5QTpeayR4PXsjTTE8R3tIOiB9cyhteGBJJE9idkF3e24hPldhOTxOP0NzYXB9Xil+cXBke3ogdGAzKyQ4e15TXSAtS14oQlBbUjd4M0p+cV9MYVlwcChsbkgyT1RDIzAzWmkvVX4zUV5fUzhKcEomNCM9QWlfcXNwWDtecmBFVF0tRWgobHtOUXBEPlp7b0RjSW1zPERXXVhHQVd7aVJnIEVlT2FHVzFCW05FYnxuZ2hqL0NafjcxSzkjRHliaiU3Z3pfMnMwYXw1PzRSK3hvcSRLWzY+bmd3b249aWdXIzFuPXlXN1kxU3dsfUZvdVp2K1RpQWErOlBPRnpFVlBxOWs4KV9Udlp+TEpINmBbU3B9WHNPbTxVem53Ry4sOmB9cj4xZFgyfjdjbHpNNC84W25CbEdxWGwyLjBwX2tlSV5EJiRlWjd4SyYlSSFjYXA0WThZTmlPZTE3SCh0Kz1sSTJ6Z0tLN35WLjNQOHkxOWYrekIvXUBtMkVNSCk+XSxdYEZGMjh6c0ouSmRDNUVONGZEJGk7JEcvNU4+OlluVC8mZHpjfVtjOXAtV0Q6V3BGfmVGQHNfKG4gSkEvUWZXPz8wMDM5PDF3cCxEQTVYfFUvfmBPPi1iQGgsMX5JemZKRD9RW2Ffbj86aSApfVVuYjgvJXtjRjNuOmlraipYVTJFPl9ZKHstIW41W2ZlPW5aLSNyKmNsQzphMjRFJUNDKzs7Z3ghNzEuJFg0M0l3SEB9NG0jZHZQT35RWGdJfHZtIDRUbSYuUURJblBdd0t3cllsaXJwcllYN2p0NWpOTkZkdTlMI3w8PEAgayQrdlJMQVNMVlNqX1kveyg8LGRwbzQ9JTNkeEQ9PSZ0NkQ5a2lhd3E3NU5GUy5yNFA1dSs3XmtXbjxOK302fGkrVjh7NHxJRWtjLygwcl94Qy8jMUhrNHY2fDJbXiRxaSlPS3g3OlVjfj9QXm5SVmxEKCY1VSRIK08qUCs6UFE9ekU4MzdEY3RCZX4qOCV6T3x6ZzZFMUs5dFIhSGt6Li5SJn53JjZbeE9eP0hZY1QyWFRXIUMgSTJnWihheUJLTDBhYVN6K1lpUHJAVnppdkV+LzRQfWQzNmBZfnAoXWRvWywuNkZpOWZEaD5QMiIgIn04OSJWInxxVz0mbzFoJCJQSkEianJgIjNQNlF9by9iIk9NNyJyIn1qLyVyIlR2fSJEQFEicU8hZzt9KWpqIllJX21mIkJ+cmFVIipmPFgifSIhJGctdVA6cUokX2cteSJzIlg0JSJQOjckKV4/anBkRyJ4WnRkIl8yeEsjIjotMCJCInI8QDsxOyRRNno8Tkt7eSwkNk1ZUjM3Z0YpSWY0XXNobkIzPztEPkB2fVBAPTVoJWdDI3s1dS1SOEZmS094PkhUIStHTnhmQlZWcUpJZ0FtWiwrbiVkZzxUL2ZtdkI6RClHQF5kImk0ciIlYHsiISI3dSBleGx2TER1PVNeP2d1bXssP1hxfDkvLW5OS1o3Y2RFTU5VSmFIQHdGX3JVJDEoSkt8M1lneyImIiM/UCItIHZoX2s5dCUiTy5CIm9CTiA9LkhoZiZ6cHtuREl8RiJ0fDEibW56fGFbMiJTMiYiaS0/dzByaURFIjNyQCJoQExQanItPVc2SSUiIFJDIyJ2Ik8iQSsyImt5XyJMY1Z9MH5zIiJGIl5VPCIsTEksVE0iLnBHJiJIUmpQVG4ifGoiWnZ2KEcuNEdgcStsMiIiPCpGIkl+VSJ1NS0mWCFocXIiSEgidzFBPSwwKVdJOEw7bD1wNl0id2EmdS1NPWYtQn05W2kgT1IgcU5TWWBaJE8oZUo3I3JoZjImb1VOV1N5IXtmcSF9MV97O2M4TElnUmQ7LXFuPThMMDhZInY2fSJnLG8iNCIiSyJOMHkiVzJUfFdjbSJCNV5tTGZZW0tRVW56Jm1CUj1ETzdJMkVfZXFwVU0yNiVFQy1EJkE6eiwtfWZ4KjhKRXxYQ2h9RTQ+eUIvLlIzIix4SyJvZ2giWyNCP3IiLyRQImYiLUBQMkAiWVphIlBKQnYvInp0WyQ2ckEiW2ZkIi0iNyR9IUEiYVdLIj4+YCIhYENxMiJtOSQiRiJ2eWVUQHRJa3RtNGZOPUZRaCJyInBBSSJoalpsOXo3JnlyXklBeyJeZmMiOCt1OHlJQiJOV1tDInl6fFRrIkxFQSJWWDg0WzA3L3tFIikwRmEiYiIkPC1dP3tKM3Y/Z0ddQFpkKGY1Zzl2Tms5e1ZieH5HYCM7PnxWbmVhPTp6ZyJpIlBCQSJ9IkQiYXZjIjZZaCIjZisiZlBoIjUqTCJHRm0iUjU7XT5VSCIieiJ4QXwiKyJgImVmPyJrVDgiZHwpTVBmY29XQlQpcl9aci4iczopIjo1VUJ3UWIiP0JfIjVTWVYhN3FdakJ9RSIiPCJzOiJvIlhvaV8sTDovPUhuKFBbLiJCInE5YyJ7IiBtNm9MVm5NQH0lIkglc2d7I1EiOCJwcHwiUGwiMD1bIkdoWyI/IlFnMEBhRCNGPj5OJSo4MlV6KFUqYUI1ciZbL3BDemsvTlgsQEQkWjs1W2trYTZsQ0lMREkiYCJMLkwiNylQVyUiM0txIihXZU9zQCo0d0JAMGhpNGA4VU0vIFkwIHcqUz1fP1dxIlUiVW5IInhZNHQtVmJlIjM+TCI+ImBiVVA9OVtBWXFjRWVoImFReCIyYSoiQyIie0xXImBtQiJqb1lVc2FwInRvMUMidCIvfCI5ajoiaUpMdSJIe3BRalYiRjUiPyJRSzldKnkxfF5OQkZqM1t+IjAiYUw4IlgiImA0ZSI0TXsiQiJyVTQzemhOVC9sMV5WWS9RRS8+M1NPZl5nYlJ6SVNKfFEibSI9MDMiMkJ8IkRNNVQiY3NobzRTYWReS31fSGd+IjJ9Ijw9eChfIm5NVFkiPC54MUJmanMvMSJ1VTtAIkoiO1g5MkZARDF8VS1EUF0zbmc4YV40ZW0oXig2PSxoIHVbZk54XXljel1beEgiNiYpIj9PZiItIiJMInVyfiJMe35haVlOSk9PQCJbaygiJSIzXnxIIjgiQlJtInMsPShTZ1oibDEtVUBaOyJ2IiJeIlslOiJ6RWE3OlZFM1ggY1ReSU4uIjBZXiJ9IiJTIiQlQiJoQVh8QT0iZlJPek07LTU6bXZEVHMrPS0rSXR0ZC1Bej4gUj1rQENvbGZBb1labnpHWTBFdH49KH5SKS8zT2hKb2E1IEt+TXVwcz93KHVEQHY6YShfYyp2IVc7OTlnL3dOOGtfKnFAbGRySS8rN0JmR2NIXjBRbGl7UDI4Sns+JFROPCRnWndJRWRMKDQwXXpWJlYlaHpTU109eDtFdUgwd3FTVC8gSiZFTyRyfjNgKVsvcUgjTnIpOS1wfCtsQy19fm5uTEJ7Vmh8ZV93fk5xXTF5UEplP0RfVElbaVozJCV5aXFWVTd8MFczKktpQGVTPixrTXxHY3t5cyxQNWpwYXdbbWRfUCRJamJaejt9TTYhb1dPemR1P0IrWndgPVVQU1JjWGRDOE4kKCRLXk57eWBlUDhrWShFQjt6Ozd6fiM1OkdGXUI+UjQzNFkjbldbMUd6JlpUdUlQSCtJRDNETG1xKTI5KSVVNDRGb0IsZGplaGFnPS5iNzpDK1ZUQGNsMSpbaiBxZjl9KTJyQz0jfiUuLyhwd0oqLUB1UlFLdHhER3olQzpLLGghJGgwQCQ0NkZMTUBFbUhwKnBVVElhJU1jPkhlaHlfQ0lnWCs7KDwzWEVhZF5CfUBlSSY6QWspUHQ7UXElPyNpKkc9cnJrKztSWHtgeExDYyB5XXgvVGhGakFlJjhLNSxVe2FQUlt+KjxNd3wlcGAgSjQzTls1PzdYO1YtO1FYQGEqI2x+MlZhLT5ucn12aS5mWEdrJU8lajl7P3s7X0lFe0VHM01OKDNpJFZWbmdiOGBtaSVRJkw5bksmWHVOQkZ8UUlIZnVLaDtRJjJdVV02YW5xRUs8bGQ8IF8xYi4qNCFOUll3OF19YiBaZzAtO3NQXW5AXU0oI0ZHL2lAY3R5ZT5KSXM4ZkAlTG0/ZmogWkZEWn5bTS19V2lHPFo7Q1pDJDkwYSRuQCNXKWJ9LjMhey1Bd0kzIH5oaU5DbF5jIG5adHdge2U3fElBYTlPXVREXnROOS52d2hgUUgubSZGMjBGUi1jSyF7UTpoQ1R1ZF97QDRhbEpfVV5YUTBzOVRST2kpXzguclg5LmdSXiFrdzBpUy8+JkMxRz5JLHU/bmdWLDsxaGJGLXxvUTBVJnUpSHZaRk9PY20qeC91biRmcmJDVEd+I2RuTlY1cUt3eHRQKnhmeSAtNU5TYEtSb1pdZSldUDE6MS92JlZUfFZnaUZ6eGQjMk5UeXopLSVaPkRTJWNMN0A3UTNONChULz5MKmtrVyo2VGMzRlVdUDdlIzlvRkU1PT1MUVRLSCRmeTJhUk1beihaaDlJc2t4X0hkdF0wNCQ5QVZaYmJkQ3xDVz0tO0NTe0FsPUx9bzFyZnI/LGt0cCp4Q0xuZnFHLFh7c1NkZ0RlL1UmQW0lNCp5OmVJOTU7VGo2OmBPbExIbS0jcSw/bi5nOnc8bHUuLH1Oem5QWXE1RmUlO1JfS0NnNiswQV09Sz9vU3NWYjImfFJzcVd+KVdzLVt5Lj82N2w5OixKZz94Z0B7Qy9KbF52PXh8dyYxbCZiJklldXx1R3gkLl96XypuWUJvWCREPl81ZWZyMEYqRXotdHtMR1gtYXt8S2tZKjdtYjN+RWt7O25RVlopQ3FAJEwyTXdtIFZIV2E2U1ErIV9tQjFpPVFQQCQ1R3QsYkksTyxYfTNNKWt9OmpLPiB3V2ZSQmpYXyh0VWFsRGJRNnlELWI4QkdDK1VmTSF0V2JPZEs/c2FvNnZwKUR5QzFwYjssUjVDYVRGaCFsQkg1QTZHLC1qVXpCOn1HWURsbT0vJGs+IDxWWUh8OixvbWhnY3V2b2lNaEQ7NVZ7WjswdWtGQHBjIE9OPSFEPW0ldTpFU0VKQiFUJTIpUyFvRTUuMnZ4YEtaMC9Cc0YxJDs0VlNqcCxycEZubnxQdGdKQkJGNzF2bjt4fSFNKyV2LzVXWDIvTTM5cE5hbDpeVT5PRlBGTj42ZDBFXj1zdGkoO05uNkFiSF9AeiBEe0tYP0tATE5bUlJ8XnolbExMU3slT2MwRmJtc1UxR2pLLnd1LTRPTllMTCR4Lko3dXYwVmkwTy0+ZnZ2Yk5lL2hQW1ljczk0RE1VLyBHYkk3QlJ4QX4xZzdaX3VqUyRKLHV8ITdEa3Y+QkEze0FgVURuflBvPWo/bjxRamZLJUo5fjw0ZXxEUWNwKW5mO2ZlU3l+XyBnL3JQIC1OQD9xOUA0SUd9KmRvR1FhZVMjSVRQcjBtPn5SQGJOWSYqOWc7MiFLSCBFcDNlcTo2LVtCQzt1MXQ0MWRWKmYuYFFpSXBxdTpYLVMrPCAxUVZZPXluLVJ6V0Esd2ZALUd3dy9qSVpYKD0hSHtNJEBxcXhQRUpYM2FXLHNpX0MsVzFBWkd9KTJifVgufEkmTnopMX5bdi9qOClsbEtMOzldNldwWDlOZkBoQnZhLnk4eSRAM3woTC9uSktCQUR8d047TWZZSnN9U352UD1sZStrKUAvfThgQiV4bHpyd29uRShFdmhrfjR1PTpwcEg6bk1oLiB+QWNNQDgqNzBRPUQqajJfZF5yPCBSWT45cmtIKkBrcG1BWFs7QThGVmllcVdGdlFQPXM8JWBeQkw5KG9gbVFGSn1PTT5CRV9mfS04I3hReys4ZSt3VFk9TjxEJXRFIyUxWDU7LzpFX2gwM0o7NHBNUWBHc11BUFFYPE03O1I4SVdAcHNxeCxVZjA2X05FMHZ+JnVKQiU8LUZHT0ZFaFRUeVQ7UE1hbEVZeDBWTU1AKTZXLm53YHttMDM+OEV1W3kjdFhrajFDeTZwfE1RTkYwRGlXMDcjTVlyZzMuLmpPdEApbiZ9X2hMa0VmKTlTPC5Ea19CTk1oJDdDbGF2VkhwLi95Mk1wOWE3cTpkbC0oIkEiLzIvIiwiYyJ6OToibTJeInUyQCZJLVUqUyAiWzZQImsiQVBrL0x0LVJjIldiISJVSXMiJiIzIj9xQyJ1dnciQkMuYTNfJWcycClLQDNrR09MeDdwIi8iM2ZOImJiaUd6fWwyQiI0Xy4iOk9FTnUiW1ApImUiLCJBJW0iUFN0IkgiImgxYSJUc1ciX2htUCpJSyQ9O18iLyVrXyIlIiJ+IkNffSJNfEosVyI1RUciSWBoTWtlMyJ4bFMiTSIiRyJSYiUiRSJIIlVGYSJAYDAieSIiIVlrIk92IlsiInR5fCsiIn5LJiJBJX0iPEljIihHdiJaImYqa34=',
    'a=&&&e=NkQ1NjJCRUFBQkZDN0ZCNzNBMDkwRkNBRkFCMjY4Q0Z+WUFBUVhySXBGd3Nib0xPVUFRQUFjT3p6MnhvUWNtT3hjYjVFS2hBUGdwdGlacUMxdzkzdkI5dXAyVkd6NW5Gek5vVS9SeUdWWUU3NTB5cTRtRFFHYVpCV0U0TGxFbDFyY3N1cUZvVlc3RFN0c1RqdUcxM21Ic2M5dnZwVklTV0ZxenpxWHZqMmgzSC80N3I2cklPV3BzbTNObnZabHd1YUIzYmg1TS81K1UzMGxxZ2plWEQrdXRhSlQvY1JlQnhIaXd6Y3pva3ZQdGFSZTErRHprS3FvNWJseHgzRjNTNzFsVDduZ2E2Q3VkQ1YrQ3dzZmFsZmlwRFFZMy8rcVRZYXVBdENBL2Roc080NGNaZzF0blZuaDdQMlVnUXg5Tk10dmg3VWhhcWlrVlpmb1NNQXpwdHROKzI4c2dKeTlta2t6U0FKeUsxcGwxUm15WkRsUWh3RzNpUHI0YlVONWJ0eGQrYll5NUx2Vm5oV1E2NHRWOGR3elpvOGwzakxuS2I4aE1RaGIvQVZYV0E1K05WTTN5Yys3MjhiZCtCOEpPdmg2cGx1eEdOTmNXN3cwMEZ6RVl6SjNYZXNJZWJJTVR2K3BRNVpSRUhsbHAzQ0tmd0kxY3RJOHc9PX4zNDIyNTEzfjM2ODM2NDA=&&&sensor_data=MzsxOzI7MDszNDIyNTEzO0FmSE5UdTZKZSt0S2k1VWIydG5yOFlUMllDamhVRENSV2x1cWtnU3NwamM9OzU2LDEsMCwwLDEzLDI2MDtOVy9JeXQiQD8iOVkvIjFqW0siNSJ6Sj4lWlddL25sL0FWMT1rXytWUEBhKG86L2RsPkByXXJFNjdgfnVdYFtrZyRnfl1ddkFuLGFsUSsgOTZyeUIzJTQ0OVZJX05kWyAgUVEtRDhnM04lV3RgOD4senk0KHZCdG8gV3FzNTxFX2VjYmRTVyV1SGlDcGdgaiBORkg2dndSXWdEfHpnfDY8KE9men5zc2VuIUwtIWRxZS0gemhnOHolNilpZ1tzKVNlKEZoXmJALUNLMm1qV15idyU8fShRP1RzVClFPDRXeTw7ImNifVVNZSBgSEdBRloicCJhaUgidiIhX2t5Q2I1UyImaF0iTURQIjZycUtbJWEiInciRjtrIjx4NzFuN3QidzdmcSJaZCMiMWYiQWFYLysiUVAiWyJJOzhQIi0idTk1Ik9Yb1FNamxOOjtAU0dmdy5MaFMiLSF6ezxQPDxAXXs0e1cpdmVJaE1jRE11OHN0V1h6eCNrKGl7bTg9a1YlblRlT2c3M2Vid2IhKlNYVUJ7LEZDPCtbZGxHIlQpcCJEcUAiaGtzNmZ7Q0oiMEcwIlBrJGJ3RT1lIkNrVTIjbGZJeVEjM0cgYWomR2BPYkd2V3ZER189ez1AfUc9IXlhZUQvXTxEX042TUohTiRZQHdUelVRfl5FZG5TIXxgXUhPNjJiS14ga053eEcgXzwoZ0xqSVhsbFZ+NiFLQ0dJLEF8fmZHY3trYiNEdEozdW1INGQ5VHFnZyhMK2hzXm5ldF12STVmJXdsNUszbmY8OHRnRn5IXmtnIFZAISp7NDBGQUkxfUdwbGouWz90fF9dSTN2ZihPSkopRDgjNjNQWGlxcGZXJFheZjljPiR8bm5bWDgwVyE6L2I5NHk9N2NwJHg9eyNNMTxHe0g6IH1zKG10XkolT2J2QXd7biE+V2E5PE4/Q3NdbiNfKX5xcGR7eiB0YDMrJDh7XVNYfS9OXihCUFtSN3gzSn5xX0xhW3BsIXVzSC5LVEMjKDNaaS9VfjNRXl9OPUdySiY0Iz1BYV9xc3BYO15yYEVPYipIaChse05RaEQ+WntvRGNJbXM3SFVfWEM9V3tpUmcgRWVPYUdXMUJWUkNkfG5naGovQ1p+NzFLOSNEemJlKDNoel8yczBhfDU/NFIreG9xIUtWODpvZ3dvbj1pZ1cjMW49eVc3WzFOeG18Rm91WnYrVGlBYSs6UE9GeEVRUXI7azgpX1R2Wn5MSkg2YFtTcn1Tc051PFV6bndHLiw6YH1yPjFkVjJ5N2Ntek00LzhbbkJsR3FYbDIuMnBZa2VGXkQmJGVaN3hLJiVJIWNhbzRUOFtKaU9lMTdIKHQrPWxJMnpnS0syflcxM1A4eTE5Zit6Qi9dQG0yRk1DKT9eLF1gRkYyOHpzSi5KZEM1RE4vZkZ+aTskRy81Tj46WW5ULyZkemN4W2A+cC1XRDpXcEZ+ZUZAc18obiBFQDRTZlc/PzAwMzk8MXdwLERBNFh3WDEgYE8+LWJAaCwxfkl6ZkpEQFFWZGBuPzppICl9VW5iOC8le2NGM242ZmRqKl1ZMkU+Z1koey0hbjVbZGU5a1UqI3IqY2xDQmEyNEUlQ0MrPDtjcyM1MS4kWDQzUXdIQH00bSNkdlBKJFVYZ0l8dm0gPFRtJi5RREluUF1yT3tzWWxpcnByYlg3anQ1ak5ORmRwPkgmfDw8QCBrLSt2UkxBU0xWU2pZXyt+KDwsZHBvPD0lM2R4RD09JnQxSTRlaWF3cTc1VkZTLnI0UDV1KzdYcFFxPE4rfTZ8cStWOHs0fElFa2MqLC5zX3hDLyMxUGs0djZ8MlteJHFkLU9MeDs+VWN+P1BeblJWbEQoJTVSI1AoTzVKLzZUTUZ3Q0MsOjlpb0tfIys0MnVMfHpnO0ssVD1xSnlIbSMrMEkvfnZ9OlcjUWJFSmNTUiRiVmB8OiM+NmJXKGYgQlpMLl1WSiA0WXNLdztPb21qTiEzP1l5XjUmYF4ucChkXW1PJC4zTGlIa0pfPUwwfShnRWFeKUhCdHpZQTF4NGh8KWpSVVt8RXNGJE8sTiAgPnlfYnhOMm5KUCg6aGAqZXY3eGB4dlRjTXhoOiVCaiYjfWB6M2k8OCwqa2RNQCxdezdvcXopYSpxUTFuWSZdXSZqbiBBJk9VOkY1N34lXz5vKHBVeDJ7TCtjUDomTzJNY1tPbEMkXlZVW1NdUVQ5eERYU054JnxGMSx4S0h2VyBEOjJYdnNfW1BdZHZsblpPcEI0NV0pZUA2JXNZaDF5RnRpeT9nYkNNUWtpIXUyKHguaHRkQGZYKjByJXFtTS1fLD01akRGID1EVl54eTQsLE86PDxyNjF1eml7bWxEQHFBTVg3am9kKCxIUnRyOikqaE9LWjhjZ0BRTVlQYFdJfEZgclUqOTVQS305WWt7fiZmS2F2USp7fXsmOjNROyxsTWB7YUJOTmojU3I6Q3JrdmdHWSlUMUU1R0tjYXt8cWtKanRgPlhgMT56KGh7RFdVUi5gIF5IU05gciE2T0tOPH5Cb1pLT2wxUzBROkt3IzkheUNnW0NJSGt1QEZsdCZnWi1QSThaWzdYQGZRYjtPZGFUIUlEOUZbfX1Nan01TDIzWCokdDFMKlg8aUtvVXI4fiFUIXl6MENncEtpMUFdRlR+V1hZfC1tPS5jUyNle0ZESnZHVEhyI0dvUV8yP2JhX0QjJnRAbVB+a14/fl98WFZrOnByez9QLEwvSiM7Z1h6RSk1OCFGLVJMLi1sVnlWU2JRJDouYnlaL2E1ezBLZGtLN0RWNlRHKXhjZkIqYzlIcVgqP1B7OXlaOm5MYkFKZD8uQF80anNUSSs0fHFEMEJTOTBGUCZFMmxbOnJIfSQ8NXhCYUJ1dVVWUlpHOHxZJjgxL0VUfVU/KG5RQHNBWCZmZSBLJnhsX35ieGFfPC9JeWtYd0N4T0x9eV9UJGsrVU9BYyxyXmdbZGd+bHJZT3VARDtjLmtCOXd5ZVpJeU1rbG0wak08RlVfZCMgMWZkKV9raDRYQyoob2pXWUE1THgqMmYqK24wLlZVe2h9dWE6a3orXiBxbmxhWk9NMy9dLTw7fFlTQlRefjJZWHwibiJOc3kiSyImKCg3Ni4me10ifkh1IlY/YyJdazpFWUxSKSJ+dWAiaCIxNmp6LSJKOWEiJVtRIiA6T3oybWc2KyJqVnJ8LSJpVF5rdCIudyVhIi0iIl4iVSg9IlkoP2J8e2tBaX4iSVAtWSJUSE1ZViJtK2MiZSI2IFJ2Q34mLzhPPnlNP2tWZEg/ZDRFZnF1eGdgY040UXwhQXY5czx2dE5OVitTRCxEUV8jb3NHSGM0ITBZVUguX14kakhFYGU/YVpdISN4biMlUXA8XTAua3Z8Pi55QHMvbjV8WSJfQlciaV5QIkUiWWtEUi1RdzpWSj9+YWFoK1Y0Z1g6JmFDViw9QnpMVUxxN1soZCxfbkJDSCNlbnBHc1gpJF1XNCJHImZ7YSJwZig/ZS09KDAiZ2xxIm9vdC1VfEpGaWh4Yy5nfiFsRyJGfEkieGIybnhjUyI6IEgiXzUjYWhVQDkjIn03UiJMY2hAd1YzflB9THoiMCRwKSJXIigiZVtbIjVpPyJLQS4qR250IiJ3Ii9EIyIxeHYkUiwiRjlWRyJqaUckRmkiR1oiKlo7Y1ZsSiA3bnUkPiIiZE5SIkRBViJzUFJuPy8oWWAibmMidlFPcVBubFlUdipOMz11LV0ieUtCMFt9SWdbeSxjXnwgZFdBKCF+SFovV04sWUdmcUpiTD4hJnE6TGo+LitPcHApe2kgUCghN14jPVdxIT5MVnd8eXZ3IlFsLiJRLEAicSIiUSJXOk8iYDMrYCNAJiJfbCxYMVpLJnVHUFluTFNfIWgmIDRLUW5LXkJDY3A1UiVjWlVqci9ROncjWE44WER8aForM1E7TXJ9NmIwSEEvIkFrZCJUQW8iMWRaaXgiOzpaIikia0dYZHciaU5SIkwhP2Q3Ikc6UylPUEkiWXxOIi8iR0o1YjkiMkpLIjhyOyJ2NzpiRCJUIDYiPiJsbD9QdyU5JiRKeG9lLDZ6SCJNIk11MCJyZTJIQy98eUZhKTlvZiJrbC0iNSxNW0VhIm5ULmEieXBhP2QiWHglIkNnLmFlKCBvTiEiIz1uTSI9Im9kKlcvSHxjXyVzYkBDJm9ZeDFUb0BwMGZdU3FEbWBeTDo7XyUhKCtjZmdpIlIiM2RMIlIiZCJsNSwiLXNOIlZ+fiJ9XnIiMz9wIjJWPiJ6RnsoWFk/IiJ3IkN8dSIjImgiMXU8Ilo6LCJ9TndkOChTSWVGTF5ZSEdpRiJaTV8iIF5bN2QsQiJwNGgic1ExXWFWekc9ZUx1IiI1Iko1ImoiY1ZJJUFrYlp1NHhGOy0iUyJhSFciQSIwYkUjOVJRTEJYbiI1U3t+eDxdInsiRjl9InVfIiw4LSJ1YFEiJiJESEVgc248Njl4QmZAWjdyJlUxRTdUelRJKEhPeyUuPnEqLUgqLl9wcSlKRVo3TEc4alg8ImIidCNVIltESmR6IkA4YSJuNyFvfVk5b2hreWBmaWxZd2Nedng5O35QcCAmS2R8fCJ+IldXTSJJKjg2QDRNJiJQJkQidCJSQ2kpV2Y9RWN1eFg8UCJBfnsiIGgxImkiIit9JiJ2cWoibyBQXjs+IldzaUYiSiJodyJxNDUiWDlPMyJkIWBdXyI0QSJtIjBkXyZyLCpRMCA3UF1PdSsicSJGL2kiQiIiSFo/Ijl8OSI/Ik05ZS98bX0kT2AtNGZqfnRgI1tRQ3B+UCRdMXg/cTNkIj4ifHF2Il1SJCJWKTZQImMwYFRlJFAkTkZ2VXFUYiIgJSJSTTVdYSJLdj5iImRaWTppa2osSyYiPmZlOCJrIldnWSE5NUtuNE0wSlZHc3IlLDcyYT9pQllzJT9gYm9aR3g6PXlCRitINE8+IixbTyI9IXwiLyIiKCI0S3IiaTg5OnFTOjhPJFgiYChpIioiOyF8NiJvImhaZyJxU0hgUVAiVzNGVihVSSIoIiJaIjI0ICJhIVE7MG17am1STC5xfkQlVEEiZjcjInoiImgiO0lGIiREKDg7WCJOVE5JL3NBXVVJZyplOy5mXjIpYUNjfXZyOGpRMzwmPCtHR0IubjdmZV8rSjFiWzo0d2lVNVh4eCBEemNBVEhlZSUoKHRlLWZyaz1MQH4mcWdVTTVxR3h5JVN7dVZ6fi08W1lYT1B7XmJYLlVOLys0OCAgX1QjYW5pP3R3a3oyT0twfTA0NWE3Q00yW0U/TTRENkY3MVkuPkohcmVXKjtbYzRAWl1MNWUjOXVKPjRJO0VTW1BKIF1wL2FVWmFzLGF0LUpzcCFWRFRwUzs2KzJGWVtiXmRFLkBbOSEyRFolQXFCS3B3LHBqd0AoamVyJiQ+WHJsZkcyVCVsXltoPGEvUCZIeCstJnVHaEZANThQbDE2UltyVEFuJCQhJENqM19BdzpifTkrfU92bllfci1GZSlCU09NSHAxMjZGYDhPM2xNflpoJiN7WHNzZCYvVGwtVHEzTDczbDM5JFFtTCFjOXJIIU5pZW5FdHltJTxuNmEhRWN1fHFNeCkyWmtbK3lkSHBMIz1KVzhdcnIyOiBFdjx1JkVAUTVneXRPcl8lMWdlNyZKa3kvc0teTi1CfTgmTy1ScXh6W0FXYTNTUSolX2xGMWk5UFBAJDpEbyNuRC5HM1l+OEQrZyQ1dk42dX1fZEpBc1RpI2lKYWxMaU4qekY3VTdDTEotTlZHeiNXb0hjRj1zW3A2KG8qOH46OHRdMDFZOENgWUZqKmc6RTVGOkMsMGteaz48JFBhRGhmODwhajYuO19NT308N2drX2xeJHlvXVJvRTM0YSBlNitqZkZIfF96TklKdENAdS13OjZNOldJLUwsMy9Te3JGRC05bG5UTGgzL0Z0SSksOzBbWm9rKGNqPXJufFR0a0FJQkg7OXJpN2l2JFQzJXouN1FhLC1POzZrS1FlO2hVPlNFUUFWODNvOENYO2RtaTM6TnI1QlRQWDslKkN2S0k4SkxNTmBRUXVmcylzVExPc3RIYT1IYnFyVCxPY0w1IHYpLkBHVllSJCAwUSxyeyxeZDpHLjJbcXBsSXEwcUtXVml2OTpESlAvd0BfST5JUXREdjB2M2BWemJTI0IjaSskOz9vdT5ESTR1OWBSRmx4RG5EaT9xPFd1ZE93STElPDRtbUNUaWsxbW5EamBTdHhfKmYtbE15Lk5DQ3g1QzRFVnorXXQ/UF9fSntVVlRtNGtEKls7XktZIyw2Yi43KkxIJEV2Omp5Ly4hYUJIPGYwczgsbFUzby9eUWM8cHl6OFEqTSg8JDVYYl0+cHMgS3tdQSR5XjghT3YmOW9OUFkoN31MJkUqPWdkdVRNSl01X1svIF5ZODFYM0NLRnguLWp8Yih5SytSeC0xe1RxKWcxKXNzTEg9MV1FVmlTPkZkP2RBcmk1eTh8JEc1fC1BKmFPTEdCNSV6TTtQamJVdn5OJWtLOnlmI21+QSsgPGdRK3tldmx8bmpEKEl2Y1sjMHxMPXhrSS1rT28odSFIYUc+PC1ANks4QSFvNWZrWHo8fVJXODwjbUx+RWJvdDxaUz9IOEZZaG15WlFsTEZCdkEgYGFDTCoraGB8VFJFfURNQ0dAU2smKjJ+fFUmMTZgI3NZXkNTN0QmcEUgfDdoODkjPzxecCg2PkI7cE1UX0d8X0ZGS1FBUTk3UjtKVzFza3MqMFthLy9YVk8waykuc0REKj82TT9KPzltWGF7Tj9KRmFqPmMqM1hHUjcoP0wzYnZne20zMUI6RX5Rc315XmpsMUZ6N2F+SVleSjo/Z0ovPitGTXVuLyErblt+PC5mJX1bdU9uQWspP0c4KVByX0NOUWN4PkVrYXxeR2gyLCBBTHEwZi9rPG93KCR1R2xdUGBtKjdfaik+VUc7WCZ5aypCfUo0XTtTNUd0WmgrXVlAVmc3SyE4X112aWI3ZWxxK0Z9Ri5iT35hdTUvNG86QjhQVzRLKjJsIUpHOWdBSEh3N3VIL3dgLWotV2pwT3tzfTJWLVV6Q3kzUVFWKnMmfltxWzQuaFoye0F4di1lPlBaITxvO3JBczVaY3RKLEFOe1VKeXJUTyt6Q3oqPi1vbnVIa0wqYzlmM15ibmJEUmxOe2VJUTo+JGk/dyVNL3cvOX0+e0Q7ZlJ+T2JyWkhxKWg0KXckbmliUTV2ME4rID5YMlZCdnFJNVs2SW9ZSnMsb0xINUc3PDI1a1NtNDExSFsublk4N21pMHwtTzdCWCp9X11IVU9sXVtCKF51d2w4UEN9dExCLXJgQmMheStMd1pVUFZ1ciRwKVtXLGROTylELmtkT1dMP3defVBbYDVgTz5TSGNqJjBHMSFPeSoyZS54T2VTTzo/KyZPc3p+WzEsJDw/Y2cwNDswN2VIX1IuaE5BPTtMMksoJlQqMk0oZ21Vd35EWHojQjpLemZ0fUszK3opICswOCYjVzxQY0sgKyA7SXo4W3lGIjgiOVdkIlYiPiI/a04iTUs1IlpoSzpHRm5yUVIiQlhiIiMiKjR+Xl5aenlHIkpGSyJxIUsiQSJdIjJzJiJ0P0siYlR0UFo0R0koPWt4Ky02dnQsTU46RmIiQyIpZS4iQ1RFOW0pZGBdInk3WCJSUFNRNSJ+cFkiXyJUIlNFYSI+VlMiQiIiQGhgIjVeICJ4LXJxQHhxUi4zIn1ySzUiYiIiMiJILXUiWmN8T3EiRlhxIj52SEg3ZHkiMGc4IjIiIkoiQWteIngiSyIodCEiYDBwIi8iImFlVyJpfSJKIiJ9KlglIiIgPkwiLmJBImZ1RyI1Z18iPyJnVSs0',
    'a=&&&e=NkQ1NjJCRUFBQkZDN0ZCNzNBMDkwRkNBRkFCMjY4Q0Z+WUFBUVhySXBGOHhUb0xPVUFRQUFiSHI0MnhwNDczbzJMaTJOaXdWb3gvWUhrcEx6NmdSWStEK2VxN2xnR0ZWYWNFMzVGRnRXanNXemtTWXZvK1cvM2haSm0vaHptNm03N2RJTG45MkVuUkRCMUVNb1hYenMrMlpXcHVMMmF1QW56VnEyWTN0aU9rSVRiZldlSnhZTVExMERkUHBmQ2FwNXpZNzFBeWJBa3pPUUg3dVFtaFdOeWk2UEZaMklLeEdYRE4vblVhTWM0OEhkMnppS1Znb3E2dkV4MGxJMXJoYjdiR29JbW1DRnh4NE1OeDQ3aEUzdHBNaWIwZDQwWkxXYjR2QTFOenRQVXhhamJVZ0xGMThWTmZlTi9DMVEyTnpoSVQxOE5WL1EyRnRDeU9lOGV0ekkxaGY1REFxOTFENnJLODRnOCtWVFVwcFJoNHNib281c1hlS05PRHdoT0NpTlV4YkdkUGgvMkNVMWd3dm1PWENmQmZ0eGFzMGZkM2oyelhRNno5bFFxSkpWa1d3M1RZSXdMR0pqR25lZnRjMG5Uc082MjdVNnZxd2UvSU1vSFdMZzArKy8yUmwvcWlSdVYzaWx2MjJ2THFvbWVvZ1FLKzdFOFJDVVVNNWtKNlVyeDNBSUtrckZ+MzQyMjUxM34zNjgzNjQw&&&sensor_data=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',
    'a=&&&e=NkQ1NjJCRUFBQkZDN0ZCNzNBMDkwRkNBRkFCMjY4Q0Z+WUFBUVhySXBGL2Rpb0xPVUFRQUFkT0Q1MnhwVkt3WWJsVDk4Q281TzBvb0p6ekltTlRMWU0rZ2k4WXgyUG90Y3RVWVdrMXBYU0h6UzZkaURma1NXTEJyaGxkSFdtWUhKK2FQaVVLV0tnOEdaenhnblc5TEQ0QzZKcThybDBhSStacUp2K0JDWEh5UDJ5YWZuK3A5UENnTm16SFU4KzFMOWlIc0ZxR1IzZjFEMUZyb0tTL0hXRTdHV20yQktTRjA3R0dTM2NsSTFEWEErWWxNSk5uUXJiTStSNHJCOTViTGpDYjNyUHQyU3l3QWZMM0J5YjlRd3oxMmdUK3ZFaXJCY1ZweWN5L29VNi9VdnhRUGZhM0xvcFBBQ1RRVTlBMXZCTXM0Q2xNREUwSEFXM292Mlk5QTN6TXpjeXhnekNyUUN4Uk9oTEFzL3JycXArOTR0SFY4UHVySklQc0w1djVMM1RiSFc1VldIUG9CSXhTaFFhcUJzVStITDM3d3l6Snd1OFZ2Wlp4dDFtZXQwVHFqb0trb2swZUxhNkllR0pvMzlxWVZhWklTdjIzSmFZKzRZWDJhS3NNVTVjcmMwQTJwSUdOZW1DSlV4a2dzbThDV0svKzFGTTEzdDF4OUZBRnpwTmNpQ3hMUGZJR1dQNG5vNzJCS0ZKcWc9fjM0MjI1MTN+MzY4MzY0MA==&&&sensor_data=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',
    # ------
    'a=&&&e=OTU2RUU3NDcyMEM5OEFDRjkyREU5OTkyMjg3REZGRkV+WUFBUURJNFFBc1FRZzcrVUFRQUFNUW9TOFJvU0lmTDZ3QUh4TzI0UytWVjM3dEZHL3VDT21yUDVOak54ZFdtUUs4bmZrZmdCY2FsL0hPTTdQaUNDN1kwdDB1V0FPQVh0dWI2OWtmY3Z2MC9NQm5VZzNJZ0JNMnFWOG9kWExaQzYzbWYwS2t3S3JyUmxkQUtYanp0OC9nZ1EzcW9EZ3dSTGxOWDdWWDZwbllpSnNZOVVnZGc0NGkyTkV0M3pxNlZ6VVBLbmx4TDlicTNQa0ZuU0YrN0s4OG9sSTZ5cEUxbjdEVy9iVlZOQlRPdzlLRzBUd3ZhN09HbFI2ZnJwZmE1OERWVGNKUWwvM01wTFdQR0ZFM0VETWNUTkdBckl0cWVXMEpQUDdXS2w3SjZwRGRvVCt0bzBXenVjeVA5LzI0N3pPR1M4QUtSZm9HWTE5ajJWM28yckZtTlFOUGJqOWpsLzJMcUlpUndGb0pzeEVWbFQzKzgvcWxRZUkvdVMvOEJVcHRUUHRyajNGWHY0STRzPX4zNzQ5NDQ1fjMyMjM2MDc=&&&sensor_data=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',
    'a=&&&e=OTU2RUU3NDcyMEM5OEFDRjkyREU5OTkyMjg3REZGRkV+WUFBUURJNFFBcWMyZzcrVUFRQUE0WnNTOFJyMzdoK0JoaGFOQUtHb1g5eklGbm9FTnpTdnd5RG5NY2dVWjAvVitKK0hDdVZ1bDJMY01LcVZTWWdja3VJdDJITGFEeE8rR3RvU0tydk8wbHdHZWhCVGg4cVRqUUEwTWV2UFlrU2thUkFxV0RwRk5ZbFJmM20rVlk1YmlycW0vUkVyU09icmVQbVJET2FuZG9KdWxVSWp3YVQwVmoyUFFuMVpSdnUzRC94ZXVNeUU3QXREUWEvSDUwNGJYSGNwalp1TGpOSitMVHlLTjRHbHNkNmRKMGdVR01jOHR2WjdjK05jdnJKYkxuM2xSTWM3b3hRZ0xneG52bndGMFRWZWZjcW0zcXhMZm1ZQ0ZoWFNJbm9mMG9md1A0WGd3alZnejltUkdzTDRJVXhxeHlIdVR3NTBuaXRNRCt0SzJvaEN4Mjgwam1UYWVtVmJObEVyS3FyanpsL0NQY2VlZ0pDcGk5SjVmbEc1Y0lnYTdVUDZQY3FrMVhPRE9GN0haN0U2fjM3NDk0NDV+MzIyMzYwNw==&&&sensor_data=MzsxOzI7MDszNzQ5NDQ1O0NKelI4STg5QXV5QVB0SjdJSWpuQTRtbWVQRGcwUmo3VlNvM3lsTVhrdFk9OzQ4LDAsMCwwLDEwLDIzODtCfVVfZyJpSjUqfnp9T2pqIStVZS5OOTczI2Y4OUJLNlldPUUmLm51NS0xXzowQVklX0d9XkUiR046Ijw+OiJvUCoveiJndUwiNTdWIi9kZyI6IlZrKzREP0kiWyJbLF4icmlUQ2t5W0prREs2YTpLJl5UIn1IY20iSH1ZbH5dNTRsJHgifDBodiJdbCZoRUFQWCIqWz0ieWp0NXtne0c/LCIjd00iICIjTj9TbFRCUV4iI2l6ImIpKSJDKkhDQm9RQUpSZSIheC9tIkZPRSF7KjJGbi94NG9wJGZwN1U6KUFBVlskNVpZalhAbSghfj9PcUUkSiRAM119cm5fKSF7JXxQYypLYnggRD4ldXJMcilfM3syLVEqMGgiUCIwMiEidyJGeiJMbXIiUytJayJPYUFTTH4iI1ZwRDVQLiIkaCY9WCJMVSJ0IG98QSJpanEifiJUQCh7MCJdbmUiYXdqLGwiakJhIS8rIiJYIiwmVSI+c2RGNn1MJksiUEByez8iOGksUCFPPCJhbk8wRlMsW1EyJG5dTjVmUSJkIndzMyJBIkI5IjtsIyI7eWN7IjYiXkJEMCJZZyYicnV7IkkifCJyXjMiUntSIj0ibytRLiJXIn15KiIxIiJRVWkibyBWIjAiWiJ2UXciQzZ3IjBzRSghJVIiPyJ0ZnUiI3Q4ImczeDgqfTRZQEVnY28gTjQwb20lODF1N2JZRltQRG9Ye09GIzF9aEwicSJxbVAiJT5kImdjeCJbMSo4c1kvIlBNfSU/OXtrXkQhIj5MIy5FOFN9dHJdWz1aVi8zbkdxaDxydGw/Z3FRRXJARjA1ZGIraHRqfHFGXyBQTWBJTlVbey4/Zko+bGBVUWYiRyldIkZefSJvIkRdYmRBcy9Ffl9RPlRVcyJrIkB9ViJGL3B2eDY6c3giSmQiSHxPcyYiPC05ImcifS8rNWVLbzAiSGFZInRqIyI7IiJbInQ3SSJVIk9WbzBffSpWOF4oQixMOD1veSYlZyA6fikhZjs9I3FwPFBrODJVYVMvJkMyUkJyIU9Icz0iNyJgfWkiaCIrOEZQeiJrKEQiYEFGIlFLTmMhUntbNG06eShHNzdhInNkKCIqMWYgRlZWWE8iRjo8IkUiUiJaUHAiVCM1Ii1NSjFnJVNuQDB+fEBsXzZXQSYiOyhBP3wxQSU3dH5JbDA/RCI4ImxCciIyIiJDL1giTi5jIkIialU9MU0oNDx+XnBtQVEoXzxUO2YxITJzZ3F3XStqTE4xNSJQIjFHUyJSImkiRjNVImVAUyJmdltLW2pPX2I4InNwWyJSIiJTInB3PyJiIiJYIkt5Iio9JSJzI3YiZEdLeTZqb2xLXShiIm52YHwidCJvYDdrfGlWUGovbk1MQVBBQTgyblYiLCVqInJ3bCI0JHVYIjoiImgiakAtIjV2LzhDJjdpIncsRyIqIiJSInF5UyJdMUNIfSIlS0MiXyJFRn07PiJZMk0iU24vIjFrIlQtNyIsWiZ+Ml0semRycSJ5NERYImk5am0gRXdRRzsieXoiLSIiY0J6Im8yIjw3YENjPCIiNyI6PFMienRhaUJmSSI3dGQqInVQfil0IjBGImRqeyVtTSYiUS4jImhwX09MZSsiVC5IV0J7MC5QVSRCdCVRP0k9dClNN21wY3ZsKi07MzltYmopeGRtcz1GJTl1LFhdZ0s7VnFePiJLIkdjcSJVSTpuPUsidH08YSIkQnFtOXcicWEhRT57NihGUX0uUCJTInY6VyJoJTtqcGF6ImhBVyImczxEQnpmZCM2ZH5JTkBGMSJ+YmwkIkUiOCI+fDkiaWBpIjEiZSktWHJGViQ9Wj85bEsiIVNhIm5FIjFiME9sImQqdmkiSlMjPWQpUCJwYGciPiJaLnkzTk92bUpieXgmTmIoP0MqREFVeT5kbHs/d3FnOms3b35HLkdEMyQ+RCJQIk9nYyJvIiI5dD4icyApInUhKWw+I19YRCl3VSJJYGtNInd5OzQqfWAiWS1KIl5AeyJ9SnZoSyJ1cmsiWSJZRCFmKzUlaHFFWCZzVDtAVD0kfVpyQ0MsL3YyaWNIO2tuSkV9QE92WjMmdDAjVC5DQVYpLXVYTn1GbXJtZE0gW2luYzsiMmFHIiVgOyJ+NUpSMyJ5WyJ5IiJbdl0iQCpWIkoiImQqLTQiKD0uWk9fTXU7Tkw4eklSYld4bU1mIEp6eHk4bFc7MDhFe289YDIlKjFhJT1TLXhkYyBOa0Q5bDssR0tzaFBQNFItNCEqIiQ5KiJBeywiYUl0IjJJPyJBIiAkaDowaG5qcXQjYGAxZ3QqaEU9N1NhJjNmZiYyL15RayJHIl9IZyIzIiJ5Iil0MiJWIi4jUl0xR3cgSiI8MWQiMFtRImhzYy13ImJzTSJ+QHZgWmYtIlp4TSJVIiJKIixSQiJSQltNZFpEIiImIlsteyJBIiIkInA2VCJqdk9HWCJnQVYiPj1ucjZ4NnMiIzsrInMiRmhObVBdRVpwXlgwUzsuP0BkdkhSeSk7emtCbmRVJDJuNCRKL1oySmhZZShKbSRHNG5+QSpZX3BYW2RsanF1YmQ1fV9Pb2Qsb0dNc0liK0JYICpzKURyP0pVL2NkXjRAKH1yTDtoNEFlWmlFOmF6MlAtbUUsejtoZFlhRU1aek4rZ2FBJC8tWXc8Q0kkLUFgd1ptYihsIzpISTt2KDhlM1NGOyFKInI5bSM/fmFrfEFdQXtVJHgtV2NrWU1Zck14blRRPEgpdUktOVhMJTtPJVQqaFJ9eTRddCZ3ay02JVFUMEItOy4hQjFGal9JYXlRKGhMOGxhM1l9OC8kSmBTI3lid3R6eHNDLkpzall+PSZEQHZzUlF2Tm4xLDNXcWlLQC5HRFJdXiwhR3R8bSVWQmpeSkcjKmU6ViB+KlV5d1BeT21qJSkmbmgxZWFrO0tDd3xaY1pOO3FHaGlnTG90UXFyKiFSUWBRQWxFTVMwWkN2L3clYXddUnZNT1s6Y2NTeGouPGBwdXluQi02P3JKMHsuICZ7IHB0N3YuLnpIWEJiYz5NbHUxLDdwS2h7TS17cnF6Ji48KnNRMkxmOyQ3JFRYNjpqfkE+SCh2LEIsWmBhbm0kJTApJmJMbHJmT2dlJURxM210SzlYMSlPaUMoNi1MPmdxKCwlY091Nil7fi1QcFJvPmE4Ols3K0l1XUhYV3R5Tk16andoYStFO3xATiNOIEQsUHcxPTMvXSt0XXF4ME14MUJHX1RJajk9L1NeOV87Zl1zU2UrI3xPenBuKS5WYyxLbCw8NSVXMjApRHJJal8ocz0hOW1oaDdocWMgMGMhVm82U2xjYD5xenJCak92YTw0blZpODE6aU1bSnAuZCpbcVJyNzk5dj9aXzleM2ZfRjJ5V31WZG5MLzA+VCRgJlogZSNMO1Y8eDE6aSopY2ZKRnVmOWh5IXFNbXE4VTRiTylXI05ZaFg9Q2c5b21NSiU1cmg7cDFCIXMwPmcwKVI5ckp1Q1pnYUxiJWAwN3oraGpjZDYgL1Y0MztVOVpQIG5INl1ITnRpZHxBI01QRE5GUzlGd2IlUUMzVGpMI3dSOn5qQy9EaGZTe0Mmb21qIHQpfH1PRmc8OTVVcVgvKG9oSU4gayZITjhsMzF7e3gzfkBJRjR7VyV+NFJvWTw0dyFkaUgyWSArMU8wJWspIUA+WVFtYVQgV1NjN2FdLD0qLy59WksgRlViNXV0UHQkNEhmdyp9eFEsLDdoSj57MiR+KS5qZTp4fDd1UkY1VGIzS2V0LyoybEZibEcpKWp4dSByKnVxRTdCQzt5fXU4THwwX20yJjp0Xnolck1JPE1KdGJ+fXJbOVBdUDBCTm17Um89XyMoNndyJkgya25ufitDRV1dYEY3TnRXUGNlPU8sQnsubXElc14jTzwmJSNNV3UyPTw/MyFFcmRXcW5QZlB2TXdIUXxfWn5INCo+PGJxLkFvdjBwaD1hWE9ld1V6YDtyO20mSj9CaDQ4LjxNZSVDYzJEYUJKbEBDPGcgTS5nQjJZMUh4bHpJIXVnJDRuIFh3T1h2fHNPbn11TmtIKXA6NW9GbCtIPnlYW1lvLVUmYCBXaysuN29OTF4wWT1qaDM6Y1h9T15oPCYrMFdmSnNfIFZyMD9Hfm59M1QpdVRIKiBkVSRbaCFeREhSK0UsXTZmTWs5M1Q8fTlJIUZBfit1bFhIbE5rJHFUcntLe18xcD4lTC08RjYoR1g4dF5XVz5PMytlQ2Alc1lxMlkoeVhQd2k5dCxMOXpIWEcmJXUkb35oakU4SnJwYSErcEAvcmpIN2VMYCB8dEJnVCs0dS0vQzE3KGV+Y1RPbTF5UUUjLF1WMW89ZVtiek9GITQ2QjheWWQ7LlI0NDNmdmVPPygrIHNOTGo8LS1jOTNzKCU6TmBlbW5OK2thbi1gTT1EKC97dGFKeVdNZzdxcGducDQ2X2Z+cm1AdiFAcTo6fiZ5L3hxYlcrb2t4YTk6NVFgeS9fX359ekk2PFQ3ZGtLVk9nbGtVXTZ4KkF9TmRZdjRQbD9DcWVzTzZea04vLncrKDpKXklJM2UpRSR0cCpLUzhLIyNVU2RON1dzVTo+PExQdHkqPTRzUXcwMHwwMV5rT2hSYC08UD42TnVfR0VRcXo7R2BhbWFNWjUpeDtDbyFpLmM1Y200eXY1blU3VlZ5NFhpIykvL3w/c3VidzZyOWVLKEIqOlBJSnFIRChUT28vWHZDQWleTiFLUj5oflkxc0w6W0BVI3NvWSZ+dTg8aCxOfEpbd2ptRXN7eDtzVXZuRTZhSVc4Ozh1TE1GaypUaU9zVGMuKH5aNEFYfj0xUkwmLFU1dTtRWzdna3g6Uj1aN2g3TXkkMGNNYmtQaWEvLHBkTjNqO0BSQCgrL3ApZDl+Sn1JcX03bWBqd1Mxdl1dVEYoLk4sNVs1KTxFfkUmYUsgXiVYcSFxYW4vZDhAICZxa15gL2IvSj8vQk19WzN7bDoxXTFNalNIbCZpTkozMjIvIDFeSmsvK3g2Si5XTy8pYUN5UnNGOzJNcWI3QjdMPk9MVyhwNV1iWXlAJlhRPTJoZkQjRHRwVi1ZRzw8LFA/ZmFkPkhvQkM/WCNtRUA2K3JvQTxbJiE/azc1IH5+NjxYZHJYVXtfWWIjZU01Nih+aXBKP3RCS1l7W1ZEXWozPFJedU9aL24lJVV6bmBvVVtqZFZJck5NYkMlfXY1QV93ME1eYWQxJi8tdD48KD88SUJQPzNvQlN6Tz4zN1JlOE1ye0FBRyh0JkcjT1hAW1p3dyh6dmIzSGxkOUJFcCBMckxlKCo5blp6OCZhcVd6dDM9WFRPM30/V0tDS1J5QG45aClIWXNUOmspI2lsZSEzR2QhfCVqXn5NPyw3UCBFdzZ5S3V4QSZ6RnNwR2diKChibDAvSDUjTm91dCIvInNeICJgIl9BRShaLG8yT0ZuIVRDNUFrR19SKzAwU2xfKjZJMUt5Y09QRH09Qzg6ck16TnM8Q2hdTS8kLS5XdjdfNG1UfCRiSFBlOywlQzNTdj9zTy5FZV5tOnwjM0lNOHdeTjczKU4ofTZpIkFNZyJSJVMidTxgYm9MNS5AayJtUEEiQiJnNV98InAiREJ7IjdeOE8vRExJUihjclYuUko0cGtWIiVGNCIlIksiW0JOIl1LdyJOIiIvJmkiM1VIIg==',
    'a=&&&e=OTU2RUU3NDcyMEM5OEFDRjkyREU5OTkyMjg3REZGRkV+WUFBUWt3Y1FBdEpuVnJDVUFRQUFSUTRoOFJwenI1S09TV2t1L0VFbFVjTlRNeDREeSttdzNmZ2xWRmk3VDM4ckFVVTlCUDdsZUxKd0pGN1dKQWt3QjNJbGpBU1g1dkpMLys2eXRMdUtSc3BTM2U4S2hqT1Rnb3lkRS94WDMrbjZ0ZlVVQ0lsbEhXUUxjUVk5U1BMdGVrRmpSRHJYMXBGUUhPVmw3czU3blFGWDBwUTh3TkIvOGpiQnQxa2I2NzhUS2lWdVh0MFU0UFArWFdnbFhoRXlDOXMzMHp2ZmlpS0FtWjc1bnFXQ3JFTFRTQjlEVlpOTXVMUnZSMm9rdmRzVEVwR1p0QVREcXlEVytZYS8xNFNpL1g3TDc2ZXppOGNtSC9ONXVLdFJQTzJBMjUwcEEySG1lTGhnMEFnb0tkcHkwMVNQNFpWbVNTZG1yZU5SRzNLb0E4Yk9ES3lPT3dSaHBGajhWSHJXVTRGSUtUY3BzWDdHM1RmRzhLSkh5MElUdFFsQnY3KzVvSzEvYzZtVTc5T3huSnliNzFKWjZpM29BZ1k9fjM3NDk0NDV+MzIyMzYwNw==&&&sensor_data=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',
    'a=&&&e=OTU2RUU3NDcyMEM5OEFDRjkyREU5OTkyMjg3REZGRkV+WUFBUWt3Y1FBcU9VVnJDVUFRQUFZeEVsOFJwVUNnR0xYTC9jRGE5V2ZFZi9EZkdncmt6bU0xeVBTcHFDL1lUeE45K0Z1V0Q5NmlTSlRqY2NyL3I0SXMxNVdtenhZYmk5ampyWkROdlFlWXBKVEgxMGlsL2JDTTVvdllsL3prU01MRzAvRGhQakZFM3pnYWsyU0FwbFdzd2dIRlBZSHkwMi92MGg4Z1BCY3V1NlRvWHRNMlhQT0hmRU5zMFpOKzEvRGd2QStJNTVQMXRvcTlsamFRRkI1Rk9KVDAxdGNPVSs3SDE3UTdYVWJqdlFXSkp0V0swNmtQWENxMHBuNXNORlZjTzNZWmRrOSs2d2RmVTh2aTU3NXR6dmY3MGJRMVBFSVhMdTRRdFZGd0ZqcXZtbVJEdndiZnFtbzFaUkpHNHZzSjgzOGo2VFJJMFdRdzhJeXk5cE01MlJvVk44Z2RkUHVqQzJ5OGlhZkxrYWFJQWNwMkxUUWUwc09Hd2I4L014Z1c1emduNzc3M01GTnE1MytNWWlrZkhBMW1RemZzaDYrcUROLzI2eG50TWc1RzFhYVI5ckxnPT1+Mzc0OTQ0NX4zMjIzNjA3&&&sensor_data=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',
    # ------
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBcFpMWnJDVUFRQUFOSnVLOGhxTS84ZGp1TUZXMmJaSzZkekxBUFF4NTIyalRhTXovMDZrUGgxcEFQdHptdzhGbTQ3ZlJYSWl0ZW5IWk1wMEpGQk45U0Q5TU1aNFVzcS8vZFVvVmZ0ZG5jT1ZCT0xqKy9XaXFnVEhmbFNvM1dud3VjUlBwSkNDSXRSN2E1d2l4YkFnV3ZGejVPWHMyekhiZVU0Y1dvVWowNUIyRTlkb01aM1NhQUVwb0ZKVHRTbk5EeUNUZldBajV3Rm9Jd3c1WDlHeXFHemtRbUViZW5MWDNxY1J2bFNKK1VTSnMxUStES1JOSDVGZXcrd1VxVjdMVTNFNy8razI0STNPQk1UVWQ5Y0VFVjNTbE1EeE1YWnVWWFFzZFFieDNMUlA2WWVMMHV1N0RxU1VGNHZWL0VVcFZ6OHhkNXNJVi8ySzdNOXdHSXdPcjIva3g1UTdnZHpKZ3l3TFI0QW81RngvZjJhUE5ZTExLY0RCS2NoK0RDNlVucVAvd2RsTi90UnlpVmlPekl5WEVsSGV+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBaTFhWnJDVUFRQUFBditMOGhxRGMzRXlVQXV1Vlh4TDRJRWVWVWhPclZGMVc2QUdEY0lpaWc4S3YyNDlBWFF3N2htWXNTdm9pVE9DMzlXZndEZ0pEUHBlY2ZtV1ltc1BWMDNBbXhlazQxQ0xRQlZMS0k4QnFzRkIvMXlleG9vakUrWU8xYjl4Z1Rwb1EzRmM0WUJyMEpTV0tFbmk3dy9tOHRrWnhFblZtMDhOWjZIS1B1NzdPekZOa3lvbUNDY2lxOHBEYWFOVWVTSjF3MHVwTUI0VWpvZDFYcm95ZjNBbVk2R3k3NDZDS3Y0NXpRQ2pSZFNQeVUxOVVqOTRHN2Y0dFcvMm5HRElUWlRXSXVpZzl3V0ZZYjNKUU5aNzE2T0hlRmFJSkhLeGxzNnVGSXVMR3lKSFkyR2ptTndRaDdhaXFHNUx2THZwRXdVK1J2TXVOU1E1Y0pnakZ2Tk1FYXRwZmRWYjdKOS84SWZqVU1BN2lIeVJwbWZPUmxZTFBraTB3TXI2cGw5bEZpc00zdG03Mm8yR1llcnpYVzBMS2V4UUt3PT1+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBaTFhWnJDVUFRQUFBditMOGhxRGMzRXlVQXV1Vlh4TDRJRWVWVWhPclZGMVc2QUdEY0lpaWc4S3YyNDlBWFF3N2htWXNTdm9pVE9DMzlXZndEZ0pEUHBlY2ZtV1ltc1BWMDNBbXhlazQxQ0xRQlZMS0k4QnFzRkIvMXlleG9vakUrWU8xYjl4Z1Rwb1EzRmM0WUJyMEpTV0tFbmk3dy9tOHRrWnhFblZtMDhOWjZIS1B1NzdPekZOa3lvbUNDY2lxOHBEYWFOVWVTSjF3MHVwTUI0VWpvZDFYcm95ZjNBbVk2R3k3NDZDS3Y0NXpRQ2pSZFNQeVUxOVVqOTRHN2Y0dFcvMm5HRElUWlRXSXVpZzl3V0ZZYjNKUU5aNzE2T0hlRmFJSkhLeGxzNnVGSXVMR3lKSFkyR2ptTndRaDdhaXFHNUx2THZwRXdVK1J2TXVOU1E1Y0pnakZ2Tk1FYXRwZmRWYjdKOS84SWZqVU1BN2lIeVJwbWZPUmxZTFBraTB3TXI2cGw5bEZpc00zdG03Mm8yR1llcnpYVzBMS2V4UUt3PT1+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBdEdFWnJDVUFRQUFDYmVROGhyUTU5aStCV0s5dnQ4SjZNOW5pNHEwK1lSdGdUa0MxWFloajR6M2M3ZHFhYjczRmNSdHF2QWpkWUV0VzltdVBHQ0YyemFjdnhGYTduN1hVYVRjSVZ3NzJzS3Y1eEZ5Wjh1SStuUVRZSXlYQmtyQ0xnMzNLOW5lME85Y29qY005UGRZU0djb3VNTGoxUGlTTVM4bWF0ZktjNkhoZHRoaWlzcTVRak1uYWlaSnhrRVRpSGNRRTR6S1Bvajhnem1malpQR3UybWFpcUo4Mnl3eitpUUh3cGpOQThKTndQRHZ0RmZtWVdTNHViTzdzblpIUFh4MnM0UlBCaUYvQ2poSFM2d0FwLy85WTArTGp0NFd2bU92WDVXYlBuWnkrVUVJZzBUdzNOSTdLcDBkOS9HZVk0QWpvY0ZyS1BPMXNUTXlGTmxVMUtXZXV4UEZVa1g5ZWpLODlZeVBSYklMVmtTY1dwZzJOeXBYUDFqVElHK094dmxTQTd0eXl6L3V1ak9TejA0eVhRZHYxMkJvSmxoZUJtbjZwd2daSmgwPX40NTM4Njc0fjM2MTkxMjg=&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBdmlZWnJDVUFRQUF0UEdVOGhvRWxGZ3pHUnpBVHFmbnJRTzUxdTJrYzJrcGJYRWc1QWsrTkI0eXNzNFlVRVB3eFVrZGhySm9hL1phZ2lxWWxuclliWW53aVRBVkxON0Vxa0M4cWs1a2dBaGFXcXZWL3BGWmpIWklhZUdNWHpraTZnYTRnN0JMQ3djejhnL2NDbzFWRGhlQkZ3L3BtemkzdE8vRUwxTXZGVnFyVVRSTVhHOTIvZ0VKSEtOYk1hdXB0WDJibURiMnZyUUx0aUVSeExXSk1YZElJYnVRbkRSazkzaHhkZjAwTkpLOGprc2pRVDhadnp3Rk9CU25URDQ5UHNyOEhhYlk4TVF1NGFZdDhZTnltWlhnWjh6dllmSnQvV0tOOW1QR2Jvb015STE0TmFUSEwxbHdiZTFXK0J0RW81bmE0Wkk4YkV3S040bGVkZW9tOFNOd29VcXYwUHpDMERMaDV5SVc3TzY3K3pBVTZEVmZoNXVldkRtaXZZRHBNbzUvM08yTmMvQmhhMDBmdEM1dE1QcHQ5NWdlZ3ZYa3BFZE93ajJJTW13aXBDd3lwZ3J4dTRQbjllcEt+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBa09mWnJDVUFRQUFUTHFWOGhwcHEvTlNmK3I3eVNqbS9iOCtRdW5ZTmtuanhOK01qSjRIWU4vV0wzVzhJS2haSUR0OVZrMUpEeUhWMWhCQTA0YnlyMllpNDZJdHA1U0FrQ0h2c2JiRWtUNmw4MG16aGN3Nm9OMTNNUzB3ejhTOW1CajdDbU05T0dTR0tkcnErc1MrLzlDRkFGaVlOazJ0emd2czQzSHlvSVdhT01CZG1BOXNQbVM0NDFnV0MyUzhZSWFya3V3YnhpYlpIZngzL3hKNHZsek5yUXZ2cVcwUmdJKzZlZ2taZnhYRHZmRm9PL0dEM1VEc2dBYW1WQWU0RXJNV0gxd1l4a21IM3IxUWZZT1FwcU41ZWU1clpiVldSajFCZDUzR0F0Vmppai91R3NtSkR0Q0NLWlBWQUlqMVJrWFROOFQ2Yi9PUGhSSUR5RjhUTitmeHJaUUNSTTdGY2lMZ3E0MTJRejVMQ0hDTkdFMkd1bDNUK3lUcjEyUWs0OVcyUE5Fb29xTmtwcVppemJlUEpOOTBWR1ZwWDY3a0FOVTQraXRhSGtWdzJNY1ZYY1p2RFhWOEdidVlSV2dEMUQyZnZjYS9sQmVWfjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBdVNrWnJDVUFRQUFON2lXOGhyNkVGOUNhTXpVQTNUNGpDVjJjWGtFZkVmeWdTK0FQRFdIN21Hbys0L2Fod1RtQnk5dFBOZVE0OXdMM2JYbzY2a1hFSkRMaEo2NjlIZnFPenhVN2JKaC9ybVpIM1dIWUF3aXpBQTJxckNkTFFhQ0czUkxZZFFtNjhackVGNnN0K205enIvSjd1cUZKWmRVZG11bVh5K3p3WHFEazFTOGJ2Wk1UWlRxTG9qSWNQcXNuNmkyOU5qY0lvZVJCNVpOQmJaaXdKWHFZcFM1ZSs1WDRLTFNUaUl2UzRFbUdzWWxoaytNbys3c2I4VGs2US9rVTVONjZKN2R3TVRXeWVlTis4Mk9YMnMyOXNkVVl4bzBObkxMTTExTXRJR2YwVFhqOGFEYk5kclArVHFZOUljTHh0WW5CWTdvemVaQWJ2TnAycTU5SXVpdVIzcVV4U2F5MThYbGErajNReUdMWEpXd3ZtcHdQZ2RSbDBEcldhMWREOXphNExPa2hxdXpWRlpDT2RYNnRoeFNueU9weXR1cW0yRjIxZ09XcFNCN0thd3QvclZDY2EvamdFbUFlSlBQTnlnUUJOZVFkZ0ZLVTkrT2RLRmpEaEpnbHpRaCtBPT1+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBbU9vWnJDVUFRQUFoMldYOGhwK0QxdW5YWHFpSUJQUzBsYmtINmV2eWxybUlianN6WTlSU0paMDRYY1J0d1RudDVyUk9NdnowMUNJRlg0c3gvcGsyTW90eDduMDZ1NWRsODR0SllLQUkwN01YdjdudXdPdU04eVZaaFFJY0o2WlluQmxGSGNhaTZUVVZxTzVyd1lJNHY0R3E2Zi9tMWt2VlFtRjFOdWlzclNQNUIvODl1ZEk4R2Z5VG1DOFQ0elVRU0lMZ2ViUGc3eFFHdzlyNDE5bzlORFdvc3ZEdHhzQTQ3ckxGbnJraWZQL3ZNbmswb0ZRSkx5dW9uZGxpQXRlY0dWdXRiZHUybHdkWU5LR21ycHBYdDF3bVNHdWV0LzZzZ21FL2E4cituSTl2MGZXRkRnVUo2bUdveENKK1dYR3ZXOUFjVVdVMDVQKzdaaUVYVklQSkd2VERTQ0k1dG1ZY3NkT3A1bkYzd1FEaGZMNFduUnZDc1c1MkdCcXVncmFaQXplWTBXcW80aTZqUGVDc1Y2WFVZalhpdUF3WEhiQkxndW1WWTFaSkxtRzZsVG50SlFvbzJ3RWIxb0JTL3lMWkhjMVpOWjcwV0g5YkZsTCtvSXdxTndtY3Z5TEY2S1hKR3pzaE10YUROT1Nldz09fjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBazdDWnJDVUFRQUFJY09jOGhyVTdmbkZiaWZVL25rYk04bHE3NXc4UzNDdmRsY3UvTVpFUklZS3FLUTNxcmZlM1VjOUgxblFyUzY2aTNjTFc5cXZDRmMwbVZYY1dnOStFRno5eTNvSnBqaXh6bkkzbGtBRUNzekR5THFKbUVGc0VoaUpBaHBnWWw3eHJjVVVZR2M1M0Nkb0Z2Y002OERLSVBlOXFzc0tyYkh6VkdGRGdybkkzS2hCVWR3c0pZY0hoc1BRbkNGdEprd25HVThMZWcxZEllWFg1NXowNHQ4QlZlY1VmMVVvV1NxUC9jUFFwMDZ6RlVUYUF2SUV3Q3FUc0ZtYlhiQVdPTy9KVUR5WDExVVlQaUY3dTM0cGRwazNTNFBJZnpaYXc0NWhsZXpEUUc4WkI3b0J3VG1KL3lUalpJOCtOVUJiMnNSbTRqeDJGNWtWemJRS0VDZytEc0lxcUJWNXNXMkRIUmtqVHVQZTcyMXVSRE9Jd2ZGeGlmcFpVKzlvUzVnQ2N1dWkxNUM5MFErQTllSENwNTFlMlBJRmpTOEFBTjE0SUYrWWhibTlKOGoyaUlJaDhlZ0FyekNld3lDeTJlZWovbG5RK3NJVHlIZUpUTlpsZGRRVEtXbEZXYVA2K2NGS1BmczB3a0tocGZLNEtMK3JabEx2VVduc340NTM4Njc0fjM2MTkxMjg=&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBcjdKWnJDVUFRQUF5KzZkOGhxSC8wcFMrb2UvZGpJUzVxRm1vRTEvbkljQUEwMkIwQ3NGbUxPLzNxVkFVOTJBaU1oTkI4bEdDVERVZ255R3JzSlNEMWp4Uy9zN0xmK3ROQzVXcmYzZENDek1pb0xUUjZmZkxOc3lCMk10THhwTkVCZDZhSjJSc011OFd1eURaOFU1SmR4MkhhTUtSakZFanBNL2swMXlaQ3dERzBTaGxuWnk0M2JNMHUvQTZrMXN2Z2NTZWV2aGlLWWxucm5MREowc0gvanFTVE82SHh1U2VzNTEvU0RZUGJjd3FWc0hRYUN2dy9nc0dFNkIwZzAxMDJaSEpWTVFiOEFnS2FwL2Ftd09TcE40TVFwU2hKVVo4VjNiemsveHJLMFVlZHpLdVg4aUxtY1k4RTFjdFBjcEs2TUhrUUNZL01CZ1h1QmVncEt0citzbHNheUJ6VkRWSzZQamtWZ09ITCtDa0tPbUVsNnJRdVo5TmFPYTVHK1VSU2xmNHpRUDhSVDZQR0VsZ25SUzd6am9FZlp6Um9yeVpNNEdLY1VkKzBEYXN0cUZsTXljQ2pWWC92bDhzdWZzWU9nWXVmOGVDcVovOTN5MFoxVm5sVE40UTR6N0xZUkpDQkhMcTVOblNRR2ZxUFZ6TWtnbWNWa3JTdytHbnRtU2NPcGl0Y1ZkZ2tUeWR6WEx+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBbDdjWnJDVUFRQUEwMmlpOGhvMnBRREFJTCt0NGpmVTVKUWlraDFrS2V5b2V5QW8xb240TXVNZjlSODFhamFKVTFkMlRreDlpRTJmajA1U014c0pGOVEwY0RvTEVJYmZTc0NDMjZuUXBBdU9nOVpYdFI0TEhnbzRoYWNNSG1zWE1rbHdnL0FOL1BmM2pDU1NORS9kaUw0M01KN3dQblZET0ZIL05WZHg5bmNScDV1RVAxNzZZSEJUbVdERjFVbTVEb2o0WDh0aUtDTUpoNzY2em1RdzU3Qno3WUR3VTlHbkhPWEJoVGw0S0tFR2JqMUs2UG5ISjY5WlBlWkttY1FXdUF0bldvdDgvYThqd2V2MGF0M2pUTGxrUHRZb2pDV1FqMHJlVmxqV1RXekNhdTIzY0pWUDJiNm11c1k2NUNXSWRyZHRqNEk0aGdZdEtKb0NkRFoyVUhXWjYxME5WZDhNakRGV0tSckY4VDVaWi9nc0JBM1A0NUFETXZBOG1yeFp4RmZFM0wxU0pOaXJyZURXbldGN3Noa1NUNU8xRmwvMndKa3dEOVUxeTAvbnE2ZHVZYXdxRmt2Y3poY1BQVGdWVkk2WnpEdmVEL0ZwNGpTY2ZWMlNlN1REQXZwRzlFczBNbzJkZGU5ZEpHODkxZWdPbGhUaE5lUVM0N2JsU3Uwd2RvS3p0b2VHKzNVYW15T2ZSTDZxdVNDeWo1MG5nKzExfjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=MzsxOzI7MDs0NTM4Njc0O2RKYVBTWDFiTjFQMjlSRUE1dU1LUFcrNnl0eEZuVVdEdjRlMFJucS9tWEU9OzUzLDEsMCwwLDEzLDExMjsiKyJ8M3UiMVRaIloiXV84eS8wbEM5fTV9MTdGIiUibSo6Int9bHZEfiZQMWBLJCI8ImJCaiJUV2giQSI1Il5KVCJSM0QiIztdfk9kNDFBamJnImFFQDIifSIiNTU6Ik1bMSIsIiJLQEkiMD1jIkYiSnE2JTNuaSo0T1lEb3pyXiU2L2xPWSpBX0BmP0h7cClXQUdUKVM1fFVORHZeOVFtIkxfOiJiPkUiL2QoR2N1KV0uY20sU1NAP1h6OT52WUhjRmM6UWNTbFgiNCJ+MWEic0BfaFUiZTtYImYiIksgRyIwZiImIiJIIjsuaiIsUVFJLFkiQFEibSFpI05RI2UiPWR5IiMtbXo5Ikp0cSIhLi47OSQydz5pM21+Y3EiITcidyI2XytvIip2aiIpR3YiaiJ5IipiZiJkQ18iOSJial49VGE5aFkifHtrIjBjOiIycD1WVCI/NnMiPGoiU3ZxIjpbeCJKIn55bGlaSylrIiR1VCJ3P3UiXXFqImREaG8idSJKMmtsT1hNVz9EdFggOy0oSVg4ZFMofF1Gd1lpOXlxPnMiKiJiXmIiLiJoIlozeSIpWyYie2BUMjZgSlB+bCJ+Qz97IkwiIlciPCpvIjUzfj1wYDk3d3RnWy9jOVQiTXRRPyJYIiJjImJgIn5EcVJaTXRSPCsidVliMyJ4QzdKdyIzeT0iIHlDP1dJLG43IkJdIllCQTklKCEiTnJLIjFfNnlxJFNvLExLaVNVKCJoZiJPRTA/LyAxIyJoN2giXyIsUWRtJE1VQlVrbHFPYE9iTHA9S1VYb3QqLzQ2R2ZyTUkzKkxfIEJqaUlTenJTbyZySEQ4eXY4O0soJEQlTF5ncU1SfTV9PTh6S0dgQFB6OSpqa2QuMFVNO0hVMjBPLS12LTtvLiJwUmoiMkFCIi87MGNiL1VLeyAiMDdRImsiImNoMioiIkwiM2FyIlQiSnY2QEoiT3kxImBWeyIvInoheDciJCJ9PTwiaG97K34icVgiQ3NjIkRMMSJ5IiIuIkBWYCI0IiRmRHt9IjpPR3tbJHAuJVZseCZdUWprNCJCS00gInsidWVSIjxSeSkmIjA6NiIzIi9nIl5+OiI0YkBhImUicEFCcXdTN2NCSFYtcSkjWXYifCJuOnQiWW5XLkdNKmZNJS1xbVkjYDMiRCx8ImAqRytIO2giXy5FUCJOIjN9VVM8IjZMfCJOMDsibiIia0lnIm1mLCJuR1d4YUZ4KGdERjI8KDZnb0MiMUFLInYiQU5WIHlTfnZNPyZVVzpCJmNDbnh0fUJNc2QjITZxR0RYSXN8ODU1eURLVVEiXiJTOUcieGkoJS1nWmdKNyJMcEMiWSIiZmc4IjRiZyJhfXJfY1JzbCJ0dl8iWSIifSJfRzYiOjsjbFtIIiMgPm8iXyIiWyJhfSoiSyJ+IkdeeSI0e3EiRjMoeVUiVGVySiI/OD9Mc2g5PCI4PnkiLjNwQCFybSJpY2oid0ssMDotTCI8YHYwIkQiIDw+eWZqOU1JMkxRWzxCOiU2ZXtXQSZranh9SHIzXSlkRTEvPmY+IWRsUypJOCZtVFZjW1pxZE1CX2BwSWA9RSh9MCMtIllSIyItOjkiPEc7M2ZXUGNRTGNYJT0iMGAzIi89L3pQc0NDOCJGYSowdyI5IjJyfXlzTUR4OnFEQVV2Mk0iZiI0fiUiYGUiP0wgImMiImEieGIlIk5qTVE8NSJ5UlFEXUciLSIpV3UiJiJfdnFtQ21vaDpPO19UMnlHejxsW3lDfnJ+Lk51Pnkza2oyKS1rR05AJjwlT0kmelAsSHV9MWs+Pk1tJFkmYiZofTM2QiZhem5Ib2A3NnFyQTNNKClOLG5wc0VfNmVSb1t4PDtPOHQ2NnI8OGVnVVA6IEp+OUs5eDM4ZyVzMyhVPl05M0k0dTZHNFZRMUQwfHJlOnkvQzd9MkJ1STRmUCtxNns0NjR2Mkc5cGdPYE9LRjomWHBAMi5FTyVXSXZ2Sz1rQmcscXIzTT9+fmV6X3ZebFI6XiN1bTNVJWJYQkB1YCx9NWVQUXo5MnB8d3UsPDNCfGEpWlRLJEQuUVNCOypyUkNsMiksUStrX2VrKnk7O043KVcuJT5RK2VHRzw3Ji1fUnlUVlA3ZFpRWVlvIDM9UU5EbEhdUCtZSjcvKywpfHFaMWNxJE8pLnk3MmFvL0RSUUopXXF5YChzbnhxfWN1a2o8bXckbkVOT3B2N0h8NVI9SCpoLzhtR0MxQ0JZS1RRVjBteDMmY3ZsJEByeFtsLDQsd3F+QnViWlFzail5OjE1fFUjJndpdCFAYzhMMT5lZCVfWyA6KGJubXc1Q1J2X3lSSll+c10hIFJrR3hKbS1NZkg+ZTNnV2plMDpobzA5RTh3P3BmV3MqSnlPIWUwW2ojd3RMYmVUXXQrTW4jQE1gXk1oP0Y5X2lLbV4yZDtvL0hGPXI7NzFNWSA6bytTaSFzbDhkd3c7WjNjSyhwL300X2pqOnBuYX4/aDZWJF1rMnQkWC5BPm4qbj07a10ycUBsdChKLEE3aXdPYURiQ115K35jSk9gLFNCIH5VSHZrMGhtfF09S1ApO3JJJlYyQnV2IV9GXXFSdWRNOyZ+Z1cka2wmXVNgaTdUQWdaLWQ5W2p9YVlgI1YufF5mVE0vLGlDVmZhUmp4SnpOLHNROls7R2JSQlprVTsuKHV6c1hQMHs5UD09U2xNZ2dCM21jJWJ1MSUtRWVPJisjNXYydn1sSmkmL30/ZEFzWD1CfXU3fkhgblktPD14dyM4ITguN3xwNF9oWDE/KWFfPUEkeVs3YygsMFh8I2JuZXkhMjZDM3pOcnowVX1kR0w2OHggWUFvPE1LIEpDO0lNYmc0MUY6NlY7OUggSjx3dXZxZW5MQnNXUGc2aWxkdyNCSXEgLiYpYUhKaD1iUExIPVFRVDozc0ZiWER+KCU5U2d7SF94ciFXNU1aRW9wZG95JHsmeXdWPFNrPyQ7OVRoNVUpNVdOV0EoQWVBLntuNytNP1pPVUEjPUo9fjpDZ3tMcT9bLCBCfHI7UEN5LH4/QGNlencya2Z5NS9+MT5tJFZxW3pRVGZPSGY3dnB7cD5IaXI/Nk4yI1BpZGJ4NlQjZC5vLWNlL3RxTW5jQmNqME1gKERMclVIZkI/NVtuRGxYfWYzZndIRUNxRTYmPlF5NF5zQVppYlIoWnJtLkV7SDBlZSlodkhLVjNSXkxxMFRrSWUwTmhrbDN8fHlVYlkqdVNEeVd4PEZiOm1xaj1RIz8oSiFIaGJlQSEuP2QucU5HKHRUQm5ESV5BbSp6TXdNc08lWHg8QFczfTVBcT8uZ2ReRDp2STA1UC90JC5lfmIkekIwS3k4Nit0JTxpRj0jKnVvSU92WnUqfFYjKWU1YkYtYFsgVl51ZFFpL2Y4QDY2LCR0bEY7S3JMS2UhSyZuRj93bjppfEswMlNwUi4mKCkvM3wsbk1yMi4mSG1Hc1tINn1rQik7YmJbeEcwdyB6MXsmKTBzYzBZSlFzL31HUTA3KHtNLkludXlRdVhUXllzb34qN3x2Q11pYkFfVDQkd31kbTwoXyMtMGk1JXUxL0ZYZmh+cGk4cyAlXyB8TVdGUENUL31TICZFcUNIP1JXeyZPT29aajJnJS1mRSZvJXg1ISNqZi94JDtuTlhQaX0xSSAqT0pNd1tvK2c1PCA8OU9MTktKe2FtKWtMT05zL2FqPFB7dHtiQ10oazYxNDxDZmF0aHRIMllmWT1IWnsoZHxQZTs8RCgtRFpDMTAoSFloaCkjMm9eMDpBKzY4bSplLm5+QldpYUp1QXx2fncuTHF1QEFEKiNLa19XfXpkd115YSBkdil8Y0JgV0VaW3hDZXA2RF5FS2kxKiw/XjVlQW5XeVtkKy8kYjAobiUvZHJPYyA7TElBbEhLU20mXjdzUTluVFgyIzVgMzYyVG02TSk6eyxMSj4lVlBZIUwyX1Qgck8lTCQjM2VKS01jIFIgWHlVZSMuOnZPVlU6WUh1d09FKnUwXWt2WD1NVWg4cD53PnpJdG10UEBNYjxlVSQwdnA/OmxBVWhNKEZFfDx7US9lS2M1QVlFMz9QJlNFMTR6JV1hNWl8PSp5MUd0N3JEQ2lYKEpoKmtRcjR5VkYyLysseXRLN0x0YFlnel8sfVY8dF4wb3xKNipLclcoLCM0Li58b1ZIaSsteTdSN2ZWPDV4aTp2L1dSRnI+MGNoYG9xe3x9YUx4PDVCYnprNj94d2JeP2o+YmVbNlhJLj0/UVRlanBLT3NHT1V+NTNtYURTOjhzaCpVbW4/bVhZVW8hMEJFUkk+cUVLViZeIisiUGNOIl5OeiI9OSMidCJ4dEtKcm83JCEiLEQ8Ij0uJCJAIj9IOHxfK0NKNW5uZiYiUCJ9JT0iayI0d3pfOyYzbCY0WlNJe10pPEw2TH5HcnVLZiBGVF5rYF5XcUlYV305KUZJcS9fKUJDZXliaW85P1g0OVUhJTNkZ3c6JXwiIUA+IlhacSIlYypGeH13Ik9mZCJjSCsiQDQhIjciImMiXXlKIj4iOyR4Ol5ZSGFlQ2ZEcE1rPlpqXmEkQkYmQ0pqez1ddyQ0KiZLIXBnNUdoRXVYO2s3Tm5gZzlkXURxbTdaLTBlcikjIVAhIHY3VjhqUSRqRC87XldkO3FwZX0rY3lXakZKb29mVHp7LlB1USwgTTRsWXFGR0cwZGd2N0NzMSRDeDVGRl0ubnAoUHZhPz5yWDp7Wnk4P3BXals2RC1NMl40YCt2KmxTYnJUdWE+MHx2X0d0Ul51YjZSWChCNmA+ak9uQEJXRCxHVjlaTz0+IyZtZDxqIUh+cCxBcTd2U0l3T3NYZClmXXgmcURALip2eHZnOzFEalJCUW9SI2c0MGhTJl9xMTJ7Q2BFJXpwcHRyd2xIL1ptcGIlOitKPTB+UkN8U3c/QzBYc2xEUjdTS2NUX1AoWX4kb0BZPn5nU1M7MGFUZ0RBPmgzMGJvaTEpQj87ISVFe3Z4RG5iPT4jJGFvRT1eKC43YzQreywpRVltcSFtbjJud3pPcmtOTEZLNTIlbkl4fitXRCYtNT9hbTQ4Qj4+eE9jZk91alpWTFRdYExIdVdWZ1EofXg6P3F5SFhtY3BGMEhXNHJfUWRZamR5XWU7ezpAMl5sZTdGeH5VZCx7MHJZdS9qTE5DWVJ0aS51cVsvVGpRQkpNbDJgeV5qMzJCLnw/VUF9LSwvR19xdyF8bFtrMCBpdDBbbFZqQGMoQ0VLK1N3Zl1bZnEhR1N6biBlUiZAOyNUVy5ELlUuWHo6RkFAXTdzZCF9QVk0NmFmdGlULlFJOWx5U3BLL3A2a35DODZjMj4pRzh0IFdyOUZPR0l4TkhJYy5uOCZKQWRCYyorLmAmMS4/TSpDaz1sekcyNWlARUR2MnZBKmtaL3UzVWhxQSYwKzxZK14+WSw2Z2piRSMuN2U0blVJKHBNOWsxQU4qXm13NVM4UEllR2skMC12UW4mTnxeREkgI15VelRrbWtEV1MjPC9hP2tMakFBUjYuOF8rWFk/NngqWl04diU1dml8K2Axa0s3W111S1JvU1BtJmQtMHd6bW9kSy9zLlVAL0RWLG1XLH5INnE9YHltWy85fGpgUlFXU1ZYMnIuUEg4ZnJhIXpWU0AuUjJScnB1O2BAIyFvJX40MT5zYzpYSEVsLiFURi4jYGI7IDVnWmc1YV04PDNORmtoaFZLbj48TnQzd15bQkwvM21Vc1VUVC9NUjtHUGVoLTdBKi9RMSw8aTMoZGpOYEpRPSxOLDU1alVGOlBUaiZDUWFTSiNfdnhZdnpdbGdwZF9QTSVWcm9OKDklREZ7KVBfcXhzUi9HVDRmZFJUWW5neGRaMHcvQS5leWAwN3ckUlh6di1pWGh6Y0dAPFhJblp2ZXNFLUxVRTNBSGchSHFHVjElO3JpKE0va3pqJihBS2ViYUs5VylrV1pzL1c0VSY7bX0wdmcxU0kqM0VhXnczUVhZSD5MI3xgITJhJF8uWytZc35xZEVmWD5EV3coW2YqJUI6KV16e2QuO31LIFM3UjNIa1tbL2dQSmFpPT1zKlptI3NnN3BoZShQIFA5Z1sqaXpMRFB9UU87W3g9Xi1HcTVVRVJ9VVRdflAsYEl0bz0rSm12dlUsODciaiI5czAiVyJxdFIuQ0x+PHBRQSh5YyJXIncmYyIgc0RjQGhGUT5QImV6QDMiJCIiWEYwIl8zLiJQImhVMCVNdkBNTDk4cWNocHk3UTBFTFVJfDBAfFFSelV2Jj1WcH59eVhnSFBfKzNuTngxSz5ES3hbPU9XcWVCWUEiaV9uIk5zdiJgIiI8InYmLCJfIls2InksbiJYWDIqIjgieC5IKV5INyRnUiVqKSIjN0siOns8IlciIDglez4ia29jIi4lUzxRIjsiXyJMJHQiKlVVImhWY2JuIllLRSJuW1V6U0IpeUhYNCJjPCJpImw5bW1MY2YsKkA1UEQ5ZDk+RnQ3LHR3c3ZZYEQvXy8zO3ZNTjlSYnEsSVJWW0wtZm1zSyh0WWciYiJELCoiXiJ1TnsgdjNJIiMiNkY2IlQzRURxXT4iQTVQInkkOyI6WG8iYmBGeXQiPXomInZ7V3EqS1c4N2wodyIvNjEvZVRwIj0iLyhOamYyY0htR087I29lUy4tW0xOZVpKPE0pfnI6JmJIRnc6Zi5pWTM1O2B3PG5eO25mKyJRIlFgWSJyK05FQFdZIUB7InkraW4i',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBbW5lWnJDVUFRQUEvL09pOGhwQ0RtcTcyMk9wSXpWNHVlQ1U2L1hpNDJDdzBCSEg0Qng0VElxQTBFbVJVYk0zNzM5d0Z0UTFuMGtRenNkQ1dIOFJVQUNYR3plMElma29UOE4rUVl6eHFZMmV2bHY4MDNESjBsRHg0eWZ6Ri9ycDBOODUzbnNaRTlGajZaa1Q2aVVudEdaZ2g4OVZkRGU2MDJKYzRZK2ZHL0tlMi83d1NSMG10azJVTHFuL0ZVTUpaTUd4Mis2cldZelFyekREbkM3RkhRR1VrREJFZ3ZZVS9wREM3SWFRYWtaZ1c2SmdqdmNocDRIM0l2NS8wTy9URWhQcENuVFNMYnhnM3U3SUdiWTdOMUdDaDZqWFF2TXFrY004RG5kRlZCZ2MwVjFYL2czQWtMVFl5SVN0eUNNWnE3eDM4bUp4Q0VjbGw4WkZ6c1hjVEZzNG5LOXllblM4Uzc1UER2WFA5SDZ1V3ovejcxVkJ2ZXFFVm1sbVlGcEVvNHdvY09zbVlSRFFSM296VHBNMU5meVk5YWNjWGJMbXpQL1hQODBxNDFWZ0xDUTVaUzFCV2xVZGh4VXdwdk5DV0thNVlSVXh5dUdvYVQ5aEI2THZpdnB0ODhKRFNYYnlaNmtheGhKZ0p6cGVWbWlPUXZ4V21JTmJxMzVGT29HUEc4d3NyM0UvMC9aemd5S1ZJNHNLQ2s4N0UyU2NPNnZVfjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBdmZnWnJDVUFRQUFscG1qOGhwbW85RWNVN1lXMnhwVTNTblFFREpPZXRFcnpVOGgrdlJpUXdEV0pKMkFHcDNlRFd2VUttUDJPdUdaR1poenZlRk5PSXhlRmlCcUhxRW90bUl3empvR0p0djFYZDN3WnJiRFRrb3BzR0dmOWNtN0JTK3pPUW1WR29WSVR4bEg1aEZYbFVTeFkrSEtZbzRhaGRzSVE5NHNldURxbnZ3aUZubTg4cGtSeUdOcHNtTW9kcTd2MTRoTXEyTktMSW5GRlNQeWphVlN0ZUw2MWdDZ1hDWTFxcURMSW1hbGdzek9ZTDhHN1BETlEyaUIyd1dwSEFpb2xlZUxYSDNZMDd0RGRndUZVT2M2L242NUxqeW9FZzhUREZNZHA4b0lLeVFac3JxRlV2cHFsaU03MzN0cEs4RzhxZWZkK3Npd0JzQTNzRmt4eDhaV0FTSmJ1ZmExYmViSC9HamJhUTNQK3pRbjFYQTEyVzdtUGNIamE1bTJoRTJyUnQxdGxnZnlCL01Hdjc0WkV1QW93d1dqL2k3dUpRQjVtRzNYMGlSVVFsQTBwL0MrS3F2cm1pVFJSSXBrMkVQWXJGU3RpeWk1UUJVRUJnOHBlQks2ckk1eElLSERtU0ZXZmVUVElCcmpZNjZNekg2Yk5OWEgzbVVYNSs1WEZoMFBRYVYvWE5BWjRGeTk2NUNVUlVraGVGcEcrczQ9fjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWt3Y1FBdVBpWnJDVUFRQUE0U0drOGhvUFNoQnBBUFI4aGlLRDdYMUp3OUgxRkgrb0IzSWpYdERWTVU0QmdYckpUWFV6RjJpY1krcXZUaHNqeEFaNDVtT09WWC96aHBjczJ5aU1jRDk1dU1xc3NobTZzZ2NQdmRnMmVUMWtBVmpXbmhjb3dZaTRiRUlsZEN6STdiVHpTeEhTYXR4SXhhVjZicWNlYzZwQ0F6enZCNG10dzh4QUlER01idmNsOGQ1N1ZnN3ovRGhUZWNTVmtVN1g1VzgzbVF5R0JRZnk0dDFXUUFwL2pEa3BpR1hjMk5ROHZPdUQvT3NSMjRib0VRazZSeGVlVU8rMjlpblhrTWJFQ3dPQW8wL3dOMGpudjlHSkF1NVdJajErWS9YcHFhb2VRNkRUeTRsMUk4OGFkOXQ3RVo5ZGE4WCtuZXJOVGVya3gvdUM1QzFBYzFLUTFValZ4Tjh0SXRTRStLK3ptYmh5ZXVtdlNZbnNNZStSTjBnYSs2Y0VZbGN5MWlqZk9CV1lMVllaYUVBbEtub0tjTjlodjdPVTNYZ2h2cUdLa0RIUzhPb093Z0RSdDhxNFJsVEZjMHRaL0NQNnBySjVxVlZ2TDVhUG5RNFZ5eUlVQkkvNEtLc2U2Mk8xUlZxbWtsRFhRakxBZGdUbEJJY0w2ZVNBeFVlRHVOQ3BLZnRyRjArYXh4OGFIWUl1U2FtV1Zlc29+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    # ---
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWp3VVhBcFdjTGZDVUFRQUFZdFNrOGhyUVFUMzh4Zk9oT28rS3pSY3JQOHAxV3FUemZLZTMyOWhsRkQxakJNcFdtOXZkbmpnRWwrSEI2ajMyZGRiT2lZZENBRjI0S1ZwVGlqd0FDd0dFdHV2aWlBc3NaaXF5eURnTEU3c3lGcG4wMUdVYjBFYk1CdjhHUXdib2k5clBQVnBnaW5GSGJXZEdsUTdYUFEwekhyNnM3TUpUMXNtUEI1SmxJM2NxWmVtNUlxcnp0UkhMa3pER3FkdkJEa0U3UUwvWmUyWG1xUllKQjdzdkJOS3hnaDFFWEJqalcrbEtxMkZoa1ZVMTdWVHFTTnlwZ0V3U0YvV0xhK0dvV2dVSU9hZmpPaXFLcGZFdFRxbGpYM1hvOVk1b0tBa1VFS2l3UnBJSDRJdkZsR3dmbGVOVXdYSjlOODducmZWZGQyUFdHZitJM0ExNUxFNWNZQk84Y0luMjBMbDlaM05vcXZEcnQ0d1dEZno4UWxlUzhWSzllV1d0bVNOb0xhVW4zb3gyeVV3OHlSZlAzN2FoaDBaR1ljNCtXM2lSSzZiYlZrRlZPS0hrTmZmVWRBUVNGazBhRnRPeEQ5UUpSL1F6bW51U0NJemUxbGJnT3M4OU5sYTBSN2phakx3b1ExeTJKM1VJMUY0d0NvSlVmNGNqNnVjR0xtNDBRNWlRZWJFYUVsck05dHA2WVN3Q3dRPT1+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUW9nVVhBdkpzTCtHVUFRQUFsMWFtOGhvei8xUndEOStPUk5CR3EyM1Y1azQ3NCtGZUs5RWtkR2E3MU9tMlBidnkvRytta0V4Z3YxN3BtM2xXa0lNd3kzL3FUTFRoRE5pWkYwYy9vRVVqQ1AvSFBuMGdCUWdCYmhQamR4aHM0VGZ5eHZ5b20xenUweFI1NWJXWHhNNzJMaHhFNy9aQ3dSMnpkU1JNc1ZQNGVscnBtVHhvMDZZeXBXL3JCMDB0VnBSaW8zdG80SjYrWTl5V1FwQm5LUDZLWkMzeGc5alNhamErN3FRK082Y0lGcEFBYVFlQWpFMHhHbEhVVnlNOGhRMjhIZm4zcnZsTUZpWE1xNzlmTFlmdks5MkxscllETHhSMTFhTXhodjEzT3dGOUF3VU5qUmxKa3owb3dPczgvVnFkZDhxOGZzUTlVWnRuL2VFVnZpK2RsMS80MUFTdEVuT3pzN2FoWEdkdVpQM1NnRlFneSsySFJoVVI5Z2t1WHhUT1gycHlSbUVQajFRdTZHWWlSTG1naTA0QllKNU9VdU1CS0VyTlAwak9xRk1SM08wUFE5T2U3bDZJdjBhdEE2cFdpWEZrL3pIejhuTk1yQnJSTjBISjRySGNSM0I2N1gweGpMYnJXaVhwRGl0RkhYTkplUmh4aHBNeFhReWJPcHlYaFYxZituUjlvS2FacUpzdEptNnFjRzNwdjhhVmNBPT1+NDUzODY3NH4zNjE5MTI4&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUW9nVVhBdFZ3TCtHVUFRQUF5OHVtOGhwR1JxZmNpZytmZkQ0RUVPcDg0bmdpYWFvVThZSGRxMnVzSmxnU1h3Q2hxeXVxcFZ1bDZTRTlaWldiSnpTdHQ2WFlHMG5nWVcvd2syaTlZTE9acEFOU25lTmVWVkxLVWYwZVlteGNZUzc4NDI2TUcxMVduSGpMVDUrOHN6NkZ2TTU0QmRoMG0xNTZ0WVlHSUtpSVpIVWpEWWQ5S2J5NCs5TUhJaWk3enQ3S2drbzFDWnNXMDlFbW5RRHlTekpvQU5RREFBc0lHR1hweDJxQXJTV0paeVpVOVg4azVKdmVQMjRNQzRidExKNzBDM1A3QzVDTEZjVWE3K3dCQVRKd1A3eDFrWDBSTlZBZlpFUTdUQm8vQVRuMFluZWtFMlZSUGpLdTg0dHkzRXVmWitXN3B0UGNlNENvV3JabmdTdXdTbnNhYmExTkM4NjNmSk56VWg4MzlpMzJqV1A1QVVjV3kyemNiY3ZDdVpWbmhGTEFnT2dyMTYxb0lkTUhLa0VNMHd4VHM3WmhOdzgxa2JoUzg2RUZ5MFo1ZTd1dHA5RU5lWmMvaGNKL3VWYVR5T0NLSEpFQ2dmVGs5c050VmJlUlc3QW13SnlJL0JCR0pCamIvMS9XWlpsdlAwNzhweWJHVFVqTEZXcUtuRWZVamhVRG1BOHJmcGZKa25YTU9DZTRnZFBEc2dyOH40NTM4Njc0fjM2MTkxMjg=&&&sensor_data=MzsxOzI7MDs0NTM4Njc0O2RKYVBTWDFiTjFQMjlSRUE1dU1LUFcrNnl0eEZuVVdEdjRlMFJucS9tWEU9OzI5LDEsMCwxLDExLDIyMDsiKyJ8M3UiMVRaIloiXV87fCoxcD46IzB+NUEiISI3ciYiRXF5Sz5NdSAwO08hImUiT240ImNOZCJCIkUiJmo8InFSNCJrejhfJEppNjIodlMidGpENCJ1IiJ8QSYiZT9rIkMiIikrbSJWLDYiPCJaenZhKmBBa3VaSilxbHosTz5pTDdUWiMgfSEldXBZNGN7fmg1SC5aVXwyYVEkdHQiKVhQIk5hMCJdI2RwR2MsZGgweEQ4UXMrKWxpPmNfVzpwYUkwT2pOcSJGIkVzQiJ3aTBrWSJWdz8iSyIiKCtOIllXImAiInAiaUQ4Im4mUTlVeyJANiJDZChrfjlecyJqMG8iSHd6TEkiVEp8Ill2KmVPJi5bcjZqK1stVCIkLiJDIi0yZSMiNjZoIjErQyJRIkYifjZTIi9hPyJ2ImhYclVCT2Y0cCImK20iRCZoInMsW0lIIm5RSiJfMyJ9YGgiUzxfInQiOHx5b2ZbSjAiYjFnImdwSiIwfjMiOl5VXiIxIjlGOnFoSV5MU0RDcF5+NzImRV43YFgmeGJFc19oNX4gImQia2FrIiUiIyJXSVgia3t9Ilopcl1TLi5OQU4iVEwpUiJBIiJGIjI/QSJAWyZ7JVR5YC82dXliRythIkY+VnsiayIiQyJCWSI0dnB4VCl7M3BQIiNsd1YiX0tePzUiczkzIl5Vd3lFRUM+KiIxIyI2alJALi4jInhMQCJ+fiE/em07UFF0I0s7YFEidUgiPWpLTComK30ifWNYIjoicnlYS1Vwd24qQVBfZEpYOFlSXllfV2Bjby1FVTRpOlMtPngvfDhfLClxNG1yfnROay9hOm5YJHswd35obEMgYUBML1NfO0U6JWcjRj0galR8NCZqa2QuI3kvTUhiOkp5MS9xKUMidVhuIld5OyJoWn5+Zyoxck9JImgsWyJZIiJ4XmNFIiI9IjNjJSJJIiArcE9LIig2TSIoJFsiRyIgVnkgIjMiZCorIl57TWl5IncwIjBFJiJdWkIiVSIiYSJoUz4iNiJdPiZkdyJNeUZLRkV2dFl0b3w5amVCUTUiLmdGUSJyIlI5KSJ4RiBOdyJ8VzAiWiIlaCJVKFsiMX0obyIrIlp+cUFBcXdTPGk9QlMycCkzImciaS5uIjhWVnBZLUFSL19NKCVvV0wgInstUiJCVV12Q3MiIFFHWiJnInF5OVYqImZWTCI2eGIiUCIiU01QIiNiNyIqX0ltRVJ3ZEVyJmc+PDAhJXwiUylvIngiKSlbLldOYCpJfmUxRylpYHpyM3l8eFdZQS4yQF5fNGo0I2VwaHxgcjR6MnIiPCJ1RHYiYWVgdW4pI3FgQyI1LyEiNyIiPy92IkMqICIvey5fI1tSSyJiUXIiTyIiSyJjZz0ibFJKfTRtIjYyZiwiYCIiUCJDN2EiUiJfIjt5OiJHcTYiQjkkOH4iY019VCI4aj03MC5AXyIjNEUiYz56JHdoLSJYWVIiNT0pXUZ2In5uR0kiLSJpSnl6RjJOW2hoRSVhe3V5eDctcCRbOGwlRHNvZHUtWkQ7U3Zkczsoai00M0ZuUTYgT3A4fHNeRjNwLH4zLWNfTVk6UjoiPj8gIlM7ayJNVV5ia3lJSzMuS1FHMiJSXjQiUC5RcCpCdXU2IjAtLylsIk8iS1JeQjwvJCNkKU43T2s7JSJDIkU6TyJmNiI8LVsiYSIiOSIocDwiPy5KQnd0InppNmdnSiI+InNubyJdIjdse0ZifHZtSHJxaDhQPG5PJHE4fERzW3dDIHJ8L08mOmwrW2w4KS1pRlJAJD0jX0Z3ckEtUHp9L2lEPkttKmkkVHxYfT04QiRfeW5Gb2BGNWRrMjJYLylMKXBwcUVZRWVFaUx2ST1PNnA6NnA7NnRoSEsrfU59OVE/eCxBYiN3P3tNOVYxP0Q/ejVDNF1RPEYjI2liNHUgTjwkLUZ3QkNmTyRwNnsuOiR8OE00eWdWakpQQTp5W3c+JixAUH5hSSMhSz1kR2Ivc28zTz54b2l5ZyFjbk04WC14dCZaMGFNPjZ3aDEhNWVLU3ZDLXR+dnUsNipCfGIpWlRPKkQhXVhENi12VUdkLSMoUS92YGBtKyU2PEc2OFMtfjRMKnFHR0I8KSVoUXhbVV0uXVNLYVtvKD1ETExCcVJXWSRfQTQ1JiYoKXhaNGtyJlUoI3UxPFtsKEBXUUosanMjWCFzbm5wdmlsbGsyZ3sxc1RPTmNxN014L0ZISiReKD5tVkQ4Pj9VTVpYTDFzfSojanR1JEhtfVZuLjosfXJ7N31kWV1qbSB+NTs4IFAhMndfdClHaTNSID1dbipmViQ/IGJxbnU3SVRrYGpWS195fmN9eFF1T31JbS1JWk05aylyXm9gMDpnfjE8PjF3QHFnSHgqUHRXKGQ0WW58cm1Jb2ZLXnArQXYoSldfVkZtOkc1X2lNcFohZjd3OU9HNWo2QjFKUSRFbCNVY35+czpkd285U0BeTCtuL3w2ZWpqPXBuYSY9aStiK1ljLXwkZC47N20qdEU/YmMzeDtqdCBZKz8xX3BTa0ViSV96IylmRVZbN0s+c3pYSHZxO2tkfV9KVU0tNHdBK1omO3cjJV9JWnZUfGxDOCAsbF16Z3AlXVZnaz1UOmdaIWkxY2N7Y1RYfl4tLmFiS0ovM2VJTXFlUmFxSXheL3lMNlFAUWRIRmF3Tjoqfn11elNVK347VD1DVHNAb2ZCOmZjIGdwPiUqOmNaL34lMHw6eXtdR2Q0MSM6ZkFsWEA+fXs/I0RfX18vRjglfn0rID4uPH5zNF5bWiw/IGxmQjwhe1hGZiolL1glIWFfaH0qLT5DNiZRIHUrTyhwRkI1NXd2YkF7RkxKck8+NklNamE1Nz8yNFtCSEx6RDd3dXJ2bW5RRXBIUGFCZHVlcSxCT2x9KCgxX0lCZEFeUE9NREdSVD49ckhVXz56LHg9RnIkUFl2bipXOUlZSXhyW2xqJHsseXdSN0pfRH0yOVkiLyJTaSoiZkAoIkVwbSJ3Ii9FR1RNSzd4PyIsfiYiSUw5IkMiKyBAdmosSzx+JiQ6OiJdIlhpTCIqIkRdZXBHXkcxO0lGRWJtaSBDNiBrJHIoRlchazRkYypmbkVdY2Q5RGQ9ZDRaR1hFRFpVZSt9RF51dVYkSzMhTnIqbTZIOiJHc1IiU0ssIkJxQiogMCJbdGUiSiFVIi9jNCJsIiJ7ImhGRyJpIkdBVihYX1FsfkttSWQwTV1oZjcpd3NVYlkre0w6dV5zQEFaLW13aUJQfEQgSiRAaFtmQiEtM2Qlek9BL3dUQ2hDQlpEbSUhSG9IcU8qVHNESFEycSw/c0QpaGVRQy16RC8xSz53ezFVemEvekIsRXMxNipqIzptT0B8fWtrUVQlU3IqeFp8IVoxaEU0Z0x8S2R4b05lKmg4PywwfC51aFE4QWtMTG4kT35kTDpxZjlpIUkwMlZjWSktKi4wKn0tZE1nNikoSmJLdGBDO3ZtQypHXVlWc0src3l0LHo2KTVsZiZZU1V3KXdNTCwrenBQNEh9c3tHd1hVYFNxb3omMXFrQF1taD5qTy8keHVlakEpVXgjJGU1JHUzMT9fa2t3bGA+eHooT3V5TVZGTT9RLiNefSw6dz5EP0hScShQT2xWYS1wJitsPTFqfnAsIHtwYTB3fTtqUlNTa3pASX4jRT9HI2FzI2M3MCU3OEdOVEpMel5iIWtNWVFyKldwN1BucXtlRVooZD8xNDxCa2Z2aHBKKlJmVzhNUXMyantQZTY7STMrN1JJKy4jPU1rbigzMW9WKDo6KzxFZyRffGZ3RlJyYEl8PCRpIG40UHV6MTZCKiFLaFlXeX5ncF15YHhecSl4Yz5mUERQVnhAYW1FRF4/Q10tNDNFVjFgOnJLdVRtKysqWC16dH41Z3lKXiE1RkBBakBISmUqZDxzUDRoVF0wfClmLTIlSWEyUyhJejI/Rz59XVFfekUsT0t7dkovSyEvM3E+TUNpJlF3SW1WZSEuN3BTVlk9W1B1d0c/JW8uXWd8UTtITGg2aTcpP3Y9amB0VENVWjtpSCkkdWdIOmhETWBFLUFMej99RzBgPl81R1FCKjZWLlRFMS55I2ZgKGQkNyVtLjpzPXFTQ2pPKUpkIXJabC1zRz0mOyU1eHJQMlRpWU1ue18jbk46dF0wbHZHNC5PbVYoK3kvJiV0b1JOYil9dzdQMWJmPTdsYTV0Ml1QRmtAJWJoWGZ2I3gqYldvOzE6ZnVpNjh+b2FRNmo8X2VrNWBDNTRAVklkYWpRSXc/TkglOyxzZFFLOjJ6aDBdXmo8ZV1TWWMmK0BUWUg+d0BSXy5ZQSwzdiNzfE9TIVZiZjxtbGF2fk5UbXA4JHxUPERTNVNiQEcyTztPPitiK0BQMHJqaiE5VmxISl9aYzF9PkQxWExDTkZaXV5WXzZ4LDd+W2dpOD5sfUtidXwpZ05zMXJYRENTUmR1KnwjT0FTaVo3T1YkMGcsW3c8Rko3IUFeQSE7L0RMaGssMSomZiw9LH0wN2wlVyFadj1MaFBNZi0tZ29pLDVlYzo3NyV5OllMQVluSGRTdFpnQ1FsX10lQkAtO0Ffdz1ldyk/MyZLfmprK0xuQHZWLmQrUm1jbTlzYklobTNTLDpnciB6dUghJHBAWDx1WiBkRn07ZF9rMm5wWSMqYXldcEZZb3BiSnEmK1VwTSt6TTdmXm1PSUs2Z2tnNEN2NX5DbDBNRVoubnAtVnFqIi8iM3ZWIiQiInAiQ0BsIjdTLmI0WCFqIV4iRVJ+VyJGIiJqWjkiLzRPIkQiXSpBZFpCdiB6QnowS1h5LTAyVEJuLiVtYWZ1Lk8qczVESjN5VnF6VU8tblc7XUIrTEpLZDFMfXU6Pyx2PStCKiJBdFIibD4+Im0iIikiJSwpIisicXAiXmI6IjlJQ0siSCJIOyshVU97W3tBQixefiI4TikiJTE6Ik8idV5OWVAiLnpYIi4kcj1VIkkiPiIgJVMiSGdqIkk/c303Ik1OKyJqPi9rfGZ4SShXcyJ7OyI5IjIrTV1sdXt1ajpnfHxVenBbV0dLNjoqeUx4ISZSOCwmNjtaZzA4RjhDdFNfa0ZvZktQSFRWYEMibSI1SDUiKiI3RGhzRElrInAidHctInZsWGNNZlUiSkEhIjlqeyJDQHYie3xJY3UiYVs0IjRpSHVyPWF1bnZuXyJ2M0E2cy0zIjciJk9pOmp6dSREOn5pYTF3LEpAKWJfUyh0KCxoJW49USp5RWU3RU1OczNdPV0yM1NjIVh0bSJlIlombiJWXSpDN1A1QXolIiBxRG0i',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWpRVVhBdmR5MisrVUFRQUFwZ2FwOGhvb2pjNE5HTUFKTTkzT1N0VFY5bFZjZVRoY1lINE1mWFIvMzRqWkN1STlIQzhzZGdCWlJOSE5rR0VmbjZTODV6YTM2d2xtMmw1WGNxL1ZHdTVGd0RHelM2dktPOTU2a1gyemVFd0VTd3NKZXBTZVRjVGVrdk1PdjBMMjJFbnI0YTdyZ0hzaEpBZG01SExxQ2lTeXcwR0lwS2wvWVdRVFFkZ1JDdGhLV1B2dFFlc0xxYVFrV1JWU204WDIzdDJXMHlEdzkxZ1grZG1rRVdQV1pGaU1WUkdDWisvbGVkMEUyUzA0bHRlOURqSzJmVENRZ0x3dGJYMGlaTVJ3UUtsMituT004MUJiNXlFZFZ5aksrVldMTE1Md0trclpydncyeTZVZFQ2aW8razZCYndIMnlWbzNPYm9HelUrcGRwbzcwR2JmVkdTWUVlMWhqK0ZNMVdidW9UWi9RaU9BeUJ4OUJwd01wdEtyMCs2RWZER3B2UXY1WWxhZVZDRHRFdjVUWmQwS1gwd1VyUmZIMVUvaDE0TTJOUkRyc0FhLzBZQTZhN2RUN2Z4WVRUWUZlTGFqaUJvRmQrcmFuL3AyWjJvTVMycEJxR2s5N2xwL2lRZmtPQ3N4dFAyc2dBVGZjSUNyaE1ZVXN6UjFiUGtzWXBUN1U4WGJRMzZvUFpwbzZjSVlkS0haMGNken40NTM4Njc0fjM2MTkxMjg=&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWpRVVhBaXQyMisrVUFRQUFTSW1wOGhwdEdieGJYaTc4Y3Y4T3pKSlZtc1BQWnhBY0VicVg1cS8vOWlJcU1GdzZjVDJBU2RPdXp4NCtTNURlaHRFOFgwdHY5MERRUGJVK3hzVllweDlTQU5CTXV6Z0RhUXFaV21reXdHblg0bE9LY1E5UkE1akFEK0d4akhmREY3aXp4ZUg3bURlc3ViMXhYNGJNVzJ4MFE3T0pzcUI1aFZtL3NKZk10OXBENmwyYU1sVW9jQUdJZG01ZHJKMXVUZlNtWERrRlpMUkUyZXpWTllWazhWREdHcXg2QTlvVlc4K3VnemxmbzFkZ0dpYzI0UjNkeUp6L3lXQkpKd2ptQkovZ3VTRWNhYnZhSlVxenV3RGc1bXdyd2pEamsyOWxER2dWNzlXbHI2UTYrcDRxWTd6UUZjaGErSHBaV2dTSkU0a09FVCs0d3luUjI2YkxPYU9DWlpKSG9DVlZJSzQrVThYRjI3ZkxsUzA2WCtqWkd4Uzg1UTNpQWJWREVUbDJUV1JEN2w0NTQ2Y0w4blh6Rkw4Z0xqMDY5UUFJTTAycUJnbW5LT0g0QjBHNnpONE9LKzJoeEY1S09LSm9GTHpsRUNPSGRjQjVSbUxMQkxUbkppUVM3SHA4aXl2RmNIYjRGOWFXUmdlZlZwQ1dDMjRKNUZwdncwcnZoNDVYODdMeEV6dlFTaEJQTFE9PX40NTM4Njc0fjM2MTkxMjg=&&&sensor_data=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',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWpRVVhBaXg1MisrVUFRQUFUdlNwOGhwZFBoUisxKzF0Qm1DTHRPS1MyekpwV3M0SW02SldtbmJqanBrNFFVNmZjV0hmaFZiODltWFR1VUR3azZORmhYWnR5M0NhRGkxR2VsaU8rSE41U09NVEtQSGQ0bVJCeFN0ZktqOEJyV0tuMmQ1cmhSSzFpSlRpUmlzRDFZNW1rUVNyQ3JxQkdtUGpoeHpVVjZ1NkYzYU82RVJ4TEZVWXFGa3E0dmNzMDFEbHRqcGxHMGVDVVhqWVlCOHhtZ1FKbURtMnU2a0dzRlNjSUxiUUsxQlhPSjdab0grS3BnRWxzTUI1N3Bzako3OG02bjVYMW5SeG1tZXpNWkpGcmlIV2l5MGFFME1qakdPY3hLWGsvamNTS0R6K0Y5QURxZW4yRUNzK3lTMXRMeEdwVWlTb00rcWhPSVIxdjZ4WVdQd3pQRzRDczUxbEg4UFg5a2p2OUxpYjg1eEs4L1JWQ09LQU42RnBSK2ZsTTUzZFRnaW9BWWNnYTh6My9RcStDa3BRZnROTkpqSXd0OUhLdEdwWDJheG14dS8rR0Fyemw4ZElFR2pBa1pML2QrWTFhd0JpeVdBRWw5M1pYdS8wL2FmMnhDUGliVWZ4MnVydmQ3WnR3M0M0b2RrOU1QMkwrS1ZjZlAveXRsdCtqYWNZS01pUDM2WUUrNWdpWTVpcTVWaGRJZzd0SXc9PX40NTM4Njc0fjM2MTkxMjg=&&&sensor_data=MzsxOzI7MDs0NTM4Njc0O2RKYVBTWDFiTjFQMjlSRUE1dU1LUFcrNnl0eEZuVVdEdjRlMFJucS9tWEU9OzYwLDEsMCwxLDE3LDkzOyIrInwzdSIxVFoiWiJdXzh6MzBsQzl9NX0xN0YiJSJtKjoie31sdkR+JlAxYEskIjwiYkJqIlRXaCJBIjUiXkpUIlIzRCIjO11+T2Q0MUFqYmciYUVAMiJ9IiI1NToiTVsxIiwiIktASSIwPWMiRiJKcCNVZ2w7KCtMWEY/emNjXklLbk9ZLEFfQGY/SHtwKVdBR1QpUzV8VU5Edl45UW0iTF86ImI+RSIvZChHY3UpXS5jbSxTU0A/WHo5PnZZSGNGYzpRY1NsWCI0In4xYSJzQF9oVSJlO1giZiIiSyBHIjBmIiYiIkgiOy5qIixTSUksWSJAUSJtIWkjTlEjZSI9ZHkiIy1tejkiSnRxIiEuLjs5JDJ3OmgxbH5jcSIhNyJ3IjZfK28iKnZqIilHdiJqInkiKmJmImRDXyI5ImJqXj1UYTloWSJ8e2siMGM6IjJwPVZUIj82cyI8aiJTdnEiOlt4IkoifnlsaVpLKWsiJHVUInc/dSJdcWoiZERobyJ1Ikoya2xTWE1XP0R0WCA7LShJWDhkUyh8XUZ3WWk5eXE+cyIqImJeYiIuImgiWjN5IilbJiJ7W04xNmFKUH5sIn5DP3siTCIiVyI8Km8iNTN+PXBgOTZwel9eNWM5VCJNdFE/IlgiImMiYmAifkRxUlpNdFI8KyJ1WWIzInhDN0p3IjN5PSIgeUM/V0ksbjciQl0iWUJBOSUoISJOcksiMV82eXEkU28sTEtpU1UoImhmIk9FMD8vIDEjImg3aCJfIixRZG0kTVVCVWtscU9gT2JMcD1LVVhvdCovNDZHZnJNSTMqTF8gQmppSVN6clNvJnJIRDh5djg7SygkRCVMXmdxTVJ9NX09OHpLR2BAUHo5KmprZC4wVU07SFUyME8tLXYtO28uInBSaiIyQUIiLzswY2IvVEt7ICIwN1EiayIiY2gyKiIiTCIzYXIiVCJKdjZASiJPeTEiYFZ7Ii8ieiF4NyIkIn09PCJob3srfiJxWCJDc2MiREwxInkiIi4iQFZgIjQiJGZEe30iOk9He1skcC4lVmx4Jl1Rams0IkJLTSAieyJ1ZVIiPFJ5KSYiMDo2IjMiL2ciXn46IjRiQGEiZSJwQUJxd1M3Y0JIVi1xKSNZdiJ8Im46dCJZblcuR00qZ0glKGxvUCNgMyJELHwiYCpHL0g7aCJfLkVQIk4iM31VUzwiNkx8Ik4wOyJuIiJrSWcibWYsIm5HV3hhRnl+YkI/Ljh3LWUiNmAzInMiQkU+VEkqVl0+RU9AbXZkKTJae3dxJk5bMy5yNncyfWBmNEdFYV1WUzFFejAiQCI6cmIia2JwbC8gKVNRZSIwMjwidyIiISZkIiFySCImKV0mcUZZUCJpbGMiMiIiJiJhPGYiWUsyKHtqIjFUNikiPSIiSyJBT2giSyJCIm1IRSJxQSkiQzUsLyUiTXxVZSJvQTU2PzRtZiI1RDgiPyAoK1s7fiJiWVkiQyVvT3grOCI1Sk5fIlsiUSRJNDt3eU4oZ2dORn4tNzA6IWxnaylCI21beihDd0oqdzBEZV5yMDZ9YiA4dmNVQ2cjKF5JWm48TzIwYW1LUT9NISRHIiNLVyJ9LngibHkuMHh8NyZMalA0WVYiOWMrIlh2JUMsezhrQSImNk5TRyIgImNMLWgvQGkxP3BJOEp0RigiaSJCXkEiSkEiYGM7IkciIj4iSmdqIlhqQEImJSItaSVLNUNxIjEieC5dInoiSlp7bHhGaXJxNEo5ZlE0cTh6PHRjbEV+eHMySnxDciVhZDgpMV5IUEZ5QH1VTn5tRiROdygja0JEQnAmXyxdd151OTpOd2F2dD1yXUQ7bWY3KlMtM0ErbHdoSFdBak9kUW5CQVcrcjY/Zz41bmxTRjB0UCg/RkB9NzhlI21CKkg+TTNASDR7Ok8rYFE5SDF8blg1dy9DPSk6PXpDP3BQKWs7ci81L3E5UTlwa09jVFBGNX5SdzwvfkFUKFdNe3dVPGpCZyVycDlEP3t3YH1kdW1sVDNeI3duK08xY1Y1OnRmO309YFBKdEA5aSB3ISE6Kj4pXjJVWUYmRC1RWURBI3tNQm4oLiFWJXJjaGIsJUMzTC8xXiYsL1F+bExNNz0oKl9WdFJgVTpXWEJbWXR6PkNRQ0dwR2JRMllGKy8mM3oqd2EsZnMjXyoocDYyX28yNVhPUSNleXxiI3hpc2Z4cHRhazhvcy12TVhOaWw8Q3ouTD1KK2d9OnVNTTdFOlpDXVFQJXMlNHlndGouRnV4W2QvMzlyciNBdWFbWnNqK3k6MTh6WnUyfWpsJUxlPE4sOGJkKWZgdz8obWlrfDJST3Zab0xJYiBzYyUoSXNOdVJnOURgQzdoLWdedW0oOGl0OjVLLHw2bmVVbSpWeE8laDJicSFtcj9qZldScDFGbiZLUmdYS2g/PDllckJwYSleNnoxV0g7ZTs3NE9Xd0VyKk1iJnR7OmtydC5VQGJBK3M2dDZkZ3I8eGlmeT5xN1YrX2skfCVeNjlAaC9pRjpsVzN9RGJ0JFAzPDtZdUhqRGs+XyAtfmZKS2QzVjl4b1dGfGY7b211YEZQVShAckZ9Vyo/bCMqaEFbc0wmZlAzJn5oWSlbcClnTmhtMls+a1UoXTVkbXBjVmN2XzEpaGVQRTQmaEVVZmVTa2lLdlY2e1IxVjRQZ047YXdYMix+dHx7WlAwcjdVQThUckpnaEMvbWMqYnUxKi9GV1ouK3syfTchemZCaSYzLERaQHRjOEB+dUYgTllkUTBJQHh9JjV3QDA0KHA/WGFNLDsoYWVJRnh9WzxtJTIqXnYhXmNdfC83NkYvI1h6JCVUeG5GTio0fCFZRHVCUk92SkMxTU5sYTU3QTI0XT9ITHpENXd6c3RheVJDaFBOZEVtcl9yekRTc3UzLzNaR0hgRF9XR004UlVZOjl1S1VhRHszfTlGbHZUXnZpKWQ6Q15AdXllb2ohdzN8IFE9Vmg/KDc6SnE1UisvWElgPDVGYjcuKnMtLktFVFFRNipAVTgmNUZme0x3QWEmKkJ8ZjVNQCswLTo8VmV+ejVnWX4vKnwgNmo0InEiSiorIlhCYiJhRWIiPSJpckI2TiYkRXEiS3R5Imk6ayIyImkqeGxGZV5CY2AwQGQiPyJJMCEiSyJLNkl4Ti9pfm8/czk0VjVWTj9TQihsQVkgOTtEMmU6Ym1wflZSS0U/WD1ROV82X1RNQylLaCBndSVhQkdGdmBJXi5HOH4iODpmImF0KiI7bX5YMzwiLW1QIkcwTSJ2ZGUibiIiSSJXVkIidiI+Uz9tKiVQc0huVX5SbzlAWjN1NTxpRilsaFlHLXdKJS9HM24mMFklXyR6QjBIITM2JnB4OGlENih+b3RQSn1Tdi0oXnx9YShmQSlbVXtPbXhkT2Uua0VHLC0kJHNkRixKbFBVbnlOfmhPR3lmNm93RywmSWxYLTYrJC0qIzFpUmczL3xIXkBvZUk6KHI6KDtiY1V9Ryx1eW8leiYtNnBuM1NPTG8zfkxMKTF2dEcyRHd0eVZ+WFZVU3Z3IH4yc2tAXWhiQ2FONyp2dWVgQS1iJXslZzUkdS4rRFVqcnxrYD5uei1dI3NOWEZNP0woKVR8Mj93PkM1SFh1K0pQblZhLWt+MGM8Nm8gcC11e3ZlM3F+PWpSU05lIDdIJClIP0d3W3soaTExKDc4R0lOT0N5YWcka01PTHouXmo4Um5xe2A/YHxjQTY5PEFhYHhsekQrVGZXOEhLeCloKVVpNjw/LSw7XUMsMCM9TWZoLSoveVsvOjl+NkRsKFh9aHdGUm1ZTnM6Lm4objVGb3k2OTwrJEtoWVJzJV5uZSBfeF5nICBrR2BRRlBWeDtacjxCZUVBXS0qLEtgOFk7dEt1VGgkMH5WMyF0fjVdck9oKS9HQkFqQENEan5iQXlRNGhJXjIrM2AuNCVJYS1NLUB4NkVJPnxRUWAgTyVUUXt2SjJFKCUxdERQQ2h5UHxTdlBmJC43cFZQXzRZUnt7R0B4bjNncHZSPUhMaDljPH08I0NwYHNQQVdmPF9NLyRtZ0M0bTtKaks0QUt1PH5TOlk/YTU/UT0jO00rXks3Lnd8Y2Isb3w4KG0lOm43dkpAclYmSmR6bV5wOG1IPyYzJTByd0cvW3BYTWx0XS10TTB1XzBsdkIuM0ZqXS8seS98Jnx1VkhjK313N0srZ106PHNhNXIqXlhNdTomZGhYZnF7fX5fW3Y+MTpdd3I9Q3hwY1E2ajdYamIyY0o3ND9NTGRlbUtKeT9OSH41MWphU1I/MnlfK1VibTZmX1NZYyAkRUtVU0V7QFBVKVJGNi13JXN8T056W1hiRnRyYXZ0Sk5yejIlflQ8RE4vWFg8UDlWO000JV8xRUoxdGpqITRQcT9GZ2NhMX00PihfUT1PSFpdXlFYO28oPilbZ2csOGolUlt2filnTm4rd09ASVtRZHV7dn5VSE1qXTdPVn0qbCFXfERHSjV8QVhIKDUwRkxoayYrL3tiMEUvfS4zaXxjLlR3P0xoUEhgMiNjcnEuNWNfNzBELXM7W0xBWWlCaUpwXW9IUWpZWCRGRiY8Q193PWBxLjYuMlMkamglSG9EfVAvZitSbV5nPmpdU3BzM1IlN2V2KXR2SiEkcDtSQWxVK2xNfTleWWw4empaJSpheVdqS1BqeGtJcSEmV3RXLHNOOWZebUpDUC1icnAyQ3QxIUZ2MkZGXS5ucChQdmE/PnBfNSFRezQ+eVZlYjJIKVEpYTZULiAqbFFdbVEgaTgxfnZfR29MY2xYRVVhfEIqWUZ0T249SFNIIUVSM1tPTEIte29XNnItSH5tMj11LnRPQ3hOJFpufWZQcjB5QkArMHJ8bWU3K0VoYkVdZlR0aD04Z1MjZW01KXk/WUYhLHR8a3JqaVE4YG1taCA+IEg5KiBOUn5hbkE2LGJ8cURPPU9PWVJaSilUMCpzN1k6I3BgVTstZ1BrOz86YjQqcXJuKCg+QkQvLEV4fHRIZWA5OCR7cHRLNF8jL0BvOyt4MiRJUGttem5mQXF+cU9ubFhVRUsyOCByQHZ6JFg7NjE9NmFmMkJLPT51VV9qRnNmVFZMZGFpQ0htUWFwUCh6fjZDaHdEUm1iIEo6P1crb2leZVlnanVhWzl3NEAwbXBwLkZtIGBwLnsteFV5JWhISENWYnh1JHNtWjNbcFFDUUlwKV51V2ovQUc7czxPQCMwLi9IZmV7d3poVWsrMSJ0Ii9JKiJNIiI/InxtJiJwU1theilUPXNZIk0+VSEiMiIidj55ImgoZCJUIjxjMU9rfi1zZi5uNGdINCkoLkw+OXtScVRhcUJ0KkZBNDYzOCpxQHpbKXJseFt7R1RWUyBqXW08TktHPXI7JVYiTSYgInwlciJ5IiJ2Im9pUSJTImwzIjUpViJtUWQ/InkieSswR18xYT1hKj9tcG8idSopImZBMiIvIm12Mm5QIntdWCJvPXotRSJRIiAifm9DIlglXiJRR3N9TyJRJUsiakJOQiFBM1koYD4iIHgiRCI+Wy1hT0A2KC1jUjVxIDx5byguYDR1TDpiVHZJUmlYRmN8Wi40cSBpdGBPJXIqRjkhRFAsY0smIkgiSX1FInciJjh4WlhFVSJTIjNfRSJeT0BnZl1yIj41fCJdYj4iQ0R2Ik4mbm9xImV4cSJtMFB5elE8JE81JHMiRXhYdzo9RyJrIj83OFZ+QERyXTZVI3VZX3VjMGUpJXBlfFB9T1Y1bjktRE1UdGo1PSVsaSQ4ZmxLb1tpZFMiRCJzcCMiOjRqT0c7VEFqayIyNEAsIg==',
    'a=&&&e=Q0Y5NDM0NDMwN0Y0MzMzMkQ2QjQ0RTJBNEUwQTU4NDF+WUFBUWpRVVhBaUY4MisrVUFRQUFxbVdxOGhxT1NFTEhjZkpoamMyZDYxS0hsMGMwczBLcTF4YzR0M3pmVUJpYSs5M2JLYldyQXJzSFgzSllqUnV3bjJlMnowUG9IakFBY21HeE5HaHRhZjhXOHVrWmZUd0xGc0p1ZnljdERTaXlKc0xDMU56MitUTHBnZXovVC93Rm0zcjBrOUtIMEs5UkpaUWV4cXlKb0pMUXlEalgrWGVLNXJJbjJrZjJUMkczWjZpa1ZrZWMvbHpXcGxuUTZNNWxrSEZqQlNMREdIRnZnd2dGZG1CTzlseUlhZVlPbDdIaHRLQld3WG5pSTVIVUNLb1c1bHowR1BkazJ1Uk5pQTNKRHhHc2p6OEJ3OFFuM0l5YkhkK3MyWTFSSmgycFBoS2FqWEJ1MW9wc2dxK1VKUGVqUDU2TjVIMVd5RkJUeFRjSTgyRFN0aHVQL01DMzBRenVEcXloQkZqTVg4dENRMHA4N2YyMWZ0RDUvcGRIamxsYlFiSDZQcS9KZzMrVTl0L3h3MEZOOTdiQUx6b0tjVDhkQ1lQdTBYcGVTeHlaTXkvTUttSENDSkYybWNDWmM4R0dsU1Z4S2tkVXI0U3YvL0NLWnNLSVphYWFta3d4VzZOUHY5VXF1QkNoVlVLY2ViQTNXbGxBMUtNaE43enE2RkZEVmgxRngySWt4SkZvRnJVeGowNmxBdkJHfjQ1Mzg2NzR+MzYxOTEyOA==&&&sensor_data=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',
    # -------
    'a=&&&e=NkIxQjgyRTE1RkRBQkVENEE1N0Y0RDM1QUVERDhCMzF+WUFBUXhhTVFBZ2ppbmJHVUFRQUFkYkNDNEJxSnM0NVk3Y3ArN28xcHJKMnRMYTRTb0ZwOEJGMEhIdkgrZGhaRnlHckhKc0wzR2w5TUE4Lzg0TU0ra01IUEI3SGVHVTcycFVoY2hpV3VIckpMd3BaR3k4WkxSQUFVaDg3WGhUUzd0aFVnNUorL3JCVkVmS0lyZTI0VHlWRW1IckkyQ2tRcGhTclFlenRtV3JTTWdiWXVrTC9TYmp6UFVsd1VZVURkWCtGMklod1ZiL0dRWkhFeWtWT0VDOGxLSlNyV3VGRTE3ekcvUHNkcFpUaHpVRStkZXpVbjdhS0FHd1RKN2F5alNsY05ubnh1OEpIR251a2NETmV2ZW5RenplRnVzR3dLMjhiUUkrYk16d0NXNXFUYktCUnE4b0lnQVhib21ETVB5WU5tRU10eEJjSElrMTdDejVQMGFObFFqNDVvaW1rUWdndk5ETlJGdEFCRjY1c3RWOEJmS2JXLzZhdlZYOTBRYk13RUUvaDlNbHRYdmJCaCs4dC82Zz09fjM1NTE1MzZ+MzYyMTQzMg==&&&sensor_data=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',
    'a=&&&e=NkIxQjgyRTE1RkRBQkVENEE1N0Y0RDM1QUVERDhCMzF+WUFBUXhhTVFBZ2ppbmJHVUFRQUFkYkNDNEJxSnM0NVk3Y3ArN28xcHJKMnRMYTRTb0ZwOEJGMEhIdkgrZGhaRnlHckhKc0wzR2w5TUE4Lzg0TU0ra01IUEI3SGVHVTcycFVoY2hpV3VIckpMd3BaR3k4WkxSQUFVaDg3WGhUUzd0aFVnNUorL3JCVkVmS0lyZTI0VHlWRW1IckkyQ2tRcGhTclFlenRtV3JTTWdiWXVrTC9TYmp6UFVsd1VZVURkWCtGMklod1ZiL0dRWkhFeWtWT0VDOGxLSlNyV3VGRTE3ekcvUHNkcFpUaHpVRStkZXpVbjdhS0FHd1RKN2F5alNsY05ubnh1OEpIR251a2NETmV2ZW5RenplRnVzR3dLMjhiUUkrYk16d0NXNXFUYktCUnE4b0lnQVhib21ETVB5WU5tRU10eEJjSElrMTdDejVQMGFObFFqNDVvaW1rUWdndk5ETlJGdEFCRjY1c3RWOEJmS2JXLzZhdlZYOTBRYk13RUUvaDlNbHRYdmJCaCs4dC82Zz09fjM1NTE1MzZ+MzYyMTQzMg==&&&sensor_data=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',
    'a=&&&e=NkIxQjgyRTE1RkRBQkVENEE1N0Y0RDM1QUVERDhCMzF+WUFBUXhhTVFBZ2ppbmJHVUFRQUFkYkNDNEJxSnM0NVk3Y3ArN28xcHJKMnRMYTRTb0ZwOEJGMEhIdkgrZGhaRnlHckhKc0wzR2w5TUE4Lzg0TU0ra01IUEI3SGVHVTcycFVoY2hpV3VIckpMd3BaR3k4WkxSQUFVaDg3WGhUUzd0aFVnNUorL3JCVkVmS0lyZTI0VHlWRW1IckkyQ2tRcGhTclFlenRtV3JTTWdiWXVrTC9TYmp6UFVsd1VZVURkWCtGMklod1ZiL0dRWkhFeWtWT0VDOGxLSlNyV3VGRTE3ekcvUHNkcFpUaHpVRStkZXpVbjdhS0FHd1RKN2F5alNsY05ubnh1OEpIR251a2NETmV2ZW5RenplRnVzR3dLMjhiUUkrYk16d0NXNXFUYktCUnE4b0lnQVhib21ETVB5WU5tRU10eEJjSElrMTdDejVQMGFObFFqNDVvaW1rUWdndk5ETlJGdEFCRjY1c3RWOEJmS2JXLzZhdlZYOTBRYk13RUUvaDlNbHRYdmJCaCs4dC82Zz09fjM1NTE1MzZ+MzYyMTQzMg==&&&sensor_data=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',
    # -------
    'a=&&&e=OTY5OTc3RUU4NzY5MzQzRDdBMzJBN0IzOTlGNzQwQTF+WUFBUXhhTVFBZ0FVN3JHVUFRQUFQQXB6NVJyUFJKUXFJUGFKelFBRVlBTzUrOVVnMHFCbS9XNE5mZ2JUdUpZRDdnM1Q5b2VVSzgvRXRZdE9mM1F5WHpoOUFselpybmd5ZnpEMmd0Y1dzSnZUN1BUT3h1ZzYxb1BLSElabmVvWC9pUEhPTExWUCs3d1JKc1BHTDNycVcvNzNLcTRKbzAwd3NIaTlrQThVbFZVODBvcjI4V0g1bDEzcnB1NVJBNEY3Uk41UnN5aSt0ZDJJUFhMRkFnR0x3UVBhdFlqWTFmWkxCWEd3cDZOTGtkL1V2Z1E3Y3Y3RVFhL0pEbXVoWjk3S1lKYjZTbFQ5QXZLZS9EM0FzdGNrYVJXOEt4QXFKeml5ODgrcktGTnlKUFlqdG5RUHR6OFBDQ0ZCaU1ubXVaQlFtMVkxK2pwZnZ1L3l4YzNRUE1lYk5uUXZNMS9WcjhKMUVERXU3dEIvQVJyRjBYK29VSXNCNXJXUVVRVkNOdzFEbEw4OVlyNnNhS0hsUEZZOGJBRDFPUFRzOW0yNVg1MzRqaGVOd2JlOERBPT1+NDQwNzYyMH4zNDg3MDI2&&&sensor_data=MzsxOzI7MDs0NDA3NjIwO3QyNTVyQkUweEFyVlVPS2ZqQWVXUk9sc0RKRG1IdmNlblozMTV1T3hHdWc9OzI2LDEsMCwwLDIsMjk7PUpSPyI3KyMiJDQrQT9PdnwyIkBMeiJMIilTX05sWE01S1ZmaD4qYkYmQTtNJV9PSGJpZ3Y0cC5ve0spb25hQnBHJjBmJVVsIyxTTEEmNS15QnUpOWY5KyIzImlxaSJ4N15yICIhbnkiXSIyUl95bFVEfDtQd0dPP0A0QUBPOzJpNVZgRSAkJkpPeTpfZSAkK3FMcCBVOjJ+Mi1JVExJSS1adzptX15tKk10LllGcDJTO2ZFfX0/RjxKdkZBUT9QX3U8Yi9KcyVXaENkUmpZRFRBfS5UYyIiMiI3ZFkiVCIiIyJCPnwibTxBZk0iKGFsIkQ3Qn1TIkpJdHsidCsxTy5+Rlp+MFJmP3ppMWo1cilCOHdqWWBCVmo4WDVNdXYlcnBIdmhdLjh8PytaPnZKbnx1IEwmeGwzOGMgIVJ1LXJgWjJKXU8iLls3In4iL3kqYSJZIk1ETSJHcjhfLEMieGN+TyJbUiE1ajUlNndHbjE3IlZNfkBrIipwLSJvWGwuXSJHejJBYDFxTjwiXjIieyJTYFIsPTpyK2IseD54ImsiXT0vInsiT0pAWkAiVVV7Il1dImwiIj4iO11IIjIidCo1fiJtPWwiNVtnIiYiIjEiXn5+IkVEfkUyVk1uIiZUbSI1Ij0iKnJeIkBGMSJVIiJ+SisiK0l6Im4iKmNbL2srTTQjWXpfO0AiLSMxImlIRiJVPTpFckoiUzRAfSJtfVIiVWcpIm8iLDAwMVBiQDB5P307fTBZRSkifiI7PCkiWyJ9ekR1ZVVjVCJjNCEiVU4zIjUgS2NwRlM2LStzIi5VNyJlMGYyfU5reCUvNEFMLGVGWkR3RFome3p1eEBuWiVlIXVJfSohOi1nP0A+T1J7KWl8LkorJmMiLyJ5d3QiaiIiXSJXamoiXSIiR1hvIltDOCIgTX5jSS4pOUFLKzZnIktgRyJfVHg+W2dIRyJjZl4ifi13MmBfal5nZG46QCJGbyEiQE1oImoiMm01TVcxdm0rUzNxfX1CPWtmKWkoYSJQbXAiREpsc1NidVZJIllJOSJZQX16eTVqNj5rY21sUX46PipBXTk9LUoiPWUuImFOeyAvYiRYcCVWbjI6OTh8ImpmbiJmQmdNYlNzIlQpIkFnPXovRlUjLGVpIkFiTiJQfiN1KTtwclUgbTcidUp3IlF7IU8jJSs+dn5CICJIa00oPiJ6SCMiP3pYIkBfLG16Kl9bOmZyU0B1QXopSEpJIlZXImkzelFLK35sUGM9QCJ3bnZyIiwiI2QiXy5PIlktaDgiRWtIIn5NZSJScDlgXiIzMyI/IiJpImFBaCJrIGFVZihVfkQ+SDA2PD91S2x9cVVwcXBYUnJiTDp3TGkhbVEienI2Inp+byIwdSIsNGcicXk7XXs8IiI7IjEkKSJyWmk1dSJGPkk+Il4iIn0iREM3Ik4iIkYiYkBCInsiICshVkghaX1qYm11ImhKLSJdIiJuIltKQCJBemdKLyJxZno5Ii1jblhwYEkiIiNWSzk2QWgqIVtaNEAjIlhPVDgibDddZUkiUGBsIldiWTotY25mNlpbTU89SSZAbyIzVl14PCgvIl1RdSxRSm9LInlnMSIkIj8ieyAhIn1eTCJBInR0V0pQY21lejxPXl88Ty9MTV1ISUpWWXIoM1QvW0NKUD9BIiJdIiU1eSJnaGozdjt7UjlDIUAyIkxhTSJjbUMiPH09NiJEaylNYCVaIiI0IlE/MSJRYlUjIyI0OX0iVG5PTE8iezEiXTFjKDVRIyxCIjwxOy14IltbcSMpIlFwNSJbIiBUe1EiVSJ8Q2YieDVbMCo1dCY+ayBSVmVfSSRCUkJUdE1ybV1AclohTSJCInd6cyJxInwgamBAWXdWTlVbUH0xfk5OfUpKLE5yaEtFUn1TNCUhdndvZ1U9eDhMSCtLVUIiT1N1IjcgLyI6IiJBe1Yid3MibzNYeTEiMmdOUyJgIiJDIlVFKyJoIn1LNXBlNWVqMSY6RSQ4aCY8VE5daUEjeiwybT5TdTBpKixIfUEoLn4yM2VuImIiIzchIlMiImMicSN7IiUiIn4iPnNaImAkVkVxSylpImxvKyIuRkc4biIxQj5CIlcsZ1tAQSIiXyI7LSIuIkgiQmYjImB+LyIuIm19InlqbSIwPmJjIkFXMkUxI0t4ZXhoR3BTVnMiaVBaZCI=',
    'a=&&&e=OTY5OTc3RUU4NzY5MzQzRDdBMzJBN0IzOTlGNzQwQTF+WUFBUXhhTVFBdlN4N3JHVUFRQUF5blNPNVJwa1Z1WFNYR1JvRE9HeHIzTjBNYkhObXJyS0ZWcGd2eEl2VDNOUWFjY3lpMU5MV283MVgvRFJQQzk2aEFULytmUHZUa1NTNk51OGg3emJqV1ZwRzVMcHhGOEp6MjV2dTFJRUJIZjU3ZllsTmhBaWp4QWhZeGZQT25UUG1vUUpicGowTklmMCtnN3F5ZHJkUkJBV2R0SmZJOHJTUmloRUY0emJTN1YyTHJJTHQ2T2tVbjBIMDFJdUxaNDNTb0drUW5UbVJrajBtTU1EQ0RCQXA3eEZiQS96THgvdTlrYXZyM2VPb0JVcUdHSUtzVkVPT1RtYTE1ekcrSVovOGQvcEc1bmhYNEE1L0V4VWdLb001T1BwQkc0ZGgrN0loWmFKODJZTEJiMWpTcEEvWUhMN1VJUmRYREUyTXhzeXdwVzlhU0dlY2kxRkhVdUlSR0YzWXJaWHJ2M0lUbXNISlpPSVR3SjRkemwzQXY0ZHBlODFScTB5TmNNa2p6bUZZWVkreXk3ZTliVmRTUittdXhjN2M5cHFHU21nVzhSZWpYTlN0c2RIZEtXTFhIdUt+NDQwNzYyMH4zNDg3MDI2&&&sensor_data=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',
    'a=&&&e=OTY5OTc3RUU4NzY5MzQzRDdBMzJBN0IzOTlGNzQwQTF+WUFBUXhhTVFBdlN4N3JHVUFRQUF5blNPNVJwa1Z1WFNYR1JvRE9HeHIzTjBNYkhObXJyS0ZWcGd2eEl2VDNOUWFjY3lpMU5MV283MVgvRFJQQzk2aEFULytmUHZUa1NTNk51OGg3emJqV1ZwRzVMcHhGOEp6MjV2dTFJRUJIZjU3ZllsTmhBaWp4QWhZeGZQT25UUG1vUUpicGowTklmMCtnN3F5ZHJkUkJBV2R0SmZJOHJTUmloRUY0emJTN1YyTHJJTHQ2T2tVbjBIMDFJdUxaNDNTb0drUW5UbVJrajBtTU1EQ0RCQXA3eEZiQS96THgvdTlrYXZyM2VPb0JVcUdHSUtzVkVPT1RtYTE1ekcrSVovOGQvcEc1bmhYNEE1L0V4VWdLb001T1BwQkc0ZGgrN0loWmFKODJZTEJiMWpTcEEvWUhMN1VJUmRYREUyTXhzeXdwVzlhU0dlY2kxRkhVdUlSR0YzWXJaWHJ2M0lUbXNISlpPSVR3SjRkemwzQXY0ZHBlODFScTB5TmNNa2p6bUZZWVkreXk3ZTliVmRTUittdXhjN2M5cHFHU21nVzhSZWpYTlN0c2RIZEtXTFhIdUt+NDQwNzYyMH4zNDg3MDI2&&&sensor_data=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',
    'a=&&&e=OTY5OTc3RUU4NzY5MzQzRDdBMzJBN0IzOTlGNzQwQTF+WUFBUXhhTVFBdlN4N3JHVUFRQUF5blNPNVJwa1Z1WFNYR1JvRE9HeHIzTjBNYkhObXJyS0ZWcGd2eEl2VDNOUWFjY3lpMU5MV283MVgvRFJQQzk2aEFULytmUHZUa1NTNk51OGg3emJqV1ZwRzVMcHhGOEp6MjV2dTFJRUJIZjU3ZllsTmhBaWp4QWhZeGZQT25UUG1vUUpicGowTklmMCtnN3F5ZHJkUkJBV2R0SmZJOHJTUmloRUY0emJTN1YyTHJJTHQ2T2tVbjBIMDFJdUxaNDNTb0drUW5UbVJrajBtTU1EQ0RCQXA3eEZiQS96THgvdTlrYXZyM2VPb0JVcUdHSUtzVkVPT1RtYTE1ekcrSVovOGQvcEc1bmhYNEE1L0V4VWdLb001T1BwQkc0ZGgrN0loWmFKODJZTEJiMWpTcEEvWUhMN1VJUmRYREUyTXhzeXdwVzlhU0dlY2kxRkhVdUlSR0YzWXJaWHJ2M0lUbXNISlpPSVR3SjRkemwzQXY0ZHBlODFScTB5TmNNa2p6bUZZWVkreXk3ZTliVmRTUittdXhjN2M5cHFHU21nVzhSZWpYTlN0c2RIZEtXTFhIdUt+NDQwNzYyMH4zNDg3MDI2&&&sensor_data=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',
    # ------
    'a=&&&e=cGxmUWsvcUZTZFhDK3lXL0VNOEN3d04ways4Rk5zSW9aekhYUmNxZFhVcC9TUDNjYTM4YlVUc3BnMnhXUEFsWGRrd1VHVlZzTVpmenpPQUN5MG1ZQ1RSUS9ERG5SWXJsK1FmSnR4S1JlUFRvbHk4N1d1WlhCa1dXcXlvYU9xaTRSa083K3lrdCtZU3pEcmswQllSaGswM25sbmIxZmdJeDdTcWhrbytTdWNON1h1alJSYVpnREZyUm15eW5XVHhpQWI=&&&sensor_data=MzsxOzI7MDs4ODg4ODg4O3QyNTVyQkUweEFyVlVPS2ZqQWVXUk9sc0RKRG1IdmNlblozMTV1T3hHdWc9OzMxLDEsMCwwLDcsNTc7VzEvSnk1NCJeZSAiODYxIix8OCI9VCN8LyJfNjV5Ii4iKUosVW4yY3xCSyNALCxdJXYoMWEgemwwQjx2Q2FfYU0lLiUiITM4ejpdOl9KMHlaQ3FUXiV3ai9dPHQtcXByfXJpVjpfKyt8M0w4ZV4xMWxxRHtAYlddeU0vJHtzMCk5IDB5ZSlRVFIoRCVtYjY3fSlbQWY5PTdrIHhsbHJ6LEJLSz40Y3s0K2EhfllNQEctIGxPfExMYSpgW0VgZHt8P0xOTEVzRFRgMVZTJjgoN3Y3dF43ZGJ2SzglLDhJaXw+MUpGRiNYbH5aNil0dWJ0byFjaTRuJj5wQUZKX2wzU24yTkBaKGp+LmxJRzhFPVlVYUlOIGh0OnVnb2k6SWkuUmgpN0Msai06cVViSWRgIChNOTMgYnUzJmshfUlhNEsoO2lxIWtWczR2anFmLilERW1nbl9KcTN3cXwmVm1Obj9hOUxjRkpgK3NkZnQqSWR2MjVEKHRIYltUbXhjfFIpXihOaysjIEhpZVFnazFCcXhARGhNTiFNR0JeZUVxWCR3RXgwTEdBdkkzLE9RJUJuJlgidSJCIUsieSwieTU2InEicT8iSl8hIkk5XXkiNSIiTiJlbF4iQUU7cCtvQTd2XzhhN08iTjJweSJkcDhtPSIhN2QiO288OUdfZjlvWU9CM2ciUnBzIigqNSJOekcpUzVSJHw1b1JlaEplWjEiYFFBIiZdYVVSI2plOkJ5cVgjbSxLX24iLT4iYSIiWFg5InN9NCJod2BPYVg/WyJqTSMibDZKXTg3QyJIeTwiK21vOUpwY0giIigpYiJYaSI1cl0raSxHOCs6ZD0idWFuIjUiWT0/e0kibUZIImA8IkIhbEwsSVlaTyIpe11aeiI0Iik7dnA3YF1iKk4mZVoiLCZjInAycCI0IiV3VG8ifSJ4ayYiMkl+b2gkJCJ1I1huYXIwLEB8I0JpeSRqKSJeImBhLSI2WT47SHxLNnsqdGttWyIuYXk3IkBCWSJaUTIoIiA6KSlhRlVhOlVdNSIkPS4mIkhpPS4+WFNvInclUSJjWiYje0c8QSIjVV8iIWoocXlZIyJGU2FWIn4wSCIqIFIiWCIiPCM6In1gaCI3IiJLIjQ0IiQ5SkR8Im1CJSJ2RVJZeXFnITRdOGJgUkRGY0NqLyhjOVp9M3cgMVIiR2g8Ik4iIlYiUX5tIiAiQEZxeD0kSjd+TXVwXnwqUHxlKWB9WHEqJHxKaHFTYngzRXQhO09fUFZ5RDsxUWRCdU8mZzVmfUM0OWQ5MitBT3peSXBkY3B3RHxBQzxVRyFRQGJRVmwqX0NuYUM/QmZpY314ZkRUX0NITX0pKlR5WCx0VjpwRSIsKT95Int2M0s3P3syIiE/RSJGIkBoNXFSIj15biIhTXEiXjsoKy1bWkRaIls0Ik9RTUUqPzx7Rj99dlFQLnRJIFJ8YkttJWYiZSJLe2kiMC02IFcieU42IikiRVtALWxucTBjaH45IiJuInJDNSJVX2xFPUozc0R+XzZ8cj5wImF2RSJQZXUwU31HNlhLaHMiRDg0RXROOTMpPSs2eShgSXIiJCItNSQidiIiciJ+YSQiYyIoRzxveWwlKiJxLFkiVyo9IiY5ZlM6ImlYTiI4IiJ6Ii1HQCJgImxrLXoyfm09aXx0QVZOMCl9dlphODRdMjIxaTc2cS4zUFp4bytycUBufXtXKXhZZ05fSksjfkosOzx0SlY3V1goL09abFJeOXgpKnY0L3x7bCp9LnVmO3J5OCVTXUZteENQdyxFSkclaHska0lELj82SUFSTkMhaW4tZ0hYYSolX2w4SHJ1I2dXY3daREE3UEhpbCNkc11BWW9POUBNIDxqJVhvOzFTQChSY0MmOzBLTnN5MDw8fWMmUjwsMkljNWUxY3haTnFaV2k6N3IlIEBCa3lDNk5BeFN0c1p3NlgoVnxWLFNpLnZ4OWhhSF1nNDhmejo6Vjs+bjstIUdWN1U+d14vVXkxKCZUJCB3LUddJT9iO0JiTUdyQUtGcjRnLi5KSW5Ncjo6OWc5PzJXYztRfVJ0KztFR3tdXWIpRSBiSTFzRj5VIXkxbkNSRGx1W29bflduKzYzc0ZlbzVhRXVtWEV6akJ0cn5iSkRMIzV+NXhEJTlnc31lN1VaOFpdPi50aVEwZUFYbkY5PU11OHBML1pJbTg3UjUlRUkvWl46P34jbVdDdSEzNWk0Q2s6eV08dFsoWm92b2ogR29MRTs7KSx2b00zTGpgUmcpUih2TEt2byxqJEE+LlFiVTg3dS18M3sqakttNyZvOFM+b1s/KXRqNnk/V01RfEIgb2RoeG0kcCFaTmtLQURoJW5COHQkZlM5djtpZFczU1M5RzlJVmxla2BKb1dKS3ZKKGR4V11BQyBzNmhhZT5lbU9qbCYwT0dNRTp3UlBWNkpJKzFyJHN6a019TmRZTm97YyEhS0pxezcmLXA7SFYwW1k6RkRRN1A0M1ZARF87cSBiNCxoaj5FblZlQS8wTCxfZ0BUTltUdWBeNnx9RyBnY2guRXEhUVcpJjB1ZG8talFNOk9Rem4pJCRbQVkhaUxiVnVCZC1PdDxAVUI4RmZNOTc0RlVwJTQrMnxjIUg7fTREXjJZJl55RVNsVEB4MiNqd2oxNlhzMjU+JHNCZ1hOandJW01tUSRCU3BrXjRUSD5LTXgtSWUsKjwyLFEkfmYgQnREKllFYDxPb2ZwOWdUXW93TmAqPG9uNSkxWyEgJUdfQG9aKHxEfU5iaGBDaW5sKUFdelchPmN8am5NIzYyVHJZJm9RRSBhfUdZWjN2dHApSiVHJkJzJldRWjBzKiNRKG43Nm9yQTVTKzc4K1JlaDZWMlQ5WDlWeDA5dVZzfVEhZFE8LHJfSSZTWXhVSUhgNFIlWEJqVHM8TmVAN0NbQWZeQDl9NW1sKyArSDwjLTlyOiZRQ3laKFVqeXhmIDN1U0I1PyYmbm1LNEhrUk5oeUl7Zkcrd1claiQ0JHY7ZUIoI2skcilmeU0wUCRvay0/JVBKen1dXS9kIUM9MWAqaEBTSlJWb2RWQi9UISkpR2dLfXNZYz0odlJ6RkBAZS8gdnpyLyFBPVQuJlp8JCxVemc+RngrbW5HPW80OztpOjJ8NDFKUWh4KXBeQ3N7JVIoZVFRQ0dISCRqRXN6N2hAMygxSm0gQjhUUD5wVmUgQnRmZGxfZVJhP0ZvU15mTjEydE1WbCBJWX55dlEsQE0vamhXXl54ZnF0cztzMEoyeXx3KkFpL1dsLS5Adl1xLXtOS0JSV3lvKHp+TkNVfWk+TmAgNXEvVWBAQlI5LElbSXksI0hKX2oqeiRvU30zJnQrMVp7SmtLcTpIXT9BZHZeVF1kbTFHXn5+MGFjelQ5PU9XLE4tUj9UNjBbRz1zMy1ve3lRWzE9V2dxalopWVNFZ3FQKmIyYjdjJEFBRG1FMCs2T3chWW00R2tdXXRLREl1Lm80L1VFYFJrMy0uWT87L09VKzsgNm99ODIzbjdMUm8qckI5IWI8cUBic21WLyksUGc3WjtbLktnZn1IJSU4aDJ8YEl+d007XT0/TyVyeHlMWjddQVpHXjcvPSlnfXVbfHc/SCEjaVh+V2Z1YD9XWi5TK1tAd1VpN1ZgSzVPWjFmVjw+NCxrajRudjwxdXg8YTN2STdkTmpUVCNrRmkyXjk2LX1ldGFiQXQxUjovSGNFaksufFlBclZhdW5dLk4yc2VWXlVmVVMmJC5nTk9rLFg4JGpaOC9aQ1h2eHI1VEgkMHs5OkctOiBfNlhTQXgqeklKLCN3YD53TGx0ajRfTUtORFNXXW91Z1J9UFNMcEYzblFTTzg3dWIgTFNfKmdYRVBMaXA1LjsyJFsrRz9sNCNmZ2FoW1FCLVsoND93QlNDUlgkfTpIZVdbN2ZyI1cpfW9oaWRvcV5YIVVieko7NS9HViErYFQoeSFTNERZRHdwR2ZUbGl9a2dJIy05N21ybC5JcilQaXYpIW1WcTBjR046RVlhY21qalVBSm5QLj1IaShgaEpXISk/JWQjRyl9e3IvLlJTaWB6WTNdfWJOc29DWDFPNVZ1dywlc0FVSTs/P15vJTRSVl5UO2IuIGF4M1gpaDFvLGpzJXd8PGFNTldfLzFZYiYyTTYuVCN8fDtHekQxVTxmPVNwb2QwWV9Ia3c0Vik7W2x6bmNLbmp8QVB7WD93XypmelBNTXRfTlBjdkFeOF0pKFA9RylkW1Z+RC5QTCpxQjBKcn0yYzI1NFdsR2ZDZT5PaXN3Uy8+RnVALGFJMXtXPXFEO1IsbW0kS2QzYUJ1SWgtK0F1ZXV9TnxlTj56JltNbFdbfGZFUlElPyxSPGVIXTI8TTl5NzwtT0k1KHdxUUZ9Y28pe1JoeFdtZjEhQjxlP0RbPjZMY0kodW1rWF9LRnZbbTYjdDNLekouYU04eVAlO2NEO2MlVklDLDg0NjAqXUJyJSNwQFY8bVgrN15ZOGojQERAYXd4X1NMW05gVGk/OV0hKXZDXj5nd1FQKSpkSGU9LS9mKW5ZVVRrdjEtPHZxL2NjbTNPOXx+bGVaSzJ+Om14YkVxZVlkYygoPUdGNjRlPUg9fUhBIm4iQEFAIjlfO0NPLT1JMiIwZ24iWGdSPWxGKiRab25TZTpYTWQvMlpORUdAYWooKytFZlE1R0ROIGRMNXQ0P1s2IUhGVDQ+ZyJ5IlkrRCIlIlRySktwan5jPk51SzYyfjlAUVBYT18yezBSM3UoMkxnQlQ1QGNtfmJTIikiLjIkInAsIEcpImhUfjciMzlMQ1tGMFopTWNwVVJoMXhgcWhzKj8iXk53Im4iIjwiLThkIjYiPEx9OSYkfG0hfHBaWiUhLXQuOUBfN1UhcjVPcTRpI1U2S2RqLTV9SSFURmlWWjhoMFhWRHRjP2RWWXwzejotImAiUmwsImIyTFpEImN9VSEiMTxOTDsiOC9QIl49ZVN0THs/Inl+IlM5IyI3PiBEImYiO25vdDM8RUVURWR7ZkY0L3B3YV1oP0FZK1Fub2d7KWY6Tn4scS55UVlRLT0icSIjIEUiTFpDKjRJYSBsfiIkaSwiMT9zS3d+Im5lSkQiYjgsOz5QYEYhSmM+TyhpQSJeeVtTIisiIkAiKDtiIjc0dkwoPEdjVExocVR7VS1zIitaIngmdnMkTC5fJCYxMEZFSCltOFhFOl1uZV1fMipiaEc0UXFeWiItJGAiTmNLIiMiIkBBNSJxNkwiMypnPkFPImJ4QkUiaiJWSlkiKyguIiFkYyJ5Ijt2My87ImRoQyJwZChJbyJQIjtVQTtZVSogKUd0THB7RWg3a2FaYW5lZHQ1Lix3OE5Hfjp+TkkkK0g0SzN8OWsiOnddIkNCOyJvWUNmQkgiIFVPUV93QiI/ImMiRzlgIm9mdyJDIj4iM1Q3IlUrPyJkIiI5Ikt1PSJBUFhpPXcxQSJTPjYifjJ1MXQiTnsiLXBXZ2UtR28qY3YjMz8ia3dFdSI2czR8XWMjInpYRWIjZ1NpeTVfKlUiSSJkd2YiQU5FKzcvQUs7WnZ6LDgsTmtgUG55R2ZeSjVBeDdSW1UlSzErKjFXbjE7ZmUoamAzXVNNb3FHc1gjXjJtIEEpWzdaWSAiIk4iKSNTIkoiakdobzxGUUNkInNOdyI9IiJfIj0wQiI0TGhHWSA2QyIrbmIibiIiKCIlVlYiMkx4YHBAIm5oImpFYDpJJjUiQTV1IjkiXiJVQikiSiZhIiwoLEAkRWEiVVZ7YyZqcVJITypoLy1jKixRPCw5aVR2Wl0hXlBRRzJLQCJF',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUUJTamRGd2N3cE4rVUFRQUFXMVJXNmhwQ05lV0dxYWdBVU5FNTN5Y0ZDQUtYSGN3ZVhZOVMwS0RPUWdqNFJiWVBheS9PUjlxdEFvUHNRSjUyOE5xOXBNTnNxR3VMOTFVZytSQVhpbFFINlBmcEFhVlpJZEV5K1QwUTVad2JSVGFWUTJ2MUFUcEtkd1o3SitlYzkzYnlyWE43TFIvWXAxRXE4YVdnZ0NwdGZyU1VoT281c0dpeC9UQUluOTJBUzBtdGZLc1BZMnQ3MlZmMndabWZ0K1BWVnRnV05HOWd3RzBIbTdNQVN5T0Z2Mm5aYUp3SlZJd0JHQktYdzZaTkcyemR2NmQ3T1huMitrR1FhWUxtUjJtYkgvM0kyai9EMjcxKzkzTXRyUHExbEdPUjV5d0kwdHgrRGFaUHB2eTZreTBRQmxsUkw3Yk9iQTlwNldDdTBkTXhJR0hvWTQ4K1ZrRmJlbXR1cldsc1RDWEZ+NDQwNDI3OX4zMTYwMzc3&&&sensor_data=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',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUUJTamRGd2N3cE4rVUFRQUFXMVJXNmhwQ05lV0dxYWdBVU5FNTN5Y0ZDQUtYSGN3ZVhZOVMwS0RPUWdqNFJiWVBheS9PUjlxdEFvUHNRSjUyOE5xOXBNTnNxR3VMOTFVZytSQVhpbFFINlBmcEFhVlpJZEV5K1QwUTVad2JSVGFWUTJ2MUFUcEtkd1o3SitlYzkzYnlyWE43TFIvWXAxRXE4YVdnZ0NwdGZyU1VoT281c0dpeC9UQUluOTJBUzBtdGZLc1BZMnQ3MlZmMndabWZ0K1BWVnRnV05HOWd3RzBIbTdNQVN5T0Z2Mm5aYUp3SlZJd0JHQktYdzZaTkcyemR2NmQ3T1huMitrR1FhWUxtUjJtYkgvM0kyai9EMjcxKzkzTXRyUHExbEdPUjV5d0kwdHgrRGFaUHB2eTZreTBRQmxsUkw3Yk9iQTlwNldDdTBkTXhJR0hvWTQ4K1ZrRmJlbXR1cldsc1RDWEZ+NDQwNDI3OX4zMTYwMzc3&&&sensor_data=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',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUUJTamRGd2N3cE4rVUFRQUFXMVJXNmhwQ05lV0dxYWdBVU5FNTN5Y0ZDQUtYSGN3ZVhZOVMwS0RPUWdqNFJiWVBheS9PUjlxdEFvUHNRSjUyOE5xOXBNTnNxR3VMOTFVZytSQVhpbFFINlBmcEFhVlpJZEV5K1QwUTVad2JSVGFWUTJ2MUFUcEtkd1o3SitlYzkzYnlyWE43TFIvWXAxRXE4YVdnZ0NwdGZyU1VoT281c0dpeC9UQUluOTJBUzBtdGZLc1BZMnQ3MlZmMndabWZ0K1BWVnRnV05HOWd3RzBIbTdNQVN5T0Z2Mm5aYUp3SlZJd0JHQktYdzZaTkcyemR2NmQ3T1huMitrR1FhWUxtUjJtYkgvM0kyai9EMjcxKzkzTXRyUHExbEdPUjV5d0kwdHgrRGFaUHB2eTZreTBRQmxsUkw3Yk9iQTlwNldDdTBkTXhJR0hvWTQ4K1ZrRmJlbXR1cldsc1RDWEZ+NDQwNDI3OX4zMTYwMzc3&&&sensor_data=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',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUUJTamRGd2N3cE4rVUFRQUFXMVJXNmhwQ05lV0dxYWdBVU5FNTN5Y0ZDQUtYSGN3ZVhZOVMwS0RPUWdqNFJiWVBheS9PUjlxdEFvUHNRSjUyOE5xOXBNTnNxR3VMOTFVZytSQVhpbFFINlBmcEFhVlpJZEV5K1QwUTVad2JSVGFWUTJ2MUFUcEtkd1o3SitlYzkzYnlyWE43TFIvWXAxRXE4YVdnZ0NwdGZyU1VoT281c0dpeC9UQUluOTJBUzBtdGZLc1BZMnQ3MlZmMndabWZ0K1BWVnRnV05HOWd3RzBIbTdNQVN5T0Z2Mm5aYUp3SlZJd0JHQktYdzZaTkcyemR2NmQ3T1huMitrR1FhWUxtUjJtYkgvM0kyai9EMjcxKzkzTXRyUHExbEdPUjV5d0kwdHgrRGFaUHB2eTZreTBRQmxsUkw3Yk9iQTlwNldDdTBkTXhJR0hvWTQ4K1ZrRmJlbXR1cldsc1RDWEZ+NDQwNDI3OX4zMTYwMzc3&&&sensor_data=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',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUUJTamRGd2N3cE4rVUFRQUFXMVJXNmhwQ05lV0dxYWdBVU5FNTN5Y0ZDQUtYSGN3ZVhZOVMwS0RPUWdqNFJiWVBheS9PUjlxdEFvUHNRSjUyOE5xOXBNTnNxR3VMOTFVZytSQVhpbFFINlBmcEFhVlpJZEV5K1QwUTVad2JSVGFWUTJ2MUFUcEtkd1o3SitlYzkzYnlyWE43TFIvWXAxRXE4YVdnZ0NwdGZyU1VoT281c0dpeC9UQUluOTJBUzBtdGZLc1BZMnQ3MlZmMndabWZ0K1BWVnRnV05HOWd3RzBIbTdNQVN5T0Z2Mm5aYUp3SlZJd0JHQktYdzZaTkcyemR2NmQ3T1huMitrR1FhWUxtUjJtYkgvM0kyai9EMjcxKzkzTXRyUHExbEdPUjV5d0kwdHgrRGFaUHB2eTZreTBRQmxsUkw3Yk9iQTlwNldDdTBkTXhJR0hvWTQ4K1ZrRmJlbXR1cldsc1RDWEZ+NDQwNDI3OX4zMTYwMzc3&&&sensor_data=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',
    'a=&&&e=QTZGODQ0QkM0MjNFRDQ3REY5Q0U4NTgzODc3NzkzRUR+WUFBUXhhTVFBbWR0TExLVUFRQUFMWG50NmhyTUVwOTZVRTAzYTh5bFpjTVJVUFpvNUxqcWlWU0NaaFN6SVBQMjh6c21ualQ5T3BFVFZLMFMzektRZ0JMdWJZR0hwdVVZT09WNzFOdTV3aEZick1rTXFmMHA0TGluOCtZMEU2VkFsMWNzOEZuUzY1QnlWTFphK0xjSVBTRmUzaVhYSE9mSjVGRUh5Mi9KTDF1TFBuM0gzSTFCM2ZrdXdGa0xhQ1dNNW1pck9vZk9pQnMxSmp6TGdhQjUyenk4UlNoYVRqLzJMK093aE96VS9qRXVYT3FaT3RmakR3S2FicmRuVmZVR2o1a3BJWlpYemd4VG5FY2ZuVHcwTitoK3k5VGdjY3dnYm8xSkFJbWtqRkdBNkQ3eGNYYXN2dExFc2pJYTVYNmFDczFCYmI4VVQ0WWhnV3EwM0ZvR0FUZmdOVGVkTDhWUVB3d0NLU3pReS9tOW5zMGplZkRTbnREUjBJNGhYZlJHa2xORWdqeWpSZlg5Q1hZS3ZVL2IyUGg5amJka2l6SWNiUT09fjQ0MDQyNzl+MzE2MDM3Nw==&&&sensor_data=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',
    'a=&&&e=cGxoc0IzdzRJNCsyNjQ4WlFMdS9Pb0NlcHJLaWFpRGxpQ3FrcER3Mis4UXRyb003b2hVSTl4d1BYUStPM3hYZ0RjRzlPSkx3NE1kaG52Mnd6QlZiZjUrQk9hUml1WmFLV0s2N051YWw2WGNuR0RoZFhYL3R2WDcwUkFHZE9kUjJENVh2RTRvWUdPeVp4TmluY0NjYUo4a0JNNFNzTVp2M05kZ2J5TmdTZEpleFNzdU9nS0srMDAvU3lENG8rbGs2b0U=&&&sensor_data=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',
    'a=&&&e=RjE1RDk3QzA1QjU5ODlEQzk4NjIyNDE5RjcyNEYwNzJ+WUFBUXhhTVFBa1VDU0xLVUFRQUFtS1NXNnhwWlJjRUh5RmQ3QWNEUGVNbFNJRU82MUFkb3BtWkVtaVdnQjM2SWh5SWUvOEJMNmF5SmlTRE9zVytiNFFxSXFUMnVOVTJHV2ZEK0c0RmprN2NHV1FaUDV2MVVlMUJaTTdPUExlWmc2cVZHZ3hoNE56bXp5V3BPYWp3ZW5wYWJxdnFia2V5cnlhbU5pVmFscmJwOXdpQU1VUDJKd0Y5NlZVcGpiRUpjbTgxaXNEZ3ByUlRSMTU2bjhCOXBmMEtNeU8zSkZSRS82d0I5UUZNcVJNVGZJaHd5MEQwSWNadmcycjZHeC9sbGFQL0ZiRGpjdkpveTk1RDAxV3BzQVhmbjVFaVJRZ0dVMmlZNUZsemI4dWM0eGE4Tm00MkVIYVJVWUZjcUpHVnlUYlcvTm9WcHlNY0JrSWFhNU5hTzducnp0MjhuOGN2bXJTOFMyYWxCRnpxV01hNXF+MzU1MjMyNX4zNDkxMzc3&&&sensor_data=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',
    'a=&&&e=RjE1RDk3QzA1QjU5ODlEQzk4NjIyNDE5RjcyNEYwNzJ+WUFBUXhhTVFBa1VDU0xLVUFRQUFtS1NXNnhwWlJjRUh5RmQ3QWNEUGVNbFNJRU82MUFkb3BtWkVtaVdnQjM2SWh5SWUvOEJMNmF5SmlTRE9zVytiNFFxSXFUMnVOVTJHV2ZEK0c0RmprN2NHV1FaUDV2MVVlMUJaTTdPUExlWmc2cVZHZ3hoNE56bXp5V3BPYWp3ZW5wYWJxdnFia2V5cnlhbU5pVmFscmJwOXdpQU1VUDJKd0Y5NlZVcGpiRUpjbTgxaXNEZ3ByUlRSMTU2bjhCOXBmMEtNeU8zSkZSRS82d0I5UUZNcVJNVGZJaHd5MEQwSWNadmcycjZHeC9sbGFQL0ZiRGpjdkpveTk1RDAxV3BzQVhmbjVFaVJRZ0dVMmlZNUZsemI4dWM0eGE4Tm00MkVIYVJVWUZjcUpHVnlUYlcvTm9WcHlNY0JrSWFhNU5hTzducnp0MjhuOGN2bXJTOFMyYWxCRnpxV01hNXF+MzU1MjMyNX4zNDkxMzc3&&&sensor_data=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',
    'a=&&&e=RjE1RDk3QzA1QjU5ODlEQzk4NjIyNDE5RjcyNEYwNzJ+WUFBUXhhTVFBaEVzUzdLVUFRQUE1ZFNqNnhvYWVyQlVLK3ErWFU5dWFZUk9GQVNibUhRS1NRaGk4NUtVUWx4NDZzWXdzNWFIVStYNVBraG1zWEZxdEQxS1lGUjVuUTU5NC8yR2Z6aHJLRXRYSC9ITytrRjlySXd3Y2hhUE1MMnlEMUJERzZ4VGZuYWNqSms3TTU3ODliNHVtTlorTVV5NWQxdWdZVFpJTUMvNHhBdWFSN2hWSGV2R3VHUXVXWm80bTB2NGc3L3NZcW1RVlVIbzNuRjRDY04vUXloUFdBNnZlbXpHalJLejcvUndCTis5L1FLZWJmcFVRdjZKYTZIV3lEZnBkaDFZcXcyeUZoTit4TjUvZmNiclJ4USsrclhpTWpJTjZ6ck4zbDdyZE5IRUgxR2lJUTEwVGV6cGJReVNVWGxMM0NoWHdvZjZGRG9GbTRVMWpmQVgzZVdFQ2FWUWlHMitwc1VZMzM1TjJDKzhaekIwMmhTdkZ4UnIrdHBzYld0ZGpwcGpNQlpLNEdSM3ZXT0p+MzU1MjMyNX4zNDkxMzc3&&&sensor_data=MzsxOzI7MDszNTUyMzI1O2RmNmF5QzZZOEFWRW11MCtodW1tTW5RdWNjTm1SRkxHUEp3WXF2UXRFclk9OzMxLDIsMCwwLDMsMTA1O2siNC9kIlhWXj5Nb0Y8MUxVI1YoIiFPIlkiaW08XiJBIjNmfiIzWVVwYWVyXUUiUXZSZCQiRmotXXEiaCQiLHg0SHJ2XV0iOUdMIkxubVp8OUxoTyZkIno/TiIvYS51cjdwInh0PGkhPypnPHEjdVJBXT0zUXdwVCBgbGZiPXNKbDBZaUcyIipLR1k2Xy0yYCp+W14wIEAtfXF5Z1s6UU19PHRJIVU3UiAsQi9teytwRCxuZ218Z1cyMlg1L2IkLVVGMU48XUtPU14kVG4/Xkh3eVohaTJLRiNJWXotdjQmZyoiSzczIkpyJks6c0BTImBlVyJyQEwibGFxImNGYHBdKyhaQWl3WzE+QTVZejJpQjVkImVpYmxLNlUyIHVBXjhrIjtCdyIreTYiez4oIjdsLSJYSVctNC5HZC86ICJkTTEiLiIiVng2ImA2ImosbWhkIl5zLSgiViJsOExJdkMra3Jjc1ZbLyFFJTYwd0I1KTpCXm8pLj87M109WEo3V0k/PCU4KztzeDpsIzhtPUZBR10wNmVjcG1xWDBGTCxmYkFSQ1pUYlFLJWFhKVlFRUtnbjZWcyZMR0k+dzRTLk1ZSlZieG4gdHhPMUldTjdLRWl9PmErR3hpIFdIbXlnQk07ZWF4MT4rP3FdIz42bSktTXQ/XzhiJDhONHlCWVE5O0BJWnshQDhLLSVKZmxWZmo6W0NqRlIrN0xBNWkgJmwgIzdKciA9RGhEPVsvL2syPSFANVAxZyg/YWFGfUpHM0RLditaaTk6ZlNLIUhAN2JrT31lOnxFKjtiTlMyYWpUdCJIIms1TiJdQEN5TUZUZTNbImNTNyJ4KVI1KkEia3QoOiJ6ZXEiTF91InEiXyxXIGkiRzJrIiU5Ik5MLEBNQ3RaIEkqSTA5Yi1PKXEgVCtJPG1lVEkrZlRQY2JFOVNkMFgzVEYiNWYqIjNpViJIIn14ZV1OZSI0IjFOUCJzeikiXTNPS2wiYjFPImxUY1JHRDV+em9lV0gqZyQ1JXt2OmQiZjY2InIieX0+NSlIZUUiamRZIk4/PyIpIiJHIkVOLCJ8InxXe2lkUFh4SX5LLjhCT1MyRS46Ul1rTT44RSFBbGtBSSlCWmUrI0Zob3RPInwiYmw1IlEzK055bm0yeCFUXkFeUkUgci9mWF0hbi8rKHtHTyUpL3l0QnQlJVp7Z0c/MjJ7KmpVJFJZYjdoXUtmXyo1KTA9QWkibCJuRmEiO0YsIlgiIiUibCwsInMiImN0MSJRWSYiOXFNV08mTH1ebGpyV3FKIm9SZiJ3Iis7T2ZfbC4+PDo5QzBCNjBSIiw+T1UiOyJ6WyJIaD8iK3w8XSJ3P0t1cCpvUnMydEVURGJsJiU1Oj4jZnZALmgje11pRWc7XXksOn0hKk0/LTEiPCJOTXkiTCIiOSIyfTEiP0smWzBBencie10gInFdaWAwNV5aJiAia2B7TCJkIikidGAkInlMXSI6OkguaiJVIFciQ0theSAiWipGIn07SCU4OFkiZStTIj8vaD8scWxNImg6YSJsdWwiIUdaIlEiRW5aKHhQMEckKn5OMTIpSGIiUCI6TnQiUlIyZXh1M2Q7IlgofSJoLEZPUSJZYm4ibkFYIEl6aiIoJWtNW2k4V08rfFpUIiAia20lImwiIj4iekU6Imd6RVVWLyAqImouLCIuZFVGfSIqN1A2IlVdOV83bU58bDBiayBXS2AiUW5eInhgXjUxXVNGbmduUmtIOWYrMUo5NVFVYV5vdSZqR0g2cjtGeSYwQE8keWsrPm0iXSJzQUMidX09aWlRa0Q3KyJyZkoiQ3pmK1JHLVZtInViVj8iSW5ddkc3LkN6WyJJM1hBIigiIlMiN3wlIjkiIj5jKSR5PD9MIm9rQWkicHF0eSs7Ijd5Ing9QTJ2NS0iPjRTW2AiaT9aImo/WiJ5KSlTUG9gfV4iLFQiQiJiZE5TTUJBOjRQRC9dQjtPUHFmdVJbKCx7P3pvOV5XSVp9QWw7dEIlQ2p6dV04WFsiR3JuIlByeSJoIiIsIil0SCJfImp5IzApIV8+RmtaRj1Ma3lbZTFDa28oX09dLmZMP0ljW3V6MS59bFtvNG5neSpDZTlaLUpkeCN4Xy1FKHUgJiY/Z3Aoey11VH5LPiMzRnM+YjF8PGRtfmxgL11SNzxDY343RXN0fmtNe0A/QU1lMWc4c0xqSlEkb2EwUU9AXWN6QW8rP0toT153RUJAWnhXJVc6c0t7NV1fWDBjX1Z0aUlOKk96eT82LWUyPD5gcmg0fFo+c0NpNDpFfkhMTGZ7TmdTZzVNdWZ0QXkkL1Z3WUUlYVYydTNmdHdYLD8xVWtMbV19Qm80NCx+XmZ3QGpUNypnWUAsSC46RCppdyZIZUhpVHNhckpRWUUsQUB+U0IyI2xUOjVuQUlwT0FNTXdFKVlHbF99TFF4WENpblUrJldiU1dFL2U7Y3JmVG8lTy1mOyltTCRgW3hkU24/eVVIOEg7SXwwW0htfCBgKTx1UDxsX0Q8YkFddnJnK0cmdHFnbGYgXXVSQlZ9dG9EVzlaYjg4eHJFKURmYlgrTEcqLyMqNkM+SzQqR3R8by5XRnt8ZFs2OGxgLFlQUSFMRiw/OEpZb2p3X0spW1dsL2A+fHZzd2dkOjhVIyY7aEREI0c4XVsgfDo1KlcpOUJ+Rz8qd3sgem5aUSlfY3NFeHd7LzlrZTo/TUdKK1l9fmEkem95dCBwIHNqPnk1PXdnZmh5Jk5vM0lpT2M7ITJRMmlxTmVQbWojfXRULU1lTyM5MVlyPlN9Lk1ZbE81S2pSLiUxP0JkWW5paU0/V3JoRWJYNz99NXEtTVBoSUFmJmpTTllvfDlMVl5wTT9TdG1XfC1JYUhsS1dAQGBYQW8hcl15czxIY3U5RERAJlV7bWl4K2UldDlvPHkrRDYzXiYjbSYgUF0wQ25pfnl2PmFwX31CdUogTjteR1ggaHxGe29wIzlgbE1fLDdbVlB3TVtQciZ4PjpmTHpje0dNSitSU1t7LU0gWHhLWHFyeEMrOzliI3NALVtfOXxFaWx2WTI4O151QntReklrNy86dFJVZDpvUi0lWFo7e0p7KjwjZGllQVI4a0d5TndBPUg5dC9GbDswc2NWWzMqRzk7TzopNUB5N3s4KlFEYTVITUUwP1RBbGlGPy9HJHE8JTtjTTFSWj1YQXZqRipDIz5ZQjVHcFEqLGx0a3JaVil9NFhMO113InkidnxLIkJ1JXx6aVp7IiQzeyJueWwieVsuT0A7X2FTfCI2Mnx1IlYiLSkhTSJaIipyOiJpXWVMSVYufCIpUz4iOXRsKjA4ejM2MUM8XUt3L3VlIiB2KnhFaFF2aT1uMG1tSCtRUCtndHEhJENLNS09SkJLaWZMKytoMkNYYjR7WDROVEpaOFpqL0hFdU9RTWNpKyIkInh5dyJkaW8jVSQiMj47Si4iRDJVImxPMyZOInciImN8OSJ8aEAiPSIiQCIyfEcieFVSL3l1Q3kiTlAiW3opZFoiKiZsUiJSNXdUZGMiJHYoJndsVyJOIk9zYjFbRjwjIVlqNmdGazF5Inoie3tGIjEhIHJQIi97ZyJKQXoiaTx0QSIxd2MwUEouOkFJWngiMTpILyJ+NixsKisxIiJHIiRrLCJbTWlqIFh5SyJsPyJqei4ian5LZCI8IiJFIkN2TyJqJSBlOF4vIiI6IlMwIkQiIkciVTE9IjEiIj4iTzNyIjJGSy8mX1VWXSNZJSIiOyJKVlQi',
    # ------
    'a=&&&e=OUY5QTAzQkQ4Mzg3REI2NUY0QTU2RDk0QjA1MjIzMTF+WUFBUXhhTVFBdTJSODdLVUFRQUF3SUx1N3hvUUcvb0JQMzVqYjAyM0xkQm1qenhla25CcTFCdG94K1FHY2paOEkwNW5aYmR3NVVaV2JwdE9sWWN1RVRscjEvT0RPK3RITHMzbEw5MnNpV2tqMFBZaStqdmNrU09KV2dtZDg4VWhQTzZxSXdPVmd0c200WUVIUFNhNWJvQTVWbUJjRFovMEROSVV3dUJ4MnRhYnVmT3htdUdEZ29lWUhnYmxrWStvSk1ZT1JEZ0Z4REtpSXRRbitKMGt2UHdWOEtMTjdZZ0hlSVo4ZHpjWVdyOTJpeVpsSW90VTFhMG1qbGZydVZVTXJiTEY2WGxWc3E5V2lwMzUrNFllWjMyYWY5QlFrRkV6OWpBZnBrYVU2bk8yVHJXT1FIaXNtdXBJLzJsUE5pcy9GdFBrTGpjTlFSdkdJVG9QT2plMFV6VXhBMjNmK1hscEgzNnRLWWpkSElibytmYjJwL0hvellJQTEwaFdIWWp1MjhrdkcyTHF4aVNxS29ZPX4zNDg3MjgyfjM0ODY3NzU=&&&sensor_data=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',
    'a=&&&e=OUY5QTAzQkQ4Mzg3REI2NUY0QTU2RDk0QjA1MjIzMTF+WUFBUXhhTVFBaTFCL0xLVUFRQUF4L3NCOEJwY0ZHMS9MNHUwQ1NQekRxSW0zZ0I4dG1hSzB4Vm9pcVVkeGRWSUR2anA2ZHJzTDBIZDhhK2l2VHNHUGc2U05qUC9jL2xBRVhvYm5CQ1hXTW9Ncml0TnpnbnNpMERMMkdmZVR1SkVYTko0T0ZZa0Z1TUQ5Y3JiNm1BZ0RITSt4RVNoNGhha0Y2bTF4aDRhTFhuSHRRbGJabmRpVy9vVmMwemVCTVRQYzFNcURWWVdIbVlyOXlTODR4TW15enhZMlNSZ0xZbndTZHl3ZXc3Sk9WNjloSTJ2Z05pemozd2VCeGNlM3FzYk1NeDU3NzBtT1g5Q21wbXhKQnZYZGVjbXpZS2t1V21xamZWQ3d5R2RJdExXL2VGMVZuc3RoUUxNajFVOVVRUXRNakxRbFQ2L1d0eXMzRWx2aUc5T3loWTFJWHpnZEdDTEVOUkl3MXFiTGRvdHphMVpzMVlsYmI5R0VFYnVkWnBpWGo3VjMxWmwvbzBXc0kyM05XMERpeUdKYXRndVNXN3N1dmNjWWhnZ1htU1hFdz09fjM0ODcyODJ+MzQ4Njc3NQ==&&&sensor_data=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',
    'a=&&&e=OUY5QTAzQkQ4Mzg3REI2NUY0QTU2RDk0QjA1MjIzMTF+WUFBUXlhTVFBb2xYYmVHVUFRQUFNeWdVOEJwSTR4dmhrWVMrTEY1NFVYYUFPNkJnZU1WTHlWVkg3OG1DQVNWajRvSkw5USswSzR1UzFiUDRPODZ1ZlZvUkFzMFJCcGNBaTgwZjh6N2pnK0M2VitrdEhoUzZ3YnRobWFSMDR5TU9BT01iQVVuRGZCK2dRTk81SEJibVhwZUpZZGYzdFZhWFZzTXB5NnpCdWp1bDhXQzhtQVMwT0JJU3JLallmQU5Ra3lydTlGdW05SFJrMENqNHRibjM1NTFIYnk1cEdPYS9MMTFVcWY4bVUrQUM5bjdUT2FHTVpGbUVIa0NrNkRwSjZqTXVPa3FJZW93QWIzM2tMditnV2FpbDhaZXpySDFoZ3ZYTkR4bHJOcktZQVpXRUNsQk1lZUVpUVdMSXF6dDc3Mis0Ulp5cjc1NG5QdUg4aG1DTjc0WG4veW90NWVKT3lSRHlBK3E1RmgvdWJVY2pLVFg2REIxY3lKYnk5SThUSkg4ZXZUOUJNemxUWms2WWpkbndSRURyWm42ZklzWFM3OU1VNHZlMDF4VDVGZzhuZHpuWnF1S3pXaDExM0xYUkRaSmlRTVVLb29hUGlZckx+MzQ4NzI4Mn4zNDg2Nzc1&&&sensor_data=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',
    'a=&&&e=OUY5QTAzQkQ4Mzg3REI2NUY0QTU2RDk0QjA1MjIzMTF+WUFBUXlhTVFBbnBiYnVHVUFRQUF4NUlXOEJyRVdqaGRjZDhUMkFuV2dUd3hyZDVQdHRaaWE4ZmlOZXE2R0xRMkNEVjRxZDcrQUxkYWFpTzFvRnFxQ05YYzdvd1huYmdsMlV1eGNWT2FIRXpML1RmaER6dXhVVEM4Z0JTSjRaVEgrUmM4aytLYXd4ZmF3dklqRW0zTGREaU4yOElPb1JOd1Y2aTN6UUh2bDVkeTBGd0U1bitENW1kZDBMVTc3NHovSUFhdjRkYWc3TWpkWmNpUmdUb0d4WGo5TEc0WnE5TkVzK3N5aUtqeXVVTTc4TGErYy9YWGxweUJSK2Y5VDVVd2EwTVBIaktEcVNVMDB2QllqTzBVYXlmNlh6Y2ZLUDhmS01HaU9LMmd1U0pZSE5XcGxlQTRKN1lxVlBzQ1RtbWFnNHB0VUZLWWVNMW5ISG5ZeFFKS3hNOG4yN1JSZm5DWUtFeGxJUzFTVFRVNnFkRERWWXprVm5EQ2FoTDVMVXlQY1B3dDlBaWh0cE9rR1RPWFVHeCtSc2hRdzFXaVFKRlBtNTFJMmpNdTRjZXB0MlVUOVMwZmZXSStoaGRHQUQ2b0R2a0R5K3gxUDV2M0J6bS9qZ1IvK2lLMGEzNTh4WE5PNG9jdUN5M3A3eTg9fjM0ODcyODJ+MzQ4Njc3NQ==&&&sensor_data=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',
    'a=&&&e=RkY0MUI2QjM5NTlFOUY5NDdEMEVFQzU2QjU4RjJFNjV+WUFBUXhhTVFBbU1RWHJPVUFRQUE2YnErOEJwaGFYSDM0dS9sbVlDa1pTK3pUTVptcjdLSWIxVFFzY0FJdk5qbzJQWjRnODB4NGRVU29XOUxUNGpPRVZxQjVJaHl6bFBQMFNMcUFNREJ6UjFPUHg3bm56MjFicE8xS0MrcjZudzY4M3orb3M5NjhVYVF5MnBwYjBPdldheExIMHhXeERkKzl0UTVnTWhDSlpXMVE2M1ZWM0lMTWI5VG41bm52MGphTHdnZWJxd3lJVVlFeE5WR0Foai9IOTcrYWJETER5ZEczaFBsRjhFSHVEaHBGWUQ3bGVKUERrbkdQNmFhUlJlb0VqTGxHcXlDZ1BVUytQekhUSnROcHhQWWhEUTI3bTdRVkhDMXBHdmVaVnk3aGhjUXVVZmpmTWtRV21tNmVxOER1UDg0UktGWERvd1pJOHdQNGhmMUZwZ1VKcENJeFg3QWhIbGVBcXBzT3M2Vk9taTFxcTBaaVlESWZJaHlqakdKeHV1SjA5ei9BblhEQXlEVFB0UTBLVVZxbHMrVFhqS1BRMnd5VjJLTm1QZmRMcFk4aE53WVdCVnNnUG5SMHNrZU5iLzRrTXBWa1V0YnljT2NkNGxkM0hYUXNOOE55RjZCcGcwZTVJUC9zY2haWTZwb1ZyMFI3TXk1QXp0aDh2d2txeUZRdGdIMmg3WmdpVFYyRGF3PX40NDA0NTMyfjMxNjI5NDg=&&&sensor_data=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',
    'a=&&&e=RkY0MUI2QjM5NTlFOUY5NDdEMEVFQzU2QjU4RjJFNjV+WUFBUXhhTVFBbU1RWHJPVUFRQUE2YnErOEJwaGFYSDM0dS9sbVlDa1pTK3pUTVptcjdLSWIxVFFzY0FJdk5qbzJQWjRnODB4NGRVU29XOUxUNGpPRVZxQjVJaHl6bFBQMFNMcUFNREJ6UjFPUHg3bm56MjFicE8xS0MrcjZudzY4M3orb3M5NjhVYVF5MnBwYjBPdldheExIMHhXeERkKzl0UTVnTWhDSlpXMVE2M1ZWM0lMTWI5VG41bm52MGphTHdnZWJxd3lJVVlFeE5WR0Foai9IOTcrYWJETER5ZEczaFBsRjhFSHVEaHBGWUQ3bGVKUERrbkdQNmFhUlJlb0VqTGxHcXlDZ1BVUytQekhUSnROcHhQWWhEUTI3bTdRVkhDMXBHdmVaVnk3aGhjUXVVZmpmTWtRV21tNmVxOER1UDg0UktGWERvd1pJOHdQNGhmMUZwZ1VKcENJeFg3QWhIbGVBcXBzT3M2Vk9taTFxcTBaaVlESWZJaHlqakdKeHV1SjA5ei9BblhEQXlEVFB0UTBLVVZxbHMrVFhqS1BRMnd5VjJLTm1QZmRMcFk4aE53WVdCVnNnUG5SMHNrZU5iLzRrTXBWa1V0YnljT2NkNGxkM0hYUXNOOE55RjZCcGcwZTVJUC9zY2haWTZwb1ZyMFI3TXk1QXp0aDh2d2txeUZRdGdIMmg3WmdpVFYyRGF3PX40NDA0NTMyfjMxNjI5NDg=&&&sensor_data=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',
    'a=&&&e=RkY0MUI2QjM5NTlFOUY5NDdEMEVFQzU2QjU4RjJFNjV+WUFBUXhhTVFBbU1RWHJPVUFRQUE2YnErOEJwaGFYSDM0dS9sbVlDa1pTK3pUTVptcjdLSWIxVFFzY0FJdk5qbzJQWjRnODB4NGRVU29XOUxUNGpPRVZxQjVJaHl6bFBQMFNMcUFNREJ6UjFPUHg3bm56MjFicE8xS0MrcjZudzY4M3orb3M5NjhVYVF5MnBwYjBPdldheExIMHhXeERkKzl0UTVnTWhDSlpXMVE2M1ZWM0lMTWI5VG41bm52MGphTHdnZWJxd3lJVVlFeE5WR0Foai9IOTcrYWJETER5ZEczaFBsRjhFSHVEaHBGWUQ3bGVKUERrbkdQNmFhUlJlb0VqTGxHcXlDZ1BVUytQekhUSnROcHhQWWhEUTI3bTdRVkhDMXBHdmVaVnk3aGhjUXVVZmpmTWtRV21tNmVxOER1UDg0UktGWERvd1pJOHdQNGhmMUZwZ1VKcENJeFg3QWhIbGVBcXBzT3M2Vk9taTFxcTBaaVlESWZJaHlqakdKeHV1SjA5ei9BblhEQXlEVFB0UTBLVVZxbHMrVFhqS1BRMnd5VjJLTm1QZmRMcFk4aE53WVdCVnNnUG5SMHNrZU5iLzRrTXBWa1V0YnljT2NkNGxkM0hYUXNOOE55RjZCcGcwZTVJUC9zY2haWTZwb1ZyMFI3TXk1QXp0aDh2d2txeUZRdGdIMmg3WmdpVFYyRGF3PX40NDA0NTMyfjMxNjI5NDg=&&&sensor_data=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',
    'a=&&&e=RkY0MUI2QjM5NTlFOUY5NDdEMEVFQzU2QjU4RjJFNjV+WUFBUXhhTVFBbU1RWHJPVUFRQUE2YnErOEJwaGFYSDM0dS9sbVlDa1pTK3pUTVptcjdLSWIxVFFzY0FJdk5qbzJQWjRnODB4NGRVU29XOUxUNGpPRVZxQjVJaHl6bFBQMFNMcUFNREJ6UjFPUHg3bm56MjFicE8xS0MrcjZudzY4M3orb3M5NjhVYVF5MnBwYjBPdldheExIMHhXeERkKzl0UTVnTWhDSlpXMVE2M1ZWM0lMTWI5VG41bm52MGphTHdnZWJxd3lJVVlFeE5WR0Foai9IOTcrYWJETER5ZEczaFBsRjhFSHVEaHBGWUQ3bGVKUERrbkdQNmFhUlJlb0VqTGxHcXlDZ1BVUytQekhUSnROcHhQWWhEUTI3bTdRVkhDMXBHdmVaVnk3aGhjUXVVZmpmTWtRV21tNmVxOER1UDg0UktGWERvd1pJOHdQNGhmMUZwZ1VKcENJeFg3QWhIbGVBcXBzT3M2Vk9taTFxcTBaaVlESWZJaHlqakdKeHV1SjA5ei9BblhEQXlEVFB0UTBLVVZxbHMrVFhqS1BRMnd5VjJLTm1QZmRMcFk4aE53WVdCVnNnUG5SMHNrZU5iLzRrTXBWa1V0YnljT2NkNGxkM0hYUXNOOE55RjZCcGcwZTVJUC9zY2haWTZwb1ZyMFI3TXk1QXp0aDh2d2txeUZRdGdIMmg3WmdpVFYyRGF3PX40NDA0NTMyfjMxNjI5NDg=&&&sensor_data=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',
]

logger = logging.getLogger(logger_id + '.tm_data')


class _TelemetryFactory():
    def __init__(self):
        self.used_indices = []

    def get_data(self):
        """Return telemetry data.

        Ensure to return different data on each call until the list of data is exhausted, and
        apply some unpredictability as to what data is returned.
        """
        data_len = len(telemetry_data)
        new_idx = int(min(random.random(), 0.999) * data_len)
        while new_idx in self.used_indices:
            new_idx += 1
            if new_idx >= data_len:
                new_idx = 0
        self.used_indices.append(new_idx)
        logger.debug("Using telemetry data at position %s.", new_idx)
        if len(self.used_indices) >= data_len:
            self.used_indices.clear()
        return telemetry_data[new_idx]


telemetry_factory = _TelemetryFactory()