Name: magicolor5440DL

Summary: Cups Drivers for KONICA MINOLTA magicolor 5440 DL
Requires: ghostscript, cups >= 1.1.15
Version: 1.2.1
Release: 1
Source0: %{name}-%{version}.tar.gz
License: GPL
Vendor: KONICA MINOLTA
Packager: KONICA MINOLTA <http://printer.konicaminolta.net>
Group: Applications/Publishing

BuildRequires:  cups-devel >= 1.1.15, libjbig-devel

%if "%{_vendor}" == "redhat"
BuildRequires:  lcms-devel
%else
BuildRequires:  liblcms-devel
%endif

BuildRoot: %{_builddir}/%{name}-root

%description
This package contains KONICA MINOLTA CUPS LavaFlow stream(PCL-like) 
filter rastertokm5440dl and the PPD file. The filter converts CUPS 
raster data to KONICA MINOLTA LavaFlow stream, it uses jbig for 
compression and littleCMS for colormatching. For latest version of 
this package and source code, please check Website 
http://printer.konicaminolta.net/.

%prep
%setup -q

%build
./configure
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;
make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && [ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;

%files
%defattr(-,root,root)
%{_libdir}/cups/filter/rastertokm5440dl
%{_datadir}/cups/model/KONICA_MINOLTA/km5440dl.ppd.gz
%{_datadir}/KONICA_MINOLTA/mc5440DL/*

%post
if [ "$1" = "2" ]; then
   PPD_DIR="/etc/cups/ppd/"
   FILETYPE=".ppd"
   LPADMIN="/usr/sbin/lpadmin"
   KM_PPD_DIR="/usr/share/cups/model/KONICA_MINOLTA"
   if [ -x $LPADMIN ] && [ -d $PPD_DIR ] && [ -n "`ls -1A ${PPD_DIR}`" ]; then
      KMPPDS=(`grep -l "magicolor 5440 DL" ${PPD_DIR}*`)
      for kmppd in ${KMPPDS[@]}; do
         ppdFile=${kmppd#${PPD_DIR}}
         Printer=${ppdFile%${FILETYPE}}
         ppdFileNew=`find "${KM_PPD_DIR}" -name "km5440dl.ppd.gz" -print`
         $LPADMIN -p $Printer -P $ppdFileNew
         if [ $? -eq 0 ]; then
            echo Succeed to update $Printer
         else
            echo Fail to update $Printer
         fi
      done
   fi
fi

if echo $MACHTYPE | grep "suse" ; then
   :
else
   if [ "$1" = "1" ]; then
      if [ -x /etc/init.d/cups ] ; then
	 /etc/init.d/cups restart
      fi
   fi
fi

%postun
if [ "$1" = "0" ]; then
   rm -rf /usr/share/KONICA_MINOLTA/mc5440DL

   PPD_DIR="/etc/cups/ppd/"
   FILETYPE=".ppd"
   LPADMIN="/usr/sbin/lpadmin"
   if [ -x $LPADMIN ] && [ -d $PPD_DIR ] && [ -n "`ls -1A ${PPD_DIR}`" ]; then
      KMPPDS=(`grep -l "magicolor 5440 DL" ${PPD_DIR}*`)
      for kmppd in ${KMPPDS[@]}; do
         ppdFile=${kmppd#${PPD_DIR}}
         Printer=${ppdFile%${FILETYPE}}
         $LPADMIN -x $Printer 
         if [ $? -eq 0 ]; then
             echo Succeed to delete $Printer
         else
             echo Fail to delete $Printer
         fi
      done
   fi
fi

if echo $MACHTYPE | grep "suse" ; then
   :
else
   if [ "$1" = "0" ]; then
      if [ -x /etc/init.d/cups ] ; then
	 /etc/init.d/cups restart
      fi
   fi
fi

%preun

%changelog
* Wed Feb 07 2007 Sean Zhan
- add BuildRequires so that rpm can be built with mock; libjbig-devel can get from Mandriva
* Mon Apr 03 2006 Sean Zhan
- add x86_64 support for Fedora Core
* Wed Mar 01 2006 Sean Zhan
- send extra UEL at end of USB job if the job size is 64 divisible
* Wed Feb 15 2006 Sean Zhan
- add Dot Counts support
* Tue Nov 30 2004 Sean Zhan <sean.zhan@bil.konicaminolta.us>
- use lcms-1.14beta3.
* Tue Nov 09 2004 Sean Zhan <sean.zhan@bil.konicaminolta.us>
- use lcms-1.14beta2 to fix extra black dots problem.
* Tue Oct 11 2004 Sean Zhan <sean.zhan@bil.konicaminolta.us>
- magicolor 5440 DL initial beta build

