/*
* MyGoGrinder - a program to practice Go problems
* This class' code copyright (c): Ruediger Klehn (2015)
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
*
*/

/**
*@author Ruediger Klehn
*/

package GoGrinder; //tags;

import GoGrinder.*; // (Main, GS, FileWorks, )
import GoGrinder.ui.*; // (Main, GS, FileWorks, )
import java.awt.*;
import javax.swing.*;
import java.io.*;
import java.nio.charset.Charset;

// We want to exchange the tags with others, can prepair a list of tags to import 
// or make a backup of them; export is now always done with encoding UTF-8, so 
// also Japanese, Chinese or Korean tags (and of course in any other font of any 
// other language) can be saved and imported to/from plain text.
public class TagsExpImp{ // this could also help to write the tags at program exit into
                         // a tagspool.ini (as long as the thing with unicode is not cleared,
                         // we needn't read them in - this is just a kind of backup for most of the tags)

  private static final String NL = Main.NEW_LINE;
  public static boolean reload = false;
  private static boolean success = true;
  private static String useCharset = "";
    
  public TagsExpImp(){/*NOTHING IN HERE*/}
  
  public TagsExpImp(int action, SelectionDialog selDlg){
    if (action == 1) tagsImport(selDlg); // 1 = import
    else if (action == 2) tagsExport(); // 2 = export
    /*else schaun mer mal*/
  }

  // ##### BEGIN METHOD EXPORT TAGS TO FILE #####
  public static void tagsExport(){ // info text on button: chinese etc.
      String msg = "";
      String expTagsFilePath = FileWorks.selectFile(null, FileFilters.txtFilter, 
                                                   "Export tags pool to file", true,   // true: save!
                                                   "Save tags"); 
      // here the user should have the decision, if he doesn't want utf-8 encoding, and set his encoding
      if (expTagsFilePath == null) 
        return;
      // test file! exists, isFile, canRead
      String[] exportTheseTags = GS.getTagList().getTags();
      StringBuffer tagsPoolStrB = new StringBuffer();
      if (exportTheseTags.length == 0){
        msg = "No tags in list - what shall I export?";
        myMsg(msg);
        return;
        }
      for (int i = 0; i < exportTheseTags.length ; i++){ 
        tagsPoolStrB.append(exportTheseTags[i]);   //  StringBuffer 	append(String str) 
        tagsPoolStrB.append(NL);
      }
      useCharset = "UTF-8";
      boolean success = FileWReadWrite.writeFileStrBuff(expTagsFilePath, tagsPoolStrB, useCharset);
      if (success){
        msg = "Save tags possibly done:  \n" 
            + "\"" + expTagsFilePath + "\"\n"
            + "Counted " + exportTheseTags.length + " tags. Please check the file.";
        myMsg(msg);
        return;
      }
      return;
  }//tagsExport
  // ##### END METHOD EXPORT TAGS TO FILE #####

  // ##### BEGIN METHOD IMPORT TAGS FROM FILE ##### // read file and test line should be in different methods
  public static void tagsImport(SelectionDialog selDlg){
      String[] importTheseLines;
      String msg = "";
      //reload = false;
      TagCB localTagCB = new TagCB(null);
      String caption = "Import tags from file";
      String question = "I expect the import file (plain text, one tag per line) \n"
                      + "to be not bigger then ~10kby (e.g. split the file to two).";
      if (!SelectionDialog.OKCancelMsg(question, caption)) {return;}
      
      String impTagsFilePath = FileWorks.selectFile(null, FileFilters.txtFilter, "Import tags from file", false, "Import"); // true: save!
      if (impTagsFilePath == null) {
        return;
      }
      // test file! exist, file, canRead
      
      File impTagsFilePathF = new File(impTagsFilePath);
      if (impTagsFilePathF.length() > 12000 || impTagsFilePathF.length() < 1){
        msg = "File is too big or small (or possibly doesn't exist): \n" 
            + impTagsFilePathF.length() + " bytes. \n"
            + "Please not bigger then ~10kby (e.g. split the file to two).";
        myMsg(msg);
        return;
      }
      
      useCharset = GS.getMyDefaultCharset();
      importTheseLines = FileWReadWrite.readFileLines(impTagsFilePath, useCharset);
      if (importTheseLines.length == 0) {
        msg = "File \"" + impTagsFilePath + "\": import not possible";
        myMsg(msg);
        return;
      }
      // here we show the read tags to the user; he/she may decide, if the strings are ok or should use another decoding
      String newCharset = new ChangeCharacterSet(new File(impTagsFilePath),
                                                         "Change text decoding for imported tags").forFile();
      if (newCharset.toLowerCase() != useCharset.toLowerCase()){
        useCharset = newCharset;
        importTheseLines = FileWReadWrite.readFileLines(impTagsFilePath, useCharset);
        if (importTheseLines.length == 0) {
          msg = "File \"" + impTagsFilePath + "\": import not possible";
          myMsg(msg);
          return;
        }
      }
      String testOneLine = "";
      int lineCounter = importTheseLines.length;
      int validTags = 0;
      int importedTags = 0;
      int lengthOfLine = 0;
      for (int i = 0 ; i < lineCounter ; i++){
        testOneLine = importTheseLines[i];
        lengthOfLine = testOneLine.length();
                // "public int length() Returns the length of this string.
                //    The length is equal to the number of Unicode code units in the string."
        
         // we check if last letter is whitespace; if yes, we remove this
        while(testOneLine.matches("[\\S\\s]*[\\s]+$") && lengthOfLine > 0){
          testOneLine = testOneLine.substring(0, lengthOfLine - 1);
          lengthOfLine = testOneLine.length();
        }
         // we keep leading whitespace, as this can be used to help sorting the tags in the list
        
         // we throw out empty lines
        if ( lengthOfLine == 0 ){  
          continue;
        }
        
         // long lines will disturb the display, so we omit them (and you usually don't use these long tags)
        if (lengthOfLine > 100){ // The user could adjust the maximum tags length in the settings dialog (NOT YET)
            // GS.getTagMaxLength() (NOT YET)
          msg = "String too long for a tag (" + lengthOfLine + "characters): \n"
               + testOneLine + "\n"
               + "Please shorten the string to 100 characters and import again.\n"
               + "We continue the import.";
          myMsg(msg); 
          continue;
        }
        
         // now we test, if this tag is already in our pool (and, if not, we merge it into the pool)
        if (localTagCB.mergeTag(testOneLine)){ // true, if the tag wasn't already in the list
          importedTags++;
        } // shouldn't mergeTag belong to TagList (?)

        validTags++;
      }

      JOptionPane.showMessageDialog(null, "Read " + lineCounter + " lines with " 
                                         + validTags + " valid tags. \n"
                                         + "Imported " + importedTags + " new tags.");
      selDlg.updateTagsLists();
      return;
  }//tagsImport
  // ##### END METHOD IMPORT TAGS FROM FILE #####
  
  private static void myMsg(String msg){
    JOptionPane.showMessageDialog(null, msg);
  }
  
  public void setCharset(String thisCharset){useCharset = thisCharset;}
  private boolean loadWithCharset(){return true;}
}
