/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.filters;

import org.htmlparser.Node;
import org.htmlparser.NodeFilter;
import org.htmlparser.tags.LinkTag;

public class LinkStringFilter
implements NodeFilter {
    protected String mPattern;
    protected boolean mCaseSensitive;

    public LinkStringFilter(String pattern) {
        this(pattern, false);
    }

    public LinkStringFilter(String pattern, boolean caseSensitive) {
        this.mPattern = pattern;
        this.mCaseSensitive = caseSensitive;
    }

    @Override
    public boolean accept(Node node) {
        boolean ret = false;
        if (LinkTag.class.isAssignableFrom(node.getClass())) {
            String link = ((LinkTag)node).getLink();
            if (this.mCaseSensitive) {
                if (link.indexOf(this.mPattern) > -1) {
                    ret = true;
                }
            } else if (link.toUpperCase().indexOf(this.mPattern.toUpperCase()) > -1) {
                ret = true;
            }
        }
        return ret;
    }
}

