/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexer;

import java.io.IOException;
import java.io.InputStream;

public class Stream
extends InputStream
implements Runnable {
    public int fills = 0;
    public int reallocations = 0;
    public int synchronous = 0;
    protected static final int BUFFER_SIZE = 4096;
    protected static final int EOF = -1;
    protected volatile InputStream mIn;
    public volatile byte[] mBuffer;
    public volatile int mLevel;
    protected int mOffset;
    protected int mContentLength;
    protected int mMark;

    public Stream(InputStream in) {
        this(in, 0);
    }

    public Stream(InputStream in, int bytes) {
        this.mIn = in;
        this.mBuffer = null;
        this.mLevel = 0;
        this.mOffset = 0;
        this.mContentLength = bytes < 0 ? 0 : bytes;
        this.mMark = -1;
    }

    protected synchronized boolean fill(boolean force) throws IOException {
        boolean ret = false;
        if (null != this.mIn) {
            int size;
            byte[] buffer;
            if (!force) {
                if (0 != this.available()) {
                    return true;
                }
                ++this.synchronous;
            }
            if (0 == this.mContentLength) {
                buffer = null == this.mBuffer ? (this.mBuffer = new byte[Math.max(4096, this.mIn.available())]) : (this.mBuffer.length - this.mLevel < 2048 ? new byte[Math.max(this.mBuffer.length * 2, this.mBuffer.length + this.mIn.available())] : this.mBuffer);
                size = buffer.length - this.mLevel;
            } else {
                size = this.mContentLength - this.mLevel;
                if (null == this.mBuffer) {
                    this.mBuffer = new byte[size];
                }
                buffer = this.mBuffer;
            }
            int read = this.mIn.read(buffer, this.mLevel, size);
            if (-1 == read) {
                this.mIn.close();
                this.mIn = null;
            } else {
                if (this.mBuffer != buffer) {
                    System.arraycopy(this.mBuffer, 0, buffer, 0, this.mLevel);
                    this.mBuffer = buffer;
                    ++this.reallocations;
                }
                this.mLevel += read;
                if (0 != this.mContentLength && this.mLevel == this.mContentLength) {
                    this.mIn.close();
                    this.mIn = null;
                }
                ret = true;
                ++this.fills;
            }
        }
        return ret;
    }

    @Override
    public void run() {
        boolean filled;
        do {
            try {
                filled = this.fill(true);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                filled = false;
            }
        } while (filled);
    }

    @Override
    public int read() throws IOException {
        if (0 == this.mLevel - this.mOffset) {
            this.fill(false);
        }
        int ret = 0 != this.mLevel - this.mOffset ? this.mBuffer[this.mOffset++] & 0xFF : -1;
        return ret;
    }

    @Override
    public int available() throws IOException {
        return this.mLevel - this.mOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        if (null != this.mIn) {
            this.mIn.close();
            this.mIn = null;
        }
        this.mBuffer = null;
        this.mLevel = 0;
        this.mOffset = 0;
        this.mContentLength = 0;
        this.mMark = -1;
    }

    @Override
    public void reset() throws IOException {
        this.mOffset = -1 != this.mMark ? this.mMark : 0;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.mMark = this.mOffset;
    }
}

