/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.AnchorConstraints;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockingContext;
import com.vlsolutions.swing.docking.RelativeDockingUtilities;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import com.vlsolutions.swing.docking.event.DockingActionAddDockableEvent;
import com.vlsolutions.swing.docking.event.DockingActionCreateTabEvent;
import com.vlsolutions.swing.docking.event.DockingActionEvent;
import com.vlsolutions.swing.docking.event.DockingActionListener;
import com.vlsolutions.swing.docking.event.DockingActionSplitComponentEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitDockableContainerEvent;
import com.vlsolutions.swing.docking.event.DockingActionSplitDockableEvent;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;

public class AnchorManager {
    private Container container;
    private HashMap<Dockable, AnchorConstraints> constraintsByDockable = new HashMap();
    private DockingContext context;
    private DockingActionListener actionListener = new DockingActionListener(){

        @Override
        public boolean acceptDockingAction(DockingActionEvent event) {
            switch (event.getActionType()) {
                case 1: {
                    DockingActionAddDockableEvent e = (DockingActionAddDockableEvent)event;
                    return AnchorManager.this.acceptAddDockable(e);
                }
                case 5: {
                    DockingActionCreateTabEvent e = (DockingActionCreateTabEvent)event;
                    return AnchorManager.this.acceptCreateTab(e);
                }
                case 3: {
                    DockingActionSplitComponentEvent e = (DockingActionSplitComponentEvent)event;
                    return AnchorManager.this.acceptSplitComponent(e);
                }
                case 2: {
                    DockingActionSplitDockableEvent e = (DockingActionSplitDockableEvent)event;
                    return AnchorManager.this.acceptSplitDockable(e);
                }
                case 4: {
                    DockingActionSplitDockableContainerEvent e = (DockingActionSplitDockableContainerEvent)event;
                    return AnchorManager.this.acceptSplitDockableContainer(e);
                }
            }
            return true;
        }

        @Override
        public void dockingActionPerformed(DockingActionEvent event) {
        }
    };

    public AnchorManager(DockingContext context, Container container) {
        this.context = context;
        this.container = container;
        context.addDockingActionListener(this.actionListener);
    }

    public void clear() {
        this.context.removeDockingActionListener(this.actionListener);
        this.constraintsByDockable.clear();
    }

    public void putDockableContraints(Dockable dockable, AnchorConstraints constraints) {
        this.constraintsByDockable.put(dockable, constraints);
    }

    public AnchorConstraints getDockableConstraints(Dockable dockable) {
        return this.constraintsByDockable.get(dockable);
    }

    public AnchorConstraints removeDockableConstraints(Dockable dockable) {
        return this.constraintsByDockable.remove(dockable);
    }

    private int getContactBorders(Dockable dockable) {
        return RelativeDockingUtilities.findAnchors(dockable.getComponent(), this.container);
    }

    private ArrayList findDockables(Container base) {
        ArrayList<Dockable> dockables = new ArrayList<Dockable>(10);
        for (Dockable d : this.constraintsByDockable.keySet()) {
            if (!base.isAncestorOf(d.getComponent())) continue;
            dockables.add(d);
        }
        return dockables;
    }

    private boolean acceptSplitComponent(DockingActionSplitComponentEvent event) {
        int anchor;
        Component base = event.getBase();
        ArrayList baseDockables = this.findDockables((Container)base);
        int contactBorders = RelativeDockingUtilities.findAnchors(base, this.container);
        switch (event.getSplitPosition().value()) {
            case 0: {
                if (this.isConstraintSet(1, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                if (this.isConstraintSet(2, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFF7;
                break;
            }
            case 2: {
                if (this.isConstraintSet(4, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                if (this.isConstraintSet(8, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFD;
            }
        }
        AnchorConstraints acDockable = this.getDockableConstraints(event.getDockable());
        return acDockable == null || ((anchor = acDockable.getAnchor()) & contactBorders) == anchor;
    }

    private boolean acceptSplitDockable(DockingActionSplitDockableEvent event) {
        int anchor;
        Dockable base = event.getBase();
        AnchorConstraints acBase = this.getDockableConstraints(base);
        int contactBorders = this.getContactBorders(base);
        switch (event.getSplitPosition().value()) {
            case 0: {
                if (this.isConstraintSet(1, base)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                if (this.isConstraintSet(2, base)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFF7;
                break;
            }
            case 2: {
                if (this.isConstraintSet(4, base)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                if (this.isConstraintSet(8, base)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFD;
            }
        }
        AnchorConstraints acDockable = this.getDockableConstraints(event.getDockable());
        return acDockable == null || ((anchor = acDockable.getAnchor()) & contactBorders) == anchor;
    }

    private boolean acceptSplitDockableContainer(DockingActionSplitDockableContainerEvent event) {
        Component base = event.getBase();
        ArrayList baseDockables = this.findDockables((Container)base);
        int contactBorders = RelativeDockingUtilities.findAnchors(base, this.container);
        switch (event.getSplitPosition().value()) {
            case 0: {
                if (this.isConstraintSet(1, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFB;
                break;
            }
            case 1: {
                if (this.isConstraintSet(2, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFF7;
                break;
            }
            case 2: {
                if (this.isConstraintSet(4, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFE;
                break;
            }
            case 3: {
                if (this.isConstraintSet(8, baseDockables)) {
                    return false;
                }
                contactBorders &= 0xFFFFFFFD;
            }
        }
        if (event.getDockableContainer() instanceof TabbedDockableContainer) {
            ArrayList containersDockables = this.findDockables(event.getDockableContainer());
            for (int i = 0; i < containersDockables.size(); ++i) {
                int anchor;
                Dockable d = (Dockable)containersDockables.get(i);
                AnchorConstraints acDockable = this.getDockableConstraints(d);
                if (acDockable == null || ((anchor = acDockable.getAnchor()) & contactBorders) == anchor) continue;
                return false;
            }
        }
        return true;
    }

    private boolean acceptAddDockable(DockingActionAddDockableEvent event) {
        int anchor;
        Container parent = event.getParentContainer();
        int contactBorders = RelativeDockingUtilities.findAnchors(parent, this.container);
        Dockable d = event.getDockable();
        AnchorConstraints acDockable = this.getDockableConstraints(d);
        return acDockable == null || ((anchor = acDockable.getAnchor()) & contactBorders) == anchor;
    }

    private boolean acceptCreateTab(DockingActionCreateTabEvent event) {
        int anchor;
        int contactBorders = this.getContactBorders(event.getBase());
        Dockable d = event.getDockable();
        AnchorConstraints acDockable = this.getDockableConstraints(d);
        return acDockable == null || ((anchor = acDockable.getAnchor()) & contactBorders) == anchor;
    }

    private boolean isConstraintSet(int anchor, ArrayList baseDockables) {
        for (int i = 0; i < baseDockables.size(); ++i) {
            AnchorConstraints ac = this.constraintsByDockable.get(baseDockables.get(i));
            if (ac == null || (ac.getAnchor() & anchor) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isConstraintSet(int anchor, Dockable dockable) {
        AnchorConstraints ac = this.constraintsByDockable.get(dockable);
        if (ac == null) {
            return false;
        }
        return (ac.getAnchor() & anchor) > 0;
    }
}

