/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge.gui;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.TransferHandler;
import javax.swing.text.JTextComponent;
import org.madlonkay.supertmxmerge.gui.IDropCallback;

public class FileDropHandler
extends TransferHandler {
    private static final Logger LOGGER = Logger.getLogger(FileDropHandler.class.getName());
    private IDropCallback callback;

    public FileDropHandler(IDropCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        List files;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            Object payload = support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
            if (!(payload instanceof List)) {
                return false;
            }
            files = (List)payload;
        }
        catch (UnsupportedFlavorException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return false;
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return false;
        }
        Component comp = support.getComponent();
        if (comp instanceof JTextComponent) {
            return this.handleSingleDrop(files, (JTextComponent)comp);
        }
        if (comp instanceof JList) {
            return this.handleMultiDrop(files, (JList)comp);
        }
        return false;
    }

    private boolean handleSingleDrop(List<File> files, JTextComponent comp) {
        if (files.size() != 1) {
            return false;
        }
        comp.setText(files.get(0).getAbsolutePath());
        this.callback.droppedToTarget(comp);
        return true;
    }

    private boolean handleMultiDrop(List<File> files, JList comp) {
        if (!(comp.getModel() instanceof DefaultListModel)) {
            return false;
        }
        DefaultListModel model = (DefaultListModel)comp.getModel();
        for (File file : files) {
            if (model.contains(file)) continue;
            model.addElement(file);
        }
        this.callback.droppedToTarget(comp);
        return true;
    }
}

