/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.drive.internal.zzar;
import com.google.android.gms.drive.internal.zzas;
import com.google.android.gms.drive.internal.zzx;
import com.google.android.gms.drive.zzd;
import com.google.android.gms.internal.zzrm;
import com.google.android.gms.internal.zzrn;

public class DriveId
implements SafeParcelable {
    public static final int RESOURCE_TYPE_UNKNOWN = -1;
    public static final int RESOURCE_TYPE_FILE = 0;
    public static final int RESOURCE_TYPE_FOLDER = 1;
    public static final Parcelable.Creator<DriveId> CREATOR = new zzd();
    final int zzCY;
    final String zzadd;
    final long zzade;
    final long zzacO;
    final int zzadf;
    private volatile String zzacQ = null;
    private volatile String zzadg = null;

    public static DriveId zzcs(String string2) {
        zzu.zzu(string2);
        return new DriveId(string2, -1L, -1L, -1);
    }

    public String getResourceId() {
        return this.zzadd;
    }

    public int getResourceType() {
        return this.zzadf;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzd.zza(this, out, flags);
    }

    DriveId(int versionCode, String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this.zzCY = versionCode;
        this.zzadd = resourceId;
        zzu.zzV(!"".equals(resourceId));
        zzu.zzV(resourceId != null || sqlId != -1L);
        this.zzade = sqlId;
        this.zzacO = databaseInstanceId;
        this.zzadf = resourceType;
    }

    public DriveId(String resourceId, long sqlId, long databaseInstanceId, int resourceType) {
        this(1, (String)(resourceId != null && resourceId.startsWith("generated-android-") ? null : resourceId), sqlId, databaseInstanceId, resourceType);
    }

    public int hashCode() {
        if (this.zzade == -1L) {
            return this.zzadd.hashCode();
        }
        return (String.valueOf(this.zzacO) + String.valueOf(this.zzade)).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DriveId)) {
            return false;
        }
        DriveId driveId = (DriveId)obj;
        if (driveId.zzacO != this.zzacO) {
            zzx.zzu("DriveId", "Attempt to compare invalid DriveId detected. Has local storage been cleared?");
            return false;
        }
        if (driveId.zzade == -1L && this.zzade == -1L) {
            return driveId.zzadd.equals(this.zzadd);
        }
        if (this.zzadd == null || driveId.zzadd == null) {
            return driveId.zzade == this.zzade;
        }
        if (driveId.zzade == this.zzade) {
            if (driveId.zzadd.equals(this.zzadd)) {
                return true;
            }
            zzx.zzu("DriveId", "Unexpected unequal resourceId for same DriveId object.");
        }
        return false;
    }

    public final String encodeToString() {
        if (this.zzacQ == null) {
            byte[] byArray = this.zzpb();
            String string2 = Base64.encodeToString((byte[])byArray, (int)10);
            this.zzacQ = "DriveId:" + string2;
        }
        return this.zzacQ;
    }

    public final String toInvariantString() {
        if (this.zzadg == null) {
            byte[] byArray = this.zzph();
            this.zzadg = Base64.encodeToString((byte[])byArray, (int)10);
        }
        return this.zzadg;
    }

    final byte[] zzpb() {
        zzar zzar2 = new zzar();
        zzar2.versionCode = this.zzCY;
        zzar2.zzafX = this.zzadd == null ? "" : this.zzadd;
        zzar2.zzafY = this.zzade;
        zzar2.zzafV = this.zzacO;
        zzar2.zzafZ = this.zzadf;
        byte[] byArray = zzrn.zzf(zzar2);
        return byArray;
    }

    private byte[] zzph() {
        zzas zzas2 = new zzas();
        zzas2.zzafY = this.zzade;
        zzas2.zzafV = this.zzacO;
        byte[] byArray = zzrn.zzf(zzas2);
        return byArray;
    }

    public String toString() {
        return this.encodeToString();
    }

    public static DriveId decodeFromString(String s) {
        zzu.zzb(s.startsWith("DriveId:"), (Object)("Invalid DriveId: " + s));
        String string2 = s.substring("DriveId:".length());
        byte[] byArray = Base64.decode((String)string2, (int)10);
        return DriveId.zzk(byArray);
    }

    static DriveId zzk(byte[] byArray) {
        zzar zzar2;
        try {
            zzar2 = zzar.zzl(byArray);
        }
        catch (zzrm zzrm2) {
            throw new IllegalArgumentException();
        }
        String string2 = "".equals(zzar2.zzafX) ? null : zzar2.zzafX;
        DriveId driveId = new DriveId(zzar2.versionCode, string2, zzar2.zzafY, zzar2.zzafV, zzar2.zzafZ);
        return driveId;
    }
}

